/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.apigeneration.method;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.beanmodel.annotation.DefaultValue;
import oracle.bali.xml.beanmodel.annotation.MethodIdentifier;
import oracle.bali.xml.beanmodel.annotation.MethodIdentifierException;
import oracle.bali.xml.beanmodel.annotation.Operation;
import oracle.bali.xml.beanmodel.annotation.PropertyType;
import oracle.bali.xml.beanmodel.apigeneration.method.MethodContext;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.util.Pair;

public abstract class MethodProvider {
    public final boolean shouldAddMethod(MethodContext context, GrammarComponent component) {
        return this.shouldAddMethod(context, component, false);
    }

    public boolean shouldAddMethod(MethodContext context, GrammarComponent component, boolean isList) {
        return false;
    }

    public final SourceMethod getMethod(MethodContext context, GrammarComponent component) throws Exception {
        return this.getMethod(context, component, false);
    }

    public final SourceMethod getMethod(MethodContext context, GrammarComponent component, boolean isList) throws Exception {
        SourceFactory factory = context.getSourceFactory();
        String typeName = this.getTypeName(context, component);
        QualifiedName qName = this.getQualifiedName(context, component);
        String returnType = this.getReturnType(component, typeName);
        SourceTypeReference str = factory.createType(returnType);
        ArrayList<SourceLocalVariable> slvs = new ArrayList<SourceLocalVariable>();
        List<Pair<String, String>> parameters = this.getParameters(component, typeName, qName.getName());
        for (Pair<String, String> parameter : parameters) {
            SourceLocalVariable slv = factory.createLocalVariable(factory.createType((String)parameter.getFirst()), (String)parameter.getSecond());
            slvs.add(slv);
        }
        ArrayList<SourceTypeParameter> stps = new ArrayList<SourceTypeParameter>();
        List<Pair<String, String>> typeParameters = this.getTypeParameters(component, typeName);
        for (Pair pair : typeParameters) {
            SourceTypeReference stRef = factory.createType((String)pair.getSecond());
            SourceTypeParameter stp = factory.createTypeParameter((String)pair.getFirst(), stRef);
            stps.add(stp);
        }
        SourceFormalParameterList sfpl = slvs.isEmpty() ? factory.createFormalParameterList() : factory.createFormalParameterList(slvs.toArray(new SourceLocalVariable[0]));
        SourceTypeParameter[] sourceTypeParameterArray = stps.isEmpty() ? SourceTypeParameter.EMPTY_ARRAY : stps.toArray(new SourceTypeParameter[0]);
        String methodName = this.getMethodName(qName.getName());
        SourceMethod sm = factory.createMethod(sourceTypeParameterArray, str, methodName, sfpl, null, null);
        SourceDocComment sdc = this.getMethodDocComment(context, component);
        if (sdc != null) {
            sdc.addSelf((SourceElement)sm);
        }
        List<SourceAnnotation> annotations = this.getMethodAnnotations(context, factory, component);
        for (SourceAnnotation sa : annotations) {
            sa.addSelf((SourceElement)sm);
        }
        return sm;
    }

    public MethodIdentifier getMethodIdentifier() {
        MethodIdentifier identifier;
        try {
            identifier = MethodIdentifier.create((Operation)this.getOperation(), (PropertyType)this.getPropertyType());
        }
        catch (MethodIdentifierException e) {
            throw new IllegalStateException("Unexpected exception encountered creating MethodIdentifier (see cause)", e);
        }
        return identifier;
    }

    protected abstract String getMethodName(String var1);

    protected abstract QualifiedName getQualifiedName(MethodContext var1, GrammarComponent var2);

    protected abstract Operation getOperation();

    protected abstract PropertyType getPropertyType();

    protected abstract String getTypeName(MethodContext var1, GrammarComponent var2) throws Exception;

    protected List<SourceAnnotation> getMethodAnnotations(MethodContext context, SourceFactory factory, GrammarComponent component) {
        SourceAnnotation dsa;
        SourceAnnotation sa;
        SourceAnnotation tsa;
        ArrayList<SourceAnnotation> annotations = new ArrayList<SourceAnnotation>();
        SourceAnnotation msa = this.getOperationAnnotation(factory);
        if (msa != null) {
            annotations.add(msa);
        }
        if ((tsa = this.getPropertyTypeAnnotation(factory)) != null) {
            annotations.add(tsa);
        }
        if ((sa = this.getQualifiedNameAnnotation(factory, this.getQualifiedName(context, component))) != null) {
            annotations.add(sa);
        }
        if ((dsa = this.getDefaultValueAnnotation(context, factory, this.getDefaultValue(context, component))) != null) {
            annotations.add(dsa);
        }
        return annotations;
    }

    protected DefaultValue getDefaultValue(MethodContext context, GrammarComponent component) {
        return null;
    }

    protected String getMethodComment(MethodContext context, GrammarComponent component) {
        return null;
    }

    protected SourceAnnotation getOperationAnnotation(SourceFactory factory) {
        Operation op = this.getOperation();
        ArrayList<SourceExpression> ses = new ArrayList<SourceExpression>();
        ses.add(factory.createExpressionFromText("type = \"" + op.type() + "\""));
        String variant = op.variant();
        if (variant != "simple") {
            ses.add(factory.createExpressionFromText("variant = \"" + variant + "\""));
        }
        return factory.createAnnotation("oracle.bali.xml.beanmodel.annotation.Operation", factory.createArgumentList(ses.toArray(new SourceExpression[0])));
    }

    protected List<Pair<String, String>> getParameters(GrammarComponent component, String typeName, String name) {
        return Collections.emptyList();
    }

    protected List<Pair<String, String>> getTypeParameters(GrammarComponent component, String typeName) {
        return Collections.emptyList();
    }

    protected SourceAnnotation getPropertyTypeAnnotation(SourceFactory factory) {
        SourceExpression se = factory.createExpressionFromText("\"" + this.getPropertyType().value() + "\"");
        return factory.createAnnotation("oracle.bali.xml.beanmodel.annotation.PropertyType", factory.createArgumentList(se));
    }

    protected SourceAnnotation getQualifiedNameAnnotation(SourceFactory factory, QualifiedName qName) {
        ArrayList<SourceExpression> ses = new ArrayList<SourceExpression>();
        String ns = qName.getNamespace();
        if (ns != null && !"".equals(ns)) {
            ses.add(factory.createExpressionFromText("namespace = \"" + ns + "\""));
        }
        ses.add(factory.createExpressionFromText("name = \"" + qName.getName() + "\""));
        return factory.createAnnotation("oracle.bali.xml.beanmodel.annotation.QualifiedName", factory.createArgumentList(ses.toArray(new SourceExpression[0])));
    }

    protected SourceAnnotation getDefaultValueAnnotation(MethodContext context, SourceFactory factory, DefaultValue defaultValue) {
        if (context.getOptions().generateAttrDefaultValues() && defaultValue != null) {
            SourceExpression se = factory.createExpressionFromText("\"" + defaultValue.value() + "\"");
            return factory.createAnnotation("oracle.bali.xml.beanmodel.annotation.DefaultValue", factory.createArgumentList(se));
        }
        return null;
    }

    protected String getReturnType(GrammarComponent component, String typeName) {
        return "void";
    }

    protected boolean isAbstract(GrammarComponent component) {
        if (component instanceof ElementDef) {
            return ((ElementDef)component).isAbstract();
        }
        return false;
    }

    private final SourceDocComment getMethodDocComment(MethodContext context, GrammarComponent component) {
        SourceFactory factory = context.getSourceFactory();
        String docComment = this.getMethodComment(context, component);
        if (docComment != null && !docComment.isEmpty()) {
            String[] lines = docComment.split("\n");
            ArrayList<SourceDocTextFragment> sdtfs = new ArrayList<SourceDocTextFragment>();
            sdtfs.add(factory.createDocTextFragment("\n"));
            for (int i = 0; i < lines.length; ++i) {
                sdtfs.add(factory.createDocTextFragment(lines[i] + "\n"));
            }
            SourceDocDescription sdd = factory.createDocDescription(sdtfs.toArray(new SourceDocTextFragment[0]));
            return factory.createDocComment(sdd);
        }
        return null;
    }
}

