/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.util.ArrayList;
import java.util.List;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.exec.ConstantExpr;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Document;
import oracle.xquery.exec.Dot;
import oracle.xquery.exec.DotDot;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.Focus;
import oracle.xquery.exec.FunctionCall;
import oracle.xquery.exec.OXMLItemList;
import oracle.xquery.exec.OXQuerySequence;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.PathStep;
import oracle.xquery.exec.Predicate;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.SQLQuery;
import oracle.xquery.exec.Trace;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.exec.XpathExprStreamingIterator;
import oracle.xquery.parser.XQXGen;
import org.w3c.dom.Node;

public class XpathExpr
extends Expr {
    List steps = new ArrayList();
    private boolean streamingEval = false;
    private String pathRep;

    public String getPathExpr() {
        return this.pathRep;
    }

    public void setPathExpr(String string) {
        this.pathRep = string;
    }

    @Override
    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)XpathExpr.getDoc().createElement("XpathExpr");
        if (this.pathRep != null) {
            xMLElement.setAttribute("path", this.pathRep);
        }
        this.toXMLKids((XMLNode)xMLElement);
        if (this.steps != null) {
            int n = this.steps.size();
            for (int i = 0; i < n; ++i) {
                xMLElement.appendChild((Node)((Expr)this.steps.get(i)).toXML());
            }
        }
        return xMLElement;
    }

    public void getStepStrRep(StringBuffer stringBuffer) {
        int n = this.steps.size();
        for (int i = 0; i < n; ++i) {
            Expr expr = (Expr)this.steps.get(i);
            expr.getStrRep(stringBuffer);
        }
    }

    @Override
    public void getStrRep(StringBuffer stringBuffer) {
        this.kids[0].getStrRep(stringBuffer);
        if (this.pathRep != null) {
            if (!this.pathRep.startsWith("//")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(this.pathRep);
        } else {
            for (int i = 1; i < this.kids.length; ++i) {
                if (this.kids[i] instanceof ConstantExpr) {
                    this.kids[i].getStrRep(stringBuffer);
                    continue;
                }
                stringBuffer.append("\"");
                this.kids[i].getStrRep(stringBuffer);
                stringBuffer.append("\"");
            }
        }
    }

    @Override
    public ConvertXML fromXML(XMLElement xMLElement) {
        String string = xMLElement.getAttribute("path");
        string = string.equals("") ? null : string;
        this.initialize(string);
        this.fromXMLKids(xMLElement);
        return this;
    }

    @Override
    public void toSql(XQXGen xQXGen) {
        xQXGen.startElement("function", XQXGen.createAttrs("name", "sys.xmltype.extract"));
        this.kids[0].toSql(xQXGen);
        if (this.pathRep != null) {
            if (this.kids[0] instanceof Document && this.pathRep.charAt(0) != '/') {
                this.pathRep = "/" + this.pathRep;
            }
            ConstantExpr.toSql(xQXGen, this.pathRep);
        } else {
            xQXGen.startElement("function", XQXGen.createAttrs("name", "||", "infix", "true"));
            for (int i = 1; i < this.kids.length; ++i) {
                if (this.kids[i] instanceof ConstantExpr) {
                    this.kids[i].toSqlScalar(xQXGen);
                    continue;
                }
                ConstantExpr.toSql(xQXGen, "\"");
                this.kids[i].toSqlScalar(xQXGen);
                ConstantExpr.toSql(xQXGen, "\"");
            }
            xQXGen.endElement("function");
        }
        xQXGen.endElement("function");
    }

    public XpathExpr(Expr[] exprArray) {
        super(exprArray);
        this.initialize(null);
    }

    public XpathExpr(String string, Expr expr) {
        super(expr);
        this.initialize(string);
    }

    public XpathExpr() {
    }

    public XpathExpr(Expr expr) {
        super(expr);
    }

    private void initialize(String string) {
        this.pathRep = string;
    }

    @Override
    public Expr optimize(OptimizeContext optimizeContext) {
        int n;
        int n2;
        if (optimizeContext != null) {
            n2 = optimizeContext.getOptimizeFlag();
            int n3 = n = (n2 & 8) == 8 ? 1 : 0;
            if (n == 0 && this.verifyXpPushdown()) {
                return this.xpPushdownRewrite(optimizeContext);
            }
        }
        n2 = this.steps.size();
        for (n = 0; n < n2; ++n) {
            Expr expr = (Expr)this.steps.get(n);
            expr = expr.optimize(optimizeContext);
        }
        return super.optimize(optimizeContext);
    }

    @Override
    public Expr normalize() {
        if (this.steps != null) {
            this.streamingEval = true;
            int n = this.steps.size();
            Expr expr = null;
            PathStep pathStep = null;
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                expr = (Expr)this.steps.get(i);
                if (expr instanceof PathStep) {
                    pathStep = (PathStep)expr;
                    if (this.streamingEval) {
                        if (!this.isStreamable(pathStep)) {
                            this.streamingEval = false;
                        } else {
                            int n3 = pathStep.getAxis();
                            if (n3 == 4 || n3 == 5) {
                                if (n2 >= 0) {
                                    this.streamingEval = false;
                                } else {
                                    n2 = i;
                                }
                            }
                        }
                    }
                } else {
                    this.streamingEval = false;
                }
                expr.normalize();
            }
            if (this.streamingEval && n2 >= 0 && n2 != n - 1 && (n2 != n - 2 || pathStep.getAxis() != 2)) {
                this.streamingEval = false;
            }
        }
        return super.normalize();
    }

    private boolean isStreamable(PathStep pathStep) {
        int n = pathStep.getAxis();
        if (n != 2 && !XQueryUtils.isForwardElementAxis(n)) {
            return false;
        }
        if (pathStep.predicateSet != null && pathStep.predicateSet.predicates != null) {
            if (pathStep.predicateSet.predicates.size() != 1) {
                return false;
            }
            Predicate predicate = (Predicate)pathStep.predicateSet.predicates.get(0);
            if (predicate.getPositionTestExact() == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean verifyXpPushdown() {
        boolean bl = false;
        if (this.kids != null && this.kids.length == 1 && (this.kids[0] instanceof FunctionCall || this.kids[0] instanceof SQLQuery)) {
            Expr expr;
            int n = this.steps.size();
            if (this.kids[0] instanceof FunctionCall) {
                expr = (FunctionCall)this.kids[0];
                if (!((FunctionCall)expr).verifyXpPushdown()) {
                    return false;
                }
                bl = ((FunctionCall)expr).getDBVsn();
            }
            if (this.kids[0] instanceof SQLQuery) {
                expr = (SQLQuery)this.kids[0];
                if (!((SQLQuery)expr).verifyXpPushdown()) {
                    return false;
                }
                bl = ((SQLQuery)expr).getDBVsn();
            }
            for (int i = 0; i < n; ++i) {
                Expr expr2 = (Expr)this.steps.get(i);
                if (!(expr2 instanceof PathStep) && !(expr2 instanceof Dot)) {
                    return false;
                }
                if (((PathStep)expr2).getHasNodeTest()) {
                    return false;
                }
                if (((PathStep)expr2).predicateSet != null) {
                    return false;
                }
                if (i != n - 1 || !((PathStep)expr2).isTextTest()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Expr xpPushdownRewrite(OptimizeContext optimizeContext) {
        StringBuffer stringBuffer = new StringBuffer();
        this.getStepStrRep(stringBuffer);
        if (this.kids[0] instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)this.kids[0];
            functionCall.optimizeGeneral(optimizeContext);
            return functionCall.pushdownRewrite(stringBuffer);
        }
        if (this.kids[0] instanceof SQLQuery) {
            SQLQuery sQLQuery = (SQLQuery)this.kids[0];
            Expr expr = sQLQuery.optimize(optimizeContext);
            if (!(expr instanceof SQLQuery)) {
                return this;
            }
            return sQLQuery.xpPushdownRewrite(stringBuffer);
        }
        return this;
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        return this.EvaluateUsingIterator(queryState);
    }

    @Override
    public ExprResultIterator getIterator(QueryState queryState) {
        if (this.streamingEval) {
            XpathExprStreamingIterator xpathExprStreamingIterator = null;
            xpathExprStreamingIterator = this.kids != null ? new XpathExprStreamingIterator(this.steps, this.kids[0], queryState) : new XpathExprStreamingIterator(this.steps, null, queryState);
            return xpathExprStreamingIterator;
        }
        XpathExprIterator xpathExprIterator = null;
        xpathExprIterator = this.kids != null ? new XpathExprIterator(this.steps, this.kids[0], queryState) : new XpathExprIterator(this.steps, null, queryState);
        return xpathExprIterator;
    }

    public void addStep(Expr expr) {
        if (expr instanceof PathStep && !((PathStep)expr).reorder) {
            if (!(this.kids == null || this.kids[0] instanceof Document || this.kids[0] instanceof Dot || this.kids[0] instanceof SQLQuery)) {
                ((PathStep)expr).setReorder(true);
            } else {
                int n = this.steps.size();
                for (int i = 0; i < n; ++i) {
                    Expr expr2 = (Expr)this.steps.get(i);
                    if (expr2 instanceof PathStep && ((PathStep)expr2).reorder) {
                        ((PathStep)expr).setReorder(true);
                        break;
                    }
                    if (expr2 instanceof PathStep) continue;
                    ((PathStep)expr).setReorder(true);
                    break;
                }
            }
        }
        this.steps.add(expr);
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
        visitor.visitPath(this);
    }

    class XpathExprIterator
    implements ExprResultIterator {
        OXMLItemList items;
        int index;
        int length;
        private List steps;
        QueryState qryState;
        boolean isMaterialized = false;
        Expr leadExpr = null;
        boolean onlynodes = true;

        public XpathExprIterator(List list, Expr expr, QueryState queryState) {
            this.steps = list;
            this.qryState = queryState;
            this.leadExpr = expr;
        }

        public XpathExprIterator(OXMLItemList oXMLItemList) {
            this.Reset(oXMLItemList);
        }

        public XpathExprIterator() {
        }

        public void Reset(OXMLItemList oXMLItemList) {
            this.items = oXMLItemList;
            this.index = 0;
            this.length = this.items == null ? 0 : this.items.getLength();
        }

        public void Reset(List list, Expr expr, QueryState queryState) {
            this.items = null;
            this.index = 0;
            this.length = 0;
            this.isMaterialized = false;
            this.steps = list;
            this.qryState = queryState;
            this.leadExpr = expr;
        }

        @Override
        public void Restart() {
            if (!this.isMaterialized) {
                this.materializeIT();
                this.isMaterialized = true;
            }
            this.index = 0;
        }

        @Override
        public OXMLItem Fetch() {
            OXMLItem oXMLItem;
            if (this.Eof()) {
                return null;
            }
            int n = this.items.getItem(this.qryState, this.index).getPrimitiveType();
            if (n == 90) {
                oXMLItem = this.qryState.createItem();
                oXMLItem.setNode((XMLNode)this.items.getNode(this.index));
            } else {
                oXMLItem = this.items.getItem(this.qryState, this.index);
            }
            ++this.index;
            return oXMLItem;
        }

        private boolean Eof() {
            return this.index < 0 || this.index >= this.length;
        }

        @Override
        public void Close() {
            Trace.trace(1, this, "Entering Close");
            this.index = -1;
        }

        private void addNodeItemsToList(OXMLItemList oXMLItemList, OXMLSequence oXMLSequence) {
            while (oXMLSequence.next()) {
                OXMLItem oXMLItem = oXMLSequence.getItem();
                if (oXMLItem.getPrimitiveType() != 90) {
                    throw new XQException(XQMesg.getInstance().getMessage0("XPTY0019"));
                }
                oXMLItemList.addItem(oXMLItem);
            }
        }

        private void checkAllNodes(OXMLItemList oXMLItemList) {
            for (int i = 0; i < oXMLItemList.getLength(); ++i) {
                if (oXMLItemList.getItem(this.qryState, i).getPrimitiveType() == 90) continue;
                throw new XQException(XQMesg.getInstance().getMessage0("XPTY0019"));
            }
        }

        private void addNodesOrScalarItemsToList(OXMLItemList oXMLItemList, OXMLSequence oXMLSequence) {
            boolean bl;
            OXMLItem oXMLItem;
            int n;
            if (oXMLItemList.getLength() > 0) {
                n = oXMLItemList.getItem(this.qryState, 0).getPrimitiveType();
            } else {
                if (!oXMLSequence.next()) {
                    return;
                }
                oXMLItem = oXMLSequence.getItem();
                oXMLItemList.addItem(oXMLItem);
                n = oXMLItem.getPrimitiveType();
            }
            boolean bl2 = bl = n == 90;
            while (oXMLSequence.next()) {
                oXMLItem = oXMLSequence.getItem();
                if (oXMLItem.getPrimitiveType() == 90 ? !bl : bl) {
                    throw new XQException(XQMesg.getInstance().getMessage0("XPTY0018"));
                }
                oXMLItemList.addItem(oXMLItem);
            }
        }

        private void materializeIT() {
            OXQuerySequence oXQuerySequence;
            int n = this.steps.size();
            OXMLItemList oXMLItemList = null;
            if (this.leadExpr != null) {
                oXQuerySequence = (OXQuerySequence)this.leadExpr.Evaluate(this.qryState);
                oXMLItemList = oXQuerySequence.getItemList();
            } else {
                oXMLItemList = this.qryState.getContextItemList();
                if (oXMLItemList == null && (oXQuerySequence = this.qryState.getContextItem()) != null) {
                    oXMLItemList = new OXMLItemList();
                    oXMLItemList.addItem((OXMLItem)oXQuerySequence);
                }
            }
            if (oXMLItemList == null) {
                oXMLItemList = new OXMLItemList();
            }
            for (int i = 0; i < n; ++i) {
                Object object;
                Expr expr = (Expr)this.steps.get(i);
                Focus focus = this.qryState.getFocus();
                focus.setContextItemList(oXMLItemList);
                this.qryState.pushFocus(focus);
                if (expr instanceof PathStep) {
                    object = (PathStep)expr;
                    ((PathStep)object).eval(this.qryState);
                } else if (expr instanceof DotDot) {
                    object = (DotDot)expr;
                    ((DotDot)object).eval(this.qryState);
                } else if (expr instanceof Dot) {
                    if (i == 0) {
                        this.checkAllNodes(oXMLItemList);
                    }
                } else {
                    object = focus.getContextItemList();
                    OXMLItemList oXMLItemList2 = new OXMLItemList();
                    OXMLItemList oXMLItemList3 = new OXMLItemList();
                    for (int j = 0; j < ((OXMLItemList)object).getLength(); ++j) {
                        focus.setContextItem(((OXMLItemList)object).getItem(this.qryState, j));
                        focus.setContextSize(((OXMLItemList)object).getLength());
                        focus.setContextPosition(j + 1);
                        oXMLItemList3.reset();
                        oXMLItemList3.addNode((XMLNode)((OXMLItemList)object).getNode(j));
                        focus.setContextItemList(oXMLItemList3);
                        OXMLSequence oXMLSequence = expr.Evaluate(this.qryState);
                        if (i < n - 1) {
                            this.addNodeItemsToList(oXMLItemList2, oXMLSequence);
                            continue;
                        }
                        this.addNodesOrScalarItemsToList(oXMLItemList2, oXMLSequence);
                    }
                    if (oXMLItemList2.getLength() > 0 && oXMLItemList2.getItem(this.qryState, 0).getPrimitiveType() == 90) {
                        oXMLItemList2.removeDuplicates();
                        oXMLItemList2.makeDocOrder(1);
                    }
                    this.qryState.setContextItemList(oXMLItemList2);
                }
                oXMLItemList = this.qryState.getContextItemList();
                focus = this.qryState.popFocus();
            }
            this.items = oXMLItemList;
            this.length = this.items == null ? 0 : this.items.getLength();
        }
    }
}

