/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.math.BigDecimal;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Trace;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import org.w3c.dom.Node;

public class XQRangeExpr
extends Expr {
    public XQRangeExpr(Expr expr, Expr expr2) {
        super(expr, expr2);
    }

    @Override
    public ExprResultIterator getIterator(QueryState queryState) {
        return new XQRangeExprIterator(this, queryState);
    }

    @Override
    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)XQRangeExpr.getDoc().createElement("RangeExpr");
        XMLElement xMLElement2 = (XMLElement)XQRangeExpr.getDoc().createElement("FromExpr");
        XMLElement xMLElement3 = (XMLElement)XQRangeExpr.getDoc().createElement("ToExpr");
        xMLElement2.appendChild((Node)this.kids[0].toXML());
        xMLElement3.appendChild((Node)this.kids[1].toXML());
        xMLElement.appendChild((Node)xMLElement2);
        xMLElement.appendChild((Node)xMLElement3);
        return xMLElement;
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        return this.EvaluateUsingIterator(queryState);
    }

    @Override
    public void getStrRep(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = new StringBuffer("");
        this.kids[0].getStrRep(stringBuffer2);
        this.kids[1].getStrRep(stringBuffer3);
        stringBuffer.append("position() >= " + stringBuffer2.toString() + " and position() <= " + stringBuffer3.toString());
    }

    public String getStrRep() {
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        this.kids[0].getStrRep(stringBuffer);
        this.kids[1].getStrRep(stringBuffer2);
        return "position() >= " + stringBuffer.toString() + " and position() <= " + stringBuffer2.toString();
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
        visitor.visitRangeExpr(this);
    }

    static class XQRangeExprIterator
    implements ExprResultIterator {
        private XQRangeExpr parentXQRangeExpr;
        private long currval;
        private boolean started;
        private long fromval;
        private long toval;
        private boolean descending;
        private boolean eof;
        private QueryState qryState;

        public XQRangeExprIterator(XQRangeExpr xQRangeExpr, QueryState queryState) {
            this.parentXQRangeExpr = xQRangeExpr;
            this.started = false;
            this.eof = false;
            this.qryState = queryState;
        }

        @Override
        public void Restart() {
            OXMLSequence oXMLSequence;
            OXMLItem oXMLItem;
            this.started = true;
            this.eof = false;
            OXMLSequence oXMLSequence2 = this.parentXQRangeExpr.kids[0].Evaluate(this.qryState);
            OXMLItem oXMLItem2 = XQueryUtils.getEmptyOrSingleItem(oXMLSequence2);
            if (oXMLItem2 == null) {
                this.eof = true;
                return;
            }
            OXMLSequence oXMLSequence3 = null;
            if (this.parentXQRangeExpr.kids[0].needAtomization()) {
                oXMLSequence3 = oXMLItem2.atomize();
                oXMLItem2 = XQueryUtils.getSingleItem(oXMLSequence3);
            }
            if (this.parentXQRangeExpr.kids[0].needCast() && oXMLItem2.matchesType(OXMLSequenceType.TUNTYPED)) {
                oXMLItem2 = XQueryUtils.convert(oXMLItem2, OXMLSequenceType.TINTEGER, this.qryState);
            } else if (this.parentXQRangeExpr.kids[0].unknownStaticType() && !oXMLItem2.matchesType(OXMLSequenceType.TINTEGER)) {
                throw new XQException(XQMesg.getInstance().getMessage0("XPTY0004"));
            }
            long l = this.fromval = oXMLItem2.withinRange() ? (long)oXMLItem2.getInt() : oXMLItem2.getDecimal().longValue();
            if (oXMLSequence3 != null) {
                this.qryState.returnSequence(oXMLSequence3);
            }
            if ((oXMLItem = XQueryUtils.getEmptyOrSingleItem(oXMLSequence = this.parentXQRangeExpr.kids[1].Evaluate(this.qryState))) == null) {
                this.eof = true;
                return;
            }
            OXMLSequence oXMLSequence4 = null;
            if (this.parentXQRangeExpr.kids[1].needAtomization()) {
                oXMLSequence4 = oXMLItem.atomize();
                oXMLItem = XQueryUtils.getSingleItem(oXMLSequence4);
            }
            if (this.parentXQRangeExpr.kids[1].needCast() && oXMLItem.matchesType(OXMLSequenceType.TUNTYPED)) {
                oXMLItem = XQueryUtils.convert(oXMLItem, OXMLSequenceType.TINTEGER, this.qryState);
            } else if (this.parentXQRangeExpr.kids[1].unknownStaticType() && !oXMLItem.matchesType(OXMLSequenceType.TINTEGER)) {
                throw new XQException(XQMesg.getInstance().getMessage0("XPTY0004"));
            }
            long l2 = this.toval = oXMLItem.withinRange() ? (long)oXMLItem.getInt() : oXMLItem.getDecimal().longValue();
            if (oXMLSequence4 != null) {
                this.qryState.returnSequence(oXMLSequence4);
            }
            if (this.fromval > this.toval) {
                this.eof = true;
            } else {
                this.descending = false;
            }
            this.currval = this.fromval;
        }

        @Override
        public OXMLItem Fetch() {
            if (this.eof) {
                return null;
            }
            OXMLItem oXMLItem = this.qryState.createItem();
            if (this.currval < Integer.MAX_VALUE && this.currval > Integer.MIN_VALUE) {
                oXMLItem.setInt(OXMLSequenceType.TINTEGER, (int)this.currval);
            } else {
                oXMLItem.setDecimal(OXMLSequenceType.TINTEGER, new BigDecimal(this.currval));
            }
            if (this.currval == this.toval) {
                this.eof = true;
            } else {
                this.currval = this.descending ? --this.currval : ++this.currval;
            }
            return oXMLItem;
        }

        @Override
        public void Close() {
            Trace.trace(1, this, "Entering Close");
            this.started = false;
        }
    }
}

