/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;

public class OXQueryItem
extends OXMLItem {
    private QueryState ctx;

    public void setContext(QueryState queryState) {
        this.ctx = queryState;
    }

    public void atomize(OXMLSequence oXMLSequence) {
        OXQueryItem oXQueryItem = this;
        if (FNUtil.isNode((OXMLItem)this)) {
            oXQueryItem = this.ctx.createItem();
            this.atomizeNode(oXQueryItem, this.nodeValue);
        }
        oXMLSequence.appendItem((OXMLItem)oXQueryItem);
    }

    public OXMLSequence atomize() {
        OXQueryItem oXQueryItem = this;
        OXMLSequence oXMLSequence = this.ctx.createSequence();
        if (FNUtil.isNode((OXMLItem)this)) {
            oXQueryItem = this.ctx.createItem();
            this.atomizeNode(oXQueryItem, this.nodeValue);
        }
        oXMLSequence.appendItem((OXMLItem)oXQueryItem);
        return oXMLSequence;
    }

    private void atomizeNode(OXMLItem oXMLItem, XMLNode xMLNode) {
        switch (xMLNode.getNodeType()) {
            case 1: 
            case 2: {
                this.setItemValue(oXMLItem, xMLNode);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: {
                oXMLItem.setUntypedLexical(xMLNode.getText());
                break;
            }
            case 7: 
            case 8: {
                oXMLItem.setString(OXMLSequenceType.TSTRING, xMLNode.getText());
            }
        }
    }

    private void setItemValue(OXMLItem oXMLItem, XMLNode xMLNode) {
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createValueType((XMLNode)xMLNode);
        if (oXMLSequenceType == null) {
            if (xMLNode.getSchemaTypeName() != null && xMLNode.getPrimitiveTypeId() == 0) {
                throw new XQException(XQMesg.getInstance().getMessage0("FOTY0012"));
            }
            oXMLItem.setUntypedLexical(xMLNode.getText());
        } else if (oXMLSequenceType.exactlyMatches(OXMLSequenceType.TQNAME)) {
            QName qName = XQueryUtils.convertString2QName(xMLNode.getText(), null, xMLNode);
            oXMLItem.setQName(OXMLSequenceType.TQNAME, qName);
        } else {
            oXMLItem.setString(OXMLSequenceType.TSTRING, xMLNode.getText());
            oXMLItem.convert(oXMLSequenceType);
        }
    }

    public void copyItem(OXMLItem oXMLItem) {
        super.copyItem(oXMLItem);
        QueryState queryState = (QueryState)((OXQueryItem)oXMLItem).getContext();
        if (queryState != null) {
            this.ctx = queryState;
        }
    }

    protected OXMLFunctionContext getContext() {
        return this.ctx;
    }

    protected void convert2QName() {
        int n = this.getPrimitiveType();
        QName qName = null;
        switch (n) {
            case 18: {
                return;
            }
            case 0: 
            case 1: {
                String string = this.getString().trim();
                qName = XQueryUtils.convertString2QName(string, this.ctx, null);
            }
        }
        this.setQName(OXMLSequenceType.TQNAME, qName);
    }

    public void toSql(XQXGen xQXGen) {
    }

    public void toSql(StringBuffer stringBuffer) {
    }

    public void reset() {
        this.stype = null;
        this.nodeValue = null;
        this.objValue = null;
        this.lexicalValue = null;
    }
}

