/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.comp;

import java.io.PrintStream;

public class PageBuf {
    int lineLength;
    int lineNum;
    int currentPos;
    int indentLevel;
    StringBuffer strBuffer;
    int depth;
    boolean prettyPrint;

    private void init(int n) {
        this.strBuffer = new StringBuffer();
        this.reset(n);
        this.prettyPrint = true;
    }

    public PageBuf(int n) {
        this.init(n);
    }

    public PageBuf() {
        this.init(140);
    }

    public void prettyPrintOff() {
        this.prettyPrint = false;
    }

    public void reset() {
        this.lineNum = 0;
        this.currentPos = 0;
        this.indentLevel = 0;
        this.depth = 0;
        this.strBuffer.setLength(0);
    }

    public void reset(int n) {
        this.lineLength = n;
        this.reset();
    }

    public void setIndentLevel(int n) {
        this.indentLevel = n;
        --this.depth;
    }

    public void setIndentLevel() {
        this.indentLevel = this.currentPos;
        ++this.depth;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public void append(char c) {
        this.reposition(1);
        this.strBuffer.append(c);
        ++this.currentPos;
    }

    public void append(char[] cArray) {
        this.reposition(cArray.length);
        this.strBuffer.append(cArray);
        this.currentPos += cArray.length;
    }

    public void append(char[] cArray, int n, int n2) {
        this.reposition(n2);
        this.strBuffer.append(cArray, n, n2);
        this.currentPos += n2;
    }

    public void append(String string) {
        this.reposition(string.length());
        this.strBuffer.append(string);
        this.currentPos += string.length();
    }

    public void newline() {
        this.strBuffer.append('\n');
        ++this.lineNum;
        this.currentPos = 0;
        while (this.currentPos < this.indentLevel) {
            this.strBuffer.append(' ');
            ++this.currentPos;
        }
    }

    private void reposition(int n) {
        if (!this.prettyPrint) {
            return;
        }
        if (this.currentPos + n < this.lineLength) {
            return;
        }
        this.newline();
    }

    public void display(PrintStream printStream) {
        printStream.println(this.strBuffer.substring(0, this.strBuffer.length()));
    }
}

