/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.xml.parser.v2.BlobPageManager;
import oracle.xml.parser.v2.FilePageManager;
import oracle.xml.scalable.PageManager;
import oracle.xml.scalable.PageManagerPool;

public class XQPageManagerPool
implements PageManagerPool {
    private Connection _connection = null;
    private ArrayList _pagemanagers = new ArrayList();

    private XQPageManagerPool() {
    }

    public static XQPageManagerPool getInstance() {
        return new XQPageManagerPool();
    }

    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    public PageManager getPageManager(String string) {
        FilePageManager filePageManager;
        if (this._connection != null) {
            try {
                filePageManager = new BlobPageManager(this._connection);
                this._pagemanagers.add(filePageManager);
            }
            catch (SQLException sQLException) {
                filePageManager = null;
            }
        } else {
            filePageManager = new FilePageManager(string, "new");
            this._pagemanagers.add(filePageManager);
        }
        return filePageManager;
    }

    public PageManager getPageManager() {
        BlobPageManager blobPageManager = null;
        if (this._connection != null) {
            try {
                blobPageManager = new BlobPageManager(this._connection);
                this._pagemanagers.add(blobPageManager);
            }
            catch (SQLException sQLException) {
                blobPageManager = null;
            }
        }
        return blobPageManager;
    }

    public void returnPageManager(PageManager pageManager) {
        int n = this._pagemanagers.indexOf(pageManager);
        if (n != -1) {
            this._pagemanagers.remove(n);
        }
        pageManager.close();
    }

    public void close() {
        int n = this._pagemanagers.size();
        for (int i = 0; i < n; ++i) {
            ((PageManager)this._pagemanagers.get(i)).close();
        }
    }
}

