/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery;

import oracle.xml.parser.v2.XMLNode;
import oracle.xml.sql.query.OracleXMLQuery;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xquery.SQLDataSource;
import oracle.xquery.XMLDataSourceIterator;
import oracle.xquery.XQException;

public class SQLIterator
implements XMLDataSourceIterator {
    private SQLDataSource outerDataSrc;
    private XMLNode resultNode;
    private OracleXMLQuery qry;
    private boolean noMoreData;

    public SQLIterator(SQLDataSource sQLDataSource) {
        this.outerDataSrc = sQLDataSource;
        this.noMoreData = true;
    }

    @Override
    public void start() {
        this.qry = new OracleXMLQuery(this.outerDataSrc.conn, this.outerDataSrc.sqlString);
        this.qry.setMaxRows(1);
        this.qry.keepObjectOpen(true);
        this.noMoreData = false;
    }

    @Override
    public void start(OXMLItem[] oXMLItemArray) {
        throw new XQException("sql datasource does not take in arguments");
    }

    @Override
    public boolean fetch(OXMLItem oXMLItem) {
        if (this.noMoreData) {
            return false;
        }
        this.resultNode = (XMLNode)this.qry.getXMLDOM().getDocumentElement().getFirstChild();
        this.noMoreData = true;
        if (this.qry.getNumRowsProcessed() == 1L) {
            oXMLItem.setNode(this.resultNode);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.noMoreData = true;
    }
}

