/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views.tables;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.SquareIconButton;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorFactory;
import oracle.dbtools.raptor.ui.table.ListReorderableTableModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.components.MapGeometry;
import oracle.dbtools.spatial.mapviewer.components.MapViewerHelper;
import oracle.dbtools.spatial.persistence.QueryHistoryManager;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.TableToolbar;
import oracle.spatial.geometry.JGeometry;

public class SpatialReorderableTableModel
extends ListReorderableTableModel<QueryObject> {
    private static final long serialVersionUID = 1L;
    private static final String[] cols = new String[]{SpatialArb.getString("SPATIAL_TABLE_ACTIVE"), SpatialArb.getString("SPATIAL_TABLE_MAP_TITLE"), SpatialArb.getString("SPATIAL_TABLE_SQL_SENTENCE"), SpatialArb.getString("SPATIAL_TABLE_ANNOTATION"), SpatialArb.getString("NewQueryDialogLabelColorLabel"), SpatialArb.getString("SPATIAL_TABLE_MARKER_TYPE"), SpatialArb.getString("SPATIAL_TABLE_MARKER_BORDER_COLOR"), SpatialArb.getString("SPATIAL_TABLE_MARKER_FILL_COLOR"), SpatialArb.getString("SPATIAL_TABLE_MARKER_WIDTH"), SpatialArb.getString("SPATIAL_TABLE_CURVE_COLOR"), SpatialArb.getString("SPATIAL_TABLE_CURVE_WIDTH"), SpatialArb.getString("SPATIAL_TABLE_AREA_LINE"), SpatialArb.getString("SPATIAL_TABLE_AREA_FILL")};
    private static final String[] ttps = new String[]{SpatialArb.getString("SPATIAL_TABLE_ACTIVE_TTP"), SpatialArb.getString("SPATIAL_TABLE_MAP_TITLE_TTP"), SpatialArb.getString("SPATIAL_TABLE_SQL_SENTENCE_TTP"), SpatialArb.getString("SPATIAL_TABLE_ANNOTATION_TTP"), SpatialArb.getString("NewQueryDialogLabelColorLabel"), SpatialArb.getString("SPATIAL_TABLE_MARKER_TYPE_TTP"), SpatialArb.getString("SPATIAL_TABLE_MARKER_BORDER_COLOR_TTP"), SpatialArb.getString("SPATIAL_TABLE_MARKER_FILL_COLOR_TTP"), SpatialArb.getString("SPATIAL_TABLE_MARKER_WIDTH_TTP"), SpatialArb.getString("SPATIAL_TABLE_CURVE_COLOR_TTP"), SpatialArb.getString("SPATIAL_TABLE_CURVE_WIDTH_TTP"), SpatialArb.getString("SPATIAL_TABLE_AREA_LINE_TTP"), SpatialArb.getString("SPATIAL_TABLE_AREA_FILL_TTP")};
    private static final int ACTIVE = 0;
    private static final int NAME = 1;
    private static final int SQL_SENTENCE = 2;
    private static final int ANNOTATION = 3;
    private static final int LABEL_COLOR = 4;
    private static final int MARKER_TYPE = 5;
    private static final int MARKER_BORDER_COLOR = 6;
    private static final int MARKER_FILL_COLOR = 7;
    private static final int MARKER_WIDTH = 8;
    private static final int CURVE_COLOR = 9;
    private static final int CURVE_WIDTH = 10;
    private static final int AREA_FILL = 12;
    private static final int AREA_LINE = 11;
    private TableToolbar _toolbar;
    private GenericTable _table;
    MapGeometry[] currentGeometries = null;
    private QueryHistoryManager historyManager;
    private QueryObject[] restoredObjects;
    private String rTabId;
    private String rQCnx;
    private UUID modelId;
    private int srid = -10;
    JGeometry[] hiliteGeoms;

    public SpatialReorderableTableModel() {
        super(cols, ttps);
        this.setRowList(new ArrayList());
        this.hiliteGeoms = new JGeometry[0];
        this.historyManager = new QueryHistoryManager();
        this.modelId = UUID.randomUUID();
    }

    public SpatialReorderableTableModel(UUID uUID) {
        super(cols, ttps);
        this.setRowList(new ArrayList());
        this.historyManager = new QueryHistoryManager();
        this.modelId = uUID;
    }

    public void setToolbar(TableToolbar tableToolbar) {
        this._toolbar = tableToolbar;
    }

    public void setTable(JTable jTable) {
        super.setTable(jTable);
        this._table = (GenericTable)jTable;
        this._table.setName("Spatial query layer table");
        this.setEditable(true);
        jTable.setSurrendersFocusOnKeystroke(true);
        jTable.setSelectionMode(2);
        jTable.setCellSelectionEnabled(false);
        jTable.setRowSelectionAllowed(true);
        if (jTable instanceof GenericTable) {
            GenericTable genericTable = (GenericTable)jTable;
            genericTable.setSelectAllEnabled(true);
            genericTable.setColumnSelectorAvailable(true);
        }
        jTable.getColumnModel().getColumn(11).setCellRenderer(new ColorCellRenderer());
        jTable.getColumnModel().getColumn(11).setCellEditor(new ColorCellEditor());
        jTable.getColumnModel().getColumn(12).setCellRenderer(new ColorCellRenderer());
        jTable.getColumnModel().getColumn(12).setCellEditor(new ColorCellEditor());
        jTable.getColumnModel().getColumn(9).setCellRenderer(new ColorCellRenderer());
        jTable.getColumnModel().getColumn(9).setCellEditor(new ColorCellEditor());
        jTable.getColumnModel().getColumn(5).setCellRenderer(new MarkerCellRenderer());
        jTable.getColumnModel().getColumn(5).setCellEditor(new MarkerCellEditor());
        jTable.getColumnModel().getColumn(6).setCellRenderer(new ColorCellRenderer());
        jTable.getColumnModel().getColumn(6).setCellEditor(new ColorCellEditor());
        jTable.getColumnModel().getColumn(7).setCellRenderer(new ColorCellRenderer());
        jTable.getColumnModel().getColumn(7).setCellEditor(new ColorCellEditor());
        jTable.getColumnModel().getColumn(2).setCellEditor(new QueryCellEditor());
        jTable.getColumnModel().getColumn(3).setCellEditor(new AnnotationCellEditor());
        jTable.getColumnModel().getColumn(4).setCellRenderer(new ColorCellRenderer());
        jTable.getColumnModel().getColumn(4).setCellEditor(new ColorCellEditor());
        jTable.getColumnModel().getColumn(1).setCellEditor(new TitleCellEditor());
        jTable.getColumnModel().getColumn(10).setCellEditor(new CurveWidthEditor());
        jTable.getColumnModel().getColumn(8).setCellEditor(new MarkerSizeEditor());
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SpatialViewController.getInstance().toggleToolbar();
            }
        });
    }

    protected Object getValueAt(QueryObject queryObject, int n) {
        switch (n) {
            case 0: {
                SpatialViewController.getInstance().toggleToolbar();
                return queryObject.isPreselected();
            }
            case 1: {
                return queryObject.getQueryTitle();
            }
            case 2: {
                return queryObject.getQueryText();
            }
            case 5: {
                return queryObject.getMarkerType();
            }
            case 7: {
                return queryObject.getMarkerFillColor();
            }
            case 6: {
                return queryObject.getMarkerColor();
            }
            case 8: {
                return queryObject.getMarkerSize();
            }
            case 9: {
                return queryObject.getCurvesColor();
            }
            case 10: {
                return queryObject.getCurveLineWidth();
            }
            case 12: {
                return queryObject.getAreaFillColor();
            }
            case 11: {
                return queryObject.getAreaBorderColor();
            }
            case 3: {
                return queryObject.getAnnotatedColumn();
            }
            case 4: {
                return queryObject.getLabelColor();
            }
        }
        return null;
    }

    protected void setValueAt(Object object, QueryObject queryObject, int n) {
        int n2 = this.getSelectedRow();
        boolean bl = false;
        switch (n) {
            case 0: {
                if (queryObject.isPreselected() != ((Boolean)object).booleanValue()) {
                    queryObject.setPreselected((Boolean)object);
                } else {
                    bl = true;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialUtil.getMapViewer(SpatialReorderableTableModel.this.getIdentifier().toString()).getMapViewerContoller().clearAllSelections();
                    }
                });
                break;
            }
            case 1: {
                if (!queryObject.getQueryTitle().equals(object)) {
                    queryObject.setNewTitle((String)object);
                    break;
                }
                bl = true;
                break;
            }
            case 2: {
                if (!queryObject.getQueryText().equals(object)) {
                    queryObject.setQueryText((String)object);
                    this.saveHiliteGeoms(new JGeometry[0]);
                    break;
                }
                bl = true;
                break;
            }
            case 3: {
                String string = queryObject.getAnnotatedColumn();
                if (!string.equals(object)) {
                    queryObject.setAnnotatedColumn((String)object);
                    queryObject.setLabelChanged(true);
                    break;
                }
                bl = true;
                break;
            }
            case 4: {
                if (!queryObject.getLabelColor().equals(object)) {
                    queryObject.setLabelColor((Color)object);
                    break;
                }
                bl = true;
                break;
            }
            case 5: {
                if (queryObject.getMarkerType() != ((Integer)object).intValue()) {
                    queryObject.setMarkerType((Integer)object);
                    break;
                }
                bl = true;
                break;
            }
            case 6: {
                if (!queryObject.getMarkerColor().equals(object)) {
                    queryObject.setMarkerColor((Color)object);
                    break;
                }
                bl = true;
                break;
            }
            case 7: {
                if (!queryObject.getMarkerFillColor().equals(object)) {
                    queryObject.setMarkerFillColor((Color)object);
                    break;
                }
                bl = true;
                break;
            }
            case 8: {
                if (queryObject.getMarkerSize() != ((Integer)object).intValue()) {
                    queryObject.setMarkerSize((Integer)object);
                    break;
                }
                bl = true;
                break;
            }
            case 9: {
                if (!queryObject.getCurvesColor().equals(object)) {
                    queryObject.setCurvesColor((Color)object);
                    break;
                }
                bl = true;
                break;
            }
            case 10: {
                if (queryObject.getCurveLineWidth() != ((Integer)object).intValue()) {
                    queryObject.setCurveLineWidth((Integer)object);
                    break;
                }
                bl = true;
                break;
            }
            case 12: {
                if (!queryObject.getAreaFillColor().equals(object)) {
                    queryObject.setAreaFillColor((Color)object);
                    break;
                }
                bl = true;
                break;
            }
            case 11: {
                if (!queryObject.getAreaBorderColor().equals(object)) {
                    queryObject.setAreaBorderColor((Color)object);
                    break;
                }
                bl = true;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (!bl) {
            SpatialUtil.getMapViewer(this.getIdentifier().toString()).getMapViewerContoller().updateLayer(n2, queryObject);
            this.historyManager.editRecord(queryObject);
        }
    }

    protected boolean isCellEditable(QueryObject queryObject, int n) {
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 5: {
                return true;
            }
            case 7: {
                return true;
            }
            case 6: {
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 12: {
                return true;
            }
            case 11: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    public List<QueryObject> addRow(QueryObject queryObject) {
        Object[] objectArray = new Object[1];
        queryObject = this.getUniqueTitle(queryObject);
        int n = queryObject.getSRID();
        ArrayList arrayList = new ArrayList(this.getRowList());
        if (!arrayList.contains(queryObject) && this.getIdentifier().toString().equals(queryObject.getTabIdentifier()) && queryObject.areGeomsLoaded()) {
            objectArray[0] = queryObject;
            if (this.getTableSRID() == -10) {
                this.setTableSRID(n);
            }
            super.addRow(objectArray);
            int n2 = this.getRowCount();
            queryObject.setLayerNumber(n2);
            this.historyManager.addRecord((QueryObject)objectArray[0]);
            SpatialUtil.getMapViewer(this.getIdentifier().toString()).getMapViewerContoller().clearAllSelections();
            SpatialUtil.getMapViewer(this.getIdentifier().toString()).getMapViewerContoller().addLayerToCanvas(queryObject, n2);
        }
        return this.getRowList();
    }

    public void addRowAt(QueryObject queryObject, int n) {
        queryObject = this.getUniqueTitle(queryObject);
        int n2 = queryObject.getSRID();
        ArrayList arrayList = new ArrayList(this.getRowList());
        if (!arrayList.contains(queryObject) && this.getIdentifier().toString().equals(queryObject.getTabIdentifier())) {
            if (this.getTableSRID() == -10) {
                this.setTableSRID(n2);
            }
            super.getRowList().add(n, queryObject);
            queryObject.setLayerNumber(n + 1);
            this.historyManager.addRecord(queryObject);
            SpatialUtil.getMapViewer(this.getIdentifier().toString()).getMapViewerContoller().clearAllSelections();
            SpatialUtil.getMapViewer(this.getIdentifier().toString()).getMapViewerContoller().addLayerToCanvas(queryObject, n + 1);
        }
    }

    public boolean isEmpty() {
        return this._rowList.isEmpty();
    }

    private synchronized QueryObject getUniqueTitle(QueryObject queryObject) {
        boolean bl = true;
        int n = 0;
        String string = queryObject.getQueryTitle();
        Object object = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getRowList();
        for (QueryObject queryObject2 : list) {
            arrayList.add(queryObject2.getQueryTitle());
        }
        bl = arrayList.contains(queryObject.getQueryTitle());
        while (bl) {
            object = string + "_" + n;
            bl = arrayList.contains(object);
            ++n;
        }
        queryObject.setNewTitle((String)object);
        queryObject.setQueryTitle((String)object);
        return queryObject;
    }

    private synchronized boolean isTitleInTable(String string) {
        List list = this.getRowList();
        for (QueryObject queryObject : list) {
            if (!queryObject.getQueryTitle().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void removeRow(int n) {
        List list = this.getRowList();
        QueryObject queryObject = (QueryObject)list.get(n);
        if (queryObject != null) {
            this.historyManager.deleteRecord(queryObject);
            super.removeRow(n);
            if (this.getRowCount() == 0) {
                this.setTableSRID(-10);
            } else {
                this.setTableSRID(((QueryObject)this.getRowList().get(0)).getSRID());
            }
        }
    }

    public void moveRow(int n, int n2, int n3) {
        super.moveRow(n, n2, n3);
        List list = this.getRowList();
        SpatialUtil.getMapViewer(this.getIdentifier().toString()).getMapViewerContoller().moveLayer(n, n3);
        for (int i = 0; i < list.size(); ++i) {
            int n4 = i + 1;
            QueryObject queryObject = (QueryObject)list.get(i);
            queryObject.setLayerNumber(n4);
            this.historyManager.editRecord(queryObject);
        }
    }

    public void removeAll() {
        super.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryObject[] getQueryObjectsFromHistoryEasy(String string, String string2) {
        QueryObject[] queryObjectArray = null;
        String[] stringArray = null;
        queryObjectArray = this.historyManager.getQueryObjectsFromTab(string, string2);
        String string3 = SpatialUtil.getPanel().getTabPageByTabId(string).getCombobox().getCurrentConnectionName();
        if (queryObjectArray != null && queryObjectArray.length > 0 && string3.equals(string2)) {
            try {
                Connection connection = Connections.getInstance().getConnection(string3);
                for (QueryObject queryObject : queryObjectArray) {
                    try {
                        stringArray = MapViewerHelper.getColumnNames(queryObject.getQueryText(), connection);
                    }
                    catch (Exception exception) {
                        stringArray = new String[]{""};
                        queryObject.setCandidateColumns(stringArray);
                    }
                    finally {
                        if (stringArray != null && stringArray.length > 0) {
                            queryObject.setCandidateColumns(stringArray);
                        }
                    }
                }
            }
            catch (DBException dBException) {
                System.err.println("Cannot restore history: " + dBException.getMessage());
            }
        }
        return queryObjectArray;
    }

    public List<QueryObject> getActiveItemList() {
        List list = this.getRowList();
        ArrayList<QueryObject> arrayList = new ArrayList<QueryObject>();
        for (QueryObject queryObject : list) {
            if (!queryObject.isPreselected()) continue;
            arrayList.add(queryObject);
        }
        return arrayList;
    }

    public int getTableSRID() {
        return this.srid;
    }

    public void setTableSRID(int n) {
        this.srid = n;
    }

    public boolean checkTableSRID(int n) {
        if (this.getRowCount() < 1) {
            this.srid = n;
            return true;
        }
        return this.srid == n;
    }

    public UUID getIdentifier() {
        return this.modelId;
    }

    public void eraseTabHistory(String string) {
        this.historyManager.deleteAllTabRecords(string);
    }

    public void replaceHistoryTask(String string) {
        this.rTabId = this.getIdentifier().toString();
        this.rQCnx = string;
        this.removeAll();
        this.restoredObjects = this.getQueryObjectsFromHistoryEasy(this.rTabId, this.rQCnx);
        if (this.restoredObjects != null && this.restoredObjects.length > 0) {
            Arrays.sort(this.restoredObjects);
            this.restoreHistory(this.restoredObjects);
        }
    }

    private void restoreHistory(QueryObject[] queryObjectArray) {
        int n = -100;
        boolean bl = true;
        if (queryObjectArray.length > 0 && queryObjectArray != null) {
            Arrays.sort(queryObjectArray);
        }
        for (QueryObject queryObject : queryObjectArray) {
            if (n == -100) {
                n = queryObject.getSRID();
            }
            if (n == -10) {
                n = queryObject.getSRID();
            }
            if (n == queryObject.getSRID() || queryObject.getSRID() == -10) continue;
            bl = false;
            break;
        }
        this.setTableSRID(n);
        this.setRowList(Arrays.asList(queryObjectArray));
        for (QueryObject queryObject : queryObjectArray) {
            try {
                SpatialUtil.getMapViewer(this.getIdentifier().toString()).getMapViewerContoller().addLayerToCanvas(queryObject, queryObject.getLayerNumber());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void hideBottomLayers() {
        List list = this.getRowList();
        for (int i = 0; i < list.size(); ++i) {
            ((QueryObject)list.get(i)).setPreselected(false);
            SpatialUtil.getMapViewer(this.getIdentifier().toString()).getMapViewerContoller().updateLayer(i, (QueryObject)list.get(i));
        }
    }

    public void saveTabInSession(String string) {
        this.historyManager.addTabRecord(this.getIdentifier().toString(), string);
    }

    public void toggleActiveConnectionHistory(String string) {
        this.historyManager.toggleActiveConnectionInTab(this.getIdentifier().toString(), string);
    }

    public void saveHiliteGeoms(JGeometry[] jGeometryArray) {
        this.hiliteGeoms = jGeometryArray;
    }

    public JGeometry[] getHiliteGeoms() {
        return this.hiliteGeoms;
    }

    class MarkerCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        int selectedType;
        JComboBox columnBox;
        String[] columns;
        JLabel markerNameLabel;
        JButton pencilButton;
        JPanel holdingPanel;

        MarkerCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.selectedType;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string;
            this.holdingPanel = new JPanel(new BorderLayout()){

                @Override
                public void requestFocus() {
                    MarkerCellEditor.this.pencilButton.requestFocusInWindow();
                    if (MarkerCellEditor.this.pencilButton.isFocusOwner()) {
                        MarkerCellEditor.this.pencilButton.doClick();
                    }
                }
            };
            this.pencilButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
            this.pencilButton.setFocusable(true);
            this.pencilButton.setMargin(new Insets(2, 2, 2, 2));
            this.markerNameLabel = new JLabel();
            String[] stringArray = MapViewerHelper.getMarkerNamesArray();
            if (object instanceof Integer) {
                this.selectedType = (Integer)object;
                string = stringArray[(Integer)object];
            } else {
                this.selectedType = 0;
                string = stringArray[0];
            }
            this.markerNameLabel.setText(string);
            this.columnBox = new JComboBox<String>(new DefaultComboBoxModel<String>(stringArray));
            this.columnBox.setSelectedItem(string);
            this.columnBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MarkerCellEditor.this.selectedType = MarkerCellEditor.this.columnBox.getSelectedIndex();
                }
            });
            this.pencilButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MarkerCellEditor.this.holdingPanel.remove(MarkerCellEditor.this.markerNameLabel);
                            MarkerCellEditor.this.holdingPanel.add(MarkerCellEditor.this.columnBox);
                            MarkerCellEditor.this.columnBox.requestFocus();
                            MarkerCellEditor.this.holdingPanel.revalidate();
                        }
                    });
                }
            });
            this.holdingPanel.setName("Marker type container panel (editor)");
            this.columnBox.setName("Marker type selection combobox");
            this.holdingPanel.add("Center", this.markerNameLabel);
            this.holdingPanel.add("East", this.pencilButton);
            return this.holdingPanel;
        }
    }

    class MarkerCellRenderer
    extends DefaultTableCellRenderer {
        JLabel holdingTextLabel = new JLabel();

        MarkerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            String[] stringArray = MapViewerHelper.getMarkerNamesArray();
            JPanel jPanel = new JPanel(new BorderLayout()){

                @Override
                public void requestFocus() {
                    MarkerCellRenderer.this.holdingTextLabel.requestFocus();
                }
            };
            string = object instanceof Integer ? stringArray[(Integer)object] : stringArray[0];
            this.holdingTextLabel.setText(string);
            this.holdingTextLabel.setName("Marker type label");
            jPanel.setName("Marker type panel container (renderer)");
            jPanel.add("Center", this.holdingTextLabel);
            return jPanel;
        }
    }

    class AnnotationCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        String annotatedColumn;
        JComboBox columnBox;
        String[] columns;
        JButton delegateButton;
        JLabel mapLabel;
        JPanel holdingPanel;

        AnnotationCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.annotatedColumn;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.delegateButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
            this.delegateButton.setFocusable(true);
            this.delegateButton.setMargin(new Insets(2, 2, 2, 2));
            this.holdingPanel = new JPanel(new BorderLayout()){

                @Override
                public void requestFocus() {
                    AnnotationCellEditor.this.delegateButton.requestFocusInWindow();
                    if (AnnotationCellEditor.this.delegateButton.isFocusOwner()) {
                        AnnotationCellEditor.this.delegateButton.doClick();
                    }
                }
            };
            String[] stringArray = new String[1];
            if (object instanceof String) {
                this.mapLabel = new JLabel((String)object);
            }
            this.annotatedColumn = "";
            List list = SpatialReorderableTableModel.this.getRowList();
            Object e = list.get(n);
            if (e instanceof QueryObject) {
                QueryObject queryObject = (QueryObject)e;
                this.columns = queryObject.getCandidateAnnotation();
            }
            this.columnBox = new JComboBox<String>(new DefaultComboBoxModel<String>(stringArray));
            this.columnBox.setName("Map label combobox selector");
            this.columnBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AnnotationCellEditor.this.annotatedColumn = (String)AnnotationCellEditor.this.columnBox.getSelectedItem();
                    if (AnnotationCellEditor.this.annotatedColumn == null) {
                        AnnotationCellEditor.this.annotatedColumn = "";
                    }
                }
            });
            this.delegateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AnnotationCellEditor.this.holdingPanel.remove(AnnotationCellEditor.this.mapLabel);
                            AnnotationCellEditor.this.holdingPanel.add(AnnotationCellEditor.this.columnBox);
                            AnnotationCellEditor.this.columnBox.requestFocus();
                            AnnotationCellEditor.this.holdingPanel.revalidate();
                        }
                    });
                }
            });
            if (this.columns != null && this.columns.length > 0) {
                this.columnBox.setModel(new DefaultComboBoxModel<String>(this.columns));
                this.columnBox.setSelectedItem(object);
            }
            this.holdingPanel.setName("Label selector panel container (editor)");
            this.holdingPanel.add("Center", this.mapLabel);
            this.holdingPanel.add("East", this.delegateButton);
            return this.holdingPanel;
        }
    }

    class QueryCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        String revisitedQuery;
        JLabel holdingLabel;
        String prevQuery;
        PopupCellEditor popupEditor;
        JButton editBtn;
        JTable theTable;
        Connection cnx;
        Boolean stopClose;

        QueryCellEditor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getCellEditorValue() {
            Vector<Integer[]> vector;
            int n = SpatialReorderableTableModel.this.getTable().getEditingRow();
            String string = ((QueryObject)SpatialReorderableTableModel.this.getRowList().get(n)).getQueryText();
            int n2 = SpatialReorderableTableModel.this.getTableSRID();
            if (this.revisitedQuery.equals(string)) {
                return this.revisitedQuery;
            }
            try {
                String[] stringArray;
                Connection connection = MapViewerHelper.getCurrentTabCnx();
                if (MapViewerHelper.isValidSpatialQuery(this.revisitedQuery, connection)) {
                    stringArray = MapViewerHelper.getColumnNames(this.revisitedQuery, connection);
                    vector = MapViewerHelper.getQuerySRIDS(this.revisitedQuery, connection);
                    if (MapViewerHelper.areQuerySRIDsValid(n2, vector)) {
                        ((QueryObject)SpatialReorderableTableModel.this.getRowList().get(n)).setCandidateColumns(stringArray);
                        ((QueryObject)SpatialReorderableTableModel.this.getRowList().get(n)).setAnnotatedColumn("");
                        String string2 = this.revisitedQuery;
                        return string2;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("NonUniqueSRIDException"), (String)SpatialArb.getString("SPATIAL_NEW_QUERY_DLG_ERR_TITLE"), null);
                } else if (this.revisitedQuery != null) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("SPATIAL_NEW_QUERY_DLG_ERR_TEXT"), (String)SpatialArb.getString("SPATIAL_NEW_QUERY_DLG_ERR_TITLE"), null);
                    this.revisitedQuery = null;
                }
                stringArray = string;
                return stringArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, outOfMemoryError.getStackTrace()[0].toString(), outOfMemoryError);
                vector = string;
                return vector;
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)SpatialArb.getString("SPATIAL_NEW_QUERY_DLG_ERR_TEXT"), null);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                vector = string;
                return vector;
            }
            finally {
                System.gc();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editBtn = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
            this.theTable = jTable;
            JPanel jPanel = new JPanel(new BorderLayout()){
                private static final long serialVersionUID = 1L;

                @Override
                public void requestFocus() {
                    QueryCellEditor.this.editBtn.requestFocusInWindow();
                    if (QueryCellEditor.this.editBtn.isFocusOwner()) {
                        QueryCellEditor.this.editBtn.doClick();
                    }
                }
            };
            jPanel.setName("Query text panel (editor)");
            this.prevQuery = object.toString();
            this.holdingLabel = new JLabel(this.prevQuery);
            this.revisitedQuery = this.prevQuery;
            try {
                this.cnx = MapViewerHelper.getCurrentTabCnx();
                String string = (String)SpatialUtil.getPanel().getSelectedTabPage().getCombobox().getJComboBox().getSelectedItem();
                this.popupEditor = PopupCellEditorFactory.getPopupCellEditor((String)string, (int)12);
                this.popupEditor.setConnection(this.cnx);
                this.popupEditor.setEditable(true);
                this.popupEditor.setValue((Object)this.prevQuery);
                this.editBtn.setName("EditCell");
                this.editBtn.setMargin(new Insets(2, 2, 2, 2));
                this.editBtn.setFocusable(true);
                this.editBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                QueryCellEditor.this.popupEditor.setValue((Object)QueryCellEditor.this.prevQuery);
                                QueryCellEditor.this.handlePopupEdit(QueryCellEditor.this.popupEditor);
                                if (QueryCellEditor.this.theTable.isVisible()) {
                                    QueryCellEditor.this.theTable.requestFocusInWindow();
                                }
                            }
                        });
                    }
                });
                jPanel.add("Center", this.holdingLabel);
                jPanel.add("After", this.editBtn);
                this.holdingLabel.setText(this.prevQuery);
                this.holdingLabel.setName("Query text label (editor)");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return jPanel;
        }

        public void handlePopupEdit(final PopupCellEditor popupCellEditor) {
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)popupCellEditor.getComponent(), (Component)popupCellEditor.getDefaultComponent(), (String)SpatialArb.getString("MapViewerPanelToolTipEditQuery"));
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                        String string = popupCellEditor.validateValue();
                        String string2 = (String)popupCellEditor.getValue();
                        if (string == null) {
                            QueryCellEditor.this.revisitedQuery = QueryCellEditor.this.stripSemicolon(string2);
                            QueryCellEditor.this.stopCellEditing();
                        } else {
                            QueryCellEditor.this.cancelCellEditing();
                        }
                    }
                }
            });
            jEWTDialog.setOKButtonEnabled(true);
            popupCellEditor.setPopupDialog(jEWTDialog);
            WizardLauncher.runDialog((JDialog)jEWTDialog);
        }

        private String stripSemicolon(String string) {
            int n = string.length();
            if (string.lastIndexOf(59) == n - 1) {
                return string.substring(0, n);
            }
            return string;
        }
    }

    class TitleCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel holdingPanel;
        JButton pencilButton;
        JLabel editorLabel;
        JTextField editingField;
        String value;
        JTable theTable;

        TitleCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.theTable = jTable;
            this.value = (String)object;
            this.editorLabel = new JLabel(this.value);
            this.editorLabel.setName("map title label (cell editor)");
            this.holdingPanel = new JPanel(new BorderLayout()){

                @Override
                public void requestFocus() {
                    TitleCellEditor.this.pencilButton.requestFocusInWindow();
                    if (TitleCellEditor.this.pencilButton.isFocusOwner()) {
                        TitleCellEditor.this.pencilButton.doClick();
                    }
                }
            };
            this.holdingPanel.setName("map title panel (cell editor)");
            this.editingField = new JTextField(this.value);
            this.editingField.setName("map title editing field (cell editor)");
            this.pencilButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
            this.pencilButton.setFocusable(true);
            this.pencilButton.setMargin(new Insets(2, 2, 2, 2));
            this.pencilButton.setName("map title edit button (cell editor)");
            this.pencilButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (TitleCellEditor.this.theTable.isVisible()) {
                                TitleCellEditor.this.theTable.requestFocusInWindow();
                                TitleCellEditor.this.holdingPanel.remove(TitleCellEditor.this.editorLabel);
                                TitleCellEditor.this.holdingPanel.add(TitleCellEditor.this.editingField);
                                TitleCellEditor.this.editingField.requestFocus();
                                TitleCellEditor.this.holdingPanel.revalidate();
                            }
                        }
                    });
                }
            });
            this.holdingPanel.add((Component)this.editorLabel, "Center");
            this.holdingPanel.add((Component)this.pencilButton, "After");
            return this.holdingPanel;
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.editingField.getText().trim();
            if (string != null && string.length() > 0 && !string.equals("") && !SpatialReorderableTableModel.this.isTitleInTable(string)) {
                this.value = string;
            }
            return this.value;
        }
    }

    class MarkerSizeEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JLabel holdingLabel;
        JButton pencilButton;
        JSpinner spinner;
        JPanel holdingPanel;
        JTable theTable;
        int value;

        MarkerSizeEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            SpinnerNumberModel spinnerNumberModel;
            this.holdingPanel = new JPanel(new BorderLayout()){

                @Override
                public void requestFocus() {
                    MarkerSizeEditor.this.pencilButton.requestFocusInWindow();
                    if (MarkerSizeEditor.this.pencilButton.isFocusOwner()) {
                        MarkerSizeEditor.this.pencilButton.doClick();
                    }
                }
            };
            this.holdingLabel = new JLabel();
            this.holdingLabel.setName("marker size label (cell editor)");
            this.pencilButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
            this.pencilButton.setFocusable(true);
            this.pencilButton.setMargin(new Insets(2, 2, 2, 2));
            this.pencilButton.setName("marker size edit button (cell editor)");
            if (object instanceof Integer) {
                this.value = (Integer)object;
                spinnerNumberModel = new SpinnerNumberModel(this.value, 1, 250, 1);
                this.holdingLabel.setText(Integer.toString((Integer)object));
            } else {
                spinnerNumberModel = new SpinnerNumberModel(8, 1, 250, 1);
                this.holdingLabel.setText("8");
                this.value = 8;
            }
            this.spinner = new JSpinner(spinnerNumberModel);
            this.spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    MarkerSizeEditor.this.value = (Integer)MarkerSizeEditor.this.spinner.getValue();
                }
            });
            this.spinner.setName("marker size spinner (cell editor)");
            this.pencilButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MarkerSizeEditor.this.holdingPanel.remove(MarkerSizeEditor.this.holdingLabel);
                            MarkerSizeEditor.this.holdingPanel.add(MarkerSizeEditor.this.spinner);
                            MarkerSizeEditor.this.spinner.requestFocus();
                            MarkerSizeEditor.this.holdingPanel.revalidate();
                        }
                    });
                }
            });
            this.holdingPanel.add("Center", this.holdingLabel);
            this.holdingPanel.add("East", this.pencilButton);
            this.holdingPanel.setName("marker size holding panel (cell editor)");
            return this.holdingPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    class CurveWidthEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JLabel holdingLabel;
        JButton pencilButton;
        JSpinner spinner;
        JPanel holdingPanel;
        int value;

        CurveWidthEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            SpinnerNumberModel spinnerNumberModel;
            this.holdingPanel = new JPanel(new BorderLayout()){

                @Override
                public void requestFocus() {
                    CurveWidthEditor.this.pencilButton.requestFocusInWindow();
                    if (CurveWidthEditor.this.pencilButton.isFocusOwner()) {
                        CurveWidthEditor.this.pencilButton.doClick();
                    }
                }
            };
            this.holdingLabel = new JLabel();
            this.holdingLabel.setName("label width label (cell editor)");
            this.pencilButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
            this.pencilButton.setFocusable(true);
            this.pencilButton.setMargin(new Insets(2, 2, 2, 2));
            this.pencilButton.setName("curve width edit button (cell editor)");
            if (object instanceof Integer) {
                this.value = (Integer)object;
                spinnerNumberModel = new SpinnerNumberModel(this.value, 1, 250, 1);
                this.holdingLabel.setText(Integer.toString((Integer)object));
            } else {
                spinnerNumberModel = new SpinnerNumberModel(1, 1, 250, 1);
                this.holdingLabel.setText("1");
                this.value = 1;
            }
            this.spinner = new JSpinner(spinnerNumberModel);
            this.spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    CurveWidthEditor.this.value = (Integer)CurveWidthEditor.this.spinner.getValue();
                }
            });
            this.spinner.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                }
            });
            this.spinner.setName("curve width spinner (cell editor)");
            this.pencilButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CurveWidthEditor.this.holdingPanel.remove(CurveWidthEditor.this.holdingLabel);
                            CurveWidthEditor.this.holdingPanel.add(CurveWidthEditor.this.spinner);
                            CurveWidthEditor.this.spinner.requestFocus();
                            CurveWidthEditor.this.holdingPanel.revalidate();
                        }
                    });
                }
            });
            this.holdingPanel.add("Center", this.holdingLabel);
            this.holdingPanel.add("East", this.pencilButton);
            this.holdingPanel.setName("curve width holding panel (cell editor)");
            return this.holdingPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    class ColorCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1473864321417753465L;
        private JFrame dialogContainer;
        private JButton delegateButton;
        private JPanel holdingPanel;
        private JLabel colorLabel;
        private JTable theTable;
        private Color selectedColor;
        private JDialog chooserDialog;
        private JColorChooser colorChooser;

        ColorCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.selectedColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.selectedColor = (Color)object;
            this.theTable = jTable;
            this.delegateButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
            this.delegateButton.setFocusable(true);
            this.delegateButton.setMargin(new Insets(2, 2, 2, 2));
            this.dialogContainer = new JFrame();
            this.colorLabel = new JLabel();
            this.colorLabel.setName("Color label (editor)");
            this.colorChooser = new JColorChooser(this.selectedColor);
            this.holdingPanel = new JPanel(new BorderLayout()){

                @Override
                public void requestFocus() {
                    ColorCellEditor.this.delegateButton.requestFocusInWindow();
                    if (ColorCellEditor.this.delegateButton.isFocusOwner()) {
                        ColorCellEditor.this.delegateButton.doClick();
                    }
                }
            };
            this.holdingPanel.setName("Color panel (editor)");
            this.colorLabel.setBackground(this.selectedColor);
            this.holdingPanel.setBackground(this.selectedColor);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ColorCellEditor.this.selectedColor = ColorCellEditor.this.colorChooser.getColor();
                            ColorCellEditor.this.colorLabel.setBackground(ColorCellEditor.this.selectedColor);
                            ColorCellEditor.this.holdingPanel.setBackground(ColorCellEditor.this.selectedColor);
                            ColorCellEditor.this.stopCellEditing();
                        }
                    });
                }
            };
            ActionListener actionListener2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
            ActionListener actionListener3 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ColorCellEditor.this.theTable.isVisible()) {
                                ColorCellEditor.this.theTable.requestFocusInWindow();
                            }
                            ColorCellEditor.this.chooserDialog.setVisible(true);
                        }
                    });
                }
            };
            this.delegateButton.addActionListener(actionListener3);
            this.chooserDialog = JColorChooser.createDialog(this.dialogContainer, SpatialArb.getString("NewQueryDialogColorLabel"), true, this.colorChooser, actionListener, actionListener2);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ColorCellEditor.this.theTable.isVisible()) {
                        ColorCellEditor.this.theTable.requestFocusInWindow();
                    }
                }
            });
            this.holdingPanel.add("Center", this.colorLabel);
            this.holdingPanel.add("East", this.delegateButton);
            return this.holdingPanel;
        }
    }

    class ColorCellRenderer
    extends Component
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JPanel holdingPanel = new JPanel(new BorderLayout());
        private JLabel colorLabel;

        public ColorCellRenderer() {
            this.holdingPanel.setName("Color panel (renderer)");
            this.colorLabel = new JLabel();
            this.colorLabel.setName("Color label (renderer)");
            this.colorLabel.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = (Color)object;
            this.colorLabel.setBackground(color);
            this.holdingPanel.add("Center", this.colorLabel);
            this.holdingPanel.setToolTipText(color.toString());
            return this.holdingPanel;
        }
    }
}

