/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views.tables;

import java.awt.Color;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.spatial.mapviewer.components.MapViewerHelper;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.sdovis.JSDOGeometry;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.ROWID;

public class QueryObject
implements Comparable<QueryObject> {
    public static int DEFAULT_TYPE = 0;
    private int type = DEFAULT_TYPE;
    private String connectionSourceName;
    private boolean isPreselected = true;
    private String queryTitle;
    private String queryText;
    private Color areaBorderColor;
    private Color areaFillColor;
    private Color curvesColor;
    private int curveLineWidth;
    private Color markerColor;
    private Color markerFillColor;
    private int markerSize;
    private int markerType;
    private Color labelColor;
    private String labelColumn;
    private int layerNumber;
    private int srid;
    private String[] candidateColumns;
    private String tabIdentifier;
    private boolean isNewlyCreated;
    private String newTitle;
    private Connection cnx;
    private HashMap<String, JSDOGeometry> pointMap;
    private HashMap<String, JSDOGeometry> curveMap;
    private HashMap<String, JSDOGeometry> areaMap;
    private ResultSet queryRs;
    private ArrayList<String> pointKeys;
    private ArrayList<String> curveKeys;
    private ArrayList<String> areaKeys;
    private String geomColName;
    private double[] layerMBR;
    private ArrayList<HashMap<String, String>> columnLabelMappings;
    private ArrayList<String> allColumnNames;
    private boolean labelChanged;
    private boolean loadedGeoms;

    public QueryObject(String string, String string2, String string3, Color color, Color color2, Color color3, int n, int n2, Color color4, int n3, Color color5, Color color6, String[] stringArray, Connection connection) {
        this.queryTitle = string;
        this.queryText = string2;
        this.labelColumn = string3;
        this.labelColor = color;
        this.areaBorderColor = color5;
        this.areaFillColor = color6;
        this.curvesColor = color4;
        this.curveLineWidth = n3;
        this.markerColor = color2;
        this.markerFillColor = color3;
        this.markerSize = n;
        this.markerType = n2;
        this.type = DEFAULT_TYPE;
        this.candidateColumns = stringArray;
        this.cnx = connection;
        this.labelChanged = false;
        this.loadedGeoms = false;
        this.srid = -10;
        this.layerMBR = new double[4];
        if (this.getGeometries()) {
            this.loadedGeoms = true;
        }
    }

    public String getMarkerStyleString() {
        String string;
        String string2 = Integer.toString(this.markerSize);
        String string3 = StyleUtils.getHexidecimalString((Color)this.getMarkerColor());
        String string4 = StyleUtils.getHexidecimalString((Color)this.getMarkerFillColor());
        switch (this.markerType) {
            case 0: {
                string = "circle";
                break;
            }
            case 1: {
                string = "star";
                break;
            }
            case 2: {
                string = "rect";
                break;
            }
            case 3: {
                string = "arrow";
                break;
            }
            default: {
                string = "circle";
            }
        }
        String string5 = "marker_" + string + "_" + string4 + "_" + string3 + "_" + string2 + "_255";
        return string5;
    }

    public String getLineStyleString() {
        Object object = "line_red_1_255";
        String string = StyleUtils.getHexidecimalString((Color)this.getCurvesColor());
        object = "line_" + string + "_" + this.curveLineWidth + "_255";
        return object;
    }

    public String getAreaStyleString() {
        Object object = "color_cyan_black_255";
        String string = StyleUtils.getHexidecimalString((Color)this.getAreaFillColor());
        String string2 = StyleUtils.getHexidecimalString((Color)this.getAreaBorderColor());
        object = "color_" + string + "_" + string2 + "_255";
        return object;
    }

    public String getHoverAreaStyleString() {
        String string = StyleUtils.getHexidecimalString((Color)this.getAreaBorderColor());
        return string;
    }

    public String getLabelStyleString() {
        Object object = "";
        String string = StyleUtils.getHexidecimalString((Color)this.getLabelColor());
        object = "text_Dialog_" + string + "_12_false_false";
        return object;
    }

    public HashMap<String, String> getSelectedLabelColumnData() {
        int n = this.allColumnNames.indexOf(this.labelColumn);
        HashMap<String, String> hashMap = n >= 0 ? this.columnLabelMappings.get(n) : new HashMap<String, String>();
        return hashMap;
    }

    public HashMap<String, String> getLabelColumnData(int n) {
        if (n >= 0 && n < this.columnLabelMappings.size()) {
            return this.columnLabelMappings.get(n);
        }
        return new HashMap<String, String>();
    }

    public ArrayList<String> getAllColumnNames() {
        return this.allColumnNames;
    }

    @Override
    public int compareTo(QueryObject queryObject) {
        return Integer.compare(this.layerNumber, queryObject.getLayerNumber());
    }

    private boolean getGeometries() {
        String string = "";
        int n = 0;
        if (MapViewerHelper.isConnectionValid(this.cnx)) {
            this.pointMap = new HashMap();
            this.curveMap = new HashMap();
            this.areaMap = new HashMap();
            this.pointKeys = new ArrayList();
            this.curveKeys = new ArrayList();
            this.areaKeys = new ArrayList();
            try {
                this.geomColName = this.getGeometryColumn(0);
            }
            catch (SQLException sQLException) {
                System.err.println("Error getting spatial column: " + sQLException.getMessage());
                return false;
            }
            catch (Exception exception) {
                System.err.println("Error finding spatial column: " + exception.getMessage());
                return false;
            }
            try {
                ResultSet resultSet;
                if (this.cnx.isClosed()) {
                    System.err.println("Warning: connection closed");
                }
                Statement statement = this.cnx.createStatement(1004, 1007);
                this.queryRs = resultSet = statement.executeQuery(this.queryText);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                String[] stringArray = new String[resultSetMetaData.getColumnCount()];
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    stringArray[i - 1] = resultSetMetaData.getColumnName(i);
                }
                string = MapViewerHelper.buildLabelsAndGeomQuery(this.queryText, stringArray, this.geomColName);
                ResultSet resultSet2 = statement.executeQuery(string);
                ResultSetMetaData resultSetMetaData2 = resultSet2.getMetaData();
                String string2 = "BUILDING_FOOTPRINTS";
                while (resultSet2.next()) {
                    ROWID rOWID = new ROWID(resultSet2.getBytes("ROWID"));
                    try {
                        JGeometry jGeometry = JSDOGeometry.load((byte[])resultSet2.getBytes(2));
                        JSDOGeometry jSDOGeometry = JSDOGeometry.recast((JGeometry)jGeometry);
                        int n2 = jSDOGeometry.getType();
                        if (jSDOGeometry.isPoint() || jSDOGeometry.isMultiPoint() || n2 == 1 || n2 == 5) {
                            this.pointMap.put(rOWID.stringValue(), jSDOGeometry);
                            this.pointKeys.add(rOWID.stringValue());
                        } else if (!(jSDOGeometry.isPoint() || jSDOGeometry.isMultiPoint() || n2 != 2 && n2 != 6)) {
                            this.curveMap.put(rOWID.stringValue(), jSDOGeometry);
                            this.curveKeys.add(rOWID.stringValue());
                        } else if (!jSDOGeometry.isPoint() && !jSDOGeometry.isMultiPoint() && n2 != 2 && n2 != 6) {
                            this.areaMap.put(rOWID.stringValue(), jSDOGeometry);
                            this.areaKeys.add(rOWID.stringValue());
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        return false;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        System.gc();
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, outOfMemoryError.getStackTrace()[0].toString(), outOfMemoryError);
                        return false;
                    }
                    ++n;
                }
                if (n > 0) {
                    Vector<Integer[]> vector = MapViewerHelper.getQuerySRIDS(this.queryText, this.cnx);
                    Integer[] integerArray = vector.get(0);
                    if (MapViewerHelper.isSRIDUnique(integerArray[0], vector)) {
                        this.setSRID(integerArray[0]);
                    } else {
                        this.setSRID(-10);
                    }
                    this.layerMBR = this.getLayerMBR();
                    resultSet2.beforeFirst();
                    this.columnLabelMappings = (ArrayList)MapViewerHelper.getColumnValuesMaps(resultSet2);
                    this.allColumnNames = new ArrayList();
                    for (int i = 1; i <= resultSetMetaData2.getColumnCount(); ++i) {
                        this.allColumnNames.add(resultSetMetaData2.getColumnName(i));
                    }
                }
                this.columnLabelMappings = new ArrayList();
                this.allColumnNames = new ArrayList();
                Arrays.fill(this.layerMBR, -10.0);
                this.setSRID(-10);
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                return false;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                exception.printStackTrace();
                return false;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, outOfMemoryError.getStackTrace()[0].toString(), outOfMemoryError);
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private String getGeometryColumn(int n) throws Exception, SQLException {
        String string;
        Vector<String> vector = new Vector<String>();
        Statement statement = this.cnx.createStatement();
        ResultSet resultSet = statement.executeQuery(this.queryText);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= n2; ++i) {
            int n3 = resultSetMetaData.getColumnType(i);
            if (n3 != 2002) continue;
            vector.add(resultSetMetaData.getColumnName(i));
        }
        if (vector.isEmpty()) {
            throw new Exception("No spatial columns");
        }
        if (n < 1) {
            string = (String)vector.get(0);
        }
        string = n >= vector.size() ? (String)vector.get(vector.size()) : (String)vector.get(n);
        return string;
    }

    private double[] getLayerMBR() {
        double[] dArray = new double[4];
        if (this.geomColName == null) {
            return dArray;
        }
        String string = "SELECT SDO_AGGR_MBR(" + this.geomColName + ")AS MBR FROM (" + this.queryText + ")";
        try {
            Statement statement = this.cnx.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (n != 1) {
                return dArray;
            }
            try {
                resultSet.next();
                JGeometry jGeometry = JSDOGeometry.load((byte[])resultSet.getBytes(n));
                JSDOGeometry jSDOGeometry = JSDOGeometry.recast((JGeometry)jGeometry);
                dArray = jSDOGeometry.getMBR();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, outOfMemoryError.getStackTrace()[0].toString(), outOfMemoryError);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return dArray;
    }

    public String getNewTitle() {
        return this.newTitle;
    }

    public void setNewTitle(String string) {
        this.newTitle = string;
    }

    public String[] getCandidateAnnotation() {
        return this.candidateColumns;
    }

    public void setCandidateColumns(String[] stringArray) {
        this.candidateColumns = stringArray;
    }

    public String getConnectionSourceName() {
        return this.connectionSourceName;
    }

    public void setConnectionSourceName(String string) {
        this.connectionSourceName = string;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public void setQueryText(String string) {
        this.queryText = string;
    }

    public int getLayerNumber() {
        return this.layerNumber;
    }

    public void setLayerNumber(int n) {
        this.layerNumber = n;
    }

    public void setQueryTitle(String string) {
        this.queryTitle = string;
    }

    public String getQueryTitle() {
        return this.queryTitle;
    }

    public void setPreselected(boolean bl) {
        this.isPreselected = bl;
    }

    public boolean isPreselected() {
        return this.isPreselected;
    }

    public void setCurvesColor(Color color) {
        this.curvesColor = color;
    }

    public Color getCurvesColor() {
        return this.curvesColor;
    }

    public void setCurveLineWidth(int n) {
        this.curveLineWidth = n;
    }

    public int getCurveLineWidth() {
        return this.curveLineWidth;
    }

    public void setMarkerFillColor(Color color) {
        this.markerFillColor = color;
    }

    public Color getMarkerFillColor() {
        return this.markerFillColor;
    }

    public void setMarkerColor(Color color) {
        this.markerColor = color;
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerSize(int n) {
        this.markerSize = n;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerType(int n) {
        this.markerType = n;
    }

    public int getMarkerType() {
        return this.markerType;
    }

    public void setAreaBorderColor(Color color) {
        this.areaBorderColor = color;
    }

    public void setAreaFillColor(Color color) {
        this.areaFillColor = color;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public Color getAreaFillColor() {
        return this.areaFillColor;
    }

    public void setAnnotatedColumn(String string) {
        this.labelColumn = string;
    }

    public String getAnnotatedColumn() {
        return this.labelColumn;
    }

    public String getTabIdentifier() {
        return this.tabIdentifier;
    }

    public void setTabIdentifier(String string) {
        this.tabIdentifier = string;
    }

    public int getSRID() {
        return this.srid;
    }

    public void setSRID(int n) {
        this.srid = n;
    }

    public void setNewlyCreated() {
        this.isNewlyCreated = true;
    }

    public boolean isUserCreated() {
        return this.isNewlyCreated;
    }

    public Connection getCnx() {
        return this.cnx;
    }

    public Map<String, JSDOGeometry> getPointMap() {
        return this.pointMap;
    }

    public Map<String, JSDOGeometry> getCurveMap() {
        return this.curveMap;
    }

    public Map<String, JSDOGeometry> getAreaMap() {
        return this.areaMap;
    }

    public List<String> getPointKeys() {
        return this.pointKeys;
    }

    public List<String> getCurveKeys() {
        return this.curveKeys;
    }

    public List<String> getAreaKeys() {
        return this.areaKeys;
    }

    public String getGeomColName() {
        return this.geomColName;
    }

    public double[] getMBR() {
        return this.layerMBR;
    }

    public boolean isLabelChanged() {
        return this.labelChanged;
    }

    public void setLabelChanged(boolean bl) {
        this.labelChanged = bl;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public ResultSet getQueryRs() {
        return this.queryRs;
    }

    public boolean areGeomsLoaded() {
        return this.loadedGeoms;
    }

    public void printInfo() {
        System.out.println("Name: " + this.getQueryTitle());
        System.out.println("NewName: " + this.getNewTitle());
        System.out.println("Query: " + this.getQueryText());
        System.out.println("Annot: " + this.getAnnotatedColumn());
        System.out.println("Layer: " + this.getLayerNumber());
        System.out.println("SRID: " + this.getSRID());
        System.out.println("TABID: " + this.getTabIdentifier());
        System.out.println("******************************");
    }
}

