/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.tools;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.spatial.tools.ISpatialTool;
import oracle.dbtools.spatial.tools.SpatialAddGeomQuery;
import oracle.dbtools.spatial.tools.SpatialDeleteGeomQuery;
import oracle.dbtools.spatial.tools.SpatialNewTool;
import oracle.dbtools.spatial.tools.SpatialZoomFit;
import oracle.dbtools.spatial.tools.SpatialZoomIn;
import oracle.dbtools.spatial.tools.SpatialZoomMarquee;
import oracle.dbtools.spatial.tools.SpatialZoomOut;

public class SpatialToolRegistry {
    private static Map<String, ISpatialTool> tool_registry = new LinkedHashMap<String, ISpatialTool>();

    public static synchronized void registerSpatialTool(ISpatialTool iSpatialTool) {
        tool_registry.put(iSpatialTool.getType().toLowerCase(), iSpatialTool);
    }

    public static synchronized void unregisterSpatialTool(ISpatialTool iSpatialTool) {
        tool_registry.remove(iSpatialTool.getType().toLowerCase());
    }

    public static synchronized ISpatialTool getTool(String string) {
        return tool_registry.get(string.toLowerCase());
    }

    public static synchronized List<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(tool_registry.keySet());
        return arrayList;
    }

    public static synchronized List<String> getTypes(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(tool_registry.keySet());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : arrayList) {
            ISpatialTool iSpatialTool = SpatialToolRegistry.getTool(string);
            if (iSpatialTool.getGroup() != n) continue;
            arrayList2.add(string);
        }
        return arrayList2;
    }

    static {
        SpatialToolRegistry.registerSpatialTool(new SpatialNewTool());
        SpatialToolRegistry.registerSpatialTool(new SpatialZoomIn());
        SpatialToolRegistry.registerSpatialTool(new SpatialZoomOut());
        SpatialToolRegistry.registerSpatialTool(new SpatialZoomFit());
        SpatialToolRegistry.registerSpatialTool(new SpatialZoomMarquee());
        SpatialToolRegistry.registerSpatialTool(new SpatialAddGeomQuery());
        SpatialToolRegistry.registerSpatialTool(new SpatialDeleteGeomQuery());
    }
}

