/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.validate.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.dialogs.validate.model.ValidateGeometryModel;
import oracle.dbtools.spatial.dialogs.validate.view.ValidateGeometryView;

public class ValidateGeometryController {
    private ValidateGeometryModel model;
    private ValidateGeometryView view;
    private SpatialColumnBoxListener columnBoxlistener = new SpatialColumnBoxListener();
    private SpatialToleranceListener tolerancelistener = new SpatialToleranceListener();
    private JEWTDialog dlg;

    public ValidateGeometryController(ValidateGeometryModel validateGeometryModel, ValidateGeometryView validateGeometryView) {
        this.model = validateGeometryModel;
        this.view = validateGeometryView;
    }

    public void addListeners() {
        this.view.addSpatialColumnBoxListener(this.columnBoxlistener);
        this.view.addToleranceListener(this.tolerancelistener);
    }

    public void removeListeners() {
        this.view.removeSpatialColumnBoxListener(this.columnBoxlistener);
        this.view.removeToleranceListener(this.tolerancelistener);
    }

    public void populateSpatialModel(JEWTDialog jEWTDialog) {
        this.dlg = jEWTDialog;
        this.dlg.setEnabled(false);
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(SpatialArb.getString("SpatialPopulateModel"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            public Void doWork() {
                ValidateGeometryController.this.model.setInitialModelData();
                return null;
            }

            public boolean cancel() {
                return false;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ValidateGeometryController.this.view.decorateMainPanel();
                            if (ValidateGeometryController.this.model.getIsColumnSelected()) {
                                ValidateGeometryController.this.view.enableSpatialColumn(false);
                            } else {
                                ValidateGeometryController.this.view.enableSpatialColumn(true);
                            }
                            ValidateGeometryController.this.addListeners();
                            ValidateGeometryController.this.dlg.setEnabled(true);
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                });
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void applyModelData() {
        this.view.showGrid();
    }

    class SpatialToleranceListener
    implements DocumentListener {
        SpatialToleranceListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            String string = ValidateGeometryController.this.view.getTolerance();
            ValidateGeometryController.this.model.setTolerance(string);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            String string = ValidateGeometryController.this.view.getTolerance();
            ValidateGeometryController.this.model.setTolerance(string);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            String string = ValidateGeometryController.this.view.getTolerance();
            ValidateGeometryController.this.model.setTolerance(string);
        }
    }

    class SpatialColumnBoxListener
    implements ActionListener {
        SpatialColumnBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ValidateGeometryController.this.view.getSpatialColumnValue();
            ValidateGeometryController.this.model.setCurrrentColumn(string);
        }
    }
}

