/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;

public class LASImportExport {
    public static void importLAS(String string, String string2, String string3, int n) throws SQLException, IOException {
        LASImportExport.importLAS(string, string2, string3, DriverManager.getConnection("jdbc:default:connection:"));
    }

    public static void importLAS(String string, String string2, String string3, Connection connection) throws SQLException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        LasHeader lasHeader = LasHeader.readLasHeader(dataInputStream);
        lasHeader.includeColumns(connection, string3);
        lasHeader.importLAS(string2, dataInputStream, string3, connection);
        dataInputStream.close();
        fileInputStream.close();
    }

    private static String readString(DataInputStream dataInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != 0) continue;
            return new String(byArray, 0, i);
        }
        return new String(byArray);
    }

    private static void skipBytes(DataInputStream dataInputStream, int n) throws IOException {
        dataInputStream.skipBytes(n);
    }

    private static int readUnsignedShort(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        return n + n2 * 256;
    }

    private static int readUnsignedByte(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readUnsignedByte();
    }

    private static int readSignedByte(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readByte();
    }

    private static long readUnsignedInt(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        int n3 = dataInputStream.readUnsignedByte();
        int n4 = dataInputStream.readUnsignedByte();
        return n + 256 * (n2 + 256 * (n3 + 256 * n4));
    }

    private static int readSignedInt(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.read(byArray);
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private static double readDouble(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[8];
        dataInputStream.read(byArray);
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    protected static void includeColumn(Connection connection, String string, LasAttribute lasAttribute) {
        try {
            Statement statement = connection.createStatement();
            String string2 = "alter table " + string + " add " + lasAttribute.m_name + " number default null";
            statement.execute(string2);
            statement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new RuntimeException(sQLException);
        }
    }

    protected static void includeColumns(Connection connection, String string, LasAttribute[] lasAttributeArray) {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            ResultSet resultSet = connection.getMetaData().getColumns(null, null, string, null);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString("COLUMN_NAME"));
            }
            for (int i = 0; i < lasAttributeArray.length; ++i) {
                if (hashSet.contains(lasAttributeArray[i].m_name)) continue;
                System.out.println("Add column " + lasAttributeArray[i].m_name + " to table " + string);
                LASImportExport.includeColumn(connection, string, lasAttributeArray[i]);
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new RuntimeException(sQLException);
        }
    }

    public static void exportLAS(String string, String string2) throws SQLException, IOException {
    }

    protected static class Las12Header
    extends Las10Header {
        protected final int m_fileSourceId;
        protected final int m_globalEncoding;
        protected static final LasAttribute[] FORMATS_LAS12_BASE = Las12Header.concatArrays(FORMATS_LAS10_BASE1, new LasAttribute[]{new LasAttribute("USER_DATA", 5), new LasAttribute("POINT_SOURCE_ID", 2)});
        protected static final LasAttribute[] FORMATS_LAS12_FORMAT0 = FORMATS_LAS12_BASE;
        protected static final LasAttribute[] FORMATS_LAS12_FORMAT1 = Las12Header.concatArrays(FORMATS_LAS12_FORMAT0, new LasAttribute[]{new LasAttribute("GPS_TIME", 7)});
        protected static final LasAttribute[] FORMATS_LAS12_FORMAT2 = Las12Header.concatArrays(FORMATS_LAS12_FORMAT0, new LasAttribute[]{new LasAttribute("RED", 2), new LasAttribute("GREEN", 2), new LasAttribute("BLUE", 2)});
        protected static final LasAttribute[] FORMATS_LAS12_FORMAT3 = Las12Header.concatArrays(FORMATS_LAS12_FORMAT1, new LasAttribute[]{new LasAttribute("RED", 2), new LasAttribute("GREEN", 2), new LasAttribute("BLUE", 2)});
        protected static final LasAttribute[][] FORMATS_LAS12 = new LasAttribute[][]{FORMATS_LAS12_FORMAT0, FORMATS_LAS12_FORMAT1, FORMATS_LAS12_FORMAT2, FORMATS_LAS12_FORMAT3};

        @Override
        protected LasAttribute[][] getAttributes() {
            return FORMATS_LAS12;
        }

        @Override
        protected void includeColumns(Connection connection, String string, int n) {
            LASImportExport.includeColumns(connection, string, FORMATS_LAS12[n]);
        }

        protected Las12Header(DataInputStream dataInputStream, String string, int n, int n2, int n3, int n4) throws IOException {
            super(dataInputStream, string, n, n2);
            this.m_fileSourceId = n3;
            this.m_globalEncoding = n4;
        }
    }

    protected static class Las10Header
    extends LasHeader {
        protected final String m_fileSignature;
        protected final String m_systemIdentifier;
        protected final String m_generatingSoftware;
        protected final int m_versionMajor;
        protected final int m_versionMinor;
        protected final int m_flightDateJulian;
        protected final int m_year;
        protected final int m_headerSize;
        protected final int m_pointDataFormatId;
        protected final int m_pointDataRecordLen;
        protected final long m_offsetToData;
        protected final long m_numVarLenRecords;
        protected final long m_numPointRecords;
        protected final long m_numPointsByReturn_1;
        protected final long m_numPointsByReturn_2;
        protected final long m_numPointsByReturn_3;
        protected final long m_numPointsByReturn_4;
        protected final long m_numPointsByReturn_5;
        protected final double m_scaleFactorX;
        protected final double m_scaleFactorY;
        protected final double m_scaleFactorZ;
        protected final double m_offsetX;
        protected final double m_offsetY;
        protected final double m_offsetZ;
        protected final double m_maxX;
        protected final double m_minX;
        protected final double m_maxY;
        protected final double m_minY;
        protected final double m_maxZ;
        protected final double m_minZ;
        protected static final LasAttribute[] FORMATS_LAS_XYZ = new LasAttribute[]{new LasAttribute("X", 1), new LasAttribute("Y", 1), new LasAttribute("Z", 1)};
        protected static final LasAttribute[] FORMATS_LAS10_BASE1 = Las10Header.concatArrays(FORMATS_LAS_XYZ, new LasAttribute[]{new LasAttribute("INTENSITY", 2), new LasAttribute("RETURN_NUMBER", 3), new LasAttribute("NUMBER_OF_RETURNS", 3), new LasAttribute("SCAN_DIRECTION_FLAG", 4), new LasAttribute("EDGE_OF_FLIGHT_LINE", 4), new LasAttribute("CLASSIFICATION", 5), new LasAttribute("SCAN_ANGLE_RANK", 6)});
        protected static final LasAttribute[] FORMATS_LAS10_BASE2 = Las10Header.concatArrays(FORMATS_LAS10_BASE1, new LasAttribute[]{new LasAttribute("FILE_MARKER", 5), new LasAttribute("USER_BIT_FIELD", 2)});
        protected static final LasAttribute[] FORMATS_LAS10_FORMAT0 = FORMATS_LAS10_BASE2;
        protected static final LasAttribute[] FORMATS_LAS10_FORMAT1 = Las10Header.concatArrays(FORMATS_LAS10_FORMAT0, new LasAttribute[]{new LasAttribute("GPS_TIME", 7)});
        protected static final LasAttribute[][] FORMATS_LAS10 = new LasAttribute[][]{FORMATS_LAS10_FORMAT0, FORMATS_LAS10_FORMAT1};

        protected LasAttribute[][] getAttributes() {
            return FORMATS_LAS10;
        }

        protected void includeColumns(Connection connection, String string, int n) {
            LASImportExport.includeColumns(connection, string, FORMATS_LAS10[n]);
        }

        @Override
        public final void includeColumns(Connection connection, String string) {
            this.includeColumns(connection, string, this.m_pointDataFormatId);
        }

        protected Las10Header(DataInputStream dataInputStream, String string, int n, int n2) throws IOException {
            this.m_fileSignature = string;
            this.m_versionMajor = n;
            this.m_versionMinor = n2;
            this.m_systemIdentifier = LASImportExport.readString(dataInputStream, 32);
            this.m_generatingSoftware = LASImportExport.readString(dataInputStream, 32);
            this.m_flightDateJulian = LASImportExport.readUnsignedShort(dataInputStream);
            this.m_year = LASImportExport.readUnsignedShort(dataInputStream);
            this.m_headerSize = LASImportExport.readUnsignedShort(dataInputStream);
            this.m_offsetToData = LASImportExport.readUnsignedInt(dataInputStream);
            this.m_numVarLenRecords = LASImportExport.readUnsignedInt(dataInputStream);
            this.m_pointDataFormatId = dataInputStream.readUnsignedByte();
            this.m_pointDataRecordLen = LASImportExport.readUnsignedShort(dataInputStream);
            this.m_numPointRecords = LASImportExport.readUnsignedInt(dataInputStream);
            this.m_numPointsByReturn_1 = LASImportExport.readUnsignedInt(dataInputStream);
            this.m_numPointsByReturn_2 = LASImportExport.readUnsignedInt(dataInputStream);
            this.m_numPointsByReturn_3 = LASImportExport.readUnsignedInt(dataInputStream);
            this.m_numPointsByReturn_4 = LASImportExport.readUnsignedInt(dataInputStream);
            this.m_numPointsByReturn_5 = LASImportExport.readUnsignedInt(dataInputStream);
            this.m_scaleFactorX = LASImportExport.readDouble(dataInputStream);
            this.m_scaleFactorY = LASImportExport.readDouble(dataInputStream);
            this.m_scaleFactorZ = LASImportExport.readDouble(dataInputStream);
            this.m_offsetX = LASImportExport.readDouble(dataInputStream);
            this.m_offsetY = LASImportExport.readDouble(dataInputStream);
            this.m_offsetZ = LASImportExport.readDouble(dataInputStream);
            this.m_maxX = LASImportExport.readDouble(dataInputStream);
            this.m_minX = LASImportExport.readDouble(dataInputStream);
            this.m_maxY = LASImportExport.readDouble(dataInputStream);
            this.m_minY = LASImportExport.readDouble(dataInputStream);
            this.m_maxZ = LASImportExport.readDouble(dataInputStream);
            this.m_minZ = LASImportExport.readDouble(dataInputStream);
            dataInputStream.skip(this.m_offsetToData - (long)this.m_headerSize);
        }

        protected String trimFirstAndLastLetter(String string) {
            return string.substring(1, string.length() - 1);
        }

        @Override
        public void importLAS(String string, DataInputStream dataInputStream, String string2, Connection connection) throws SQLException, IOException {
            Object[] objectArray = this.getAttributes()[this.m_pointDataFormatId];
            Object[] objectArray2 = new String[objectArray.length];
            Arrays.fill(objectArray2, "?");
            String string3 = "insert /*+ APPEND_VALUES */\ninto " + string2 + "(source_id, pt_id, " + this.trimFirstAndLastLetter(Arrays.toString(objectArray)) + ")\n" + "values (?, ?, " + this.trimFirstAndLastLetter(Arrays.toString(objectArray2)) + ")";
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            this.importLAS(dataInputStream, string, preparedStatement, connection);
            try {
                dataInputStream.readByte();
                throw new RuntimeException("No LAS file EOF after presumed end of point data.");
            }
            catch (EOFException eOFException) {
                preparedStatement.executeBatch();
                preparedStatement.close();
                connection.commit();
                connection.close();
                return;
            }
        }

        protected void importLAS(DataInputStream dataInputStream, String string, PreparedStatement preparedStatement, Connection connection) throws SQLException, IOException {
            try {
                int n = 0;
                while ((long)n < this.m_numPointRecords) {
                    if ((n + 1) % 5000 == 0) {
                        preparedStatement.executeBatch();
                        connection.commit();
                    }
                    this.readPoint(n, dataInputStream, preparedStatement, string);
                    ++n;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw sQLException;
            }
        }

        protected void readPoint(int n, DataInputStream dataInputStream, PreparedStatement preparedStatement, String string) throws IOException, SQLException {
            LasAttribute[] lasAttributeArray = this.getAttributes()[this.m_pointDataFormatId];
            double d = (double)LASImportExport.readSignedInt(dataInputStream) * this.m_scaleFactorX + this.m_offsetX;
            double d2 = (double)LASImportExport.readSignedInt(dataInputStream) * this.m_scaleFactorY + this.m_offsetY;
            double d3 = (double)LASImportExport.readSignedInt(dataInputStream) * this.m_scaleFactorZ + this.m_offsetZ;
            if (d < this.m_minX || d > this.m_maxX || d2 < this.m_minY || d2 > this.m_maxY || d3 < this.m_minZ || d3 > this.m_maxZ) {
                throw new RuntimeException("Point #" + n + " (format " + this.m_pointDataFormatId + ") coords (" + d + ", " + d2 + ", " + d3 + "), scale factor (" + this.m_scaleFactorX + ", " + this.m_scaleFactorY + ", " + this.m_scaleFactorZ + "), offset (" + this.m_offsetX + ", " + this.m_offsetY + ", " + this.m_offsetZ + ") outside range (" + this.m_minX + ", " + this.m_minY + ", " + this.m_minZ + ") - (" + this.m_maxX + ", " + this.m_maxY + ", " + this.m_maxZ + ").");
            }
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, n);
            preparedStatement.setDouble(3, d);
            preparedStatement.setDouble(4, d2);
            preparedStatement.setDouble(5, d3);
            int n2 = 1;
            block9: for (int i = 3; i < lasAttributeArray.length; ++i) {
                switch (lasAttributeArray[i].m_dataType) {
                    case 1: {
                        preparedStatement.setLong(3 + i, LASImportExport.readSignedInt(dataInputStream));
                        continue block9;
                    }
                    case 2: {
                        preparedStatement.setLong(3 + i, LASImportExport.readUnsignedShort(dataInputStream));
                        continue block9;
                    }
                    case 3: {
                        if (n2 < 8) {
                            n2 = n2 * 256 + LASImportExport.readUnsignedByte(dataInputStream);
                        }
                        preparedStatement.setInt(3 + i, n2 % 8);
                        n2 /= 8;
                        continue block9;
                    }
                    case 4: {
                        if (n2 < 2) {
                            n2 = n2 * 256 + LASImportExport.readUnsignedByte(dataInputStream);
                        }
                        preparedStatement.setInt(3 + i, n2 % 2);
                        n2 /= 2;
                        continue block9;
                    }
                    case 5: {
                        preparedStatement.setInt(3 + i, LASImportExport.readUnsignedByte(dataInputStream));
                        continue block9;
                    }
                    case 6: {
                        preparedStatement.setInt(3 + i, LASImportExport.readSignedByte(dataInputStream));
                        continue block9;
                    }
                    case 7: {
                        preparedStatement.setDouble(3 + i, LASImportExport.readDouble(dataInputStream));
                        continue block9;
                    }
                    default: {
                        throw new RuntimeException("Attribute type " + lasAttributeArray[i].m_dataType + " unknown.");
                    }
                }
            }
            preparedStatement.addBatch();
        }
    }

    private static abstract class LasHeader {
        private LasHeader() {
        }

        public static LasHeader readLasHeader(DataInputStream dataInputStream) throws IOException {
            String string = LASImportExport.readString(dataInputStream, 4);
            int n = LASImportExport.readUnsignedShort(dataInputStream);
            int n2 = LASImportExport.readUnsignedShort(dataInputStream);
            LASImportExport.skipBytes(dataInputStream, 4);
            LASImportExport.skipBytes(dataInputStream, 2);
            LASImportExport.skipBytes(dataInputStream, 2);
            LASImportExport.skipBytes(dataInputStream, 8);
            int n3 = dataInputStream.readUnsignedByte();
            int n4 = dataInputStream.readUnsignedByte();
            if (n3 == 1 && n4 == 0) {
                return new Las10Header(dataInputStream, string, n3, n4);
            }
            if (n3 == 1 && n4 == 2) {
                return new Las12Header(dataInputStream, string, n3, n4, n, n2);
            }
            throw new RuntimeException("LAS version " + n3 + "." + n4 + " not supported.");
        }

        public abstract void importLAS(String var1, DataInputStream var2, String var3, Connection var4) throws SQLException, IOException;

        public abstract void includeColumns(Connection var1, String var2);

        protected static LasAttribute[] concatArrays(LasAttribute[] lasAttributeArray, LasAttribute[] lasAttributeArray2) {
            int n;
            LasAttribute[] lasAttributeArray3 = new LasAttribute[lasAttributeArray.length + lasAttributeArray2.length];
            for (n = 0; n < lasAttributeArray.length; ++n) {
                lasAttributeArray3[n] = lasAttributeArray[n];
            }
            for (n = 0; n < lasAttributeArray2.length; ++n) {
                lasAttributeArray3[lasAttributeArray.length + n] = lasAttributeArray2[n];
            }
            return lasAttributeArray3;
        }
    }

    private static class LasAttribute {
        public final String m_name;
        public final int m_dataType;
        public static final int LAS_TYPE_LONG = 1;
        public static final int LAS_TYPE_UNSIGNED_SHORT = 2;
        public static final int LAS_TYPE_3BITS = 3;
        public static final int LAS_TYPE_1BIT = 4;
        public static final int LAS_TYPE_UNSIGNED_CHAR = 5;
        public static final int LAS_TYPE_CHAR = 6;
        public static final int LAS_TYPE_DOUBLE = 7;

        public LasAttribute(String string, int n) {
            this.m_name = string;
            this.m_dataType = n;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

