/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.KML2;

public class ExtendedKML2 {
    private int extrudeFlag = 0;
    private int tessellateFlag = 0;
    private String altitudeModeFlag = "relativeToGround";
    private String altitude;
    private String region;
    private String lod;
    private String latlonbox;
    private String schema;
    private String lookat;
    protected static Connection conn;

    public static void setConnection(Connection connection) {
        connection = conn;
    }

    public static Connection getConnection() {
        return conn;
    }

    public static String to_KML(ArrayList arrayList, String[] stringArray, String[] stringArray2, int n, String[] stringArray3, String[] stringArray4, boolean[] blArray, String[] stringArray5, int[] nArray) throws SQLException, IOException, DataException, Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.1\">\n<Document>\n<name>\nRBNL_v3</name>\n");
        for (int i = 0; i < arrayList.size(); ++i) {
            JGeometry jGeometry = (JGeometry)arrayList.get(i);
            stringBuffer.append("<Folder>\n");
            stringBuffer.append(ExtendedKML2.to_KML(jGeometry, stringArray, stringArray2, n, stringArray3, stringArray4, blArray, stringArray5, nArray) + "\n");
            stringBuffer.append("</Folder>\n");
        }
        stringBuffer.append("</Document>\n</kml>");
        return stringBuffer.toString();
    }

    public static String to_KML(JGeometry jGeometry, String[] stringArray, String[] stringArray2, int n, String[] stringArray3, String[] stringArray4, boolean[] blArray, String[] stringArray5, int[] nArray) throws SQLException, IOException, DataException, Exception {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (!blArray[0]) {
            d = jGeometry.getOrdinatesArray()[1];
            d2 = jGeometry.getOrdinatesArray()[7];
            d3 = jGeometry.getOrdinatesArray()[6];
            d4 = jGeometry.getOrdinatesArray()[0];
        } else {
            int[] nArray2 = new int[jGeometry.getElemInfo().length];
            for (int i = 0; i < jGeometry.getElemInfo().length; ++i) {
                nArray2[i] = jGeometry.getElemInfo()[i];
            }
            double[] dArray = new double[jGeometry.getOrdinatesArray().length];
            for (int i = 0; i < jGeometry.getElemInfo().length; ++i) {
                dArray[i] = jGeometry.getOrdinatesArray()[i];
            }
            J3D_Geometry j3D_Geometry = new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), nArray2, dArray);
            double[] dArray2 = j3D_Geometry.getMBR();
            d4 = dArray2[0];
            d = dArray2[1];
            d3 = dArray2[3];
            d2 = dArray2[4];
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        KML2 kML2 = new KML2();
        try {
            string = KML2.to_KMLGeometry(jGeometry);
        }
        catch (SQLException sQLException) {
            System.out.println("Error: " + sQLException.getMessage());
        }
        int n2 = 64;
        int n3 = -1;
        if (!blArray[0]) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.1\">\n<Document>\n<name>\nRBNL_v3</name>\n");
        }
        stringBuffer.append("<Region>\n<LatLonAltBox>\n<south>" + Double.toString(d) + " </south>\n" + "<north>" + Double.toString(d2) + " </north>\n" + "<east>" + Double.toString(d3) + " </east>\n" + "<west> " + Double.toString(d4) + " </west>\n" + "</LatLonAltBox>\n" + "<Lod>\n" + "<minLodPixels>" + n2 + "</minLodPixels>\n" + "<maxLodPixels>" + n3 + "</maxLodPixels>\n" + "</Lod>\n" + "</Region>\n" + "<Placemark>\n" + "<name>" + "TheRegion" + "</name>\n" + "<tesselate>1</tesselate>\n" + string + "\n" + "</Placemark>\n");
        if (!blArray[0]) {
            double[] dArray = new double[]{(d + d2) / 2.0, d2, (d4 + d3) / 2.0, d4, d, (d + d2) / 2.0, (d4 + d3) / 2.0, d4, (d + d2) / 2.0, d2, d3, (d4 + d3) / 2.0, d, (d + d2) / 2.0, d3, (d4 + d3) / 2.0};
            int n4 = 0;
            try {
                n4 = Integer.parseInt(stringArray4[0].trim());
                ++n4;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("NumberFormatException: " + numberFormatException.getMessage());
            }
            String string2 = String.valueOf(n4);
            for (int i = 0; i < 4; ++i) {
                d6 = dArray[i * 4 + 0];
                d8 = dArray[i * 4 + 1];
                d7 = dArray[i * 4 + 2];
                d5 = dArray[i * 4 + 3];
                String string3 = stringArray3[0];
                string3 = i == 0 ? stringArray3[0].concat("00") : (i == 1 ? stringArray3[0].concat("01") : (i == 2 ? stringArray3[0].concat("10") : stringArray3[0].concat("11")));
                stringBuffer.append("<NetworkLink>\n<Region>\n<LatLonAltBox>\n<south>" + d6 + "</south>\n" + "<north>" + d8 + "</north>\n" + "<east>" + d7 + "</east>\n" + "<west>" + d5 + "</west>\n" + "</LatLonAltBox>\n" + "<Lod>\n" + "<minLodPixels>" + n2 + "</minLodPixels>\n" + "<maxLodPixels>" + n3 + "</maxLodPixels>\n" + "</Lod>\n" + "</Region>\n" + "<Link>\n" + "<href>" + "http://" + stringArray5[0] + ":" + nArray[0] + "/SpatialWS-SpatialWS-context-root/kmlservlet?BBOX=" + d5 + "," + d6 + "," + d7 + "," + d8 + "&amp;TABLENAME=" + stringArray[0] + "&amp;COLUMNNAME=" + stringArray2[0] + "&amp;GEOMETRYCOUNT=" + n + "&amp;LABEL=" + string3 + "&amp;LOD=" + string2 + "</href>\n" + "<viewRefreshMode>onRequest</viewRefreshMode>\n" + "</Link>\n" + "</NetworkLink>\n");
            }
        }
        if (!blArray[0]) {
            stringBuffer.append("</Document>\n</kml>");
        }
        return stringBuffer.toString();
    }
}

