/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import oracle.spatial.util.ShapefileReaderJGeom;

class DBFileHdr {
    byte version;
    byte[] last_update = new byte[3];
    int n_records;
    short header_sz;
    short record_sz;
    byte[] unused1;
    byte xct_flag;
    byte encrypt_flag;
    byte[] unused2;
    byte mdx_flag;
    byte lang_drv_id;
    byte[] unused3;
    static final int size = 32;

    public void fromBuffer(byte[] byArray) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ShapefileReaderJGeom.swapBytes(byArray, 4, 4);
        ShapefileReaderJGeom.swapBytes(byArray, 8, 2);
        ShapefileReaderJGeom.swapBytes(byArray, 10, 2);
        this.version = dataInputStream.readByte();
        for (int i = 0; i < 3; ++i) {
            this.last_update[i] = dataInputStream.readByte();
        }
        this.n_records = dataInputStream.readInt();
        this.header_sz = dataInputStream.readShort();
        this.record_sz = dataInputStream.readShort();
    }
}

