/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status.window;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.View;

public class BasicTableCellRenderer
extends JComponent
implements SwingConstants,
TableCellRenderer,
Accessible {
    private String text;
    private Icon icon;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 10;
    private int verticalTextPosition = 0;
    private int horizontalTextPosition = 11;
    private int iconTextGap = 4;
    private Insets margin = new Insets(1, 1, 1, 1);
    private Dimension preferredSize = new Dimension();
    private Rectangle bounds = new Rectangle();
    private Rectangle iconBounds = new Rectangle();
    private Rectangle textBounds = new Rectangle();
    protected Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private int ascent;

    public BasicTableCellRenderer() {
        this.setBorder(this.noFocusBorder);
    }

    protected void setValue(Object value) {
        this.setText(value != null ? String.valueOf(value) : "");
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public String getText() {
        return this.text;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setHorizontalTextPosition(int horizontalTextPosition) {
        this.horizontalTextPosition = horizontalTextPosition;
    }

    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.margin = new Insets(top, left, bottom, right);
    }

    public void setMargin(int width) {
        this.margin = new Insets(width, width, width, width);
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setVerticalTextPosition(int verticalTextPosition) {
        this.verticalTextPosition = verticalTextPosition;
    }

    protected void setText(String text) {
        this.text = text;
    }

    protected void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null) {
            font = UIManager.getFont("Table.font");
        }
        return font;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new BasicTreeCellRendererAC();
        }
        return this.accessibleContext;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color background;
        Color foreground;
        if (isSelected) {
            foreground = table.getSelectionForeground();
            background = table.getSelectionBackground();
        } else {
            foreground = table.getForeground();
            background = table.getBackground();
        }
        this.setFont(table.getFont());
        Border border = null;
        if (hasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            if (!isSelected && table.isCellEditable(row, column)) {
                Color color = UIManager.getColor("Table.focusCellForeground");
                if (color != null) {
                    foreground = color;
                }
                if ((color = UIManager.getColor("Table.focusCellBackground")) != null) {
                    background = color;
                }
            }
        } else {
            border = this.noFocusBorder;
        }
        this.setBorder(border);
        this.setForeground(foreground);
        this.setBackground(background);
        this.setValue(value);
        AccessibleContext ac = this.getAccessibleContext();
        if (ac != null) {
            ac.setAccessibleName(value != null ? String.valueOf(value) : "");
        }
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        this.layout(Short.MAX_VALUE, Short.MAX_VALUE, this.preferredSize);
        return this.preferredSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.layout(this.getWidth(), this.getHeight(), null);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.icon != null) {
            this.icon.paintIcon(this, g, this.iconBounds.x, this.iconBounds.y);
        }
        if (this.text != null) {
            View v = (View)this.getClientProperty("html");
            if (v != null) {
                v.paint(g, this.textBounds);
            } else if (this.isEnabled()) {
                g.setColor(this.getForeground());
                this.drawString(g, this.text, this.textBounds.x, this.textBounds.y, this.textBounds.width, this.textBounds.height);
            } else {
                Color background = this.getBackground();
                g.setColor(background.brighter());
                this.drawString(g, this.text, this.textBounds.x + 1, this.textBounds.y + this.ascent + 1, this.textBounds.width, this.textBounds.height);
                g.setColor(background.darker());
                this.drawString(g, this.text, this.textBounds.x, this.textBounds.y + this.ascent, this.textBounds.width, this.textBounds.height);
            }
        }
    }

    private void drawString(Graphics g, String text, int x, int y, int width, int height) {
        MotifGraphicsUtils.drawStringInRect((Graphics)g, (String)text, (int)x, (int)y, (int)width, (int)height, (int)2);
    }

    private void layout(int width, int height, Dimension size) {
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        this.ascent = metrics.getAscent();
        Insets insets = this.getInsets();
        int left = insets.left + this.margin.left;
        int right = this.margin.right + insets.right;
        int top = insets.top + this.margin.top;
        int bottom = this.margin.bottom + insets.bottom;
        this.bounds.x = left;
        this.bounds.y = top;
        this.bounds.width = width - left - right;
        this.bounds.height = height - top - bottom;
        this.iconBounds.height = 0;
        this.iconBounds.width = 0;
        this.iconBounds.y = 0;
        this.iconBounds.x = 0;
        this.textBounds.height = 0;
        this.textBounds.width = 0;
        this.textBounds.y = 0;
        this.textBounds.x = 0;
        SwingUtilities.layoutCompoundLabel(this, metrics, this.text, this.icon, this.verticalAlignment, this.horizontalAlignment, this.verticalTextPosition, this.horizontalTextPosition, this.bounds, this.iconBounds, this.textBounds, this.iconTextGap);
        if (size != null) {
            int x1 = Math.min(this.iconBounds.x, this.textBounds.x);
            int x2 = Math.max(this.iconBounds.x + this.iconBounds.width, this.textBounds.x + this.textBounds.width);
            int y1 = Math.min(this.iconBounds.y, this.textBounds.y);
            int y2 = Math.max(this.iconBounds.y + this.iconBounds.height, this.textBounds.y + this.textBounds.height);
            size.width = left + x2 - x1 + right;
            size.height = top + y2 - y1 + bottom;
        }
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    private class BasicTreeCellRendererAC
    extends JComponent.AccessibleJComponent {
        private BasicTreeCellRendererAC() {
            super(BasicTableCellRenderer.this);
        }
    }
}

