/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status;

import java.net.URL;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.status.AssistListener;
import oracle.ide.status.IssueListener;
import oracle.ide.status.MonitorContext;
import oracle.ide.status.StalenessListener;
import oracle.ide.status.StatusExecutor;
import oracle.ide.status.StatusListener;
import oracle.ide.status.StatusMonitor;
import oracle.ide.view.View;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.javatools.status.Status;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.jdevimpl.audit.util.EmptyIterator;

public class StatusManager {
    private static final boolean SUPPRESSED = Boolean.getBoolean("oracle.status.suppressed");
    private static StatusManager manager;
    private Map<Workspace, Map<Project, Map<URL, StatusMonitor>>> monitorsByWorkspace = new LinkedHashMap<Workspace, Map<Project, Map<URL, StatusMonitor>>>();
    private MultiMap<URL, StatusMonitor> monitorsByUrl = new MultiMap();
    private MultiMap<EventListener, StatusMonitor> statusListeners = new MultiMap(IdentityHashMap.class, HashSet.class);
    private MultiMap<EventListener, StatusMonitor> issueListeners = new MultiMap(IdentityHashMap.class, HashSet.class);
    private MultiMap<EventListener, StatusMonitor> assistListeners = new MultiMap(IdentityHashMap.class, HashSet.class);
    private MultiMap<EventListener, StatusMonitor> stalenessListeners = new MultiMap(IdentityHashMap.class, HashSet.class);
    private MonitorContext context;
    private MultiListener listener;
    private final IssueList NULL_STATUS = new NullIssueList();
    private static final Log LOG;
    private static final Log LOG_CREATE;
    private static final Log LOG_NODE;

    public static synchronized StatusManager getStatusManager() {
        if (manager == null) {
            LOG.trace("creating status manager");
            manager = new StatusManager();
        }
        return manager;
    }

    private StatusManager() {
        this.listener = new MultiListener();
        this.context = new MonitorContext(new StatusExecutor(), this.listener);
        Ide.getWorkspaces().attach((Observer)this.listener);
        Node.addNodeListenerForTypeHierarchy(Node.class, (NodeListener)this.listener);
    }

    public synchronized Status addStatusListener(URL file, Project project, Workspace workspace, StatusListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        if (SUPPRESSED) {
            return this.NULL_STATUS;
        }
        StatusMonitor monitor = this.getOrCreateMonitor(file, project, workspace);
        this.statusListeners.add((Object)listener, (Object)monitor);
        return monitor.addStatusListener(listener);
    }

    public synchronized void removeStatusListener(URL file, Project project, Workspace workspace, StatusListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        StatusMonitor monitor = this.getMonitor(file, project, workspace);
        if (monitor != null) {
            monitor.removeStatusListener(listener);
            this.statusListeners.removeValue((Object)listener, (Object)monitor);
        }
    }

    public synchronized void removeStatusListener(StatusListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        Collection monitors = this.statusListeners.remove((Object)listener);
        if (monitors != null) {
            for (StatusMonitor monitor : monitors) {
                monitor.removeStatusListener(listener);
            }
        }
    }

    public synchronized IssueList addIssueListener(URL file, Project project, Workspace workspace, IssueListener listener, View view) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        if (SUPPRESSED) {
            return this.NULL_STATUS;
        }
        StatusMonitor monitor = this.getOrCreateMonitor(file, project, workspace);
        this.issueListeners.add((Object)listener, (Object)monitor);
        return monitor.addIssueListener(listener, view);
    }

    public synchronized void removeIssueListener(URL file, Project project, Workspace workspace, IssueListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        StatusMonitor monitor = this.getMonitor(file, project, workspace);
        if (monitor != null) {
            monitor.removeIssueListener(listener);
            this.issueListeners.removeValue((Object)listener, (Object)monitor);
        }
    }

    public synchronized void removeIssueListener(IssueListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        Collection monitors = this.issueListeners.remove((Object)listener);
        if (monitors != null) {
            for (StatusMonitor monitor : monitors) {
                monitor.removeIssueListener(listener);
            }
        }
    }

    public synchronized IssueList addAssistListener(URL file, Project project, Workspace workspace, AssistListener listener, View view) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        if (SUPPRESSED) {
            return this.NULL_STATUS;
        }
        StatusMonitor monitor = this.getOrCreateMonitor(file, project, workspace);
        this.assistListeners.add((Object)listener, (Object)monitor);
        return monitor.addAssistListener(listener, view);
    }

    public synchronized void removeAssistListener(URL file, Project project, Workspace workspace, AssistListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        StatusMonitor monitor = this.getMonitor(file, project, workspace);
        if (monitor != null) {
            monitor.removeAssistListener(listener);
            this.assistListeners.removeValue((Object)listener, (Object)monitor);
        }
    }

    public synchronized void removeAssistListener(AssistListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        Collection monitors = this.assistListeners.remove((Object)listener);
        if (monitors != null) {
            for (StatusMonitor monitor : monitors) {
                monitor.removeAssistListener(listener);
            }
        }
    }

    public synchronized boolean addStalenessListener(URL file, Project project, Workspace workspace, StalenessListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        if (SUPPRESSED) {
            return true;
        }
        StatusMonitor monitor = this.getOrCreateMonitor(file, project, workspace);
        this.stalenessListeners.add((Object)listener, (Object)monitor);
        return monitor.addStalenessListener(listener);
    }

    public synchronized void removeStalenessListener(URL file, Project project, Workspace workspace, StalenessListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        StatusMonitor monitor = this.getMonitor(file, project, workspace);
        if (monitor != null) {
            monitor.removeStalenessListener(listener);
            this.stalenessListeners.removeValue((Object)listener, (Object)monitor);
        }
    }

    public synchronized void removeStalenessListener(StalenessListener listener) {
        if (listener == null) {
            throw new NullPointerException("null listener");
        }
        Collection monitors = this.stalenessListeners.remove((Object)listener);
        if (monitors != null) {
            for (StatusMonitor monitor : monitors) {
                monitor.removeStalenessListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(boolean cancel, String description) {
        StatusManager statusManager = this;
        synchronized (statusManager) {
            if (this.context == null) {
                this.listener = new MultiListener();
                this.context = new MonitorContext(new StatusExecutor(), this.listener);
                Ide.getWorkspaces().attach((Observer)this.listener);
            }
        }
        this.context.executor().pause(cancel, description);
    }

    public void resume(String description) {
        this.context.executor().resume(description);
    }

    private StatusMonitor getMonitor(URL file, Project project, Workspace workspace) {
        Map<Project, Map<URL, StatusMonitor>> monitorsByProject = this.monitorsByWorkspace.get(workspace);
        if (monitorsByProject == null) {
            return null;
        }
        Map<URL, StatusMonitor> monitorsByFile = monitorsByProject.get(project);
        if (monitorsByFile == null) {
            return null;
        }
        return monitorsByFile.get(file);
    }

    private StatusMonitor getOrCreateMonitor(URL file, Project project, Workspace workspace) {
        StatusMonitor monitor;
        Map<URL, StatusMonitor> monitorsByFile;
        if (workspace == null && project != null) {
            throw new IllegalArgumentException("workspace null implies project null");
        }
        Map<Project, Map<URL, StatusMonitor>> monitorsByProject = this.monitorsByWorkspace.get(workspace);
        if (monitorsByProject == null) {
            monitorsByProject = new HashMap<Project, Map<URL, StatusMonitor>>();
            this.monitorsByWorkspace.put(workspace, monitorsByProject);
            if (workspace != null) {
                workspace.attach((Observer)this.listener);
            }
        }
        if ((monitorsByFile = monitorsByProject.get(project)) == null) {
            monitorsByFile = new HashMap<URL, StatusMonitor>();
            monitorsByProject.put(project, monitorsByFile);
        }
        if ((monitor = monitorsByFile.get(file)) == null) {
            monitor = new StatusMonitor(file, project, workspace, this.context);
            monitorsByFile.put(file, monitor);
            this.monitorsByUrl.add((Object)file, (Object)monitor);
            LOG.trace("created {0}", (Object)monitor);
            LOG_CREATE.trace("created monitor for {0} {1} {2}", (Object)file, (Object)project, (Object)workspace);
        }
        return monitor;
    }

    private synchronized void profileChanged() {
        Map<Workspace, Map<Project, Map<URL, StatusMonitor>>> monitorsByWorkspace = this.monitorsByWorkspace;
        for (Map<Project, Map<URL, StatusMonitor>> monitorsByProject : monitorsByWorkspace.values()) {
            for (Map<URL, StatusMonitor> monitorsByFile : monitorsByProject.values()) {
                for (StatusMonitor monitor : monitorsByFile.values()) {
                    monitor.profileChanged();
                }
            }
        }
    }

    private synchronized void workspaceRemoved(Workspace workspace) {
        workspace.detach((Observer)this.listener);
        Map<Project, Map<URL, StatusMonitor>> monitorsByProject = this.monitorsByWorkspace.remove(workspace);
        if (monitorsByProject != null) {
            for (Map<URL, StatusMonitor> monitorsByFile : monitorsByProject.values()) {
                this.shutdownMonitors(monitorsByFile);
            }
        }
    }

    private void projectRemoved(Project project) {
        for (Map<Project, Map<URL, StatusMonitor>> monitorsByProject : this.monitorsByWorkspace.values()) {
            Map<URL, StatusMonitor> monitorsByFile = monitorsByProject.remove(project);
            if (monitorsByFile == null) continue;
            this.shutdownMonitors(monitorsByFile);
        }
    }

    private void shutdownMonitors(Map<URL, StatusMonitor> monitorsByFile) {
        for (StatusMonitor monitor : monitorsByFile.values()) {
            monitor.shutdown();
            this.monitorsByUrl.removeValue((Object)monitor.getFile(), (Object)monitor);
            this.removeListeners(monitor);
        }
    }

    private void fileRemoved(URL file) {
        Collection monitors = this.monitorsByUrl.remove((Object)file);
        if (monitors != null) {
            for (StatusMonitor monitor : monitors) {
                monitor.shutdown();
                Map<Project, Map<URL, StatusMonitor>> monitorsByProject = this.monitorsByWorkspace.get(monitor.getWorkspace());
                Map<URL, StatusMonitor> monitorsByFile = monitorsByProject.get(monitor.getProject());
                monitorsByFile.remove(monitor.getFile());
            }
        }
    }

    private void removeListeners(StatusMonitor monitor) {
        for (StatusListener statusListener : monitor.getStatusListeners()) {
            this.statusListeners.removeValue((Object)statusListener, (Object)monitor);
        }
        for (IssueListener issueListener : monitor.getIssueListeners()) {
            this.issueListeners.removeValue((Object)issueListener, (Object)monitor);
        }
        for (AssistListener assistListener : monitor.getAssistListeners()) {
            this.assistListeners.removeValue((Object)assistListener, (Object)monitor);
        }
        for (StalenessListener stalenessListener : monitor.getStalenessListeners()) {
            this.stalenessListeners.removeValue((Object)stalenessListener, (Object)monitor);
        }
    }

    static {
        LOG = new Log("status");
        LOG_CREATE = new Log("status-create");
        LOG_NODE = new Log("status-node");
    }

    private class NullIssueList
    implements IssueList {
        private NullIssueList() {
        }

        public int size() {
            return 0;
        }

        public Issue getIssueAt(int index) {
            throw new IndexOutOfBoundsException();
        }

        public Severity getSeverity() {
            return Severity.OK;
        }

        public boolean isStale() {
            return false;
        }

        public int getErrorCount() {
            return 0;
        }

        public int getWarningCount() {
            return 0;
        }

        public int getIncompleteCount() {
            return 0;
        }

        public int getAdvisoryCount() {
            return 0;
        }

        public Iterator<Issue> iterator() {
            return EmptyIterator.emptyIterator();
        }
    }

    private class MultiListener
    extends NodeListener
    implements ChangeListener,
    Observer {
        private MultiListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            LOG.trace("status profile changed");
            StatusManager.this.profileChanged();
        }

        public void nodeDeleted(NodeEvent event) {
            URL url = event.getNodeURL();
            LOG.trace("node deleted: {0}", (Object)url);
            StatusManager.this.fileRemoved(url);
        }

        public void nodeRenamed(NodeEvent event, URL oldUrl, URL newUrl) {
            LOG.trace("node renamed from {0} to {1}", (Object)oldUrl, (Object)newUrl);
            StatusManager.this.fileRemoved(oldUrl);
        }

        public void update(Object observed, UpdateMessage change) {
            if (change.getMessageID() == UpdateMessage.CHILD_REMOVED) {
                for (Object object : change.getRemoveObjects()) {
                    if (object instanceof Workspace) {
                        LOG.trace("workspace {0} removed", object);
                        StatusManager.this.workspaceRemoved((Workspace)object);
                        continue;
                    }
                    if (!(object instanceof Project)) continue;
                    LOG.trace("project {0} removed", object);
                    StatusManager.this.projectRemoved((Project)object);
                }
            }
        }
    }
}

