/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.macro;

import oracle.ide.Context;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.macro.MacroExpander;
import oracle.ideimpl.externaltools.Util;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;

public class LazyMacroExpander
extends MacroExpander {
    private HashStructure _hash;
    private MacroExpander _instance;
    static final String MACRO = "macro";
    static final String SHORT_NAME = "name";
    static final String LONG_NAME = "description";
    static final String TOOLTIP = "tooltip";
    static final String DIRECTORY_MACRO = "isDirectoryMacro";
    static final String VALID_FOR_TYPES = "validForTypes";

    public LazyMacroExpander(HashStructure hash) {
        this._hash = hash;
    }

    @Override
    public String getMacro() {
        return this._hash.getString(MACRO);
    }

    @Override
    public String getSampleExpansion(Context context) {
        if (this._instance == null) {
            if (Util.isProvidingExtensionAvailable(this._hash)) {
                return this.getInstance().getSampleExpansion(context);
            }
            return null;
        }
        return this._instance.getSampleExpansion(context);
    }

    @Override
    public String expand(Context context) {
        MacroExpander macro = this.getInstance();
        if (macro == null) {
            return null;
        }
        return macro.expand(context);
    }

    @Override
    public String getShortLabel() {
        return this._hash.getString(SHORT_NAME);
    }

    @Override
    public String getLongLabel() {
        return this._hash.getString(LONG_NAME);
    }

    @Override
    public String getToolTipText() {
        return this._hash.getString(TOOLTIP);
    }

    @Override
    public boolean isDirectoryMacro() {
        return this._hash.getBoolean(DIRECTORY_MACRO);
    }

    @Override
    public boolean isAvailableForType(ExternalToolType type) {
        return this.isAvailableForType(type.getId());
    }

    @Override
    public boolean isAvailableForType(String typeId) {
        String validTypeIds = this._hash.getString(VALID_FOR_TYPES);
        if (ModelUtil.hasLength((String)validTypeIds)) {
            String[] types;
            for (String t : types = validTypeIds.split(",")) {
                if (!typeId.equals(t)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private MacroExpander getInstance() {
        if (this._instance == null) {
            this._instance = (MacroExpander)LazyClassAdapter.getInstance((HashStructure)this._hash).createInstance(MacroExpander.class, "implClass");
        }
        return this._instance;
    }
}

