/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.externaltools;

import java.net.URL;
import java.util.StringTokenizer;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;

public final class ContextUtils {
    private static final String FILE_PROTOCOLS = System.getProperty("ide.externaltools.fileprotocols", "file");

    private ContextUtils() {
    }

    public static boolean isLocalFile(URL url) {
        String protocol = url.getProtocol();
        if (protocol == null) {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(FILE_PROTOCOLS, ",");
        while (tok.hasMoreTokens()) {
            if (!protocol.equals(tok.nextToken())) continue;
            return true;
        }
        return false;
    }

    public static Element getSelectedElement(Context ctx) {
        if (ctx == null) {
            return null;
        }
        Element[] sel = ctx.getSelection();
        if (sel == null || sel.length < 1 || !(sel[0] instanceof Locatable) || sel[0] instanceof Locatable && ((Locatable)sel[0]).getURL() != null && !((Locatable)sel[0]).getURL().getProtocol().equals("file")) {
            return ctx.getNode();
        }
        return sel[0];
    }

    public static Locatable getLocatable(Context ctx) {
        Element e = ContextUtils.getSelectedElement(ctx);
        if (e instanceof Locatable) {
            return (Locatable)e;
        }
        return null;
    }

    public static URL getURL(Context ctx) {
        Locatable l = ContextUtils.getLocatable(ctx);
        if (l != null) {
            return l.getURL();
        }
        return null;
    }

    public static Project getProject(Context ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.getProject() instanceof Project) {
            return ctx.getProject();
        }
        return null;
    }
}

