/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import jakarta.json.JsonException;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Locale;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.util.ByteArray;
import oracle.json.util.JsonByteArray;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.rdbms.OracleRDBMSMetadataBuilder;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;

public class CollectionDescriptor {
    public static final boolean BUG31894459 = "true".equals(System.getProperty("BUG31894459", "true"));
    static final byte STRING_KEY = 1;
    static final byte NCHAR_KEY = 2;
    static final byte INTEGER_KEY = 3;
    static final byte RAW_KEY = 4;
    static final byte CHAR_CONTENT = 1;
    static final byte RAW_CONTENT = 2;
    static final byte NCHAR_CONTENT = 3;
    static final byte BLOB_CONTENT = 4;
    static final byte CLOB_CONTENT = 5;
    static final byte NCLOB_CONTENT = 6;
    static final byte JSON_CONTENT = 7;
    static final byte LOB_COMPRESS_NONE = 0;
    static final byte LOB_COMPRESS_HIGH = 1;
    static final byte LOB_COMPRESS_MEDIUM = 2;
    static final byte LOB_COMPRESS_LOW = 3;
    static final byte LOB_ENCRYPT_NONE = 0;
    static final byte LOB_ENCRYPT_3DES168 = 1;
    static final byte LOB_ENCRYPT_AES128 = 2;
    static final byte LOB_ENCRYPT_AES192 = 3;
    static final byte LOB_ENCRYPT_AES256 = 4;
    static final byte KEY_ASSIGN_CLIENT = 1;
    static final byte KEY_ASSIGN_UUID = 2;
    static final byte KEY_ASSIGN_GUID = 3;
    static final byte KEY_ASSIGN_SEQUENCE = 4;
    static final byte KEY_ASSIGN_IDENTITY = 5;
    static final byte KEY_ASSIGN_EMBEDDED_OID = 6;
    static final byte KEY_ASSIGN_SERVER = 7;
    static final byte VERSION_NONE = 0;
    static final byte VERSION_TIMESTAMP = 1;
    static final byte VERSION_SEQUENTIAL = 2;
    static final byte VERSION_UUID = 3;
    static final byte VERSION_SHA256 = 4;
    static final byte VERSION_MD5 = 5;
    static final byte DBOBJECT_TABLE = 0;
    static final byte DBOBJECT_VIEW = 1;
    static final byte DBOBJECT_PACKAGE = 2;
    static final byte DBOBJECT_BOV = 3;
    static final byte VALIDATION_NONE = 0;
    static final byte VALIDATION_LAX = 1;
    static final byte VALIDATION_STANDARD = 2;
    static final byte VALIDATION_STRICT = 3;
    private static final int VAR_KEY_TYPE_DEFAULT_LENGTH = 255;
    private static final int DEFAULT_VARCHAR2_CONTENT_LENGTH = 4000;
    private static final int DEFAULT_RAW_CONTENT_LENGTH = 2000;
    private static final int DEFAULT_NVARCHAR2_CONTENT_LENGTH = 2000;
    private static final String DEFAULT_CONTENT_NAME = "JSON_DOCUMENT";
    private static final byte DEFAULT_LOB_ENCRYPT = 0;
    private static final byte DEFAULT_VERSION = 0;
    private static final byte DEFAULT_LOB_COMPRESS = 0;
    private static final byte DEFAULT_CONTENT = 4;
    private static final String DEFAULT_KEY_NAME = "ID";
    private static final int DEFAULT_KEY_LENGTH = 0;
    private static final byte DEFAULT_KEY_TYPE = 1;
    private static final byte DEFAULT_CONTENT_LENGTH = 0;
    private static final boolean DEFAULT_LOB_CACHE = true;
    private static final byte DEFAULT_KEY_ASSIGN = 2;
    private static final boolean DEFAULT_WRITABLE = true;
    private static final boolean DEFAULT_PRE_PARSED = false;
    private static final byte DEFAULT_VALIDATION_MODE = 2;
    private static final byte DEFAULT_DBOBJECT = 0;
    static final int MAX_KEY_LENGTH = 255;
    final String uriName;
    final String dbObjectName;
    final byte dbObjectType;
    final String dbSchema;
    final boolean writable;
    final String jsonFormat;
    final byte validationMode;
    final String timeIndex;
    final int keyAssignmentMethod;
    final String keySequenceName;
    final int versioningMethod;
    final String keyColumnName;
    final int keyDataType;
    final int keyLength;
    final String keyColumnPath;
    final String contentColumnName;
    final int contentDataType;
    final int contentLength;
    final int contentLobCompress;
    final int contentLobEncrypt;
    final boolean contentLobCache;
    final String timestampColumnName;
    final String versionColumnName;
    final String doctypeColumnName;
    final String creationColumnName;
    final long creationTime;
    private volatile long lastAccessTime = 0L;

    long getAccessTime(boolean bl) {
        long l = System.currentTimeMillis();
        long l2 = l - this.lastAccessTime;
        if (bl) {
            this.lastAccessTime = l;
        }
        return l2;
    }

    static String stringToIdentifier(String string) {
        return CollectionDescriptor.stringToIdentifier(string, true);
    }

    static String stringToIdentifier(String string, boolean bl) {
        String string2 = null;
        if (string != null) {
            int n;
            char[] cArray = string.toCharArray();
            if (cArray.length == 0) {
                return "";
            }
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = !bl;
            for (n = 0; n < cArray.length; ++n) {
                char c = cArray[n];
                if (c == '\"') {
                    cArray[n] = 95;
                    continue;
                }
                if (c < ' ') {
                    cArray[n] = 95;
                    continue;
                }
                if (c >= 'A' && c <= 'Z') {
                    bl2 = true;
                    continue;
                }
                if (c >= 'a' && c <= 'z') {
                    bl3 = true;
                    continue;
                }
                if (c >= '0' && c <= '9' || c == '_' || c == '$' || c == '#') continue;
                bl4 = false;
            }
            if (bl4 && bl2 && bl3) {
                bl4 = false;
            }
            if (!(!bl4 || (n = cArray[0]) >= 65 && n <= 90 || n >= 97 && n <= 122)) {
                bl4 = false;
            }
            string2 = new String(cArray);
            if (bl4) {
                string2 = string2.toUpperCase(Locale.US);
            }
        }
        return string2;
    }

    public static CollectionDescriptor createDefault(String string) {
        try {
            return new Builder().buildDescriptor(string);
        }
        catch (OracleException oracleException) {
            throw new IllegalStateException(oracleException);
        }
    }

    private static boolean isLobType(int n) {
        return n == 4 || n == 5 || n == 6;
    }

    private static boolean isJsonType(int n) {
        return n == 7;
    }

    private static boolean isLobOrJsonType(int n) {
        return CollectionDescriptor.isLobType(n) || CollectionDescriptor.isJsonType(n);
    }

    private static boolean keyTypeSupportsLength(int n) {
        return n == 1 || n == 2;
    }

    private static String contentTypeToString(int n) {
        switch (n) {
            case 1: {
                return "VARCHAR2";
            }
            case 2: {
                return "RAW";
            }
            case 3: {
                return "NVARCHAR2";
            }
            case 4: {
                return "BLOB";
            }
            case 5: {
                return "CLOB";
            }
            case 6: {
                return "NCLOB";
            }
            case 7: {
                return "JSON";
            }
        }
        throw new IllegalStateException();
    }

    private CollectionDescriptor(String string, String string2, String string3, byte by, String string4, byte by2, int n, String string5, String string6, byte by3, int n2, byte by4, boolean bl, byte by5, String string7, String string8, String string9, String string10, byte by6, byte by7, String string11, boolean bl2, String string12, byte by8, String string13) {
        this.uriName = string;
        this.dbSchema = string2;
        this.dbObjectName = string3;
        this.dbObjectType = by;
        this.keyColumnName = string4;
        this.keyLength = n;
        this.keyDataType = by2;
        this.keyColumnPath = string5;
        this.contentColumnName = string6;
        this.contentDataType = by3;
        this.contentLength = n2;
        this.contentLobCompress = by4;
        this.contentLobEncrypt = by5;
        this.contentLobCache = bl;
        this.doctypeColumnName = string7;
        this.creationColumnName = string8;
        this.timestampColumnName = string9;
        this.timeIndex = string13;
        this.versionColumnName = string10;
        this.versioningMethod = by6;
        this.keySequenceName = string11;
        this.keyAssignmentMethod = by7;
        this.writable = bl2;
        this.jsonFormat = string12;
        this.validationMode = by8;
        this.lastAccessTime = this.creationTime = System.currentTimeMillis();
    }

    public String getName() {
        return this.uriName;
    }

    String getKeyAssignmentMethod() {
        switch (this.keyAssignmentMethod) {
            case 1: {
                return "CLIENT";
            }
            case 2: {
                return "UUID";
            }
            case 3: {
                return "GUID";
            }
            case 4: {
                return "SEQUENCE";
            }
            case 5: {
                return "IDENTITY";
            }
            case 6: {
                return BUG31894459 ? "EMBEDDED_OID" : "OID";
            }
            case 7: {
                return "SERVER";
            }
        }
        throw new IllegalStateException();
    }

    String getVersioningMethod() {
        switch (this.versioningMethod) {
            case 1: {
                return "TIMESTAMP";
            }
            case 2: {
                return "SEQUENTIAL";
            }
            case 3: {
                return "UUID";
            }
            case 4: {
                return "SHA256";
            }
            case 5: {
                return "MD5";
            }
            case 0: {
                return "NONE";
            }
        }
        throw new IllegalStateException();
    }

    String getKeyDataType() {
        switch (this.keyDataType) {
            case 3: {
                return "NUMBER";
            }
            case 4: {
                return "RAW";
            }
            case 2: {
                return "NVARCHAR2";
            }
            case 1: {
                return "VARCHAR2";
            }
        }
        throw new IllegalStateException();
    }

    String getContentDataType() {
        return CollectionDescriptor.contentTypeToString(this.contentDataType);
    }

    String getValidationMode() {
        switch (this.validationMode) {
            case 1: {
                return "LAX";
            }
            case 2: {
                return "STANDARD";
            }
            case 3: {
                return "STRICT";
            }
        }
        throw new IllegalStateException();
    }

    String getLobCompression() {
        switch (this.contentLobCompress) {
            case 1: {
                return "HIGH";
            }
            case 2: {
                return "MEDIUM";
            }
            case 3: {
                return "LOW";
            }
            case 0: {
                return "NONE";
            }
        }
        throw new IllegalStateException();
    }

    String getLobEncryption() {
        switch (this.contentLobEncrypt) {
            case 1: {
                return "3DES168";
            }
            case 2: {
                return "AES128";
            }
            case 3: {
                return "AES192";
            }
            case 4: {
                return "AES256";
            }
            case 0: {
                return "NONE";
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasBinaryFormat() {
        return this.jsonFormat != null;
    }

    public String getContentColumnName() {
        return this.contentColumnName;
    }

    public boolean hasJsonType() {
        return this.contentDataType == 7;
    }

    public boolean isDualityView() {
        return this.dbObjectType == 3;
    }

    private boolean compareStrings(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    boolean matches(CollectionDescriptor collectionDescriptor) {
        if (this == collectionDescriptor) {
            return true;
        }
        if (this.versioningMethod != collectionDescriptor.versioningMethod) {
            return false;
        }
        if (this.keyAssignmentMethod != collectionDescriptor.keyAssignmentMethod) {
            return false;
        }
        if (this.keyDataType != collectionDescriptor.keyDataType) {
            return false;
        }
        if (this.contentDataType != collectionDescriptor.contentDataType) {
            return false;
        }
        if (this.contentLobCache != collectionDescriptor.contentLobCache) {
            return false;
        }
        if (this.contentLobEncrypt != collectionDescriptor.contentLobEncrypt) {
            return false;
        }
        if (this.contentLobCompress != collectionDescriptor.contentLobCompress) {
            return false;
        }
        if (this.keyLength != collectionDescriptor.keyLength) {
            return false;
        }
        if (this.contentLength != collectionDescriptor.contentLength) {
            return false;
        }
        if (this.writable != collectionDescriptor.writable) {
            return false;
        }
        if (!this.compareStrings(this.jsonFormat, collectionDescriptor.jsonFormat)) {
            return false;
        }
        if (this.dbObjectType != collectionDescriptor.dbObjectType) {
            return false;
        }
        if (this.validationMode != collectionDescriptor.validationMode) {
            return false;
        }
        if (!this.compareStrings(this.timeIndex, collectionDescriptor.timeIndex)) {
            return false;
        }
        if (!this.compareStrings(this.uriName, collectionDescriptor.uriName)) {
            return false;
        }
        if (!this.compareStrings(this.dbSchema, collectionDescriptor.dbSchema)) {
            return false;
        }
        if (!this.compareStrings(this.dbObjectName, collectionDescriptor.dbObjectName)) {
            return false;
        }
        if (!this.compareStrings(this.keyColumnName, collectionDescriptor.keyColumnName)) {
            return false;
        }
        if (!this.compareStrings(this.keyColumnPath, collectionDescriptor.keyColumnPath)) {
            return false;
        }
        if (!this.compareStrings(this.contentColumnName, collectionDescriptor.contentColumnName)) {
            return false;
        }
        if (!this.compareStrings(this.keySequenceName, collectionDescriptor.keySequenceName)) {
            return false;
        }
        if (!this.compareStrings(this.timestampColumnName, collectionDescriptor.timestampColumnName)) {
            return false;
        }
        if (!this.compareStrings(this.versionColumnName, collectionDescriptor.versionColumnName)) {
            return false;
        }
        if (!this.compareStrings(this.doctypeColumnName, collectionDescriptor.doctypeColumnName)) {
            return false;
        }
        return this.compareStrings(this.creationColumnName, collectionDescriptor.creationColumnName);
    }

    public String getDescription() {
        JsonByteArray jsonByteArray = new JsonByteArray();
        jsonByteArray.appendOpenBrace();
        if (this.dbSchema != null) {
            jsonByteArray.appendValue("schemaName");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.dbSchema);
            jsonByteArray.appendComma();
        }
        if (this.dbObjectName != null) {
            switch (this.dbObjectType) {
                case 2: {
                    jsonByteArray.appendValue("packageName");
                    break;
                }
                case 1: {
                    jsonByteArray.appendValue("viewName");
                    break;
                }
                case 0: {
                    jsonByteArray.appendValue("tableName");
                    break;
                }
                case 3: {
                    jsonByteArray.appendValue("dualityViewName");
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.dbObjectName);
            jsonByteArray.appendComma();
        }
        jsonByteArray.appendValue("keyColumn");
        jsonByteArray.appendColon();
        jsonByteArray.appendOpenBrace();
        jsonByteArray.appendValue("name");
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.keyColumnName);
        jsonByteArray.appendComma();
        jsonByteArray.appendValue("sqlType");
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.getKeyDataType());
        if (this.keyLength > 0) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("maxLength");
            jsonByteArray.appendColon();
            jsonByteArray.append(Integer.toString(this.keyLength));
        }
        if (this.keyColumnPath != null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("path");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.keyColumnPath);
        }
        jsonByteArray.appendComma();
        if (this.keySequenceName != null) {
            jsonByteArray.appendValue("sequenceName");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.keySequenceName);
            jsonByteArray.appendComma();
        }
        jsonByteArray.appendValue("assignmentMethod");
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.getKeyAssignmentMethod());
        jsonByteArray.appendCloseBrace();
        jsonByteArray.appendComma();
        jsonByteArray.appendValue("contentColumn");
        jsonByteArray.appendColon();
        jsonByteArray.appendOpenBrace();
        jsonByteArray.appendValue("name");
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.contentColumnName);
        jsonByteArray.appendComma();
        jsonByteArray.appendValue("sqlType");
        jsonByteArray.appendColon();
        jsonByteArray.appendValue(this.getContentDataType());
        if (this.contentLength > 0) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("maxLength");
            jsonByteArray.appendColon();
            jsonByteArray.append(Integer.toString(this.contentLength));
        } else if (!this.getContentDataType().equals("JSON") && this.jsonFormat == null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("compress");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.getLobCompression());
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("cache");
            jsonByteArray.appendColon();
            jsonByteArray.append(this.contentLobCache ? "true" : "false");
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("encrypt");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.getLobEncryption());
        }
        if (!this.getContentDataType().equals("JSON") && this.jsonFormat == null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("validation");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.getValidationMode());
        }
        if (this.jsonFormat != null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("jsonFormat");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.jsonFormat);
        }
        jsonByteArray.appendCloseBrace();
        if (this.versionColumnName != null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("versionColumn");
            jsonByteArray.appendColon();
            jsonByteArray.appendOpenBrace();
            jsonByteArray.appendValue("name");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.versionColumnName);
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("type");
            jsonByteArray.appendColon();
            if (this.dbObjectType == 3) {
                jsonByteArray.appendValue("Raw");
            } else {
                switch (this.versioningMethod) {
                    case 1: 
                    case 2: {
                        jsonByteArray.appendValue("Integer");
                        break;
                    }
                    default: {
                        jsonByteArray.appendValue("String");
                    }
                }
            }
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("method");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.getVersioningMethod());
            jsonByteArray.appendCloseBrace();
        }
        if (this.timestampColumnName != null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("lastModifiedColumn");
            jsonByteArray.appendColon();
            jsonByteArray.appendOpenBrace();
            jsonByteArray.appendValue("name");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.timestampColumnName);
            if (this.timeIndex != null) {
                jsonByteArray.appendComma();
                jsonByteArray.appendValue("index");
                jsonByteArray.appendColon();
                jsonByteArray.appendValue(this.timeIndex);
            }
            jsonByteArray.appendCloseBrace();
        }
        if (this.creationColumnName != null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("creationTimeColumn");
            jsonByteArray.appendColon();
            jsonByteArray.appendOpenBrace();
            jsonByteArray.appendValue("name");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.creationColumnName);
            jsonByteArray.appendCloseBrace();
        }
        if (this.doctypeColumnName != null) {
            jsonByteArray.appendComma();
            jsonByteArray.appendValue("mediaTypeColumn");
            jsonByteArray.appendColon();
            jsonByteArray.appendOpenBrace();
            jsonByteArray.appendValue("name");
            jsonByteArray.appendColon();
            jsonByteArray.appendValue(this.doctypeColumnName);
            jsonByteArray.appendCloseBrace();
        }
        jsonByteArray.appendComma();
        jsonByteArray.appendValue("readOnly");
        jsonByteArray.appendColon();
        jsonByteArray.append(this.writable ? "false" : "true");
        jsonByteArray.appendCloseBrace();
        return new String(jsonByteArray.getArray(), 0, jsonByteArray.getLength(), ByteArray.DEFAULT_CHARSET);
    }

    public static Builder jsonToBuilder(JsonFactoryProvider jsonFactoryProvider, InputStream inputStream) throws OracleException {
        if (inputStream == null) {
            return CollectionDescriptor.createStandardBuilder();
        }
        Builder builder = new Builder();
        JsonParser jsonParser = null;
        try {
            jsonParser = jsonFactoryProvider.getParserFactory().createParser(inputStream);
        }
        catch (JsonException jsonException) {
            Throwable throwable = jsonException.getCause();
            if (throwable instanceof IOException) {
                throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_IO_EXCEPTION, throwable, new Object[0]);
            }
            throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_INVALID_JSON_CANT_DETERMINE_ENCODING, jsonException, new Object[0]);
        }
        try {
            while (jsonParser.hasNext()) {
                JsonParser.Event event = jsonParser.next();
                block5 : switch (event) {
                    case START_OBJECT: 
                    case END_OBJECT: {
                        break;
                    }
                    case START_ARRAY: 
                    case END_ARRAY: {
                        throw SODAUtils.makeException(SODAMessage.EX_COL_SPEC_NOT_OBJECT, new Object[0]);
                    }
                    case KEY_NAME: {
                        String string = jsonParser.getString();
                        if (string.equalsIgnoreCase("schemaName")) {
                            builder.schemaName(CollectionDescriptor.getStringEntry(jsonParser, string));
                            break;
                        }
                        if (string.equalsIgnoreCase("tableName")) {
                            builder.tableName(CollectionDescriptor.getStringEntry(jsonParser, string));
                            break;
                        }
                        if (string.equalsIgnoreCase("viewName")) {
                            builder.viewName(CollectionDescriptor.getStringEntry(jsonParser, string));
                            break;
                        }
                        if (string.equalsIgnoreCase("dualityViewName")) {
                            builder.dualityViewName(CollectionDescriptor.getStringEntry(jsonParser, string));
                            break;
                        }
                        if (string.equalsIgnoreCase("packageName")) {
                            builder.packageName(CollectionDescriptor.getStringEntry(jsonParser, string));
                            break;
                        }
                        if (string.equalsIgnoreCase("readOnly")) {
                            event = jsonParser.next();
                            switch (event) {
                                case VALUE_TRUE: {
                                    builder.readOnly(true);
                                    break block5;
                                }
                                case VALUE_FALSE: {
                                    builder.readOnly(false);
                                    break block5;
                                }
                                case VALUE_STRING: {
                                    String string2 = CollectionDescriptor.getStringEntry(jsonParser, "readOnly");
                                    if ("READWRITE".equalsIgnoreCase(string2)) {
                                        builder.readOnly(false);
                                        break block5;
                                    }
                                    if ("READONLY".equalsIgnoreCase(string2)) {
                                        builder.readOnly(true);
                                        break block5;
                                    }
                                    throw SODAUtils.makeException(SODAMessage.EX_UNEXPECTED_IN_COL_SPEC, string);
                                }
                            }
                            throw SODAUtils.makeException(SODAMessage.EX_UNEXPECTED_IN_COL_SPEC, string);
                        }
                        if (string.equalsIgnoreCase("contentColumn")) {
                            CollectionDescriptor.parseContentColumn(builder, jsonParser);
                            break;
                        }
                        if (string.equalsIgnoreCase("keyColumn")) {
                            CollectionDescriptor.parseKeyColumn(builder, jsonParser);
                            break;
                        }
                        if (string.equalsIgnoreCase("creationTimeColumn")) {
                            CollectionDescriptor.parseCreationTimeColumn(builder, jsonParser);
                            break;
                        }
                        if (string.equalsIgnoreCase("lastModifiedColumn")) {
                            CollectionDescriptor.parseLastModifiedColumn(builder, jsonParser);
                            break;
                        }
                        if (string.equalsIgnoreCase("versionColumn")) {
                            CollectionDescriptor.parseVersionColumn(builder, jsonParser);
                            break;
                        }
                        if (string.equalsIgnoreCase("mediaTypeColumn")) {
                            CollectionDescriptor.parseMediaTypeColumn(builder, jsonParser);
                            break;
                        }
                        throw SODAUtils.makeException(SODAMessage.EX_COL_SPEC_NOT_EXPECTED, string);
                    }
                }
            }
            jsonParser.close();
            jsonParser = null;
        }
        catch (JsonParsingException jsonParsingException) {
            throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_INVALID_JSON, jsonParsingException, new Object[0]);
        }
        catch (JsonException jsonException) {
            Throwable throwable = jsonException.getCause();
            if (throwable instanceof IOException) {
                throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_IO_EXCEPTION, throwable, new Object[0]);
            }
            throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_INVALID_JSON, jsonException, new Object[0]);
        }
        finally {
            try {
                if (jsonParser != null) {
                    jsonParser.close();
                }
            }
            catch (JsonException jsonException) {}
        }
        return builder;
    }

    private static void startObject(JsonParser jsonParser, String string) throws OracleException, JsonParsingException {
        JsonParser.Event event = jsonParser.next();
        if (event != JsonParser.Event.START_OBJECT) {
            throw SODAUtils.makeException(SODAMessage.EX_UNEXPECTED_IN_COL_SPEC, string);
        }
    }

    private static void parseContentColumn(Builder builder, JsonParser jsonParser) throws OracleException, JsonParsingException {
        CollectionDescriptor.startObject(jsonParser, "contentColumn");
        block4: while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            switch (event) {
                case END_OBJECT: {
                    return;
                }
                case KEY_NAME: {
                    String string = jsonParser.getString();
                    if (string.equalsIgnoreCase("name")) {
                        builder.contentColumnName(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("sqlType")) {
                        builder.contentColumnType(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("maxLength")) {
                        builder.contentColumnMaxLength(CollectionDescriptor.getIntEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("validation")) {
                        builder.contentColumnValidation(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("compress")) {
                        builder.contentColumnCompress(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("cache")) {
                        builder.contentColumnCache(CollectionDescriptor.getBooleanEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("encrypt")) {
                        builder.contentColumnEncrypt(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("jsonFormat")) {
                        builder.jsonFormat(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    throw SODAUtils.makeException(SODAMessage.EX_COL_SPEC_NOT_EXPECTED, string);
                }
            }
            throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_INVALID_JSON, new Object[0]);
        }
    }

    private static void parseKeyColumn(Builder builder, JsonParser jsonParser) throws OracleException, JsonParsingException {
        CollectionDescriptor.startObject(jsonParser, "keyColumn");
        block4: while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            switch (event) {
                case END_OBJECT: {
                    return;
                }
                case KEY_NAME: {
                    String string = jsonParser.getString();
                    if (string.equalsIgnoreCase("name")) {
                        builder.keyColumnName(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("sqlType")) {
                        builder.keyColumnType(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("maxLength")) {
                        builder.keyColumnMaxLength(CollectionDescriptor.getIntEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("path")) {
                        builder.keyColumnPath(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("sequenceName")) {
                        builder.keyColumnSequenceName(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("assignmentMethod")) {
                        builder.keyColumnAssignmentMethod(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    throw SODAUtils.makeException(SODAMessage.EX_COL_SPEC_NOT_EXPECTED, string);
                }
            }
            throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_INVALID_JSON, new Object[0]);
        }
    }

    static void parseCreationTimeColumn(Builder builder, JsonParser jsonParser) throws OracleException, JsonParsingException {
        CollectionDescriptor.startObject(jsonParser, "creationTimeColumn");
        block4: while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            switch (event) {
                case END_OBJECT: {
                    return;
                }
                case KEY_NAME: {
                    String string = jsonParser.getString();
                    if (string.equalsIgnoreCase("name")) {
                        builder.creationTimeColumnName(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    throw SODAUtils.makeException(SODAMessage.EX_COL_SPEC_NOT_EXPECTED, string);
                }
            }
            throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_INVALID_JSON, new Object[0]);
        }
    }

    private static void parseLastModifiedColumn(Builder builder, JsonParser jsonParser) throws OracleException, JsonParsingException {
        CollectionDescriptor.startObject(jsonParser, "lastModifiedTimeColumn");
        block4: while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            switch (event) {
                case END_OBJECT: {
                    return;
                }
                case KEY_NAME: {
                    String string = jsonParser.getString();
                    if (string.equalsIgnoreCase("name")) {
                        builder.lastModifiedColumnName(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("index")) {
                        builder.lastModifiedColumnIndex(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    throw SODAUtils.makeException(SODAMessage.EX_COL_SPEC_NOT_EXPECTED, string);
                }
            }
            throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_INVALID_JSON, new Object[0]);
        }
    }

    private static void parseVersionColumn(Builder builder, JsonParser jsonParser) throws OracleException, JsonParsingException {
        CollectionDescriptor.startObject(jsonParser, "versionColumn");
        block4: while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            switch (event) {
                case END_OBJECT: {
                    return;
                }
                case KEY_NAME: {
                    String string = jsonParser.getString();
                    if (string.equalsIgnoreCase("name")) {
                        builder.versionColumnName(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("method")) {
                        builder.versionColumnMethod(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    if (string.equalsIgnoreCase("type")) {
                        CollectionDescriptor.skipField(jsonParser, string);
                        continue block4;
                    }
                    throw SODAUtils.makeException(SODAMessage.EX_COL_SPEC_NOT_EXPECTED, string);
                }
            }
            throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_INVALID_JSON, new Object[0]);
        }
    }

    private static void parseMediaTypeColumn(Builder builder, JsonParser jsonParser) throws OracleException, JsonParsingException {
        CollectionDescriptor.startObject(jsonParser, "mediaTypeColumn");
        block4: while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            switch (event) {
                case END_OBJECT: {
                    return;
                }
                case KEY_NAME: {
                    String string = jsonParser.getString();
                    if (string.equalsIgnoreCase("name")) {
                        builder.mediaTypeColumnName(CollectionDescriptor.getStringEntry(jsonParser, string));
                        continue block4;
                    }
                    throw SODAUtils.makeException(SODAMessage.EX_COL_SPEC_NOT_EXPECTED, string);
                }
            }
            throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_INVALID_JSON, new Object[0]);
        }
    }

    private static void skipField(JsonParser jsonParser, String string) throws OracleException, JsonParsingException {
        int n = 0;
        do {
            if (!jsonParser.hasNext()) {
                throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_INVALID_JSON, new Object[0]);
            }
            JsonParser.Event event = jsonParser.next();
            switch (event) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++n;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    --n;
                    break;
                }
            }
        } while (n > 0);
    }

    private static String getStringEntry(JsonParser jsonParser, String string) throws OracleException, JsonParsingException {
        JsonParser.Event event = jsonParser.next();
        if (event != JsonParser.Event.VALUE_STRING) {
            throw SODAUtils.makeException(SODAMessage.EX_UNEXPECTED_IN_COL_SPEC, string);
        }
        return jsonParser.getString();
    }

    private static boolean getBooleanEntry(JsonParser jsonParser, String string) throws OracleException, JsonParsingException {
        JsonParser.Event event = jsonParser.next();
        switch (event) {
            case VALUE_TRUE: {
                return true;
            }
            case VALUE_FALSE: {
                return false;
            }
        }
        throw SODAUtils.makeException(SODAMessage.EX_UNEXPECTED_IN_COL_SPEC, string);
    }

    private static int getIntEntry(JsonParser jsonParser, String string) throws OracleException, JsonParsingException {
        int n = 0;
        JsonParser.Event event = jsonParser.next();
        if (event != JsonParser.Event.VALUE_NUMBER) {
            throw SODAUtils.makeException(SODAMessage.EX_UNEXPECTED_IN_COL_SPEC, string);
        }
        BigDecimal bigDecimal = jsonParser.getBigDecimal();
        try {
            n = bigDecimal.intValue();
        }
        catch (ArithmeticException arithmeticException) {
            throw SODAUtils.makeException(SODAMessage.EX_UNEXPECTED_IN_COL_SPEC, string);
        }
        return n;
    }

    public static Builder jsonToBuilder(JsonFactoryProvider jsonFactoryProvider, String string) throws OracleException {
        byte[] byArray = string.getBytes(ByteArray.DEFAULT_CHARSET);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return CollectionDescriptor.jsonToBuilder(jsonFactoryProvider, byteArrayInputStream);
    }

    public String toString() {
        return this.getName();
    }

    public static Builder createStandardBuilder() {
        return new Builder().creationTimeColumnName("CREATED_ON").lastModifiedColumnName("LAST_MODIFIED").versionColumnName("VERSION").versionColumnMethod((byte)4).contentColumnCache(true);
    }

    public static final class Builder
    implements OracleRDBMSMetadataBuilder {
        private String dbSchema;
        private String dbObjectName;
        private byte dbObjectType = 0;
        private String keyColumnName = "ID";
        private byte keyColumnType = 1;
        private int keyColumnLength = 0;
        private String keyColumnPath;
        private String contentColumnName = "JSON_DOCUMENT";
        private byte contentColumnType = (byte)4;
        private int contentColumnLength = 0;
        private byte contentLobCompress = 0;
        private boolean contentLobCache = true;
        private byte contentLobEncrypt = 0;
        private String doctypeColumnName;
        private String creationColumnName;
        private String timestampColumnName;
        private String versionColumnName;
        private byte versioningMethod = 0;
        private byte keyAssignmentMethod = (byte)2;
        private String keySequenceName;
        private boolean writable = true;
        private String jsonFormat = null;
        private byte validationMode = (byte)2;
        private String timeIndex;

        @Override
        public OracleDocument build() throws OracleException {
            byte[] byArray;
            CollectionDescriptor collectionDescriptor = this.buildDescriptor(null);
            String string = collectionDescriptor.getDescription();
            try {
                byArray = string.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException(unsupportedEncodingException);
            }
            return new OracleDocumentImpl(byArray);
        }

        public CollectionDescriptor buildDescriptor(String string) throws OracleException {
            return this.buildDescriptor(string, null);
        }

        CollectionDescriptor buildDescriptor(String string, String string2) throws OracleException {
            this.validate();
            int n = this.effectiveKeyLength();
            int n2 = this.effectiveContentLength();
            String string3 = this.dbObjectName;
            byte by = this.dbObjectType;
            if (string3 == null) {
                string3 = CollectionDescriptor.stringToIdentifier(string, false);
                by = 0;
            }
            return new CollectionDescriptor(string, this.dbSchema == null ? string2 : this.dbSchema, string3, by, this.keyColumnName, this.keyColumnType, n, this.keyColumnPath, this.contentColumnName, this.contentColumnType, n2, this.contentLobCompress, this.contentLobCache, this.contentLobEncrypt, this.doctypeColumnName, this.creationColumnName, this.timestampColumnName, this.versionColumnName, this.versioningMethod, this.keyAssignmentMethod, this.keySequenceName, this.writable, this.jsonFormat, this.validationMode, this.timeIndex);
        }

        private int effectiveKeyLength() {
            if (CollectionDescriptor.keyTypeSupportsLength(this.keyColumnType) && this.keyColumnLength == 0) {
                return 255;
            }
            if (CollectionDescriptor.keyTypeSupportsLength(this.keyColumnType) && this.keyColumnLength > 255) {
                return 255;
            }
            return this.keyColumnLength;
        }

        private int effectiveContentLength() {
            if (!CollectionDescriptor.isLobOrJsonType(this.contentColumnType) && this.contentColumnLength == 0) {
                switch (this.contentColumnType) {
                    case 1: {
                        return 4000;
                    }
                    case 3: {
                        return 2000;
                    }
                    case 2: {
                        return 2000;
                    }
                }
                throw new IllegalStateException();
            }
            return this.contentColumnLength;
        }

        private void validate() throws OracleException {
            if (this.contentColumnLength > 0 && CollectionDescriptor.isLobOrJsonType(this.contentColumnType)) {
                throw SODAUtils.makeException(SODAMessage.EX_MAX_LEN_LOB_TYPE, new Object[0]);
            }
            if (this.keyColumnLength > 0 && !CollectionDescriptor.keyTypeSupportsLength(this.keyColumnType) && this.dbObjectType != 3) {
                throw SODAUtils.makeException(SODAMessage.EX_KEY_TYPE_BAD_LENGTH, new Object[0]);
            }
            if (!(this.keyColumnLength <= 0 || this.keyColumnLength >= 32 || this.keyAssignmentMethod != 3 && this.keyAssignmentMethod != 2 || this.keyColumnType != 1 && this.keyColumnType != 2)) {
                throw SODAUtils.makeException(SODAMessage.EX_KEY_TYPE_BAD_LENGTH2, new Object[0]);
            }
            if (!CollectionDescriptor.isLobType(this.contentColumnType) && (this.contentLobCompress != 0 || this.contentLobEncrypt != 0 || this.contentLobCache)) {
                throw SODAUtils.makeException(SODAMessage.EX_SECURE_FILE_NOT_LOB, CollectionDescriptor.contentTypeToString(this.contentColumnType));
            }
            if (CollectionDescriptor.isJsonType(this.contentColumnType) && this.validationMode != 0) {
                throw SODAUtils.makeException(SODAMessage.EX_VALIDATION_INVALID_FOR_JSON_TYPE, new Object[0]);
            }
            if (this.keySequenceName == null && this.keyAssignmentMethod == 4) {
                throw SODAUtils.makeException(SODAMessage.EX_KEY_COL_SEQ, new Object[0]);
            }
            if (this.timeIndex != null && this.timestampColumnName == null) {
                throw SODAUtils.makeException(SODAMessage.EX_LAST_MODIFIED_COL, new Object[0]);
            }
            if (this.versionColumnName == null && this.versioningMethod != 0) {
                throw SODAUtils.makeException(SODAMessage.EX_VERSION_METHOD, new Object[0]);
            }
            if (this.doctypeColumnName != null && this.contentColumnType != 4) {
                throw SODAUtils.makeException(SODAMessage.EX_MEDIA_TYPE_COLUMN_NOT_SUP, new Object[0]);
            }
        }

        @Override
        public Builder schemaName(String string) {
            this.dbSchema = CollectionDescriptor.stringToIdentifier(string);
            return this;
        }

        @Override
        public Builder tableName(String string) {
            this.dbObjectName = CollectionDescriptor.stringToIdentifier(string);
            this.dbObjectType = 0;
            return this;
        }

        @Override
        public Builder viewName(String string) {
            this.dbObjectName = CollectionDescriptor.stringToIdentifier(string);
            this.dbObjectType = 1;
            return this;
        }

        @Override
        public Builder dualityViewName(String string) {
            this.dbObjectName = CollectionDescriptor.stringToIdentifier(string);
            this.dbObjectType = (byte)3;
            this.keyColumnName = "OBJECT_ID";
            this.keyColumnLength = 4000;
            this.keyColumnType = (byte)4;
            this.keyAssignmentMethod = (byte)7;
            this.contentColumnName = "DATA";
            this.contentColumnType = (byte)7;
            this.contentLobCompress = 0;
            this.contentLobCache = false;
            this.contentLobEncrypt = 0;
            this.validationMode = 0;
            this.versionColumnName = "OBJECT_ETAG";
            this.versioningMethod = 0;
            this.creationTimeColumnName(null);
            this.lastModifiedColumnName(null);
            this.mediaTypeColumnName(null);
            return this;
        }

        public Builder packageName(String string) {
            this.dbObjectName = CollectionDescriptor.stringToIdentifier(string);
            this.dbObjectType = (byte)2;
            return this;
        }

        public Builder dbObject(String string, String string2) {
            this.dbObjectType = "PACKAGE".equalsIgnoreCase(string2) ? (byte)2 : ("VIEW".equalsIgnoreCase(string2) ? (byte)1 : ("BOV".equalsIgnoreCase(string2) ? (byte)3 : (byte)0));
            this.dbObjectName = CollectionDescriptor.stringToIdentifier(string);
            return this;
        }

        @Override
        public Builder contentColumnName(String string) {
            this.contentColumnName = CollectionDescriptor.stringToIdentifier(string);
            return this;
        }

        @Override
        public Builder contentColumnType(String string) throws OracleException {
            int n;
            if (string == null) {
                n = 4;
            } else if (string.equalsIgnoreCase("char")) {
                n = 1;
            } else if (string.equalsIgnoreCase("varchar")) {
                n = 1;
            } else if (string.equalsIgnoreCase("varchar2")) {
                n = 1;
            } else if (string.equalsIgnoreCase("blob")) {
                n = 4;
            } else if (string.equalsIgnoreCase("clob")) {
                n = 5;
            } else if (string.equalsIgnoreCase("json")) {
                n = 7;
            } else {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_ARG_VALUE, string);
            }
            this.contentColumnType = (byte)n;
            if (CollectionDescriptor.isLobType(this.contentColumnType)) {
                this.contentColumnLength = 0;
                this.contentLobCache = true;
            } else {
                if (this.contentColumnType == 7) {
                    this.contentColumnLength = 0;
                    this.validationMode = 0;
                }
                this.contentLobCompress = 0;
                this.contentLobCache = false;
                this.contentLobEncrypt = 0;
            }
            return this;
        }

        @Override
        public Builder contentColumnMaxLength(int n) throws OracleException {
            if (n < 0) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_ARG_VALUE, n);
            }
            this.contentColumnLength = n;
            return this;
        }

        @Override
        public Builder contentColumnValidation(String string) throws OracleException {
            int n;
            if (string == null) {
                n = 2;
            } else if (string.equalsIgnoreCase("strict")) {
                n = 3;
            } else if (string.equalsIgnoreCase("standard")) {
                n = 2;
            } else if (string.equalsIgnoreCase("lax")) {
                n = 1;
            } else {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_ARG_VALUE, string);
            }
            this.validationMode = (byte)n;
            return this;
        }

        @Override
        public Builder contentColumnCompress(String string) throws OracleException {
            int n;
            if (string == null) {
                n = 0;
            } else if (string.equalsIgnoreCase("high")) {
                n = 1;
            } else if (string.equalsIgnoreCase("medium")) {
                n = 2;
            } else if (string.equalsIgnoreCase("low")) {
                n = 3;
            } else if (string.equalsIgnoreCase("none")) {
                n = 0;
            } else {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_ARG_VALUE, string);
            }
            this.contentLobCompress = n;
            return this;
        }

        @Override
        public Builder contentColumnCache(boolean bl) {
            this.contentLobCache = bl;
            return this;
        }

        @Override
        public Builder contentColumnEncrypt(String string) throws OracleException {
            int n;
            if (string == null) {
                n = 0;
            } else if (string.equalsIgnoreCase("3DES168")) {
                n = 1;
            } else if (string.equalsIgnoreCase("AES128")) {
                n = 2;
            } else if (string.equalsIgnoreCase("AES192")) {
                n = 3;
            } else if (string.equalsIgnoreCase("AES256")) {
                n = 4;
            } else if (string.equalsIgnoreCase("NONE")) {
                n = 0;
            } else {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_ARG_VALUE, string);
            }
            this.contentLobEncrypt = n;
            return this;
        }

        @Override
        public Builder keyColumnName(String string) {
            this.keyColumnName = string == null ? CollectionDescriptor.DEFAULT_KEY_NAME : CollectionDescriptor.stringToIdentifier(string);
            return this;
        }

        @Override
        public Builder keyColumnType(String string) throws OracleException {
            int n;
            if (string == null) {
                n = 1;
            } else if (string.equalsIgnoreCase("string")) {
                n = 1;
            } else if (string.equalsIgnoreCase("char")) {
                n = 1;
            } else if (string.equalsIgnoreCase("varchar")) {
                n = 1;
            } else if (string.equalsIgnoreCase("varchar2")) {
                n = 1;
            } else if (string.equalsIgnoreCase("nchar")) {
                n = 2;
            } else if (string.equalsIgnoreCase("nvarchar")) {
                n = 2;
            } else if (string.equalsIgnoreCase("nvarchar2")) {
                n = 2;
            } else if (string.equalsIgnoreCase("integer")) {
                n = 3;
            } else if (string.equalsIgnoreCase("number")) {
                n = 3;
            } else if (string.equalsIgnoreCase("raw")) {
                n = 4;
            } else if (string.equalsIgnoreCase("guid")) {
                n = 4;
            } else if (string.equalsIgnoreCase("uuid")) {
                n = 4;
            } else if (string.equalsIgnoreCase("uid")) {
                n = 4;
            } else {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_ARG_VALUE, string);
            }
            this.keyColumnType = n;
            if (this.keyColumnType == 3 || this.keyColumnType == 4) {
                this.keyColumnLength = 0;
            }
            return this;
        }

        @Override
        public Builder keyColumnMaxLength(int n) throws OracleException {
            if (n < 0) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_ARG_VALUE, n);
            }
            this.keyColumnLength = n;
            return this;
        }

        public Builder keyColumnPath(String string) throws OracleException {
            if (string == null) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_ARG_VALUE, string);
            }
            this.keyColumnPath = string;
            return this;
        }

        @Override
        public Builder keyColumnAssignmentMethod(String string) throws OracleException {
            int n;
            if (string == null) {
                n = 2;
            } else if (string.equalsIgnoreCase("sequence")) {
                n = 4;
            } else if (string.equalsIgnoreCase("guid")) {
                n = 3;
            } else if (string.equalsIgnoreCase("uuid")) {
                n = 2;
            } else if (string.equalsIgnoreCase("client")) {
                n = 1;
            } else if (string.equalsIgnoreCase("identity")) {
                n = 5;
            } else if (string.equalsIgnoreCase("embedded_oid")) {
                n = 6;
            } else if (string.equalsIgnoreCase("server")) {
                n = 7;
            } else if (string.equalsIgnoreCase("oid")) {
                n = 6;
            } else {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_ARG_VALUE, string);
            }
            this.keyAssignmentMethod = (byte)n;
            if (this.keyAssignmentMethod != 4) {
                this.keySequenceName = null;
            }
            return this;
        }

        @Override
        public Builder keyColumnSequenceName(String string) {
            if (string != null) {
                this.keyAssignmentMethod = (byte)4;
            }
            this.keySequenceName = CollectionDescriptor.stringToIdentifier(string);
            return this;
        }

        @Override
        public Builder creationTimeColumnName(String string) {
            this.creationColumnName = CollectionDescriptor.stringToIdentifier(string);
            return this;
        }

        @Override
        public Builder lastModifiedColumnName(String string) {
            if (string == null) {
                this.timeIndex = null;
            }
            this.timestampColumnName = CollectionDescriptor.stringToIdentifier(string);
            return this;
        }

        @Override
        public Builder lastModifiedColumnIndex(String string) {
            this.timeIndex = CollectionDescriptor.stringToIdentifier(string);
            return this;
        }

        @Override
        public Builder versionColumnName(String string) {
            if (string == null) {
                this.versioningMethod = 0;
            }
            this.versionColumnName = CollectionDescriptor.stringToIdentifier(string);
            return this;
        }

        @Override
        public Builder versionColumnMethod(String string) throws OracleException {
            int n;
            if (string == null) {
                n = 0;
            } else if (string.equalsIgnoreCase("timestamp")) {
                n = 1;
            } else if (string.equalsIgnoreCase("sequential")) {
                n = 2;
            } else if (string.equalsIgnoreCase("uuid")) {
                n = 3;
            } else if (string.equalsIgnoreCase("SHA256")) {
                n = 4;
            } else if (string.equalsIgnoreCase("MD5")) {
                n = 5;
            } else if (string.equalsIgnoreCase("NONE")) {
                n = 0;
            } else {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_ARG_VALUE, string);
            }
            return this.versionColumnMethod((byte)n);
        }

        protected Builder versionColumnMethod(byte by) {
            this.versioningMethod = by;
            return this;
        }

        @Override
        public Builder mediaTypeColumnName(String string) {
            this.doctypeColumnName = CollectionDescriptor.stringToIdentifier(string);
            return this;
        }

        @Override
        public Builder readOnly(boolean bl) {
            this.writable = !bl;
            return this;
        }

        public Builder jsonFormat(String string) {
            this.jsonFormat = string;
            return this;
        }

        @Override
        public Builder removeOptionalColumns() {
            return this.creationTimeColumnName(null).lastModifiedColumnName(null).versionColumnName(null).mediaTypeColumnName(null);
        }
    }
}

