/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.json.common.DistinctValue;
import oracle.json.logging.OracleLog;
import oracle.json.parser.AndORTree;
import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.QueryException;
import oracle.json.parser.ValueTypePair;
import oracle.json.util.Pair;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.rdbms.impl.OracleCollectionImpl;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.soda.rdbms.impl.TableCollectionImpl;

public class CollectionAggregationImpl
extends TableCollectionImpl {
    protected static final Logger log = Logger.getLogger(CollectionAggregationImpl.class.getName());

    public CollectionAggregationImpl(OracleCollectionImpl oracleCollectionImpl) {
        super(oracleCollectionImpl.db, oracleCollectionImpl.collectionName, oracleCollectionImpl.options);
    }

    public List<DistinctValue> distinct(String string, OracleDocument oracleDocument) throws OracleException {
        JsonQueryPath jsonQueryPath;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            jsonQueryPath = new JsonQueryPath(string);
            if (jsonQueryPath.hasArraySteps()) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_FILTER, new Object[0]);
            }
        }
        catch (QueryException queryException) {
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_FILTER, queryException, new Object[0]);
        }
        this.sb.setLength(0);
        this.sb.append("select JT.STR#, JT.NUM#, JT.BOOL#,");
        this.sb.append(" to_char(JT.TS#,'YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"'),");
        this.sb.append(" count(1)\nfrom \"");
        this.sb.append(this.options.dbSchema);
        this.sb.append("\".\"");
        this.sb.append(this.options.dbObjectName);
        this.sb.append("\" T1, JSON_TABLE(T1.\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\", '");
        jsonQueryPath.toLaxString(this.sb, true);
        this.sb.append("' columns STR# varchar2(255) path '$',");
        this.sb.append(" BOOL# varchar2(10) path '$.booleanOnly()',");
        this.sb.append(" NUM# number path '$.numberOnly()',");
        this.sb.append(" TS# timestamp path '$') JT\n");
        AndORTree andORTree = null;
        if (oracleDocument != null) {
            try {
                andORTree = AndORTree.createTree(this.getDatabase().getJsonFactoryProvider(), ((OracleDocumentImpl)oracleDocument).getContentAsStream());
                andORTree.checkStringValues(4000);
                andORTree.generateJsonExists();
            }
            catch (QueryException queryException) {
                if (OracleLog.isLoggingEnabled()) {
                    log.warning(queryException.toString());
                }
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_FILTER, queryException, new Object[0]);
            }
            if (andORTree.hasSpatialClause() || andORTree.hasContainsClause() || andORTree.hasSqlJsonClause()) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_FILTER, new Object[0]);
            }
            if (andORTree.getKeys().size() > 0) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_FILTER, new Object[0]);
            }
            this.sb.append(" where JSON_EXISTS(T1.\"");
            this.sb.append(this.options.contentColumnName);
            this.sb.append("\", ");
            andORTree.appendJsonExists(this.sb);
            this.sb.append(")\n");
        }
        this.sb.append(" group by JT.NUM#, JT.BOOL#, JT.TS#, JT.STR#\n");
        this.sb.append(" order by JT.NUM#, JT.BOOL#, JT.TS#, JT.STR#");
        String string2 = this.sb.toString();
        ArrayList<DistinctValue> arrayList = new ArrayList<DistinctValue>();
        BigDecimal object = null;
        int n = 0;
        String object2 = null;
        try {
            int n2;
            preparedStatement = this.conn.prepareStatement(string2);
            if (andORTree != null) {
                n2 = 0;
                block14: for (ValueTypePair valueTypePair : andORTree.getValueArray()) {
                    ++n2;
                    switch (valueTypePair.getValue().getValueType()) {
                        case NUMBER: {
                            preparedStatement.setBigDecimal(n2, valueTypePair.getNumberValue());
                            continue block14;
                        }
                        case STRING: {
                            preparedStatement.setString(n2, valueTypePair.getStringValue());
                            continue block14;
                        }
                        case TRUE: 
                        case FALSE: {
                            preparedStatement.setString(n2, String.valueOf(valueTypePair.getBooleanValue()));
                            continue block14;
                        }
                        case NULL: {
                            preparedStatement.setString(n2, "null");
                            continue block14;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                BigDecimal bigDecimal;
                n2 = resultSet.getInt(5);
                String string3 = resultSet.getString(4);
                if (string3 != null) {
                    if (object != null) {
                        arrayList.add(DistinctValue.createNumber(object, n));
                        object = null;
                    }
                    if (object2 != null) {
                        if (object2.equals(string3)) {
                            n += n2;
                            continue;
                        }
                        arrayList.add(DistinctValue.createDateTime(object2, n));
                    }
                    object2 = string3;
                    n = n2;
                    continue;
                }
                String string4 = resultSet.getString(3);
                if (string4 != null) {
                    if (string4.equals("true")) {
                        arrayList.add(DistinctValue.createBoolean(true, n2));
                        continue;
                    }
                    if (string4.equals("false")) {
                        arrayList.add(DistinctValue.createBoolean(false, n2));
                        continue;
                    }
                }
                if ((bigDecimal = resultSet.getBigDecimal(2)) != null) {
                    if (object2 != null) {
                        arrayList.add(DistinctValue.createDateTime(object2, n));
                        object2 = null;
                    }
                    if (object != null) {
                        if (object.equals(bigDecimal)) {
                            n += n2;
                            continue;
                        }
                        arrayList.add(DistinctValue.createNumber(object, n));
                    }
                    object = bigDecimal;
                    n = n2;
                    continue;
                }
                if (object != null) {
                    arrayList.add(DistinctValue.createNumber(object, n));
                    object = null;
                } else if (object2 != null) {
                    arrayList.add(DistinctValue.createDateTime(object2, n));
                    object2 = null;
                }
                String string5 = resultSet.getString(1);
                if (string5 == null) {
                    arrayList.add(DistinctValue.createNull(n2));
                    continue;
                }
                arrayList.add(DistinctValue.createString(string5, n2));
            }
            if (object != null) {
                arrayList.add(DistinctValue.createNumber(object, n));
                object = null;
            } else if (object2 != null) {
                arrayList.add(DistinctValue.createDateTime(object2, n));
                object2 = null;
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (SQLException sQLException) {
            try {
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string2);
            }
            catch (Throwable throwable) {
                for (String string6 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string6);
                }
                throw throwable;
            }
        }
        for (String string7 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string7);
        }
        return arrayList;
    }

    public Pair<Long, Long> summarize(OracleDocument oracleDocument) throws OracleException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Pair<Long, Long> pair = null;
        this.sb.setLength(0);
        this.sb.append("select count(1) NUM#, ");
        if (this.options.contentDataType == 1 || this.options.contentDataType == 3) {
            this.sb.append("sum(lengthb(T1.\"");
        } else if (this.options.contentDataType == 5 || this.options.contentDataType == 6) {
            this.sb.append("sum(2*length(T1.\"");
        } else {
            this.sb.append("sum(length(T1.\"");
        }
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\")) CLEN# from \"");
        this.sb.append(this.options.dbSchema);
        this.sb.append("\".\"");
        this.sb.append(this.options.dbObjectName);
        this.sb.append("\" T1");
        AndORTree andORTree = null;
        if (oracleDocument != null) {
            try {
                andORTree = AndORTree.createTree(this.getDatabase().getJsonFactoryProvider(), ((OracleDocumentImpl)oracleDocument).getContentAsStream());
                andORTree.checkStringValues(4000);
                andORTree.generateJsonExists();
            }
            catch (QueryException queryException) {
                if (OracleLog.isLoggingEnabled()) {
                    log.warning(queryException.toString());
                }
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_FILTER, queryException, new Object[0]);
            }
            if (andORTree.hasSpatialClause() || andORTree.hasContainsClause() || andORTree.hasSqlJsonClause()) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_FILTER, new Object[0]);
            }
            if (andORTree.getKeys().size() > 0) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_FILTER, new Object[0]);
            }
            this.sb.append(" where JSON_EXISTS(T1.\"");
            this.sb.append(this.options.contentColumnName);
            this.sb.append("\", ");
            andORTree.appendJsonExists(this.sb);
            this.sb.append(")\n");
        }
        String string = this.sb.toString();
        try {
            preparedStatement = this.conn.prepareStatement(string);
            if (andORTree != null) {
                int n = 0;
                block12: for (ValueTypePair valueTypePair : andORTree.getValueArray()) {
                    ++n;
                    switch (valueTypePair.getValue().getValueType()) {
                        case NUMBER: {
                            preparedStatement.setBigDecimal(n, valueTypePair.getNumberValue());
                            continue block12;
                        }
                        case STRING: {
                            preparedStatement.setString(n, valueTypePair.getStringValue());
                            continue block12;
                        }
                        case TRUE: 
                        case FALSE: {
                            preparedStatement.setString(n, String.valueOf(valueTypePair.getBooleanValue()));
                            continue block12;
                        }
                        case NULL: {
                            preparedStatement.setString(n, "null");
                            continue block12;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                Long l = new Long(resultSet.getLong(1));
                Long l2 = new Long(resultSet.getLong(2));
                pair = new Pair<Long, Long>(l, l2);
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (SQLException sQLException) {
            try {
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
        return pair;
    }
}

