/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class RewindableInputStream
extends FilterInputStream {
    private static final int BUFFER_UNIT = 4096;
    private static final byte[] NULL_DEST = null;
    private int total = 0;
    private int pos = 0;
    private int limit = Integer.MAX_VALUE;
    private int markPos = 0;
    private byte[] buffer = new byte[4096];
    protected boolean closed = false;

    public RewindableInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void rewind() throws IOException {
        this.markPos = 0;
        this.pos = 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.markPos = this.pos;
    }

    @Override
    public void reset() throws IOException {
        this.pos = this.markPos;
    }

    @Override
    public int available() throws IOException {
        return this.total - this.pos + super.available();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.read(NULL_DEST, (int)l);
    }

    @Override
    public int read() throws IOException {
        int n = this.read(NULL_DEST, 0, 1);
        if (n == 1) {
            return this.buffer[this.pos - 1] & 0xFF;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, byArray.length);
    }

    public int read(byte[] byArray, int n) throws IOException {
        return this.read(byArray, 0, n);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.consume(byArray, n, n2);
        n += n3;
        if ((n2 -= n3) > 0) {
            n2 = this.fill(n2);
            n3 += this.consume(byArray, n, n2);
        }
        return n3;
    }

    private int fill(int n) throws IOException {
        if (this.pos == this.limit || n == 0) {
            return 0;
        }
        int n2 = this.buffer.length;
        while (n2 - this.total < n) {
            n2 *= 2;
        }
        this.buffer = Arrays.copyOf(this.buffer, n2);
        int n3 = 0;
        while (n > 0) {
            int n4 = this.in.read(this.buffer, this.total, n);
            if (n4 < 0) {
                this.limit = this.total;
                n = 0;
                continue;
            }
            this.total += n4;
            n3 += n4;
            n -= n4;
        }
        return n3;
    }

    private int consume(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (n2 > 0 && this.pos < this.total) {
            n3 = this.total - this.pos;
            if (n3 > n2) {
                n3 = n2;
            }
            if (byArray != null) {
                System.arraycopy(this.buffer, this.pos, byArray, n, n3);
            }
            this.pos += n3;
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            super.close();
            this.limit = this.total;
        }
    }
}

