/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Map;

public class OrderBySpecification {
    private ArrayList<String> orderKeys = null;
    private ArrayList<String> orderVals = null;

    public OrderBySpecification(JsonObject jsonObject) {
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)"$orderby");
        if (jsonValue == null || jsonValue.getValueType() != JsonValue.ValueType.OBJECT) {
            return;
        }
        block5: for (Map.Entry entry : jsonValue.asJsonObject().entrySet()) {
            String string = (String)entry.getKey();
            JsonValue jsonValue2 = (JsonValue)entry.getValue();
            switch (jsonValue2.getValueType()) {
                case ARRAY: 
                case OBJECT: 
                case FALSE: 
                case TRUE: 
                case NULL: {
                    this.appendOrderBy(string, null);
                    continue block5;
                }
                case NUMBER: {
                    this.appendOrderBy(string, ((JsonNumber)jsonValue2).bigDecimalValue().toString());
                    continue block5;
                }
                case STRING: {
                    this.appendOrderBy(string, ((JsonString)jsonValue2).getString());
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
    }

    public OrderBySpecification() {
    }

    int getOrderCount() {
        if (this.orderKeys == null || this.orderVals == null) {
            return 0;
        }
        return this.orderKeys.size();
    }

    String getOrderPath(int n) {
        if (n < 0) {
            return null;
        }
        if (this.orderKeys == null) {
            return null;
        }
        if (n >= this.orderKeys.size()) {
            return null;
        }
        return this.orderKeys.get(n);
    }

    String getOrderDirection(int n) {
        if (n < 0) {
            return null;
        }
        if (this.orderVals == null) {
            return null;
        }
        if (n >= this.orderVals.size()) {
            return null;
        }
        return this.orderVals.get(n);
    }

    void appendOrderBy(String string, String string2) {
        if (this.orderKeys == null) {
            this.orderKeys = new ArrayList();
        }
        if (this.orderVals == null) {
            this.orderVals = new ArrayList();
        }
        this.orderKeys.add(string);
        this.orderVals.add(string2);
    }
}

