/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import jakarta.json.JsonException;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import oracle.json.common.DocumentCodec;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.common.Message;

public class DocumentCodecFactory {
    protected JsonFactoryProvider factoryProvider = null;
    protected ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public DocumentCodecFactory() {
    }

    public DocumentCodecFactory(JsonFactoryProvider jsonFactoryProvider) {
        this.setFactoryProvider(jsonFactoryProvider);
    }

    public void setFactoryProvider(JsonFactoryProvider jsonFactoryProvider) {
        this.factoryProvider = jsonFactoryProvider;
    }

    public DocumentCodec getCodec() {
        return new DefaultDocumentCodec(this.factoryProvider);
    }

    private class DefaultDocumentCodec
    extends DocumentCodec<JsonValue> {
        private DefaultDocumentCodec(JsonFactoryProvider jsonFactoryProvider) {
            super(jsonFactoryProvider);
        }

        @Override
        protected ByteArrayOutputStream getBAOS() {
            if (!this.isDetached) {
                this.baos = DocumentCodecFactory.this.baos;
            }
            return super.getBAOS();
        }

        @Override
        public void loadImage(byte[] byArray) {
            throw this.makeException(Message.EX_UNIMPLEMENTED_FORMAT, new Object[0]);
        }

        @Override
        public JsonValue getDocument() throws JsonException {
            boolean bl = this.rekeyingCheck();
            if (this.doc != null && bl) {
                this.jsonUnicode = this.getUnicode();
                this.doc = null;
            }
            if (this.doc == null) {
                if (bl) {
                    this.jsonText = this.getString();
                }
                JsonReaderFactory jsonReaderFactory = this.factoryProvider.getReaderFactory();
                JsonReader jsonReader = null;
                if (this.jsonText != null) {
                    StringReader stringReader = new StringReader(this.jsonText);
                    jsonReader = jsonReaderFactory.createReader((Reader)stringReader);
                } else if (this.jsonUnicode != null) {
                    jsonReader = jsonReaderFactory.createReader((InputStream)new ByteArrayInputStream(this.jsonUnicode));
                } else {
                    return null;
                }
                this.doc = jsonReader.read();
                jsonReader.close();
            }
            return (JsonValue)this.doc;
        }

        @Override
        public byte[] getImage() throws JsonException {
            throw this.makeException(Message.EX_UNIMPLEMENTED_FORMAT, new Object[0]);
        }

        @Override
        public String getString() throws JsonException {
            boolean bl = this.rekeyingCheck();
            if (this.jsonText == null && this.jsonUnicode == null && this.doc != null) {
                StringWriter stringWriter = new StringWriter();
                JsonGenerator jsonGenerator = this.factoryProvider.getGeneratorFactory().createGenerator((Writer)stringWriter);
                if (bl) {
                    // empty if block
                }
                jsonGenerator.write((JsonValue)this.doc);
                jsonGenerator.close();
                this.jsonText = stringWriter.toString();
            }
            if (bl && this.doc != null) {
                this.doc = null;
            }
            return super.getString();
        }

        @Override
        public byte[] getUnicode() throws JsonException {
            boolean bl = this.rekeyingCheck();
            if (this.jsonText == null && this.jsonUnicode == null && this.doc != null) {
                ByteArrayOutputStream byteArrayOutputStream = this.getBAOS();
                JsonGenerator jsonGenerator = this.factoryProvider.getGeneratorFactory().createGenerator((OutputStream)byteArrayOutputStream);
                if (bl) {
                    // empty if block
                }
                jsonGenerator.write((JsonValue)this.doc);
                jsonGenerator.close();
                this.jsonUnicode = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
            }
            if (bl && this.doc != null) {
                this.doc = null;
            }
            return super.getUnicode();
        }

        @Override
        public Object getDocument(Class clazz) throws JsonException {
            if (clazz == JsonValue.class) {
                return this.getDocument();
            }
            return super.getDocument(clazz);
        }
    }
}

