/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleDriver;

public class ConnectionPool {
    private static final int MIN_POOL_SIZE = 5;
    private static final int MAX_POOL_SIZE = 100;
    private static final int MAX_LOCK_WAIT = 100;
    private static final int MAX_REUSE_COUNT = 1000;
    private static final int STATEMENT_CACHE_SIZE = 50;
    private static final Logger log = Logger.getLogger(ConnectionPool.class.getName());
    private static final boolean isDatabaseInternal = System.getProperty("oracle.jserver.version") != null;
    private final ReentrantLock lock = new ReentrantLock();
    private final ArrayList<Connection> pool;
    private volatile boolean closeFlag = false;
    private final String dburi;
    private final String dbusr;
    private final String dbpwd;
    private static String ORA_DRIVER_NAME = "oracle.jdbc.driver.OracleDriver";
    private volatile Connection[] destruct = null;

    private void close() {
    }

    public ConnectionPool(String string, String string2, String string3, int n) {
        this.dburi = string;
        this.dbusr = string2;
        this.dbpwd = string3;
        this.pool = new ArrayList(n);
    }

    public ConnectionPool(String string, String string2, String string3) {
        this(string, string2, string3, 100);
    }

    public ConnectionPool(String string, int n) {
        this(string, null, null, n);
    }

    public ConnectionPool(String string) {
        this(string, 100);
    }

    private boolean getLock(int n) {
        boolean bl;
        if (n == 0) {
            this.lock.lock();
            return true;
        }
        try {
            bl = this.lock.tryLock(n, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        return bl;
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                log.warning("Destroy connection failed with " + sQLException.getMessage());
            }
        }
    }

    private Connection createConnection(String string, String string2, String string3) throws SQLException {
        Connection connection = DriverManager.getConnection(string, string2, string3);
        return connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Connection createConnection() {
        Connection connection = null;
        try {
            connection = this.createConnection(this.dburi, this.dbusr, this.dbpwd);
            if (connection == null) return connection;
        }
        catch (SQLException sQLException) {
            log.severe("Failed to create connection with " + sQLException.getMessage());
        }
        return connection;
    }

    public Connection getConnection() {
        Connection connection = null;
        if (this.closeFlag) {
            return connection;
        }
        if (this.getLock(100)) {
            try {
                int n = this.pool.size();
                if (n > 0) {
                    connection = this.pool.get(--n);
                    this.pool.remove(n);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (connection == null) {
            connection = this.createConnection();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putConnection(Connection connection) {
        boolean bl = true;
        if (connection == null) {
            return;
        }
        if (!this.closeFlag && this.getLock(100)) {
            try {
                int n = this.pool.size();
                if (n < 100 && !this.closeFlag) {
                    this.pool.add(n, connection);
                    connection = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.closeConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sweep() {
        int n;
        int n2 = 0;
        this.getLock(0);
        try {
            int n3 = this.pool.size();
            if (n3 == 0) {
                return;
            }
            if (this.destruct != null && this.destruct.length < n3) {
                this.destruct = null;
            }
            if (this.destruct == null) {
                this.destruct = new Connection[n3];
            }
            n = n3;
            while (n > 0) {
                Connection connection = this.pool.get(--n);
                this.pool.remove(n);
                this.destruct[n2++] = connection;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.destruct != null) {
            if (n2 > 0) {
                log.fine("Destroying " + n2 + " stale database connections");
            }
            for (n = 0; n < n2; ++n) {
                Connection connection = this.destruct[n];
                this.destruct[n] = null;
                this.closeConnection(connection);
            }
        }
    }

    public void clear() {
        this.sweep();
        this.close();
    }

    public void shutdown() {
        this.closeFlag = true;
        this.clear();
        this.close();
    }

    private static void initDriver(ConnectionPool connectionPool) throws SQLException {
        try {
            Class.forName(ORA_DRIVER_NAME);
        }
        catch (Exception exception) {
            throw new SQLException(ORA_DRIVER_NAME + ":" + exception.getMessage());
        }
    }

    public static boolean isInternalConnection() {
        return isDatabaseInternal;
    }

    public static OracleConnection defaultConnection() throws SQLException {
        ConnectionPool.initDriver(null);
        OracleDriver oracleDriver = new OracleDriver();
        OracleConnection oracleConnection = (OracleConnection)oracleDriver.defaultConnection();
        return oracleConnection;
    }
}

