/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.macrorecorder;

import java.awt.Component;
import javax.swing.JToolBar;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorController;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.TriggerController;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.javatools.editor.BasicEditorPane;

final class MacroController
implements TriggerController {
    private ToggleToolButton recordButton;
    private ToolButton playButton;
    private IdeAction toggleAction = IdeAction.find((String)"toggle-macro-recording");
    private IdeAction playbackAction = IdeAction.find((String)"playback-macro");

    MacroController() {
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action == this.toggleAction) {
            BasicEditorPane editor = CodeEditorController.getEditorPaneFromContext((Context)context);
            if (editor != null) {
                editor.invokeAction("toggle-macro-recording");
                Toolbar toolbar = Ide.getStatusBar().getToolbar();
                if (this.recordButton == null) {
                    this.recordButton = toolbar.addToggleButton((ToggleAction)this.toggleAction);
                    this.recordButton.setFocusable(false);
                    toolbar.add((Component)this.recordButton, 0);
                    this.playButton = toolbar.add((ToggleAction)this.playbackAction);
                    this.playButton.setFocusable(false);
                    toolbar.add((Component)this.playButton, 1);
                    final JToolBar.Separator sep = toolbar.newSeparator();
                    toolbar.add((Component)sep, 2);
                    EditorManager.getEditorManager().addEditorListener(new EditorListener(){

                        public void editorOpened(Editor editor) {
                        }

                        public void editorActivated(Editor editor) {
                            if (editor instanceof CodeEditor) {
                                sep.setVisible(true);
                                MacroController.this.recordButton.setVisible(true);
                                MacroController.this.playButton.setVisible(true);
                                MacroController.this.playButton.setEnabled(!MacroController.this.playbackAction.getState());
                            }
                        }

                        public void editorDeactivated(Editor editor) {
                            if (editor instanceof CodeEditor && MacroController.this.recordButton.isSelected()) {
                                BasicEditorPane editorPane = ((CodeEditor)editor).getFocusedEditorPane();
                                editorPane.invokeAction("toggle-macro-recording");
                                MacroController.this.recordButton.setSelected(false);
                            }
                            sep.setVisible(false);
                            MacroController.this.recordButton.setVisible(false);
                            MacroController.this.playButton.setVisible(false);
                        }

                        public void editorClosed(Editor editor) {
                        }
                    });
                }
                this.playbackAction.setEnabled(!this.toggleAction.getState());
            }
            return true;
        }
        if (action == this.playbackAction) {
            BasicEditorPane editor = CodeEditorController.getEditorPaneFromContext((Context)context);
            if (editor != null) {
                editor.invokeAction("playback-macro");
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action == this.toggleAction) {
            action.setEnabled(true);
            return true;
        }
        if (action == this.playbackAction) {
            action.setEnabled(!this.toggleAction.getState());
            return true;
        }
        return false;
    }

    public Object getInvalidStateMessage(IdeAction action, Context context) {
        return null;
    }
}

