/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.TranslationResult;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.util.FileUtil;

public abstract class AbstractEmulationManager {
    private final String EMULATIONGLOBALVARS = "identity NUMBER(10);\ntrancount NUMBER(10):=0;\nvar_number NUMBER(10):=0;\n";
    protected final String EMULATIONHEADERSTART = "CREATE OR REPLACE PACKAGE " + this.getEmulationPackageName() + " AS\nidentity NUMBER(10);\ntrancount NUMBER(10):=0;\nvar_number NUMBER(10):=0;\n";
    protected final String EMULATIONHEADEREND = "\nEND " + this.getEmulationPackageName() + ";\n";
    protected final String EMULATIONBODYSTART = "CREATE OR REPLACE PACKAGE BODY " + this.getEmulationPackageName() + " AS";
    protected final String EMULATIONBODYEND = "\nEND " + this.getEmulationPackageName() + ";\n";
    private final String EMULATIONFILE = this.getEmulationFile();
    protected Hashtable<String, String> m_funcBodies = new Hashtable();
    protected Hashtable<String, String> m_funcHeaders = new Hashtable();

    public abstract String getEmulationPackageName();

    public abstract String getEmulationFile();

    public abstract StringBuffer addPrivateFunctions(ArrayList<String> var1, StringBuffer var2);

    protected void init() {
        String string = null;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.EMULATIONFILE);
        try {
            string = FileUtil.inputStreamToString(inputStream);
            Pattern pattern = Pattern.compile("(\r\n|\r|\n|\n\r)");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                string = matcher.replaceAll("\n");
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        if (string != null) {
            this.processFile(string);
        }
    }

    protected void processFile(String string) {
        String string2 = "//EMULATION_";
        String string3 = "//\\";
        int n = 0;
        int n2 = 0;
        String string4 = null;
        String string5 = null;
        while (n != -1) {
            n = string.indexOf(string2, n2);
            n2 = string.indexOf(string3, n);
            if (n == -1 || n2 == -1) break;
            string4 = string.substring(n + string2.length(), string.indexOf("\n", n)).trim();
            string5 = string.substring(string.indexOf("\n", n), n2).trim();
            this.processFunc(string4, string5);
        }
    }

    protected void processFunc(String string, String string2) {
        String string3 = this.getHeaderFromBody(string2);
        if (string3 == null) {
            return;
        }
        this.m_funcBodies.put(string, string2);
        this.m_funcHeaders.put(string, string3);
    }

    protected String getHeaderFromBody(String string) {
        int n = string.toUpperCase().indexOf("\nIS\n");
        int n2 = string.toUpperCase().indexOf("\nAS\n");
        int n3 = 0;
        if (n != -1 && n2 != -1) {
            n3 = Math.min(n, n2);
        } else if (n == -1 && n2 == -1) {
            n3 = 0;
        } else if (n == -1) {
            n3 = n2;
        } else if (n2 == -1) {
            n3 = n;
        }
        if (n3 == 0) {
            return null;
        }
        Object object = string.substring(0, n3);
        object = ((String)object).replaceAll("\n", " ");
        object = ((String)object).trim();
        object = (String)object + ";";
        return object;
    }

    public TranslationResult getEmulationPackage(TranslationDBObjectReference translationDBObjectReference, Object object, ITranslationContext iTranslationContext, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object22 : this.m_funcBodies.keySet()) {
            arrayList.add(object22);
        }
        for (String string : arrayList) {
            this.processEmulationFuncs(string, stringBuffer, stringBuffer2);
        }
        if (stringBuffer.length() < 1 || stringBuffer2.length() < 1) {
            return null;
        }
        stringBuffer2 = this.addPrivateFunctions(arrayList, stringBuffer2);
        stringBuffer = new StringBuffer(this.EMULATIONHEADERSTART + stringBuffer.toString() + this.EMULATIONHEADEREND);
        stringBuffer2 = new StringBuffer(this.EMULATIONBODYSTART + stringBuffer2.toString() + this.EMULATIONBODYEND);
        ArrayList arrayList2 = new ArrayList();
        TranslationDBObject translationDBObject = translationDBObjectReference != null ? new TranslationDBObject(translationDBObjectReference, stringBuffer.toString()) : new TranslationDBObject(stringBuffer.toString());
        TranslationDBObject translationDBObject2 = translationDBObjectReference != null ? new TranslationDBObject(translationDBObjectReference, stringBuffer2.toString()) : new TranslationDBObject(stringBuffer2.toString());
        arrayList2.add(translationDBObject2);
        TranslationResult translationResult = new TranslationResult(translationDBObject, arrayList2, null);
        return translationResult;
    }

    protected ArrayList<String> getEmulationFuncs(TranslationDBObjectReference translationDBObjectReference, Object object, ITranslationContext iTranslationContext, boolean bl) {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = bl ? iTranslationContext.getEmulationFuncsForSchema(object) : iTranslationContext.getEmulationFuncsForConnection(object);
        return arrayList;
    }

    protected void processEmulationFuncs(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        StringBuffer stringBuffer3 = null;
        StringBuffer stringBuffer4 = null;
        stringBuffer3 = this.getBody(string);
        if (stringBuffer3 != null && stringBuffer3.length() != 0 && ((stringBuffer4 = this.getHeader(string)) != null || stringBuffer4.length() != 0)) {
            stringBuffer.append("\n" + stringBuffer4);
            stringBuffer2.append("\n" + stringBuffer3);
        }
    }

    protected StringBuffer getBody(String string) {
        if (string == null || this.m_funcBodies == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        String string2 = this.m_funcBodies.get(string);
        if (string2 != null) {
            stringBuffer = new StringBuffer(string2);
        }
        return stringBuffer;
    }

    protected StringBuffer getHeader(String string) {
        if (string == null || this.m_funcHeaders == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        String string2 = this.m_funcHeaders.get(string);
        if (string2 != null) {
            stringBuffer = new StringBuffer(string2);
        }
        return stringBuffer;
    }
}

