/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.Hashtable;
import oracle.dbtools.migration.parser.defaults.expression.DefaultExpressionOperatorMapper;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.helper.CodeBlockManager;
import oracle.dbtools.migration.parser.plugin.IExpressionOperatorMapper;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.Expression;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;

public class ExpressionHelper {
    private CodeBlockManager m_codeBlockMgr;
    private IExpressionOperatorMapper m_exprOpMapper;
    private Hashtable<Block, Expression> m_exprMap;

    public ExpressionHelper(CodeBlockManager codeBlockManager) {
        this.m_codeBlockMgr = codeBlockManager;
        this.m_exprMap = new Hashtable();
        this.m_exprOpMapper = new DefaultExpressionOperatorMapper();
    }

    public void setExpressionOperatorMapper(IExpressionOperatorMapper iExpressionOperatorMapper) {
        this.m_exprOpMapper = iExpressionOperatorMapper;
    }

    public void setBinaryExpression(AST aST) {
        this.setExpression(aST, Expression.ResultType.BINARY);
    }

    public void setBooleanExpression(AST aST) {
        this.setExpression(aST, Expression.ResultType.BOOLEAN);
    }

    public void setCharacterExpression(AST aST) {
        this.setExpression(aST, Expression.ResultType.CHARACTER);
    }

    public void setDateExpression(AST aST) {
        this.setExpression(aST, Expression.ResultType.DATE);
    }

    public void setLargeTextExpression(AST aST) {
        this.setExpression(aST, Expression.ResultType.LARGE_TEXT);
    }

    public void setNullExpression(AST aST) {
        this.setExpression(aST, Expression.ResultType.NULL);
    }

    public void setNumericExpression(AST aST) {
        this.setExpression(aST, Expression.ResultType.NUMERIC);
    }

    public void setTimestampExpression(AST aST) {
        this.setExpression(aST, Expression.ResultType.TIMESTAMP);
    }

    public void setXMLExpression(AST aST) {
        this.setExpression(aST, Expression.ResultType.XML);
    }

    private void setExpression(AST aST, Expression.ResultType resultType) {
        Block block = this.getExpressionBlock(aST);
        if (block == null) {
            return;
        }
        this.m_exprMap.put(block, new Expression(block, aST, resultType));
    }

    public void setExpression(AST aST, AST aST2) {
        Block block = this.getExpressionBlock(aST);
        if (block == null) {
            return;
        }
        Expression expression = this.getExpression(aST2);
        if (expression == null) {
            return;
        }
        Expression expression2 = new Expression(block, aST, expression.getResultType());
        expression2.addComponent(expression);
        this.m_exprMap.put(block, expression2);
    }

    public void setExpression(AST aST, AST aST2, String string) {
        Block block = this.getExpressionBlock(aST);
        if (block == null) {
            return;
        }
        Expression expression = this.getExpression(aST2);
        if (expression == null) {
            return;
        }
        Expression expression2 = new Expression(block, aST);
        expression2.addComponent(expression);
        expression2.setOperator(this.m_exprOpMapper.getOperator(string));
        this.m_exprMap.put(block, expression2);
    }

    public void setExpression(AST aST, AST aST2, AST aST3, String string) {
        Block block = null;
        Expression expression = null;
        Expression expression2 = null;
        block = this.getExpressionBlock(aST);
        if (block == null) {
            return;
        }
        Expression expression3 = new Expression(block, aST);
        expression = this.getExpression(aST2);
        if (expression != null) {
            expression3.addComponent(expression);
        }
        if ((expression2 = this.getExpression(aST3)) != null) {
            expression3.addComponent(expression2);
        }
        expression3.setOperator(this.m_exprOpMapper.getOperator(string));
        this.m_exprMap.put(block, expression3);
    }

    public Expression getExpression(AST aST) {
        Block block = this.getExpressionBlock(aST);
        Expression expression = null;
        if (block != null) {
            expression = this.m_exprMap.get(block);
        }
        if (block == null || expression == null) {
            return null;
        }
        return expression;
    }

    public void setExpression(AST aST, TranslationDataType translationDataType) {
        if (translationDataType == null) {
            return;
        }
        String string = translationDataType.getDataType();
        if (string.equalsIgnoreCase("NUMBER")) {
            this.setNumericExpression(aST);
        } else if (string.equalsIgnoreCase("CHAR") || string.equalsIgnoreCase("NCHAR") || string.equalsIgnoreCase("VARCHAR2") || string.equalsIgnoreCase("NVARCHAR2")) {
            this.setCharacterExpression(aST);
        } else if (string.equalsIgnoreCase("BLOB") || string.equalsIgnoreCase("RAW")) {
            this.setBinaryExpression(aST);
        } else if (string.equalsIgnoreCase("DATE")) {
            this.setDateExpression(aST);
        } else if (string.equalsIgnoreCase("CLOB")) {
            this.setCharacterExpression(aST);
        } else if (string.equalsIgnoreCase("TIMESTAMP")) {
            this.setTimestampExpression(aST);
        } else if (string.equalsIgnoreCase("XMLTYPE")) {
            this.setXMLExpression(aST);
        }
    }

    public Expression.ResultType getExpressionReturnType(AST aST) {
        Expression expression = this.getExpression(aST);
        if (expression == null) {
            return Expression.ResultType.UNKNOWN;
        }
        return expression.getResultType();
    }

    public Expression.ResultType getExpressionReturnType(Block block) {
        Expression expression = this.m_exprMap.get(block);
        if (expression == null) {
            return Expression.ResultType.UNKNOWN;
        }
        return expression.getResultType();
    }

    private Block getExpressionBlock(AST aST) {
        Block block = ((ExtAST)aST).getBlock();
        if (block != null && block.getBlockType().equalsIgnoreCase("EXPRBLOCK")) {
            return block;
        }
        return this.m_codeBlockMgr.findEnclosingBlock(aST, "EXPRBLOCK");
    }
}

