/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;
import oracle.dbtools.migration.translation.util.ASTUtil;

public class DateHelper {
    private static String m_defaultFormat = "dd/mm/yyyy";
    private static TranslationHelper m_helper = null;

    public DateHelper(TranslationHelper translationHelper) {
        m_helper = translationHelper;
    }

    public static boolean isMatchingDateFormat(String string) {
        String string2 = DateHelper.getFormatMask();
        if (string2 == null) {
            return false;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            simpleDateFormat.setLenient(false);
            Date date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public static String getFormatMaskIfRequired(AST aST) {
        String string = ASTUtil.toString(aST);
        string = string.replace('\"', ' ');
        string = string.replace('\'', ' ');
        string = string.replace('#', ' ');
        if (DateHelper.isMatchingDateFormat(string = string.trim())) {
            return DateHelper.getFormatMask();
        }
        return null;
    }

    private static String getFormatMask() {
        TranslationPreferences translationPreferences = m_helper.getTranslationContext().getTranslationPreferences(null);
        if (translationPreferences != null) {
            return translationPreferences.getFormatMask();
        }
        return m_defaultFormat;
    }

    public static void setFormatMask(String string) {
        m_defaultFormat = string;
    }
}

