/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.util.ArrayList;
import oracle.spatial.geometry.Chain;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.geometry.JPoint2DD;

class BufGeom {
    private double minX = Double.POSITIVE_INFINITY;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double minY = Double.POSITIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;
    private JPoint2DD repPt = null;
    boolean linear = false;
    ArrayList<Chain> chains = null;
    boolean toBuffer;
    int flag;

    double getMinX() {
        return this.minX;
    }

    double getMaxX() {
        return this.maxX;
    }

    double getMinY() {
        return this.minY;
    }

    double getMaxY() {
        return this.maxY;
    }

    JPoint2DD getRepPt() {
        return this.repPt;
    }

    boolean merOverlap(BufGeom bufGeom) {
        return this.maxX >= bufGeom.minX && this.minX <= bufGeom.maxX && this.maxY >= bufGeom.minY && this.minY <= bufGeom.maxY;
    }

    protected void extendMer(double d, double d2) {
        if (this.repPt == null) {
            this.extendMer(new JPoint2DD(d, d2));
        } else {
            this.minX = Math.min(this.minX, d);
            this.maxX = Math.max(this.maxX, d);
            this.minY = Math.min(this.minY, d2);
            this.maxY = Math.max(this.maxY, d2);
        }
    }

    protected void extendMer(JPoint2DD jPoint2DD) {
        this.minX = Math.min(this.minX, jPoint2DD.x);
        this.maxX = Math.max(this.maxX, jPoint2DD.x);
        this.minY = Math.min(this.minY, jPoint2DD.y);
        this.maxY = Math.max(this.maxY, jPoint2DD.y);
        if (this.repPt == null) {
            this.repPt = jPoint2DD instanceof Chain.CenterPoint ? new Chain.CenterPoint((Chain.CenterPoint)jPoint2DD) : new JPoint2DD(jPoint2DD);
        } else if (Math.abs(jPoint2DD.x - (this.minX + this.maxX) / 2.0) + Math.abs(jPoint2DD.y - (this.minY + this.maxY) / 2.0) < Math.abs(this.repPt.x - (this.minX + this.maxX) / 2.0) + Math.abs(this.repPt.y - (this.minY + this.maxY) / 2.0)) {
            this.repPt.x = jPoint2DD.x;
            this.repPt.y = jPoint2DD.y;
        }
    }

    protected void extendMer(Chain chain) {
        int n = chain.size();
        for (int i = 0; i < 4; ++i) {
            for (int j = i; j < n; j += 4) {
                JPoint2DD jPoint2DD = chain.get(j);
                if (jPoint2DD instanceof Chain.CenterPoint) {
                    Chain.CenterPoint centerPoint = (Chain.CenterPoint)jPoint2DD;
                    JPoint2DD jPoint2DD2 = chain.get(j - 1);
                    JPoint2DD jPoint2DD3 = chain.get(j + 1);
                    if (!(Math.min(jPoint2DD2.x, jPoint2DD3.x) <= centerPoint.x) || !(Math.max(jPoint2DD2.x, jPoint2DD3.x) >= centerPoint.x)) continue;
                    if (centerPoint.CUW) {
                        this.minY = Math.min(this.minY, centerPoint.y - centerPoint.radius);
                        continue;
                    }
                    this.maxY = Math.max(this.maxY, centerPoint.y + centerPoint.radius);
                    continue;
                }
                this.extendMer(jPoint2DD);
            }
        }
    }

    protected void toBuffer(double d) {
        this.toBuffer = true;
        this.minX -= d;
        this.maxX += d;
        this.minY -= d;
        this.maxY += d;
    }

    BufGeom() {
    }

    BufGeom(JPoint2DD jPoint2DD) {
        if (jPoint2DD instanceof Chain.CenterPoint) {
            this.toBuffer(((Chain.CenterPoint)jPoint2DD).radius);
        }
        this.extendMer(jPoint2DD);
    }

    BufGeom(JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2) {
        this.extendMer(jPoint2DD);
        this.extendMer(jPoint2DD2);
        this.linear = true;
        this.chains = new ArrayList(1);
        Chain chain = Chain.create()[0];
        chain.add(jPoint2DD);
        chain.add(jPoint2DD2);
        this.chains.add(chain);
    }

    BufGeom(JPoint2DD jPoint2DD, Chain.CenterPoint centerPoint, JPoint2DD jPoint2DD2) {
        this.extendMer(jPoint2DD);
        this.extendMer(jPoint2DD2);
        if (jPoint2DD.x < centerPoint.x && jPoint2DD2.x > centerPoint.x || jPoint2DD.x > centerPoint.x && jPoint2DD2.x < centerPoint.x) {
            if (centerPoint.CUW) {
                this.extendMer(centerPoint.x, centerPoint.y - centerPoint.radius);
            } else {
                this.extendMer(centerPoint.x, centerPoint.y + centerPoint.radius);
            }
        }
        this.linear = true;
        this.chains = new ArrayList(1);
        Chain chain = Chain.create()[0];
        chain.add(jPoint2DD);
        chain.add(centerPoint);
        chain.add(jPoint2DD2);
        this.chains.add(chain);
    }

    BufGeom(Chain chain, boolean bl) {
        this.addPoly(chain);
        this.linear = bl;
    }

    void addPoly(Chain chain) {
        if (this.chains == null) {
            this.linear = false;
            this.chains = new ArrayList(1);
        } else if (this.linear) {
            throw new IllegalArgumentException();
        }
        this.chains.add(chain);
        this.extendMer(chain);
        ArrayList<Chain> arrayList = chain.getMetaData();
        if (arrayList != null) {
            for (Chain chain2 : arrayList) {
                this.extendMer(chain2);
            }
        }
    }

    JGeometry asJGeometry() {
        if (this.chains == null || this.chains.size() < 1) {
            if (this.repPt instanceof Chain.CenterPoint) {
                throw new RuntimeException("Create a circle");
            }
            return new JGeometry(this.repPt.x, this.repPt.y, 0);
        }
        JGeometry.ChainConverter chainConverter = new JGeometry.ChainConverter();
        for (Chain object2 : this.chains) {
            if (object2.signedArea() > 0.0) {
                object2.reverse();
            }
            chainConverter.convert(object2);
            ArrayList<Chain> n = object2.getMetaData();
            if (n == null) continue;
            for (Chain chain : n) {
                if (chain.size() <= 3) continue;
                if (chain.signedArea() < 0.0) {
                    chain.reverse();
                }
                chainConverter.convert(chain);
            }
        }
        Object object3 = new double[2 * chainConverter.numAllVertices];
        int[] nArray = new int[3 * chainConverter.numTriplets];
        int n = 0;
        for (Chain chain : this.chains) {
            n = chainConverter.writeOrdinates(chain, true, n, (double[])object3, nArray);
            ArrayList<Chain> arrayList = chain.getMetaData();
            if (arrayList == null) continue;
            for (Chain chain2 : arrayList) {
                if (chain2.size() < 3) continue;
                n = chainConverter.writeOrdinates(chain2, false, n, (double[])object3, nArray);
            }
        }
        if (n != ((Object)object3).length || nArray[nArray.length - 1] <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.linear) {
            block7: for (int n2 = 0; n2 < nArray.length; n2 += 3) {
                switch (nArray[n2]) {
                    case 1003: 
                    case 1005: 
                    case 2003: 
                    case 2005: {
                        nArray[n2] = 2;
                        continue block7;
                    }
                }
            }
        }
        int n2 = this.chains.size() == 1 ? (this.linear ? 2 : 3) : (this.linear ? 6 : 7);
        return new JGeometry(n2, 0, nArray, (double[])object3);
    }

    String WKT() {
        String string;
        if (this.chains == null || this.chains.size() == 0) {
            return "POINT(" + this.repPt.x + " " + this.repPt.y + ")";
        }
        if (this.linear) {
            if (this.chains.size() == 1) {
                return this.chains.get(0).WKT();
            }
            StringBuffer stringBuffer = new StringBuffer("MULTILINESTRING(");
            String string2 = "";
            for (Chain chain : this.chains) {
                stringBuffer.append(string2 + chain.WKTList());
                string2 = ",";
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "";
        if (this.chains.size() == 1) {
            stringBuffer.append("POLYGON");
            string = "";
        } else {
            stringBuffer.append("MULTIPOLYGON(");
            string = ")";
        }
        for (Chain chain : this.chains) {
            stringBuffer.append(string3 + "(");
            stringBuffer.append(chain.WKTList());
            ArrayList<Chain> arrayList = chain.getMetaData();
            if (arrayList != null) {
                for (Chain chain2 : arrayList) {
                    stringBuffer.append("," + chain2.WKTList());
                }
            }
            stringBuffer.append(")");
            string3 = ",";
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

