/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.ide.runner.Debugger;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;

public class OjcRedefineMap {
    final HashMap<String, RedefineDetails> redefineMap = new HashMap();
    final byte[] empty = new byte[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] fileToBuffer(String file, Translator.Log log) {
        try {
            File f = new File(file);
            FileInputStream fis = new FileInputStream(f);
            try {
                int len = fis.available();
                if (len <= 0) {
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
                byte[] classBuffer = new byte[len];
                fis.read(classBuffer);
                byte[] byArray = classBuffer;
                return byArray;
            }
            finally {
                fis.close();
                fis = null;
            }
        }
        catch (IOException e) {
            log.error(null, 0, 0, 0, "can't redefine " + file);
            return new byte[0];
        }
    }

    public void redefineClass(String fileName, String outDir) {
        UnifiedBuildSystem.getInstance().markCompiled(fileName);
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null && debugger.isDebugging()) {
            String outDir2;
            String c = fileName.replace('\\', '/');
            if (!c.startsWith(outDir2 = outDir.replace('\\', '/'))) {
                return;
            }
            if ((c = c.substring(outDir2.length())).length() > 0 && c.charAt(0) == '/') {
                c = c.substring(1);
            }
            if (c.endsWith(".class")) {
                c = c.substring(0, c.length() - 6);
            }
            c = c.replace('/', '.');
            RedefineDetails details = new RedefineDetails(c, this.empty);
            this.redefineMap.put(fileName, details);
        }
    }

    public void redefineClassMap(Project prj, Translator.Log log) {
        if (this.redefineMap != null && this.redefineMap.size() > 0) {
            HashMap<String, byte[]> newRedefineMap = new HashMap<String, byte[]>();
            for (Map.Entry<String, RedefineDetails> entry : this.redefineMap.entrySet()) {
                if (entry.getValue().fileContents == this.empty) {
                    byte[] classBuffer = this.fileToBuffer(entry.getKey(), log);
                    if (classBuffer.length <= 0) continue;
                    newRedefineMap.put(entry.getValue().className, classBuffer);
                    continue;
                }
                newRedefineMap.put(entry.getValue().className, entry.getValue().fileContents);
            }
            this.redefineMap.clear();
            Debugger.getDebugger().redefineClasses(prj, newRedefineMap);
            newRedefineMap.clear();
        }
    }

    private class RedefineDetails {
        String className;
        byte[] fileContents;

        RedefineDetails(String className, byte[] fileContents) {
            this.className = className;
            this.fileContents = fileContents;
        }
    }
}

