/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.compiler.CompileArguments;
import oracle.ide.compiler.Compiler;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.view.View;
import oracle.javatools.util.Log;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cm.dt.CmJavaUtil;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerContext;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdevimpl.ant.AntNodeHook;
import oracle.jdevimpl.compiler.JCompilerMenuController;
import oracle.jdevimpl.compiler.JCompilerUtils;
import oracle.jdevimpl.resource.JdevBuildExtensionManifest;

public final class JCompilerMenuItems {
    private static final Log LOG = new Log("JCompilerMenuItems");
    private JCompiler jcompiler;
    private JMenuItem compileSelected;
    private JMenuItem rebuildSelected;
    private JMenuItem makeWorkingSet;
    private JMenuItem buildWorkingSet;
    private JMenuItem makeProjectAndDependencies;
    private JMenuItem makeProject;
    private JMenuItem buildProjectAndDependencies;
    private JMenuItem buildProject;
    private JMenuItem cancelBuild;
    private JMenuItem cleanProject;
    private JMenuItem cleanWorkspace;
    private JMenuItem cleanAndRefreshWorkspace;
    private JMenuItem makeWorkspace;
    private JMenuItem cleanAll;
    private static final String CompileS = CompArb.getString(5);
    private static final String RebuildS = CompArb.getString(9);
    private static final String SelectedS = CompArb.getString(2);
    private static final String CleanS = CompArb.getString(33);
    private static final String CleanRefreshS = CompArb.getString(146);
    private static final String CompileDB = CompArb.getString(83);
    private static JCompilerMenuItems instance;
    private JCompilerMenuController controller;
    private HashMap<IdeAction, JMenuItem> popupCachedMenuItems;

    private JCompilerMenuItems() {
        instance = this;
        this.controller = new JCompilerMenuController();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JCompilerMenuItems.this.createBuildMenu();
            }
        });
    }

    public static synchronized JCompilerMenuItems getInstance() {
        if (instance == null) {
            new JCompilerMenuItems();
        }
        return instance;
    }

    private JCompiler getJCompiler() {
        if (this.jcompiler == null) {
            this.jcompiler = (JCompiler)Compiler.getCompiler();
        }
        return this.jcompiler;
    }

    private void createBuildMenu() {
        JMenu buildMenu = MenuManager.getJMenu((String)"Build");
        if (buildMenu == null) {
            Menubar menubar = Ide.getMenubar();
            buildMenu = menubar.createMenu(CompArb.getString(0), JDeveloperMenuConstants.WEIGHT_BUILD_MENU, JDeveloperMenuConstants.SECTION_BUILD_TOOLS);
            MenuManager.putJMenu((String)"Build", (JMenu)buildMenu);
            menubar.add((Component)buildMenu);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (context == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (this.getJCompiler().isBusy(null) && cmdId == this.getJCompiler().getCancelBuildCmdId()) {
            UnifiedBuildSystem.getInstance().stopBuildSystem();
            return true;
        }
        CompilerContext.setCompileAction(context, action);
        if (cmdId == JCompiler.MAKE_SELECTED_CMD_ID || cmdId == this.getJCompiler().getMakeFolderCmdId() || cmdId == JCompiler.MAKE_PROJECT_CMD_ID || cmdId == JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID || cmdId == JCompiler.MAKE_WORKINGSET_CMD_ID || cmdId == JCompiler.MAKE_WORKSPACE_CMD_ID) {
            CompileArguments compileArguments = new CompileArguments(context);
            compileArguments.setRebuildAllSources(false);
            compileArguments.setWaitForTermination(false);
            compileArguments.setSaveBeforeCompiling(true);
            if (cmdId == JCompiler.MAKE_PROJECT_CMD_ID) {
                compileArguments.setCompileDependencies(false);
            }
            this.getJCompiler().compile(compileArguments);
            return true;
        }
        if (cmdId == JCompiler.BUILD_SELECTED_CMD_ID || cmdId == JCompiler.BUILD_WORKINGSET_CMD_ID || cmdId == JCompiler.BUILD_PROJECT_CMD_ID || cmdId == JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID || cmdId == JCompiler.BUILD_WORKSPACE_CMD_ID) {
            CompileArguments compileArguments = new CompileArguments(context);
            compileArguments.setRebuildAllSources(true);
            compileArguments.setWaitForTermination(false);
            compileArguments.setSaveBeforeCompiling(true);
            if (cmdId == JCompiler.BUILD_PROJECT_CMD_ID) {
                compileArguments.setCompileDependencies(false);
            }
            this.getJCompiler().compile(compileArguments);
            return true;
        }
        if (cmdId == this.getJCompiler().getCancelBuildCmdId()) {
            return true;
        }
        if (cmdId == this.getJCompiler().getCleanSelectedCmdId() || cmdId == JCompiler.CLEAN_PROJECT_CMD_ID || cmdId == JCompiler.CLEAN_WORKSPACE_CMD_ID || cmdId == JCompiler.CLEAN_AND_REFRESH_WORKSPACE_CMD_ID) {
            this.getJCompiler().cleanAll(context, cmdId == JCompiler.CLEAN_AND_REFRESH_WORKSPACE_CMD_ID);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (context == null || action == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        if (cmdId == JCompiler.MAKE_PROJECT_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveProject(), this.makeProject, action, false, false, false);
        }
        if (cmdId == JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveProject(), this.makeProjectAndDependencies, action, false, false, false);
        }
        if (cmdId == JCompiler.MAKE_SELECTED_CMD_ID) {
            return this.setMenuItem(context, this.compileSelected, action, false, false);
        }
        if (cmdId == this.getJCompiler().getMakeFolderCmdId()) {
            return this.setMenuItem(context, null, action, false, false);
        }
        if (cmdId == JCompiler.BUILD_PROJECT_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveProject(), this.buildProject, action, true, false, false);
        }
        if (cmdId == JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveProject(), this.buildProjectAndDependencies, action, true, false, false);
        }
        if (cmdId == JCompiler.BUILD_SELECTED_CMD_ID) {
            return this.setMenuItem(context, this.rebuildSelected, action, true, false);
        }
        if (cmdId == JCompiler.MAKE_WORKINGSET_CMD_ID) {
            return this.setWSMenuItem(action, !this.getJCompiler().isBusy(context), this.makeWorkingSet, JCompilerMenuItems.getWorkingSet(Ide.getActiveWorkspace()));
        }
        if (cmdId == JCompiler.BUILD_WORKINGSET_CMD_ID) {
            return this.setWSMenuItem(action, !this.getJCompiler().isBusy(context), this.buildWorkingSet, JCompilerMenuItems.getWorkingSet(Ide.getActiveWorkspace()));
        }
        if (cmdId == JCompiler.MAKE_WORKSPACE_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveWorkspace(), this.makeWorkspace, action, false, false, false);
        }
        if (cmdId == JCompiler.BUILD_WORKSPACE_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveWorkspace(), null, action, true, false, false);
        }
        if (cmdId == this.getJCompiler().getCancelBuildCmdId()) {
            boolean isCancellable = UnifiedBuildSystem.getInstance().isAlive();
            return this.setMenuItem(action, isCancellable, this.cancelBuild);
        }
        if (cmdId == JCompiler.CLEAN_PROJECT_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveProject(), this.cleanProject, action, false, true, false);
        }
        if (cmdId == JCompiler.CLEAN_WORKSPACE_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveWorkspace(), this.cleanWorkspace, action, false, true, false);
        }
        if (cmdId == JCompiler.CLEAN_AND_REFRESH_WORKSPACE_CMD_ID) {
            return this.setWPActionAndMenuItem(context, (Element)Ide.getActiveWorkspace(), this.cleanAndRefreshWorkspace, action, false, false, true);
        }
        if (cmdId == this.getJCompiler().getCleanSelectedCmdId()) {
            return this.setMenuItem(context, this.cleanAll, action, false, true);
        }
        return false;
    }

    void menuWillShow(ContextMenu popup) {
        IdeAction action;
        boolean isElementAWorkspace;
        assert (LOG.trace("Start of JCompilerMenuItems.menuWillShow"));
        Context context = popup.getContext();
        View view = context.getView();
        String viewId = view.getId();
        if (viewId != null && viewId.indexOf("VersioningNavigator") >= 0) {
            return;
        }
        if (view instanceof MessagePage && this.getJCompiler().isBusy(context)) {
            IdeAction action2 = IdeAction.find((int)this.getJCompiler().getCancelBuildCmdId());
            action2.setEnabled(true);
            popup.add((Component)this.getMenuItem(popup, action2), JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        boolean leaveEarly = false;
        Element[] elements = this.getElementsFromContext(context, false);
        if (elements == null || elements.length == 0) {
            leaveEarly = true;
        } else {
            for (int x = 0; x < elements.length; ++x) {
                if (elements[x] != null && (!(elements[x] instanceof Node) || !AntNodeHook.isAntNode((Node)((Node)elements[x]))) && (JCompiler.isBuildable(elements[x]) || JCompiler.isCopyable(elements[x], context.getProject()))) continue;
                leaveEarly = true;
                break;
            }
        }
        if (leaveEarly) {
            assert (LOG.trace("End of JCompilerMenuItems.menuWillShow"));
            return;
        }
        if (view instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)view;
            context = codeEditor.getContext();
        }
        Element element = elements.length >= 1 ? elements[0] : null;
        boolean isElementAProject = elements.length == 1 && element instanceof Project;
        boolean bl = isElementAWorkspace = elements.length == 1 && element instanceof Workspace;
        if (!isElementAWorkspace && (action = IdeAction.find((int)(isElementAProject ? JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID : JCompiler.MAKE_SELECTED_CMD_ID))) != null) {
            this.update(action, context);
            popup.add((Component)this.getMenuItem(popup, action), JDeveloperMenuConstants.SECTION_BUILD_CTXT_MENU);
        }
        if (!isElementAWorkspace && (action = IdeAction.find((int)(isElementAProject ? JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID : JCompiler.BUILD_SELECTED_CMD_ID))) != null && this.getCommand(element, false, false, false, null) != CompileDB) {
            this.update(action, context);
            popup.add((Component)this.getMenuItem(popup, action), JDeveloperMenuConstants.SECTION_BUILD_CTXT_MENU);
        }
        if (elements.length > 1) {
            boolean addCleanSelected = true;
            for (int x = 0; x < elements.length; ++x) {
                if (elements[x] instanceof Project) continue;
                addCleanSelected = false;
                break;
            }
            if (addCleanSelected && (action = IdeAction.find((int)this.getJCompiler().getCleanSelectedCmdId())) != null) {
                this.update(action, context);
                popup.add((Component)this.getMenuItem(popup, action), JDeveloperMenuConstants.SECTION_BUILD_CTXT_MENU);
            }
        }
        assert (LOG.trace("End of JCompilerMenuItems.menuWillShow"));
    }

    private JMenuItem getMenuItem(ContextMenu popup, IdeAction action) {
        JMenuItem menuItem;
        if (this.popupCachedMenuItems == null) {
            this.popupCachedMenuItems = new HashMap();
        }
        if ((menuItem = this.popupCachedMenuItems.get(action)) == null) {
            menuItem = popup.createMenuItem((ToggleAction)action, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
            this.popupCachedMenuItems.put(action, menuItem);
        }
        return menuItem;
    }

    private boolean setMenuItem(IdeAction action, boolean enabled, JMenuItem m) {
        action.setEnabled(enabled);
        if (m != null) {
            m.setEnabled(enabled);
            m.setVisible(true);
        }
        return true;
    }

    private boolean setWPActionAndMenuItem(Context context, Element node, JMenuItem menu, IdeAction action, boolean rebuild, boolean clean, boolean cleanAndRefresh) {
        String name = "";
        Element[] elements = this.getElementsFromContext(context, true);
        if (elements != null && elements.length > 1 && elements[0] != null && (node == null || elements[0].getClass() == node.getClass())) {
            if (this.inPopup(context)) {
                name = this.getCommand(elements[0], rebuild, clean, cleanAndRefresh, SelectedS);
            }
        } else if (node != null) {
            String label = this.inPopup(context) ? this.getWPMenuLabel(action, node, true) : (node instanceof Workspace || node instanceof Workspaces ? CompArb.getString(109) : this.getWPMenuLabel(action, node, false));
            name = this.getCommand(node, rebuild, clean, cleanAndRefresh, label);
        }
        if (name.length() > 0) {
            boolean isBusy = this.getJCompiler().isBusy(null);
            if (menu != null) {
                menu.setText(name);
                menu.setEnabled(!isBusy);
            }
            action.setEnabled(!isBusy);
            action.putValue("Name", (Object)name);
        } else {
            Object independentName = action.getValue("NoCtxName");
            name = independentName != null ? independentName.toString() : this.getCommand(null, rebuild, clean, cleanAndRefresh, null);
            action.putValue("Name", (Object)name);
            action.setEnabled(false);
        }
        return true;
    }

    private String getWPMenuLabel(IdeAction action, Element node, boolean inPopup) {
        String label = action.getCommandId() == JCompiler.MAKE_PROJECT_CMD_ID || action.getCommandId() == JCompiler.BUILD_PROJECT_CMD_ID ? CompArb.format(101, node.getShortLabel()) : (action.getCommandId() == JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID || action.getCommandId() == JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID ? CompArb.format(102, node.getShortLabel()) : (inPopup ? "" : node.getShortLabel()));
        return label;
    }

    private boolean setWSMenuItem(IdeAction action, boolean enabled, JMenuItem m, WorkingSet workingSet) {
        if (workingSet != null) {
            action.setEnabled(enabled);
            if (m != null) {
                m.setEnabled(enabled);
                m.setVisible(true);
                String name = workingSet.getName();
                if (name == null) {
                    name = "";
                }
                String prefix = JdevBuildExtensionManifest.format(action.getCommandId() == JCompiler.MAKE_WORKINGSET_CMD_ID ? "MAKE_WORKINGSET" : "REBUILD_WORKINGSET", name);
                m.setText(prefix);
            }
        } else if (Ide.getActiveWorkspace() != null) {
            action.setEnabled(enabled);
        } else {
            action.setEnabled(false);
        }
        return true;
    }

    static WorkingSet getWorkingSet(Workspace workspace) {
        if (workspace == null) {
            return null;
        }
        WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
        WorkingSet curWorkingSet = workingSets.getCurrentWorkingSet();
        if (curWorkingSet == null) {
            curWorkingSet = workingSets.getWorkingSet(WorkingSets.ALL_FILES_WORKING_SET_LABEL);
        }
        return curWorkingSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setMenuItem(Context context, JMenuItem menuItem, IdeAction action, boolean rebuild, boolean clean) {
        boolean allowMultipleSelections;
        Element element;
        Element[] elements;
        block15: {
            block16: {
                block14: {
                    String label;
                    boolean bl;
                    elements = this.getElementsFromContext(context, true);
                    element = null;
                    allowMultipleSelections = true;
                    try {
                        if (elements != null && elements.length != 0 && elements[0] != null) break block14;
                        action.setEnabled(false);
                        bl = true;
                        label = element == null ? null : (element instanceof Workspace || element instanceof Workspaces ? CompArb.getString(109) : element.getShortLabel());
                    }
                    catch (Throwable throwable) {
                        String label2 = element == null ? null : (element instanceof Workspace || element instanceof Workspaces ? CompArb.getString(109) : element.getShortLabel());
                        String target = elements != null && elements.length > 1 && allowMultipleSelections ? SelectedS : (this.inPopup(context) ? null : label2);
                        String command = this.getCommand(element, rebuild, clean, false, target);
                        if (menuItem != null) {
                            menuItem.setText(command);
                        }
                        action.putValue("Name", (Object)command);
                        throw throwable;
                    }
                    String target = elements != null && elements.length > 1 && allowMultipleSelections ? SelectedS : (this.inPopup(context) ? null : label);
                    String command = this.getCommand(element, rebuild, clean, false, target);
                    if (menuItem != null) {
                        menuItem.setText(command);
                    }
                    action.putValue("Name", (Object)command);
                    return bl;
                }
                element = elements[0];
                if (!clean) break block15;
                if (!(element instanceof Workspace) && !(element instanceof Workspaces)) break block16;
                action.setEnabled(true);
                boolean bl = true;
                String label = element == null ? null : (element instanceof Workspace || element instanceof Workspaces ? CompArb.getString(109) : element.getShortLabel());
                String target = elements != null && elements.length > 1 && allowMultipleSelections ? SelectedS : (this.inPopup(context) ? null : label);
                String command = this.getCommand(element, rebuild, clean, false, target);
                if (menuItem != null) {
                    menuItem.setText(command);
                }
                action.putValue("Name", (Object)command);
                return bl;
            }
            if (element instanceof Project) break block15;
            allowMultipleSelections = false;
            element = context.getProject();
            if (element == null) {
                element = Ide.getActiveProject();
            }
            if (element != null) break block15;
            action.setEnabled(false);
            boolean bl = true;
            String label = element == null ? null : (element instanceof Workspace || element instanceof Workspaces ? CompArb.getString(109) : element.getShortLabel());
            String target = elements != null && elements.length > 1 && allowMultipleSelections ? SelectedS : (this.inPopup(context) ? null : label);
            String command = this.getCommand(element, rebuild, clean, false, target);
            if (menuItem != null) {
                menuItem.setText(command);
            }
            action.putValue("Name", (Object)command);
            return bl;
        }
        if (menuItem != null) {
            menuItem.setVisible(true);
        }
        if ((element instanceof Locatable || element != null && element.mayHaveChildren()) && (!(element instanceof Node) || !AntNodeHook.isAntNode((Node)((Node)element))) && (JCompiler.isBuildable(element) || JCompiler.isCopyable(element, context.getProject())) || element instanceof Workspaces) {
            action.setEnabled(!this.getJCompiler().isBusy(null));
        } else {
            action.setEnabled(false);
        }
        String label = element == null ? null : (element instanceof Workspace || element instanceof Workspaces ? CompArb.getString(109) : element.getShortLabel());
        String target = elements != null && elements.length > 1 && allowMultipleSelections ? SelectedS : (this.inPopup(context) ? null : label);
        String command = this.getCommand(element, rebuild, clean, false, target);
        if (menuItem != null) {
            menuItem.setText(command);
        }
        action.putValue("Name", (Object)command);
        return true;
    }

    private String getCommand(Element elem, boolean rebuild, boolean clean, boolean cleanAndRefresh, String target) {
        if (elem instanceof Locatable && CmJavaUtil.isCMUrl((URL)((Locatable)elem).getURL())) {
            if (target == null) {
                return CompileDB;
            }
            return CompArb.format(114, target);
        }
        if (rebuild) {
            if (target == null) {
                return RebuildS;
            }
            return CompArb.format(115, target);
        }
        if (clean) {
            if (target == null) {
                return CleanS;
            }
            return CompArb.format(116, target);
        }
        if (cleanAndRefresh) {
            if (target == null) {
                return CleanRefreshS;
            }
            return CompArb.format(147, target);
        }
        if (target == null) {
            return CompileS;
        }
        return CompArb.format(113, target);
    }

    private boolean inPopup(Context context) {
        if (context.getNode() instanceof Workspace) {
            return false;
        }
        EventObject o = context.getEvent();
        return o == null || o instanceof MouseEvent;
    }

    private Element[] getElementsFromContext(Context context, boolean checkNode) {
        Element[] elements = context.getSelection();
        if (!(elements != null && elements.length != 0 && (elements[0] == null || JCompiler.isBuildable(elements[0])) || checkNode && context.getNode() == null)) {
            elements = new Element[]{context.getNode()};
        }
        return elements;
    }

    public void enableCancelBuild(final boolean enable) {
        if (Ide.getIdeArgs().getCreateUI()) {
            JCompilerUtils.invokeAsap(new Runnable(){

                @Override
                public void run() {
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompilerMenuItems.this.getJCompiler().getCancelBuildCmdId()), enable, JCompilerMenuItems.this.cancelBuild);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID), !enable, JCompilerMenuItems.this.makeProjectAndDependencies);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID), !enable, JCompilerMenuItems.this.buildProjectAndDependencies);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.MAKE_WORKINGSET_CMD_ID), !enable, JCompilerMenuItems.this.makeWorkingSet);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.BUILD_WORKINGSET_CMD_ID), !enable, JCompilerMenuItems.this.buildWorkingSet);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.CLEAN_PROJECT_CMD_ID), !enable, JCompilerMenuItems.this.cleanProject);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.CLEAN_WORKSPACE_CMD_ID), !enable, JCompilerMenuItems.this.cleanWorkspace);
                    JCompilerMenuItems.this.setMenuItem(IdeAction.find((int)JCompiler.CLEAN_AND_REFRESH_WORKSPACE_CMD_ID), !enable, JCompilerMenuItems.this.cleanAndRefreshWorkspace);
                }
            });
        }
    }
}

