/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.javacompiler.JavaDependencyProvider;

public class BuildSystemUtilities {
    public static boolean persistJavaAuditFlags(Project project, Map<File, Byte> flags) throws IOException {
        if (project == null || flags == null) {
            assert (project != null && flags != null) : "Need valid arguments in persistJavaAuditFlags";
            return false;
        }
        File cdiFile = BuildSystemUtilities.getCdiFile(project);
        if (cdiFile == null) {
            return false;
        }
        JavaDependencyProvider.persistAuditFlags((File)cdiFile, flags);
        return true;
    }

    public static Map<File, Byte> getJavaAuditFlags(Project project, Set<File> javaSourceFiles) throws IOException {
        if (project == null) {
            assert (project != null) : "Need a valid project in getJavaAuditFlags";
            return Collections.emptyMap();
        }
        File cdiFile = BuildSystemUtilities.getCdiFile(project);
        if (cdiFile == null) {
            return Collections.emptyMap();
        }
        return JavaDependencyProvider.getAuditFlags((File)cdiFile, javaSourceFiles);
    }

    public static File getCdiFile(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Need valid project in getCdiFile");
        }
        String ext = ".cdi";
        URL prjURL = project.getURL();
        URL cdiDir = JavaProject.getInstance((Project)project).getOutputDirectory();
        if (cdiDir != null) {
            cdiDir = URLFactory.newDirURL((URL)cdiDir, (String)".data");
        }
        if (cdiDir != null) {
            String outPathName = new File(cdiDir.getPath()).getPath();
            String prjPathName = URLFileSystem.getFileName((URL)prjURL);
            return new File(outPathName, BuildSystemUtilities.replaceExt(prjPathName, ".cdi"));
        }
        String prjPathName = URLFileSystem.getPlatformPathName((URL)prjURL);
        return new File(BuildSystemUtilities.replaceExt(prjPathName, ".cdi"));
    }

    private static String replaceExt(String name, String newExt) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            lastDot = name.length();
        }
        if (name.indexOf(File.separatorChar, lastDot) < 0) {
            name = name.substring(0, lastDot);
        }
        return name + newExt;
    }
}

