/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.compiler.TranslatorDefinition;

public final class BuildSystemHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension/jdev-build", "jdev-buildsystem-hook");
    private static HashStructureHook hashStructureHook;
    private static Set<String> _emittedErrors;
    private static Map<String, TranslatorDefinition> translators;
    private static Set<String> knownExtensions;
    private static int retrievedTranslatorCount;

    public static synchronized void addRegisteredTranslatorExtensions(Set<String> extensions) {
        knownExtensions.addAll(extensions);
    }

    private static synchronized void primeHook() {
        if (hashStructureHook == null) {
            hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
            if (hashStructureHook == null) {
                return;
            }
            hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    BuildSystemHook.getItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    BuildSystemHook.getItemsFromHook(e.getCombinedHashStructure());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static List<TranslatorDefinition> getNewTranslators(Set<String> extensions, Workspace workspace, Project project) {
        ArrayList<TranslatorDefinition> newTranslators = new ArrayList<TranslatorDefinition>();
        Class<BuildSystemHook> clazz = BuildSystemHook.class;
        // MONITORENTER : oracle.jdevimpl.compiler.BuildSystemHook.class
        BuildSystemHook.primeHook();
        knownExtensions.addAll(extensions);
        if (retrievedTranslatorCount == translators.size()) {
            // MONITOREXIT : clazz
            return newTranslators;
        }
        // MONITOREXIT : clazz
        ArrayList<TranslatorDefinition> foundTranslators = new ArrayList<TranslatorDefinition>();
        int i = 0;
        while (i < 10) {
            Class<BuildSystemHook> clazz2 = BuildSystemHook.class;
            // MONITORENTER : oracle.jdevimpl.compiler.BuildSystemHook.class
            int translatorsSize = translators.size();
            int knownExtensionsSize = knownExtensions.size();
            ArrayList<TranslatorDefinition> registeredTranslators = new ArrayList<TranslatorDefinition>(translators.values());
            // MONITOREXIT : clazz2
            BuildSystemHook.getNewTranslators(registeredTranslators, foundTranslators, workspace, project);
            for (TranslatorDefinition def : foundTranslators) {
                if (def.retrieveBuildTool() == null) continue;
                Class<BuildSystemHook> clazz3 = BuildSystemHook.class;
                // MONITORENTER : oracle.jdevimpl.compiler.BuildSystemHook.class
                knownExtensions.addAll(def.getOutputExtensions());
                newTranslators.add(def);
                ++retrievedTranslatorCount;
                // MONITOREXIT : clazz3
            }
            clazz2 = BuildSystemHook.class;
            // MONITORENTER : oracle.jdevimpl.compiler.BuildSystemHook.class
            if (translators.size() == translatorsSize && knownExtensionsSize == knownExtensions.size()) {
                // MONITOREXIT : clazz2
                return newTranslators;
            }
            // MONITOREXIT : clazz2
            foundTranslators.clear();
            ++i;
        }
        return newTranslators;
    }

    private static void getNewTranslators(Collection<TranslatorDefinition> translators, List<TranslatorDefinition> foundTranslators, Workspace workspace, Project project) {
        for (TranslatorDefinition translatorDefinition : translators) {
            if (translatorDefinition.hasBeenRetrievedFromHook() || !translatorDefinition.conditionsSatisfied(workspace, project) || !translatorDefinition.handlesAnyExtension(knownExtensions)) continue;
            foundTranslators.add(translatorDefinition);
        }
    }

    private static synchronized void getItemsFromHook(HashStructure hashStructure) {
        List translatorDefinitions;
        if (translators == null) {
            translators = new HashMap<String, TranslatorDefinition>();
        }
        if ((translatorDefinitions = hashStructure.getAsList("translator")) != null && translatorDefinitions.size() != 0) {
            for (Object definition : translatorDefinitions) {
                HashStructure hash = (HashStructure)definition;
                String className = hash.getString("class-name");
                String extensionId = HashStructureHook.getExtensionId((HashStructure)hash);
                if (className == null || className.trim().length() == 0) {
                    BuildSystemHook.logError("Missing class-name attribute in translator definition", extensionId);
                    continue;
                }
                String rule = hash.getString("rule");
                if (!BuildSystemHook.isMissingRule(rule, className, extensionId) && !BuildSystemHook.isValidRule(rule, className, extensionId)) continue;
                if (!translators.containsKey(className)) {
                    List inputExtensions = hash.getAsList("input-extension");
                    List outputExtensions = hash.getAsList("output-extension");
                    translators.put(className, new TranslatorDefinition(hash, inputExtensions, outputExtensions, extensionId));
                    continue;
                }
                BuildSystemHook.logDuplicateTranslatorError(className, extensionId);
            }
        }
    }

    private static boolean isMissingRule(String rule, String className, String extensionId) {
        if (rule == null || rule.trim().length() == 0) {
            BuildSystemHook.ruleError("Missing", className, extensionId);
            return true;
        }
        return false;
    }

    private static boolean isValidRule(String rule, String className, String extensionId) {
        RuleEngine engine = RuleEngine.getInstance();
        Rule engineRule = engine.getRule(rule);
        HashSet<String> acceptedRules = new HashSet<String>(2);
        acceptedRules.add("project-has-techscope");
        acceptedRules.add("always-enabled");
        acceptedRules.add("project-content-has-contents");
        if (engineRule == null || !engineRule.matchesType(acceptedRules)) {
            BuildSystemHook.ruleError("Invalid", className, extensionId);
            return false;
        }
        return true;
    }

    private static void ruleError(String prefix, String className, String extensionId) {
        BuildSystemHook.logError(prefix + " rule attribute in " + className + " registration", extensionId);
    }

    private static void logDuplicateTranslatorError(String className, String extensionId) {
        BuildSystemHook.logError("Duplicate translator registration for: " + className, extensionId);
    }

    static synchronized void logError(String msg, String extensionId) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        if (extensionId != null) {
            buf.append(" in extension ");
            buf.append(extensionId);
        }
        if (_emittedErrors == null) {
            _emittedErrors = new HashSet<String>();
        }
        if (!_emittedErrors.contains(buf.toString())) {
            _emittedErrors.add(buf.toString());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            if (extensionId != null) {
                Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
                ExtensionLogRecord record = new ExtensionLogRecord(Level.SEVERE, buf.toString(), ext, -1);
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
            }
        }
    }

    static {
        knownExtensions = new HashSet<String>();
    }
}

