/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeClipboard;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Assert;
import oracle.ide.util.BitField;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.controls.nicetable.DefaultNiceTableModel;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchField;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdevimpl.compiler.JCompilerUtils;

public class ProblemsPage
extends AbstractLogPage
implements ActiveViewListener,
Observer {
    private static int _shift = 0;
    public static int HIDE_NO_MENUS = 0;
    public static int HIDE_COPY_MENU = 1 << _shift++;
    public static int HIDE_SAVE_AS_MENU = 1 << _shift++;
    public static int HIDE_GOTO_SOURCE_MENU = 1 << _shift++;
    public static int HIDE_FIX_SOURCE_MENU = 1 << _shift++;
    public static int HIDE_ALL_MENUS = HIDE_COPY_MENU | HIDE_SAVE_AS_MENU | HIDE_GOTO_SOURCE_MENU | HIDE_FIX_SOURCE_MENU;
    protected static final int GOTO_SOURCE_CMD_ID = Ide.findOrCreateCmdID((String)"GOTO_SOURCE_CMD_ID");
    protected static final int FIX_SOURCE_CMD_ID = Ide.findOrCreateCmdID((String)"FIX_SOURCE_CMD_ID");
    private static URL _lastSaveToFileURL = null;
    protected KeyAdapter keyAdapter = new DefaultKeyAdapter();
    private Controller _controller;
    private JMenuItem _copyMenu;
    private JMenuItem _saveAsMenu;
    private JMenuItem _gotoSourceMenu;
    private JMenuItem _fixSourceMenu;
    private boolean _popupMenuItemsInitialized;
    private static int TYPE_COL = 0;
    private static int DESC_COL = 1;
    private static int FILE_COL = 2;
    private static int LINE_COL = 3;
    private static int PROJ_COL = 4;
    private static int DESC_FILTER_OPT = 0;
    private static int FILE_FILTER_OPT = 1;
    private static int DORF_FILTER_OPT = 2;
    private Vector colNames;
    private Vector tableContent;
    private static final String TYPE_COL_NAME = " ";
    private static final String DESC_COL_NAME = "Description";
    private static final String FILE_COL_NAME = "File";
    private static final String LINE_COL_NAME = "Line";
    private static final String PROJ_COL_NAME = "Project";
    private DefaultNiceTableModel model;
    private NiceTable table = new NiceTable(){
        private int ROW_HEIGHT = this.getRowHeight();

        public Class getColumnClass(int c) {
            if (c == TYPE_COL) {
                return Icon.class;
            }
            return Object.class;
        }

        public Object getValueAt(int r, int c) {
            int modelRowIndex = this.convertRowToModelIndex(r);
            int modelColIndex = this.convertColumnIndexToModel(c);
            if (modelRowIndex < ProblemsPage.this.model.getRowCount()) {
                Integer i;
                if (modelColIndex == TYPE_COL) {
                    IdeLog.Message msg = (IdeLog.Message)ProblemsPage.this.model.getValueAt(modelRowIndex, modelColIndex);
                    if (msg.isError()) {
                        return OracleIcons.getIcon((String)"error.png");
                    }
                    if (msg.isWarning()) {
                        return OracleIcons.getIcon((String)"warning.png");
                    }
                } else if (modelColIndex == LINE_COL && (i = (Integer)ProblemsPage.this.model.getValueAt(modelRowIndex, modelColIndex)) == Integer.MAX_VALUE) {
                    return "";
                }
            }
            return ProblemsPage.this.model.getValueAt(modelRowIndex, modelColIndex);
        }

        public void paint(Graphics g) {
            super.paint(g);
            this.paintEmptyRows(g);
        }

        private void paintEmptyRows(Graphics g) {
            if (ProblemsPage.this.model == null || ProblemsPage.this.model.getRowCount() == 0) {
                return;
            }
            int nRows = this.getRowCount();
            Rectangle clip = g.getClipBounds();
            if (ProblemsPage.this.model != null && nRows * this.ROW_HEIGHT < clip.height) {
                g.setColor(ProblemsPage.this.table.getGridColor());
                int nExtraRows = clip.height / this.ROW_HEIGHT;
                for (int i = nRows + 1; i <= nExtraRows; ++i) {
                    int y = i * this.ROW_HEIGHT;
                    g.drawLine(clip.x, y, clip.width, y);
                }
                int v0 = clip.x;
                int v1 = v0 + this.getColumnModel().getColumn(TYPE_COL).getWidth() - 1;
                int startY = nRows * this.ROW_HEIGHT;
                g.drawLine(v1, startY, v1, clip.height);
                int v2 = v1 + this.getColumnModel().getColumn(DESC_COL).getWidth();
                g.drawLine(v2, startY, v2, clip.height);
                int v3 = v2 + this.getColumnModel().getColumn(FILE_COL).getWidth();
                g.drawLine(v3, startY, v3, clip.height);
                int v4 = v3 + this.getColumnModel().getColumn(LINE_COL).getWidth();
                g.drawLine(v4, startY, v4, clip.height);
                int v5 = v4 + this.getColumnModel().getColumn(PROJ_COL).getWidth();
                g.drawLine(v5, startY, v5, clip.height);
                int viewSortColumn = this.convertColumnIndexToView(this.getSortColumn());
                g.setColor(ProblemsPage.this.table.getSortColumnBackgroundColor());
                if (viewSortColumn == 0) {
                    g.fillRect(v0, startY, v1 - v0, clip.height);
                } else if (viewSortColumn == 1) {
                    g.fillRect(v1 + 1, startY, v2 - v1, clip.height);
                } else if (viewSortColumn == 2) {
                    g.fillRect(v2 + 1, startY, v3 - v2, clip.height);
                } else if (viewSortColumn == 3) {
                    g.fillRect(v3 + 1, startY, v4 - v3, clip.height);
                } else if (viewSortColumn == 4) {
                    g.fillRect(v4 + 1, startY, clip.y - v4, clip.height);
                }
            }
        }

        public boolean getScrollableTracksViewportHeight() {
            if (this.getParent() instanceof JViewport) {
                return (double)((JViewport)this.getParent()).getHeight() > this.getPreferredSize().getHeight();
            }
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            if (this.getParent() instanceof JViewport) {
                return (double)((JViewport)this.getParent()).getWidth() > this.getPreferredSize().getWidth();
            }
            return false;
        }

        public String getToolTipText(MouseEvent e) {
            Point p = new Point(e.getX(), e.getY());
            int row = this.rowAtPoint(p);
            int col = this.columnAtPoint(p);
            if (row >= 0 && row < ProblemsPage.this.model.getRowCount() && col >= 0 && col < 5) {
                int modelRowIndex = ProblemsPage.this.table.convertRowToModelIndex(row);
                int modelColIndex = ProblemsPage.this.table.convertColumnIndexToModel(col);
                if (modelRowIndex >= 0 && modelRowIndex < this.getRowCount()) {
                    IdeLog.Message msg = (IdeLog.Message)ProblemsPage.this.model.getValueAt(modelRowIndex, TYPE_COL);
                    if (modelColIndex == DESC_COL) {
                        return msg.getMessage();
                    }
                    if (modelColIndex == FILE_COL && msg.fname != null) {
                        return msg.fname.getPath();
                    }
                    if (modelColIndex == PROJ_COL && msg.project != null) {
                        return msg.project.getLongLabel();
                    }
                }
            }
            return null;
        }
    };
    private boolean _isTableVisible = false;
    private JPanel logPage = new JPanel(new BorderLayout());
    private JPanel header = new JPanel(new BorderLayout());
    private JLabel compileInfo = new JLabel("");
    private Toolbar toolbar = new Toolbar();
    private JScrollPane scrollPane = new JScrollPane((Component)this.table);
    private int nErrors = 0;
    private int nWarnings = 0;
    private String currPattern = "";
    private int currFilterOpt = -1;
    private Vector hiddenRowData = new Vector();
    int ENTER_FILTER_CMD_ID = Ide.createCmdID((String)"enterAction");
    int APPLY_FILTER_CMD_ID = Ide.createCmdID((String)"filterAction");
    int WARN_FILTER_CMD_ID = Ide.createCmdID((String)"warnFilter");
    private IdeAction filterEnterKey = IdeAction.get((int)this.ENTER_FILTER_CMD_ID, null, (String)"Enter filter", (String)"Compiler", (Integer)new Integer(10), null, null, (boolean)true);
    private IdeAction warnFilter = IdeAction.get((int)this.WARN_FILTER_CMD_ID, null, (String)"Show/Hide warnings", (String)"Compiler", null, (Icon)OracleIcons.getIcon((String)"warning.png"), null, (boolean)true);
    private SearchField _searchField = new SearchField();
    private SearchCategory _descCat = new SearchCategory("Description");
    private SearchCategory _fileCat = new SearchCategory("File");
    private SearchCategory _dORfCat = new SearchCategory("Description or File");
    private HashMap urlMsgWrapperTable = new HashMap();
    private HashMap urlOffsetMarkTable = new HashMap();
    private HashMap msgMsgWrapperMap = new HashMap();
    private static final int MAX_ASYNC_MESSAGES = 100;
    private static final int ASYNC_THREAD_SLEEP = 1000;
    private ArrayList asyncMessages = new ArrayList(100);
    private Thread updateThread = null;

    public ProblemsPage() {
        this("CompilerPageId", CompArb.getString(40), null);
    }

    public ProblemsPage(String pageId, String pageName, Icon icon) {
        this(pageId, pageName, icon, HIDE_FIX_SOURCE_MENU);
    }

    public ProblemsPage(String pageId, String pageName, Icon icon, int menuOptions) {
        this(new ViewId(pageId, pageName), icon, false, menuOptions);
    }

    public ProblemsPage(ViewId id, Icon icon, boolean addPage, int menuOptions) {
        super(id, icon, false);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setViewportView((Component)this.table);
        ToggleToolButton hideOrShowWarnings = new ToggleToolButton((ToggleAction)this.warnFilter);
        this.table.addKeyListener((KeyListener)this.keyAdapter);
        this.table.addMouseListener((MouseListener)new TableContentAdapter());
        this.toolbar.add((Component)hideOrShowWarnings);
        this._searchField.setStyle(SearchField.Style.FILTER);
        this._searchField.addCategory(this._descCat);
        this._searchField.addCategory(this._fileCat);
        this._searchField.addCategory(this._dORfCat);
        Dimension preferredSize = this._searchField.getPreferredSize();
        this._searchField.setMaximumSize(new Dimension(200, preferredSize.height));
        JButton _button = ProblemsPage.getButton((Container)this._searchField);
        _button.setToolTipText("<html>Pattern rules:<br><table><tr><td>*</td><td>matches 0 or more</td></tr><tr><td>x y</td><td>agregates x and y</td></tr><tr><td>exp</td><td>regular expressions</td></tr></table></html>");
        JTextField _textField = ProblemsPage.getTextField((Container)this._searchField);
        _textField.setAction((Action)this.filterEnterKey);
        _textField.setColumns(20);
        this.toolbar.add((Component)this._searchField);
        this.toolbar.setBorder(BorderFactory.createEmptyBorder());
        this.header.add((Component)this.compileInfo, "West");
        this.header.add((Component)this.toolbar, "East");
        this.logPage.add((Component)this.header, "North");
        this.logPage.add((Component)this.scrollPane, "Center");
        this.initPopupMenuItems(menuOptions);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.table);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        if (addPage) {
            LogManager.getLogManager().addPage((LogPage)this);
        }
    }

    public ProblemsPage(ViewId id, Icon icon, boolean addPage) {
        this(id, icon, false, HIDE_FIX_SOURCE_MENU);
    }

    private void initPopupMenuItems(int options) {
        if (!this._popupMenuItemsInitialized) {
            this._popupMenuItemsInitialized = true;
            ContextMenu cm = LogManager.getLogManager().getContextMenu();
            IdeAction action = null;
            if (!BitField.isSet((int)options, (int)HIDE_COPY_MENU)) {
                action = IdeAction.find((int)18);
                this._copyMenu = cm.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_EDIT_COPY);
            }
            if (!BitField.isSet((int)options, (int)HIDE_SAVE_AS_MENU)) {
                action = IdeAction.find((int)12);
                this._saveAsMenu = cm.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
            }
            if (!BitField.isSet((int)options, (int)HIDE_GOTO_SOURCE_MENU)) {
                action = IdeAction.get((int)GOTO_SOURCE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)LogArb.getString((int)10)), (String)null, (Integer)StringUtils.getMnemonicKeyCode((String)LogArb.getString((int)10)), (Icon)LogArb.getIcon((int)12), null, (boolean)true);
                this._gotoSourceMenu = cm.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
                action.addController(this.getController());
            }
            if (!BitField.isSet((int)options, (int)HIDE_FIX_SOURCE_MENU)) {
                action = IdeAction.get((int)FIX_SOURCE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)LogArb.getString((int)20)), (String)null, (Integer)StringUtils.getMnemonicKeyCode((String)LogArb.getString((int)20)), (Icon)LogArb.getIcon((int)22), null, (boolean)true);
                this._fixSourceMenu = cm.createMenuItem((ToggleAction)action);
                action.addController(this.getController());
            }
            if (action != null) {
                cm.addContextMenuListener((ContextMenuListener)new PrivateContextMenuListener());
            }
        }
    }

    private void hideOrShowWarnings() {
        if (this.warnFilter.getState()) {
            int i = 0;
            while (i < this.model.getRowCount()) {
                IdeLog.Message msg = (IdeLog.Message)this.model.getValueAt(i, 0);
                if (msg.isWarning()) {
                    this.hiddenRowData.add(((Vector)this.model.getDataVector().get(i)).clone());
                    this.model.removeRow(i);
                    continue;
                }
                ++i;
            }
        } else if (this.currFilterOpt == DORF_FILTER_OPT) {
            this.restoreMessages(new int[]{DESC_COL, FILE_COL});
        } else {
            this.restoreMessages();
        }
        this.table.reSort();
    }

    public void update(final Object subject, UpdateMessage change) {
        int msgID = change.getMessageID();
        if (msgID == UpdateMessage.OBJECT_RELOADED) {
            if (subject instanceof TextNode) {
                Vector messages;
                URL url = ((TextNode)subject).getURL();
                OffsetMark[] om = (OffsetMark[])this.urlOffsetMarkTable.get(url);
                if (om != null) {
                    this.clearUrlOffsetMarkNode((Node)subject, om);
                }
                if ((messages = (Vector)this.urlMsgWrapperTable.get(url)) != null) {
                    this.setOffsetMarkTable(url, messages);
                }
            }
            return;
        }
        if (msgID == UpdateMessage.OBJECT_CLOSED) {
            if (subject instanceof Project) {
                ((Project)subject).detach((Observer)this);
                JCompilerUtils.invokeAsap(new Runnable(){

                    @Override
                    public void run() {
                        IdeLog.Message msg = new IdeLog.Message(null, (Project)subject, null, null, 0, 0, 0, 3);
                        ProblemsPage.this.addMsg(msg);
                        msg = new IdeLog.Message(null, null, null, null, 0, 0, 0, 4);
                        ProblemsPage.this.addMsg(msg);
                    }
                });
                return;
            }
            if (subject instanceof TextNode) {
                Vector messages;
                URL url = ((TextNode)subject).getURL();
                OffsetMark[] om = (OffsetMark[])this.urlOffsetMarkTable.remove(url);
                if (om != null) {
                    this.clearUrlOffsetMarkNode((Node)subject, om);
                }
                if ((messages = (Vector)this.urlMsgWrapperTable.get(url)) != null) {
                    for (int i = 0; i < messages.size(); ++i) {
                        MsgWrapper msgWrapper = (MsgWrapper)messages.get(i);
                        msgWrapper.offsetMark = null;
                    }
                }
                return;
            }
        }
    }

    private static JTextField getTextField(Container parent) {
        if (parent instanceof JTextField) {
            JTextField jTextField = (JTextField)parent;
            return jTextField;
        }
        Component[] children = parent.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Container container;
            JTextField textField;
            Component child = children[i];
            if (!(child instanceof Container) || (textField = ProblemsPage.getTextField(container = (Container)child)) == null) continue;
            return textField;
        }
        return null;
    }

    private static JButton getButton(Container parent) {
        if (parent instanceof JButton) {
            JButton jButton = (JButton)parent;
            return jButton;
        }
        Component[] children = parent.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (!(child instanceof Container)) continue;
            return ProblemsPage.getButton((Container)child);
        }
        return null;
    }

    private boolean localPatternMatcher(String currPattern, String string) {
        StringBuffer sbuffer = new StringBuffer(".*");
        int n = currPattern.length();
        for (int i = 0; i < n; ++i) {
            if (currPattern.charAt(i) == ' ' || currPattern.charAt(i) == '*') {
                sbuffer.append(".*");
                continue;
            }
            sbuffer.append(currPattern.charAt(i));
        }
        sbuffer.append(".*");
        return Pattern.matches(sbuffer.toString(), string);
    }

    private void filterMessages(int col) {
        this.restoreMessages();
        int row = 0;
        while (row < this.model.getRowCount()) {
            String string = (String)this.model.getValueAt(row, col);
            if (!this.localPatternMatcher(this.currPattern, string) && !Pattern.matches(this.currPattern, string)) {
                this.hiddenRowData.add(((Vector)this.model.getDataVector().get(row)).clone());
                this.model.removeRow(row);
                continue;
            }
            ++row;
        }
        this.table.reSort();
    }

    private void filterMessages(int[] cols) {
        if (cols.length == 0) {
            return;
        }
        this.restoreMessages(cols);
        int row = 0;
        while (row < this.model.getRowCount()) {
            String string;
            int i;
            for (i = 0; i < cols.length && !this.localPatternMatcher(this.currPattern, string = (String)this.model.getValueAt(row, cols[i])) && !Pattern.matches(this.currPattern, string); ++i) {
            }
            if (i == cols.length) {
                this.hiddenRowData.add(((Vector)this.model.getDataVector().get(row)).clone());
                this.model.removeRow(row);
                continue;
            }
            ++row;
        }
        this.table.reSort();
    }

    private void restoreMessages() {
        if (this.currPattern.equals("")) {
            if (!this.warnFilter.getState()) {
                for (int i = 0; i < this.hiddenRowData.size(); ++i) {
                    this.model.addRow((Vector)((Vector)this.hiddenRowData.get(i)).clone());
                }
                this.hiddenRowData.clear();
            } else {
                int i = 0;
                while (i < this.hiddenRowData.size()) {
                    Vector rowData = (Vector)this.hiddenRowData.get(i);
                    if (((IdeLog.Message)rowData.get(0)).isError()) {
                        this.model.addRow((Vector)rowData.clone());
                        this.hiddenRowData.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < this.hiddenRowData.size()) {
                Vector rowData = (Vector)this.hiddenRowData.get(i);
                String string = null;
                if (this.currFilterOpt == DESC_FILTER_OPT) {
                    string = (String)rowData.get(DESC_COL);
                } else if (this.currFilterOpt == FILE_FILTER_OPT) {
                    string = (String)rowData.get(FILE_COL);
                }
                assert (string != null);
                if (this.localPatternMatcher(this.currPattern, string) || Pattern.matches(this.currPattern, string)) {
                    if (this.warnFilter.getState() && !((IdeLog.Message)rowData.get(0)).isError()) continue;
                    this.model.addRow((Vector)rowData.clone());
                    this.hiddenRowData.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    private void restoreMessages(int[] cols) {
        if (this.currPattern.equals("")) {
            if (!this.warnFilter.getState()) {
                for (int i = 0; i < this.hiddenRowData.size(); ++i) {
                    this.model.addRow((Vector)((Vector)this.hiddenRowData.get(i)).clone());
                }
                this.hiddenRowData.clear();
            } else {
                int i = 0;
                while (i < this.hiddenRowData.size()) {
                    Vector rowData = (Vector)this.hiddenRowData.get(i);
                    if (((IdeLog.Message)rowData.get(0)).isError()) {
                        this.model.addRow((Vector)rowData.clone());
                        this.hiddenRowData.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < this.hiddenRowData.size()) {
                int j;
                Vector rowData = (Vector)this.hiddenRowData.get(i);
                for (j = 0; j < cols.length && !this.localPatternMatcher(this.currPattern, (String)rowData.get(cols[j])) && !Pattern.matches(this.currPattern, (String)rowData.get(cols[j])); ++j) {
                }
                if (j < cols.length) {
                    if (this.warnFilter.getState() && !((IdeLog.Message)rowData.get(0)).isError()) continue;
                    this.model.addRow((Vector)rowData.clone());
                    this.hiddenRowData.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    public String getTitleName() {
        String s = super.getTitleName();
        AccessibleUtils.updateAccessibleName((Accessible)this.table, (String)s, (boolean)true);
        return s;
    }

    public Component getGUI() {
        return this.logPage;
    }

    private final void copy(Object msg) {
        StringSelection text = new StringSelection(((IdeLog.Message)msg).getMessage());
        IdeClipboard.getClipboard().setContents(text, null);
    }

    protected void saveToFile(Context context) {
        URL url;
        if (this.model == null || this.table.getRowCount() <= 0) {
            return;
        }
        String title = LogArb.getString((int)13);
        URLChooser chooser = DialogUtil.newURLChooser((Context)context);
        chooser.setHelpID("f1_idedsaveasrename_html");
        if (_lastSaveToFileURL != null) {
            chooser.setSelectedURL(_lastSaveToFileURL);
        }
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), title) == 0 && (url = chooser.getSelectedURL()) != null) {
            _lastSaveToFileURL = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                String encoding = Ide.getEnvironOptions().getEncoding();
                OutputStream os = URLFileSystem.openOutputStream((URL)url);
                PrintStream ps = encoding == null ? new PrintStream(os) : new PrintStream(os, false, encoding);
                for (int row = 0; row < this.model.getRowCount(); ++row) {
                    IdeLog.Message msg = (IdeLog.Message)this.model.getValueAt(row, TYPE_COL);
                    ps.println(msg.toString());
                }
                ps.flush();
                ps.close();
            }
            catch (Exception e) {
                String fileName = URLFileSystem.getPlatformPathName((URL)url);
                String msg = LogArb.format((int)29, (Object)fileName);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), msg, IdeArb.getString((int)240), 0);
            }
            wc.hide();
        }
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new DefaultLogPageController();
        }
        return this._controller;
    }

    public ContextMenu getContextMenu() {
        ContextMenu cm = LogManager.getLogManager().getContextMenu();
        return cm;
    }

    public void clearAll() {
        if (this.model == null) {
            return;
        }
        this.nWarnings = 0;
        this.nErrors = 0;
        this.compileInfo.setText("");
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        this.hiddenRowData.clear();
        this.table.repaint();
    }

    public void addMouseListener(MouseListener listener) {
        if (listener != null) {
            this.table.addMouseListener(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        if (listener != null) {
            this.table.removeMouseListener(listener);
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (listener != null) {
            this.table.addKeyListener(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        if (listener != null) {
            this.table.removeKeyListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logMsg(Object msg) {
        if (msg instanceof IdeLog.Message) {
            ArrayList arrayList = this.asyncMessages;
            synchronized (arrayList) {
                this.asyncMessages.add(msg);
                if (this.asyncMessages.size() == 100) {
                    this.processAsyncMsgQueue(100);
                }
            }
        }
    }

    public void startAsynchronousLogging() {
        this.updateThread = new Thread("Log Page Updater"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (ProblemsPage.this.updateThread == this) {
                    try {
                        Thread.sleep(1000L);
                        ArrayList arrayList = ProblemsPage.this.asyncMessages;
                        synchronized (arrayList) {
                            if (ProblemsPage.this.asyncMessages.size() > 0) {
                                ProblemsPage.this.processAsyncMsgQueue(100);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        this.updateThread.setPriority(this.updateThread.getPriority() - 1);
        this.updateThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAsynchronousLogging() {
        this.updateThread = null;
        ArrayList arrayList = this.asyncMessages;
        synchronized (arrayList) {
            this.asyncMessages.clear();
        }
    }

    public void finishAsynchronousLogging() {
        this.updateThread = null;
        this.processAsyncMsgQueue(-1);
        this.requestShow();
    }

    private void processAsyncMsgQueue(final int max) {
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList arrayList = ProblemsPage.this.asyncMessages;
                synchronized (arrayList) {
                    int size = ProblemsPage.this.asyncMessages.size();
                    int num = max > 0 && size > max ? max : size;
                    for (int i = 0; i < num; ++i) {
                        ProblemsPage.this.addMsg((IdeLog.Message)ProblemsPage.this.asyncMessages.remove(0));
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    private void addMsg(IdeLog.Message msg) {
        if (this.getCurrentView() != this.table) {
            this.setCurrentView((Component)this.table);
        }
        if (msg.isStarting()) {
            this.colNames = new Vector();
            this.colNames.add(TYPE_COL_NAME);
            this.colNames.add(DESC_COL_NAME);
            this.colNames.add(FILE_COL_NAME);
            this.colNames.add(LINE_COL_NAME);
            this.colNames.add(PROJ_COL_NAME);
            this.tableContent = new Vector();
            return;
        }
        if (msg.isCompleted()) {
            String errString = this.nErrors + (this.nErrors == 1 ? " error" : " errors");
            String warnString = this.nWarnings + (this.nWarnings == 1 ? " warning" : " warnings");
            this.compileInfo.setText(TYPE_COL_NAME + errString + ", " + warnString);
            this.table.repaint();
            return;
        }
        if (msg.isRemove()) {
            this.removeMessages(msg);
            return;
        }
        if (!LogManager.getLogManager().isLogVisible()) {
            LogManager.getLogManager().showLog();
        }
        if (!this.isVisible()) {
            this.requestShow();
        }
        if (Ide.getMainWindow().getLastActiveView() == LogManager.getLogManager().getLogWindow()) {
            IdeUtil.tryToRestoreFocus((Component)this.table);
        } else {
            this.requestShow();
        }
        if (msg.isNoDetails()) {
            return;
        }
        Vector<Object> rowData = new Vector<Object>(5);
        rowData.add(msg);
        rowData.add(this.justContent(msg));
        if (msg.fname == null) {
            rowData.add("");
            rowData.add(new Integer(Integer.MAX_VALUE));
            rowData.add("");
        } else {
            rowData.add(msg.fname.getName());
            rowData.add(new Integer(msg.line));
            rowData.add(msg.getProject().toString());
        }
        if (msg.isError()) {
            ++this.nErrors;
        } else {
            ++this.nWarnings;
        }
        if (this.canAddToModel(msg)) {
            if (!this._isTableVisible) {
                this.tableContent.add(rowData);
                this.model = new DefaultNiceTableModel(this.tableContent, this.colNames){
                    Comparator<IdeLog.Message> msgComparator;
                    Comparator<Integer> intComparator;
                    {
                        this.msgComparator = new Comparator<IdeLog.Message>(){

                            @Override
                            public int compare(IdeLog.Message m1, IdeLog.Message m2) {
                                if (m1.isError() && m2.isWarning()) {
                                    return -1;
                                }
                                if (m1.isWarning() && m2.isError()) {
                                    return 1;
                                }
                                return 0;
                            }
                        };
                        this.intComparator = new Comparator<Integer>(){

                            @Override
                            public int compare(Integer i1, Integer i2) {
                                return i1 - i2;
                            }
                        };
                    }

                    public Comparator getColumnSortComparator(int col) {
                        if (col == TYPE_COL) {
                            return this.msgComparator;
                        }
                        if (col == LINE_COL) {
                            return this.intComparator;
                        }
                        return String.CASE_INSENSITIVE_ORDER;
                    }
                };
                this.table.setModel((TableModel)this.model);
                this.table.setSortColumn(FILE_COL, true);
                this.setCurrentView((Component)this.table);
                this.table.getColumnModel().getColumn(TYPE_COL).setMaxWidth(20);
                this.table.getColumnModel().getColumn(DESC_COL).setPreferredWidth(525);
                this.table.getColumnModel().getColumn(FILE_COL).setPreferredWidth(100);
                this.table.getColumnModel().getColumn(LINE_COL).setPreferredWidth(50);
                this.table.getColumnModel().getColumn(PROJ_COL).setPreferredWidth(75);
                this.table.setShowGrid(true);
                this.table.repaint();
                this._isTableVisible = true;
            } else {
                this.model.addRow(rowData);
                this.table.reSort();
                this.model.fireTableDataChanged();
                this.table.repaint();
                String errString = this.nErrors + (this.nErrors == 1 ? " error" : " errors");
                String warnString = this.nWarnings + (this.nWarnings == 1 ? " warning" : " warnings");
                this.compileInfo.setText(TYPE_COL_NAME + errString + ", " + warnString);
            }
        } else {
            this.hiddenRowData.add(rowData);
        }
        if (msg.fname != null) {
            URL url = URLFactory.newURL((String)msg.fname.getPath());
            MsgWrapper msgWrapper = new MsgWrapper(this.fixMessages(msg), msg);
            this.msgMsgWrapperMap.put(msg, msgWrapper);
            Vector messages = (Vector)this.urlMsgWrapperTable.get(url);
            if (messages == null) {
                Vector<MsgWrapper> value = new Vector<MsgWrapper>();
                value.add(msgWrapper);
                this.urlMsgWrapperTable.put(url, value);
            } else {
                messages.add(msgWrapper);
            }
        }
    }

    private boolean canAddToModel(IdeLog.Message msg) {
        if (this.warnFilter.getState() && msg.isWarning()) {
            return false;
        }
        if (this.currFilterOpt == -1 || this.currPattern.equals("")) {
            return true;
        }
        if (this.currFilterOpt == DESC_FILTER_OPT) {
            return this.localPatternMatcher(this.currPattern, msg.getMessage()) || Pattern.matches(this.currPattern, msg.getMessage());
        }
        if (this.currFilterOpt == FILE_FILTER_OPT) {
            return this.localPatternMatcher(this.currPattern, msg.fname.getName()) || Pattern.matches(this.currPattern, msg.fname.getName());
        }
        if (this.currFilterOpt == DORF_FILTER_OPT) {
            return this.localPatternMatcher(this.currPattern, msg.getMessage()) || Pattern.matches(this.currPattern, msg.getMessage()) || this.localPatternMatcher(this.currPattern, msg.fname.getName()) || Pattern.matches(this.currPattern, msg.fname.getName());
        }
        return true;
    }

    private void removeMessages(IdeLog.Message msg) {
        if (msg.project == null) {
            return;
        }
        if (msg.fname == null) {
            String projPath = msg.project.toString();
            int i = 0;
            while (this.model != null && i < this.model.getRowCount()) {
                IdeLog.Message i_msg = (IdeLog.Message)this.model.getValueAt(i, TYPE_COL);
                if (i_msg.fname == null || i_msg.project == null || projPath.equals(i_msg.project.toString())) {
                    this.model.removeRow(i);
                    if (i_msg.isError()) {
                        --this.nErrors;
                    } else if (i_msg.isWarning()) {
                        --this.nWarnings;
                    }
                    this.table.repaint();
                    String errString = this.nErrors + (this.nErrors == 1 ? " error" : " errors");
                    String warnString = this.nWarnings + (this.nWarnings == 1 ? " warning" : " warnings");
                    this.compileInfo.setText(TYPE_COL_NAME + errString + ", " + warnString);
                    continue;
                }
                ++i;
            }
        } else {
            String filePath = msg.fname.toString();
            int i = 0;
            while (this.model != null && i < this.model.getRowCount()) {
                IdeLog.Message i_msg = (IdeLog.Message)this.model.getValueAt(i, TYPE_COL);
                if (i_msg.fname == null || i_msg.project == null || filePath.equals(i_msg.fname.toString())) {
                    this.model.removeRow(i);
                    if (i_msg.isError()) {
                        --this.nErrors;
                    } else if (i_msg.isWarning()) {
                        --this.nWarnings;
                    }
                    this.table.repaint();
                    String errString = this.nErrors + (this.nErrors == 1 ? " error" : " errors");
                    String warnString = this.nWarnings + (this.nWarnings == 1 ? " warning" : " warnings");
                    this.compileInfo.setText(TYPE_COL_NAME + errString + ", " + warnString);
                    continue;
                }
                ++i;
            }
        }
    }

    private Editor getEditorFromMessageNode(IdeLog.Message msg) {
        File file;
        Editor result = null;
        Project lastActiveProject = Ide.getActiveProject();
        Project nodeProject = msg.getProject();
        if (nodeProject != null) {
            Ide.setActiveProject((Project)nodeProject);
        }
        Workspace lastActiveWsp = Ide.getActiveWorkspace();
        Workspace nodeWsp = msg.getWorkspace();
        if (nodeWsp != null) {
            Ide.setActiveWorkspace((Workspace)nodeWsp);
        }
        if ((file = new File(msg.fname.getPath())).exists()) {
            result = this.openPreferredEditor(URLFactory.newFileURL((File)file), msg.workspace, msg.project);
        }
        Ide.setActiveProject((Project)lastActiveProject);
        Ide.setActiveWorkspace((Workspace)lastActiveWsp);
        return result;
    }

    private Editor openPreferredEditor(Context context) {
        EditorManager editorManager = EditorManager.getEditorManager();
        try {
            Editor editor = editorManager.openEditorInFrame(CodeEditor.class, context);
            if (editor != null) {
                return editor;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return editorManager.openDefaultEditorInFrame(context);
    }

    private Editor openPreferredEditor(URL url, Workspace wsp, Project prj) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            Context context = Context.newIdeContext((Node)node);
            context.setWorkspace(wsp);
            context.setProject(prj);
            return this.openPreferredEditor(context);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
            Assert.println((String)("oracle.jdeveloper.compiler.CompilePage.openURLInCodeEditor() - " + e.toString()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void activateObject(Object obj, int modelRowIndex) {
        msg = (IdeLog.Message)obj;
        if (msg.fname == null) {
            return;
        }
        point = null;
        editor = this.getEditorFromMessageNode(msg);
        if (editor instanceof CodeEditor) {
            ceditor = (CodeEditor)editor;
            line = msg.line;
            col = msg.col;
            msgWrapper = (MsgWrapper)this.msgMsgWrapperMap.get(msg);
            if (msgWrapper.offsetMark == null) {
                this.activeViewChanged(null);
            }
            if (msgWrapper.offsetMark != null && msgWrapper.getURL() != null) {
                tnode = (TextNode)NodeFactory.find((URL)msgWrapper.getURL());
                try {
                    tbuf = tnode.acquireTextBuffer();
                    lmap = tbuf.getLineMap();
                    line = lmap.getLineFromOffset(msgWrapper.offsetMark.getOffset()) + 1;
                    if (col <= 0) ** GOTO lbl34
                    --col;
                }
                catch (Throwable var11_14) {
                }
                finally {
                    tnode.releaseTextBuffer();
                }
            } else if (line == 0 && col > 0) {
                line = ceditor.getLineFromOffset(col) + 1;
                lineStartOffset = ceditor.getLineStartOffset(line - 1);
                col = lineStartOffset < col ? col - lineStartOffset : 1;
            } else if (col > 0) {
                --col;
            }
lbl34:
            // 7 sources

            ceditor.gotoLine(line, col, false);
            this.model.setValueAt((Object)new Integer(line), modelRowIndex, ProblemsPage.LINE_COL);
            Ide.getStatusBar().setText(msg.msg);
            point = new CodeNavigationPoint();
        } else if (editor != null) {
            point = new DefaultNavigationPoint();
        }
        if (point != null && (mgr = NavigationManager.getNavigationManager()) != null) {
            point.setContext(editor.getContext());
            try {
                mgr.navigateTo((NavigationPoint)point);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected String fixMessages(IdeLog.Message m) {
        String msg = m.msg;
        msg = msg.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        return msg;
    }

    private String justContent(IdeLog.Message msg) {
        int start = msg.getMessage().indexOf(58) + 2;
        return msg.getMessage().substring(start);
    }

    protected final Component getCurrentView() {
        JViewport viewport = this.scrollPane.getViewport();
        return viewport != null ? viewport.getView() : null;
    }

    protected final void setCurrentView(Component view) {
        this.scrollPane.setViewportView(view);
    }

    protected void fixObject(Object obj) {
    }

    public void activeViewChanged(ActiveViewEvent e) {
        View editor;
        View view = editor = e != null ? e.getNewView() : Ide.getMainWindow().getLastActiveView();
        if (editor == null || !(editor instanceof CodeEditor)) {
            return;
        }
        Context ctxt = ((CodeEditor)editor).getContext();
        if (ctxt == null || ctxt.getNode() == null || ctxt.getNode().getURL() == null) {
            return;
        }
        URL url = ctxt.getNode().getURL();
        Vector messages = (Vector)this.urlMsgWrapperTable.get(url);
        if (messages != null && this.urlOffsetMarkTable.get(url) == null) {
            this.setOffsetMarkTable(url, messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOffsetMarkTable(URL url, Vector messages) {
        Node node = NodeFactory.find((URL)url);
        if (node instanceof TextNode) {
            TextNode tnode = (TextNode)node;
            try {
                TextBuffer tbuf = tnode.acquireTextBuffer();
                LineMap lmap = tbuf.getLineMap();
                OffsetMark[] offsetMarks = new OffsetMark[messages.size()];
                for (int i = 0; i < messages.size(); ++i) {
                    MsgWrapper msgWrapper = (MsgWrapper)messages.get(i);
                    IdeLog.Message msg = msgWrapper.getMessage();
                    int offset = msg.line == 0 && msg.col > 0 ? msg.col : lmap.getLineStartOffset(msg.line - 1);
                    msgWrapper.setURL(url);
                    offsetMarks[i] = msgWrapper.offsetMark = tbuf.addOffsetMark(offset);
                }
                tnode.attach((Observer)this);
                this.urlOffsetMarkTable.put(url, offsetMarks);
            }
            catch (Throwable throwable) {
            }
            finally {
                tnode.releaseTextBuffer();
            }
        }
    }

    protected void clearUrlOffsetMarkNode(Node node, OffsetMark[] offsetMarks) {
        if (node instanceof TextNode) {
            TextBuffer tbuf;
            TextNode tnode = (TextNode)node;
            if (tnode != null && tnode.isOpen() && (tbuf = tnode.acquireTextBuffer()) != null) {
                for (int j = 0; j < offsetMarks.length; ++j) {
                    tbuf.removeOffsetMark(offsetMarks[j]);
                }
            }
            tnode.detach((Observer)this);
        }
    }

    private class PrivateContextMenuListener
    implements ContextMenuListener {
        private PrivateContextMenuListener() {
        }

        public void menuWillShow(ContextMenu popup) {
            if (popup == null) {
                return;
            }
            Context ctxt = popup.getContext();
            if (ctxt == null || ctxt.getView() != ProblemsPage.this) {
                return;
            }
            if (ProblemsPage.this._gotoSourceMenu != null) {
                popup.add((Component)ProblemsPage.this._gotoSourceMenu, MenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            }
            if (ProblemsPage.this._fixSourceMenu != null) {
                popup.add((Component)ProblemsPage.this._fixSourceMenu, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
            if (ProblemsPage.this._copyMenu != null) {
                popup.add((Component)ProblemsPage.this._copyMenu, MenuConstants.SECTION_EDIT_CTXT_MENU);
            }
            if (ProblemsPage.this._saveAsMenu != null) {
                popup.add((Component)ProblemsPage.this._saveAsMenu, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    protected static final class MsgWrapper {
        private Object nodeData;
        private IdeLog.Message msg;
        private URL url;
        private Icon icon;
        int viewId;
        OffsetMark offsetMark;

        MsgWrapper(Object nodeData, IdeLog.Message msg) {
            this.nodeData = nodeData;
            this.msg = msg;
            this.url = null;
            this.offsetMark = null;
        }

        public Object getNodeData() {
            return this.nodeData;
        }

        public IdeLog.Message getMessage() {
            return this.msg;
        }

        public Project getProject() {
            return this.msg != null ? this.msg.project : null;
        }

        public Workspace getWorkspace() {
            return this.msg != null ? this.msg.workspace : null;
        }

        public boolean invokeFixEvent() {
            if (this.msg != null && this.msg.fixEvent != null) {
                this.msg.fixEvent.fix(this.msg);
                return true;
            }
            return false;
        }

        public boolean canInvokeFixEvent() {
            if (this.msg != null && this.msg.fixEvent != null) {
                return this.msg.fixEvent.canFix(this.msg);
            }
            return false;
        }

        public boolean invokeActivateEvent() {
            if (this.msg != null && this.msg.activateEvent != null) {
                this.msg.activateEvent.activate(this.msg);
                return true;
            }
            return false;
        }

        public String toString() {
            return this.nodeData.toString();
        }

        public URL getURL() {
            return this.url;
        }

        public void setURL(URL value) {
            this.url = value;
            Node node = NodeFactory.find((URL)this.url);
            boolean uncache = false;
            if (node == null) {
                try {
                    node = NodeFactory.findOrCreate((URL)value);
                    uncache = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (node != null) {
                this.icon = node.getIcon();
            }
            if (uncache) {
                NodeFactory.uncache((URL)this.url);
            }
        }

        public Icon getIcon() {
            return this.icon;
        }
    }

    private final class DefaultKeyAdapter
    extends KeyAdapter {
        private DefaultKeyAdapter() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e == null || e.isConsumed() || e.getKeyChar() != '\n') {
                return;
            }
            int row = ProblemsPage.this.table.getSelectedRow();
            if (row >= 0) {
                int modelRowIndex = ProblemsPage.this.table.convertRowToModelIndex(row);
                ProblemsPage.this.activateObject(ProblemsPage.this.model.getValueAt(modelRowIndex, TYPE_COL), modelRowIndex);
            }
        }
    }

    private final class TableContentAdapter
    extends MouseAdapter {
        private TableContentAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point point = new Point(e.getX(), e.getY());
                int row = ProblemsPage.this.table.rowAtPoint(point);
                if (row >= 0) {
                    int modelRowIndex = ProblemsPage.this.table.convertRowToModelIndex(row);
                    ProblemsPage.this.activateObject(ProblemsPage.this.model.getValueAt(modelRowIndex, TYPE_COL), modelRowIndex);
                }
            }
        }
    }

    private class DefaultLogPageController
    implements Controller {
        private DefaultLogPageController() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (action != null) {
                int cmdId = action.getCommandId();
                if (cmdId == 30 || cmdId == 31) {
                    int row = ProblemsPage.this.table.getSelectedRow();
                    if (row >= 0) {
                        int modelRowIndex = ProblemsPage.this.table.convertRowToModelIndex(row);
                        Object obj = ProblemsPage.this.model.getValueAt(modelRowIndex, TYPE_COL);
                        ProblemsPage.this.activateObject(obj, modelRowIndex);
                    }
                    return true;
                }
                if (cmdId == 18 || cmdId == GOTO_SOURCE_CMD_ID || cmdId == FIX_SOURCE_CMD_ID) {
                    int row = ProblemsPage.this.table.getSelectedRow();
                    if (row >= 0) {
                        int modelRowIndex = ProblemsPage.this.table.convertRowToModelIndex(row);
                        Object p = ProblemsPage.this.model.getValueAt(modelRowIndex, TYPE_COL);
                        if (p != null) {
                            if (cmdId == GOTO_SOURCE_CMD_ID) {
                                ProblemsPage.this.activateObject(p, modelRowIndex);
                            } else if (cmdId == FIX_SOURCE_CMD_ID) {
                                ProblemsPage.this.fixObject(p);
                            } else {
                                ProblemsPage.this.copy(p);
                            }
                        }
                    }
                    return true;
                }
                if (cmdId == 12) {
                    ProblemsPage.this.saveToFile(context);
                    return true;
                }
                if (cmdId == ProblemsPage.this.WARN_FILTER_CMD_ID) {
                    ProblemsPage.this.hideOrShowWarnings();
                    return true;
                }
                if (cmdId == ProblemsPage.this.ENTER_FILTER_CMD_ID) {
                    SearchCategory selectedCat = ProblemsPage.this._searchField.getSelectedCategory();
                    ProblemsPage.this.currPattern = ProblemsPage.this._searchField.getText().trim();
                    if (ProblemsPage.this.currPattern.equals("")) {
                        if (selectedCat.equals(ProblemsPage.this._dORfCat)) {
                            ProblemsPage.this.restoreMessages(new int[]{DESC_COL, FILE_COL});
                        } else {
                            ProblemsPage.this.restoreMessages();
                        }
                        ProblemsPage.this.table.reSort();
                    } else if (selectedCat.equals(ProblemsPage.this._descCat)) {
                        ProblemsPage.this.currFilterOpt = DESC_FILTER_OPT;
                        ProblemsPage.this.filterMessages(DESC_COL);
                    } else if (selectedCat.equals(ProblemsPage.this._fileCat)) {
                        ProblemsPage.this.currFilterOpt = FILE_FILTER_OPT;
                        ProblemsPage.this.filterMessages(FILE_COL);
                    } else if (selectedCat.equals(ProblemsPage.this._dORfCat)) {
                        ProblemsPage.this.currFilterOpt = DORF_FILTER_OPT;
                        ProblemsPage.this.filterMessages(new int[]{DESC_COL, FILE_COL});
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            if (action == null) {
                return true;
            }
            int cmdId = action.getCommandId();
            if (cmdId == 30 || cmdId == 31 || cmdId == 12) {
                action.setEnabled(ProblemsPage.this.table != null && ProblemsPage.this.table.getRowCount() > 0);
                return true;
            }
            if (cmdId == 18) {
                action.setEnabled(ProblemsPage.this.table.getSelectedRow() >= 0);
                return true;
            }
            if (cmdId == FIX_SOURCE_CMD_ID) {
                boolean enabled = false;
                action.setEnabled(enabled);
                return true;
            }
            if (cmdId == GOTO_SOURCE_CMD_ID) {
                action.setEnabled(ProblemsPage.this.table.getSelectedRow() >= 0);
                return true;
            }
            return false;
        }
    }
}

