/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.compiler.CompileArguments;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogPage;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarIndex;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemStorage;
import oracle.ide.net.URLPath;
import oracle.ide.runner.SimpleProcess;
import oracle.ide.util.Assert;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.filesystem.PathImpl;
import oracle.javatools.filesystem.StorageFileSystemProvider;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.PatchClassFile;
import oracle.jdeveloper.compiler.SourceMap;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.Translator2;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.buildtools.WorkspaceConfiguration;
import oracle.jdevimpl.compiler.BuildSystemUtilities;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.jdevimpl.compiler.JCompilerUtils;
import oracle.jdevimpl.compiler.OjcRedefineMap;
import oracle.jdevimpl.javacompiler.FileListener;
import oracle.jdevimpl.javacompiler.JDevJavaCompiler;
import oracle.jdevimpl.javacompiler.JDevJavaFileManager;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;
import oracle.jdevimpl.javacompiler.JavaDependencyProvider;
import oracle.jdevimpl.javacompiler.LogDiagnosticListener;
import oracle.jdevimpl.javacompiler.StorageJavaFileObject;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.FileStorage;

public class Ojc
implements Translator2 {
    private String APPS_WRITE_CLASSPATH_TO_DIR;
    private final String javacOptionsFromSystemProperty = "oracle.jdevbuild.extra.javac.options";
    private boolean OJC_COMPILE_OUT_OF_PROCESS;
    private final String eolSeparator = System.getProperty("line.separator");
    private Translator.Log _log = null;
    private static File tmpJavacFile = null;
    private Map<String, String> additionalCompilerOptions;
    private final Pattern javacErrorPattern = Pattern.compile("^([^\"]*):([0-9]+):([\\s\\S]*)$");
    private final Pattern javacWarningPatternExactLine = Pattern.compile("^([^\"]*):([0-9]+):([\\s\\p{L}\\d]+:[\\s]*)(\\[.+\\][\\s\\S]*)$");
    private final Pattern javacWarningPatternExactLineJpCn = Pattern.compile("^([^\"]*):([0-9]+):(.*\u8b66\u544a.*)(\\[.+\\][\\s\\S]*)$");
    private final Pattern javacWarningPatternNoLine = Pattern.compile("^(.+:[\\s]*)(\\[[\\p{L}]+\\][\\s\\S]*$)");
    private final Pattern javacWarningPatternNoLineJpCn = Pattern.compile("^(.*\u8b66\u544a.*)(\\[[\\p{L}]+\\][\\s\\S]*$)");
    private Workspace workspace;
    private Map<Storage, JavaFileObject> dependencyJavaFileObjects = new HashMap<Storage, JavaFileObject>();
    private boolean isJdevadfWorkspace;

    @Override
    public void setWorkspace(Workspace workspace) {
        this.isJdevadfWorkspace = false;
        this.workspace = workspace;
        if (workspace != null) {
            WorkspaceConfiguration workspaceConfig = WorkspaceConfiguration.getWorkspaceConfiguration((Workspace)workspace);
            this.isJdevadfWorkspace = workspaceConfig.isModularBuildWorkspace();
        }
    }

    @Override
    public String getName() {
        return "Ojc";
    }

    @Override
    public ArrayList<String> getInputTypes() {
        ArrayList<String> v = new ArrayList<String>(1);
        v.add(".java");
        return v;
    }

    @Override
    public ArrayList<String> getOutputTypes() {
        ArrayList<String> v = new ArrayList<String>(1);
        v.add(".class");
        return v;
    }

    @Override
    public boolean canBuild(Storage store) {
        return store.getName().endsWith(".java");
    }

    @Override
    public boolean needToBuild(Storage store) {
        return false;
    }

    @Override
    public void setLog(Translator.Log log) {
        this._log = log;
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.startsWith("JavacOption:")) {
            if (this.additionalCompilerOptions == null) {
                this.additionalCompilerOptions = new LinkedHashMap<String, String>();
            }
            this.additionalCompilerOptions.put(name.substring(12), value);
        }
    }

    @Override
    public void setProject(Project project) {
    }

    @Override
    public void updateProject(Project project) {
    }

    private static String getOutputDirectory(Project prj) {
        File outFile;
        URL outUrl = JavaProject.getInstance((Project)prj).getOutputDirectory();
        File file = outFile = outUrl != null ? new File(outUrl.getPath()) : new File(prj.getURL().getPath()).getParentFile();
        if (!outFile.exists()) {
            outFile.mkdirs();
        }
        return outFile.getPath();
    }

    private static int positionToLine(int position) {
        return position >>> 16;
    }

    private static int positionToColumn(int position) {
        return position & 0xFFFF;
    }

    private static int lineColumnToPosition(int line, int column) {
        return line << 16 | column & 0xFFFF;
    }

    private static String stringize(String str) {
        if (!(str.startsWith("\"") || str.indexOf(32) < 0 && str.indexOf(9) < 0)) {
            return "\"" + str + "\"";
        }
        return str;
    }

    private void addSMAPs(List<Storage> sources, String outPath) {
        HashMap<String, File[]> classDirectoryMap = new HashMap<String, File[]>();
        for (Storage stor : sources) {
            SourceMap sourceMap = (SourceMap)stor.getProperty("sourceMap");
            if (sourceMap == null) continue;
            try {
                String qualifiedClassName = sourceMap.getQualifiedClassName().replace('.', File.separatorChar) + ".class";
                File qualifiedClassFile = new File(outPath + File.separatorChar + qualifiedClassName);
                if (!qualifiedClassFile.exists()) continue;
                this.patchAndMoveClassFiles(qualifiedClassFile, qualifiedClassName, sourceMap, stor, outPath, classDirectoryMap);
            }
            catch (IOException e) {
                Assert.printStackTrace((Throwable)e);
            }
            catch (ClassFormatError e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    private void patchAndMoveClassFiles(File qualifiedClassFile, String qualifiedClassName, SourceMap sourceMap, Storage stor, String outPath, HashMap<String, File[]> classDirectoryMap) throws IOException, ClassFormatError {
        String destOutPath = (String)stor.getProperty("outputDirectory");
        boolean moveClassFiles = destOutPath != null && !destOutPath.equals(outPath);
        ArrayList<File> classFileList = new ArrayList<File>();
        classFileList.add(qualifiedClassFile);
        int separatorIndex = qualifiedClassName.lastIndexOf(File.separatorChar);
        String qualifiedPackageName = separatorIndex > 0 ? qualifiedClassName.substring(0, separatorIndex + 1) : "";
        File classDirectory = qualifiedClassFile.getParentFile();
        String classNamePrefix = qualifiedClassFile.getName();
        int dotIndex = classNamePrefix.lastIndexOf(46);
        classNamePrefix = dotIndex > 0 ? classNamePrefix.substring(0, dotIndex) + "$" : null;
        if (classDirectory != null && classNamePrefix != null) {
            File[] children = classDirectoryMap.get(classDirectory.getPath());
            if (children == null) {
                children = classDirectory.listFiles();
                classDirectoryMap.put(classDirectory.getPath(), children);
            }
            for (int x = 0; x < children.length; ++x) {
                String childName = children[x].getName();
                if (!childName.endsWith(".class") || !childName.startsWith(classNamePrefix)) continue;
                classFileList.add(children[x]);
            }
        }
        for (int x = 0; x < classFileList.size(); ++x) {
            File classFile = (File)classFileList.get(x);
            PatchClassFile.addSMAP(classFile, sourceMap.getSMAP());
            if (!moveClassFiles) continue;
            String className = classFile.getName();
            File dest = new File(destOutPath + File.separatorChar + qualifiedPackageName + className);
            if (dest.exists()) {
                dest.delete();
            }
            classFile.renameTo(dest);
        }
    }

    private void logMessage(Translator.Log log, Storage source, int pos, int errCode, String errMsg, boolean error) {
        SourceMap sourceMap;
        int line = Ojc.positionToLine(pos);
        int col = Ojc.positionToColumn(pos);
        if (source != null && (sourceMap = (SourceMap)source.getProperty("sourceMap")) != null) {
            int[] data = new int[]{line, col};
            Storage[] stor = new Storage[]{null};
            boolean translated = sourceMap.translateLocation(data, stor);
            line = data[0];
            col = data[1];
            source = stor[0];
            if (source != null && J2eeSettings.isCompilableJsp((String)source.getName()) && log instanceof IdeLog) {
                String path;
                URL htmlRootDirURL;
                URL newPathURL;
                String newPath;
                File f;
                if (!translated && !error) {
                    return;
                }
                Project project = ((IdeLog)log).getProject();
                if (project != null && (f = new File(newPath = URLFileSystem.getPlatformPathName((URL)(newPathURL = URLFactory.newURL((URL)(htmlRootDirURL = J2eeSettings.getInstance((Project)project).getHtmlRootDirectory()), (String)(path = source.getPath())))))).exists()) {
                    source = Helpers.createFileStorage(f);
                }
            }
        }
        if (error) {
            log.error(source, line, col, errCode, errMsg);
        } else {
            log.warning(source, line, col, errCode, errMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runJavacInProcess(Project jprj, File inProcessToolsJar, CompilerOptionManager optionManager, List<Storage> sources, final ArrayList<Storage> results, final Translator.Log log, String sourcePath) {
        int result;
        boolean bl;
        URLPath modulePath;
        String string;
        final OjcRedefineMap rm = new OjcRedefineMap();
        final String outPath = Ojc.getOutputDirectory(jprj);
        final LinkedHashMap<String, Storage> sourcesBeingCompiled = new LinkedHashMap<String, Storage>(sources.size());
        LinkedHashMap<URI, JavaFileObject> fileObjects = new LinkedHashMap<URI, JavaFileObject>();
        final LinkedHashMap<URI, Storage> storageObjects = new LinkedHashMap<URI, Storage>();
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        final boolean projectIsJdk9OrHigher = buildSysConfig.isJDK9OrHigher();
        final HashSet sourcesParsed = new HashSet();
        ArrayList<String> otherOptions = new ArrayList<String>();
        boolean[] hasProfileOption = new boolean[]{false};
        boolean[] hasReleaseOption = new boolean[]{false};
        boolean[] reallyVerboseOutput = new boolean[]{false};
        this.getProjectOptions(optionManager, otherOptions, hasProfileOption, hasReleaseOption, reallyVerboseOutput);
        this.getAdditionalOptions(otherOptions, hasProfileOption, hasReleaseOption, reallyVerboseOutput);
        this.getOptionsFromSystemProperty(otherOptions, hasProfileOption, hasReleaseOption, reallyVerboseOutput);
        Map<String, String> defaultOptions = this.getDefaultOptions(buildSysConfig, jprj, outPath, false, sourcePath, hasProfileOption[0], hasReleaseOption[0], reallyVerboseOutput[0]);
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)jprj);
        if (UnifiedBuildSystem.showCompileProgress || projectIsJdk9OrHigher || this.APPS_WRITE_CLASSPATH_TO_DIR != null) {
            URLPath classPath;
            if (hasProfileOption[0]) {
                classPath = new URLPath(pathsConfiguration.getJdkClassPath());
                classPath.add(pathsConfiguration.getRunClassPath());
            } else {
                classPath = pathsConfiguration.getRunClassPath();
            }
            String string2 = Helpers.urlPathAndDependantPathToString(reallyVerboseOutput[0], this._log, classPath, sources, File.pathSeparator, false);
            if (UnifiedBuildSystem.showCompileProgress && !string2.isEmpty()) {
                defaultOptions.put("-classpath", string2);
            }
            if (this.APPS_WRITE_CLASSPATH_TO_DIR != null) {
                this.writeAppsClassPathToDirectory(reallyVerboseOutput, this._log, classPath, sources, jprj);
            }
        }
        if (projectIsJdk9OrHigher && !(string = Helpers.urlPathAndDependantPathToString(reallyVerboseOutput[0], this._log, modulePath = pathsConfiguration.getModulePath(false, false), sources, File.pathSeparator, false)).isEmpty()) {
            defaultOptions.put("--module-path", string);
            this.addAddModulesOption(defaultOptions, modulePath);
        }
        for (String string3 : otherOptions) {
            defaultOptions.remove(string3);
        }
        ArrayList<String> finalOptions = new ArrayList<String>();
        for (Map.Entry<String, String> entry : defaultOptions.entrySet()) {
            finalOptions.add(entry.getKey());
            if (entry.getValue() == null) continue;
            finalOptions.add(entry.getValue());
        }
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int optionIndex = 0; optionIndex < otherOptions.size(); ++optionIndex) {
            String otherOption = (String)otherOptions.get(optionIndex);
            if (otherOption.equals("-classpath")) {
                bl = true;
            } else if (otherOption.equals("-endorseddirs")) {
                if (optionIndex + 1 < otherOptions.size()) {
                    String argument = (String)otherOptions.get(optionIndex + 1);
                    stringBuilder.append(argument);
                    stringBuilder.append(File.pathSeparatorChar);
                    ++optionIndex;
                    continue;
                }
            } else {
                if (otherOption.startsWith("-Djava.endorsed.dirs=")) {
                    stringBuilder.append(otherOption.substring(otherOption.indexOf(61) + 1));
                    stringBuilder.append(File.pathSeparatorChar);
                    continue;
                }
                if (otherOption.equals("-clearjarindexcache")) {
                    JarIndex.clearCache();
                    continue;
                }
            }
            finalOptions.add(otherOption);
        }
        if (stringBuilder.length() > 0) {
            if (!hasReleaseOption[0] && !projectIsJdk9OrHigher) {
                this.addEndorsedDirs(finalOptions, jprj, stringBuilder, false, reallyVerboseOutput[0]);
            } else if (hasReleaseOption[0]) {
                log.warning(null, 0, 0, 0, CompArb.getString(179));
            } else if (projectIsJdk9OrHigher) {
                log.warning(null, 0, 0, 0, CompArb.getString(170));
            }
        }
        class JavacCompilerLog
        implements JavaCompilerLog<JavaFileObject> {
            private String outputDirectory;
            private boolean reallyVerboseOutput;

            JavacCompilerLog(String outputDirectory, boolean reallyVerboseOutput) {
                this.outputDirectory = outputDirectory;
                this.reallyVerboseOutput = reallyVerboseOutput;
            }

            public void println(String line) {
                if (line.startsWith("[")) {
                    if (projectIsJdk9OrHigher) {
                        String sourceFileName;
                        String classFileName = Ojc.this.getFileNameFromOutput(line, ".class");
                        if (classFileName != null && (classFileName.indexOf(outPath + File.separator) >= 0 || classFileName.indexOf(outPath + ":") >= 0)) {
                            if (classFileName.indexOf(outPath + ":") >= 0) {
                                classFileName = classFileName.replace(outPath + ":", outPath + File.separator);
                            }
                            results.add(new FileStorage(new File(classFileName)));
                            rm.redefineClass(classFileName, outPath);
                            if (UnifiedBuildSystem.showCompileProgress) {
                                String writeMsg = "  " + CompArb.format(111, classFileName) + Ojc.this.eolSeparator;
                                JCompiler.getInstance().getOutputLog().log((Object)writeMsg);
                            }
                            return;
                        }
                        if (classFileName == null && (sourceFileName = Ojc.this.getFileNameFromOutput(line, ".java")) != null) {
                            String sourceNameForwardSlashes = sourceFileName.replace('\\', '/');
                            Storage source = (Storage)sourcesBeingCompiled.get(sourceNameForwardSlashes);
                            if (source == null) {
                                source = new FileStorage(new File(sourceNameForwardSlashes));
                                sourcesBeingCompiled.put(sourceNameForwardSlashes, source);
                                log.clear(source);
                            }
                            if (sourcesParsed.add(sourceNameForwardSlashes) && UnifiedBuildSystem.showCompileProgress) {
                                String compileMsg = "  " + CompArb.format(112, sourceFileName) + Ojc.this.eolSeparator;
                                JCompiler.getInstance().getOutputLog().log((Object)compileMsg);
                            }
                            return;
                        }
                    }
                    if (UnifiedBuildSystem.showCompileProgress && this.reallyVerboseOutput) {
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                    }
                    return;
                }
                if (UnifiedBuildSystem.showCompileProgress) {
                    JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                }
            }

            public void error(JavaFileObject source, long line, long col, int errNumber, String errMsg) {
                String msg = errMsg;
                msg = Ojc.this.replaceEolSeparator(msg, ';');
                Matcher matcher = Ojc.this.javacErrorPattern.matcher(msg);
                msg = matcher.matches() && matcher.groupCount() == 3 ? matcher.group(3) : this.shortenFileName(source, msg);
                int pos = Ojc.lineColumnToPosition((int)line, (int)col);
                Ojc.this.logMessage(log, this.getStorage(source), pos, errNumber, msg, true);
            }

            private String shortenFileName(JavaFileObject source, String msg) {
                Storage storage = this.getStorage(source);
                if (storage != null) {
                    String longName = storage.getPath().replace('\\', '/');
                    String newMsg = msg.replace('\\', '/');
                    return newMsg.replace(longName, storage.getName());
                }
                return msg;
            }

            public void warning(JavaFileObject source, long line, long col, int warnNumber, String warnMsg) {
                String msg = Ojc.this.replaceEolSeparator(warnMsg, ';');
                boolean matched = false;
                Matcher warningMatcher = Ojc.this.javacWarningPatternExactLineJpCn.matcher(msg);
                if (warningMatcher.matches() && warningMatcher.groupCount() == 4) {
                    msg = warningMatcher.group(4);
                    matched = true;
                }
                if (!matched && (warningMatcher = Ojc.this.javacWarningPatternExactLine.matcher(msg)).matches() && warningMatcher.groupCount() == 4) {
                    msg = warningMatcher.group(4);
                    matched = true;
                }
                if (!matched && (warningMatcher = Ojc.this.javacWarningPatternNoLineJpCn.matcher(msg)).matches() && warningMatcher.groupCount() == 2) {
                    msg = warningMatcher.group(2);
                    matched = true;
                }
                if (!matched && (warningMatcher = Ojc.this.javacWarningPatternNoLine.matcher(msg)).matches() && warningMatcher.groupCount() == 2) {
                    msg = warningMatcher.group(2);
                    matched = true;
                }
                if (!matched) {
                    msg = this.shortenFileName(source, msg);
                    matched = true;
                }
                int pos = Ojc.lineColumnToPosition((int)line, (int)col);
                Ojc.this.logMessage(log, this.getStorage(source), pos, warnNumber, msg, false);
            }

            private Storage getStorage(JavaFileObject javaFileObject) {
                if (javaFileObject == null) {
                    return null;
                }
                if (javaFileObject instanceof StorageJavaFileObject) {
                    return ((StorageJavaFileObject)javaFileObject).getStorage();
                }
                URI uri = javaFileObject.toUri();
                return (Storage)storageObjects.get(uri);
            }

            public void clear(JavaFileObject source) {
            }

            public int nerrors() {
                return log.nerrors();
            }

            public int nwarnings() {
                return log.nwarnings();
            }
        }
        JavacCompilerLog javacCompilerLog = new JavacCompilerLog(outPath, reallyVerboseOutput[0]);
        JDevJavaCompiler jdevJavaCompiler = new JDevJavaCompiler();
        StandardJavaFileManager standardJavaFileManager = null;
        StorageFileSystemProvider storageFileSystemProvider = null;
        if (projectIsJdk9OrHigher) {
            Charset charset = null;
            try {
                charset = Charset.forName(buildSysConfig.getCurrentEncoding());
            }
            catch (Exception ex) {
                charset = null;
            }
            LogDiagnosticListener logDiagnosticListener = new LogDiagnosticListener((JavaCompilerLog)javacCompilerLog, null);
            standardJavaFileManager = ToolProvider.getSystemJavaCompiler().getStandardFileManager((DiagnosticListener<? super JavaFileObject>)logDiagnosticListener, null, charset);
            storageFileSystemProvider = jdevJavaCompiler.getStorageFileSystemProvider();
        }
        StringBuffer sourcePathBuf = new StringBuffer();
        Iterator optionIter = finalOptions.iterator();
        while (optionIter.hasNext()) {
            String option = (String)optionIter.next();
            if ("--patch-module".equals(option) || option.startsWith("--patch-module=")) {
                log.warning(null, 0, 0, 0, CompArb.getString(178));
                return this.runJavacOutOfProcess(jprj, optionManager, sources, results, log, sourcePath);
            }
            if (!projectIsJdk9OrHigher || !"--sourcepath".equals(option) && !"-sourcepath".equals(option)) continue;
            optionIter.remove();
            if (!optionIter.hasNext()) continue;
            option = (String)optionIter.next();
            optionIter.remove();
            if (sourcePathBuf.length() == 0) {
                sourcePathBuf.append(option);
                continue;
            }
            sourcePathBuf.append(File.pathSeparatorChar);
            sourcePathBuf.append(option);
        }
        this.filterOutIncompatibleOptions(projectIsJdk9OrHigher, finalOptions, log, hasProfileOption[0], hasReleaseOption[0]);
        for (int x = 0; x < sources.size(); ++x) {
            JavaFileObject storageJavaFileObject;
            Storage storage = sources.get(x);
            String storagePath = storage.getPath().replace('\\', '/');
            if (sourcesBeingCompiled.put(storagePath, storage) != null) continue;
            log.clear(storage);
            if (projectIsJdk9OrHigher) {
                try {
                    storageJavaFileObject = this.getPathBasedJavaFileObject(standardJavaFileManager, storageFileSystemProvider, storage);
                }
                catch (Exception ex) {
                    log.warning(null, 0, 0, 0, CompArb.getString(181));
                    return this.runJavacOutOfProcess(jprj, optionManager, sources, results, log, sourcePath);
                }
            } else {
                storageJavaFileObject = this.dependencyJavaFileObjects.get(storage);
                if (storageJavaFileObject == null) {
                    storageJavaFileObject = new StorageJavaFileObject(null, storage, buildSysConfig.getCurrentEncoding());
                }
            }
            URI uri = storageJavaFileObject.toUri();
            fileObjects.put(uri, storageJavaFileObject);
            storageObjects.put(uri, storage);
        }
        if (projectIsJdk9OrHigher && sourcePathBuf.length() > 0 && !this.addInMemoryFileSystemToSourcePath(standardJavaFileManager, storageFileSystemProvider, sourcePathBuf.toString())) {
            log.warning(null, 0, 0, 0, CompArb.getString(182));
            return this.runJavacOutOfProcess(jprj, optionManager, sources, results, log, sourcePath);
        }
        if (Thread.currentThread().isInterrupted()) {
            return 0;
        }
        if (UnifiedBuildSystem.showCompileProgress) {
            this.showJavacInProcessCmdLine(jprj, finalOptions, sources);
        }
        JDevJavaFileManager fileManager = null;
        if (!projectIsJdk9OrHigher) {
            fileManager = new JDevJavaFileManager(){

                protected Storage getOutputPathStorage(String outputPath) {
                    URL url = URLFactory.newDirURL((String)outputPath);
                    if (url != null && URLFileSystem.mkdirs((URL)url)) {
                        return new URLFileSystemStorage(url);
                    }
                    return null;
                }
            };
            fileManager.setLog((JavaCompilerLog)javacCompilerLog);
            fileManager.setVerbose(reallyVerboseOutput[0]);
            if (hasProfileOption[0]) {
                URLPath urlClassPath = pathsConfiguration.getJdkClassPath();
                String path2 = Helpers.urlPathAndDependantPathToString(reallyVerboseOutput[0], this._log, urlClassPath, sources, File.pathSeparator, false);
                fileManager.setProfileJdkClassPath(path2);
            }
            if (!bl) {
                URLPath classPath = pathsConfiguration.getRunClassPath();
                Storage[] classPathStorages = Helpers.urlPathAndDependantPathToStorageArray(reallyVerboseOutput[0], this._log, classPath, sources);
                fileManager.setClassPath(classPathStorages);
            }
            fileManager.registerFileListener(new FileListener(){

                public void outputFile(String outputPath) {
                    rm.redefineClass(outputPath, outPath);
                    results.add(new FileStorage(new File(outputPath)));
                    if (UnifiedBuildSystem.showCompileProgress) {
                        String msg = "  " + CompArb.format(111, outputPath) + Ojc.this.eolSeparator;
                        JCompiler.getInstance().getOutputLog().log((Object)msg);
                    }
                }

                public void inputFile(String inputPath) {
                    if (!inputPath.endsWith(".java")) {
                        return;
                    }
                    String name = inputPath.replace('\\', '/');
                    if (!sourcesParsed.add(name)) {
                        return;
                    }
                    Storage source = (Storage)sourcesBeingCompiled.get(name);
                    if (source == null) {
                        source = new FileStorage(new File(name));
                        sourcesBeingCompiled.put(name, source);
                        log.clear(source);
                    }
                    if (UnifiedBuildSystem.showCompileProgress) {
                        String msg = "  " + CompArb.format(112, inputPath) + Ojc.this.eolSeparator;
                        JCompiler.getInstance().getOutputLog().log((Object)msg);
                    }
                }
            });
        }
        try {
            result = jdevJavaCompiler.compile(inProcessToolsJar, (JavaFileManager)(projectIsJdk9OrHigher ? standardJavaFileManager : fileManager), fileObjects.values(), finalOptions, (JavaCompilerLog)javacCompilerLog);
        }
        finally {
            try {
                if (fileManager != null) {
                    fileManager.close();
                }
            }
            catch (IOException ioe) {
                FeedbackManager.reportException((Throwable)ioe);
            }
        }
        rm.redefineClassMap(jprj, log);
        this.addSMAPs(sources, outPath);
        UnifiedBuildSystem buildSystem = UnifiedBuildSystem.getInstance();
        for (Storage storage : sourcesBeingCompiled.values()) {
            buildSystem.markTranslated(this, storage);
        }
        sourcesBeingCompiled.clear();
        storageObjects.clear();
        fileObjects.clear();
        return result == 0 ? result : (log.nerrors() > 0 ? log.nerrors() : 1);
    }

    private void writeAppsClassPathToDirectory(boolean[] reallyVerboseOutput, Translator.Log _log, URLPath classPath, List<Storage> sources, Project jprj) {
        String faPath = Helpers.urlPathAndDependantPathToString(reallyVerboseOutput[0], _log, classPath, sources, File.pathSeparator, true);
        File file = new File(this.APPS_WRITE_CLASSPATH_TO_DIR);
        if (file.isFile()) {
            _log.warning(null, 0, 0, 0, "Cannot write classpath to file in directory " + this.APPS_WRITE_CLASSPATH_TO_DIR + " because it's a file");
        } else {
            boolean created;
            if (!file.isDirectory()) {
                created = file.mkdirs();
                if (!created) {
                    _log.warning(null, 0, 0, 0, "Cannot create directory " + this.APPS_WRITE_CLASSPATH_TO_DIR + " to write classpath file");
                }
            } else {
                created = true;
            }
            if (created) {
                String projectLabel;
                String workspaceLabel;
                String string = workspaceLabel = this.workspace != null ? this.workspace.getShortLabel() : "<unknown_workspace>";
                if (workspaceLabel.endsWith(".jws")) {
                    workspaceLabel = workspaceLabel.substring(0, workspaceLabel.length() - 4);
                }
                String string2 = projectLabel = jprj != null ? jprj.getShortLabel() : "<unknown_project>";
                if (projectLabel.endsWith(".jpr")) {
                    projectLabel = projectLabel.substring(0, projectLabel.length() - 4);
                }
                file = new File(file, workspaceLabel + "_" + projectLabel + ".txt");
                try (FileWriter writer = new FileWriter(file);){
                    writer.write(faPath);
                }
                catch (IOException e) {
                    _log.warning(null, 0, 0, 0, "Exception while writing classpath to file " + file.getPath());
                }
            }
        }
    }

    private boolean addInMemoryFileSystemToSourcePath(StandardJavaFileManager standardJavaFileManager, StorageFileSystemProvider storageFileSystemProvider, String sourcePath) {
        try {
            String[] paths;
            ArrayList<Path> sourcePaths = new ArrayList<Path>();
            for (String path : paths = sourcePath.split(File.pathSeparator)) {
                sourcePaths.add(Paths.get(path, new String[0]));
            }
            Iterable rootDirectories = storageFileSystemProvider.getFileSystem().getRootDirectories();
            for (Path rootDirectory : rootDirectories) {
                sourcePaths.add(0, rootDirectory);
            }
            Method method = StandardJavaFileManager.class.getDeclaredMethod("setLocationFromPaths", JavaFileManager.Location.class, Collection.class);
            method.invoke((Object)standardJavaFileManager, StandardLocation.SOURCE_PATH, sourcePaths);
            return true;
        }
        catch (Exception ex) {
            FeedbackManager.reportException((Throwable)ex);
            return false;
        }
    }

    private JavaFileObject getPathBasedJavaFileObject(StandardJavaFileManager standardJavaFileManager, StorageFileSystemProvider provider, Storage storage) throws Exception {
        PathImpl storagePath = provider.putStorage(storage.getPath(), storage);
        Method method = StandardJavaFileManager.class.getDeclaredMethod("getJavaFileObjects", Path[].class);
        Object javaFileObjects = method.invoke((Object)standardJavaFileManager, new Object[]{new Path[]{storagePath}});
        return (JavaFileObject)((Iterable)javaFileObjects).iterator().next();
    }

    private void addAddModulesOption(Map<String, String> options, URLPath modulePath) {
        StringBuilder buf = new StringBuilder();
        boolean addComma = false;
        for (URL url : modulePath.asList()) {
            String moduleName = PathsConfiguration.getModuleName((URL)url);
            if (moduleName == null) continue;
            if (addComma) {
                buf.append(',');
            } else {
                addComma = true;
            }
            buf.append(moduleName);
        }
        if (buf.length() > 0) {
            options.put("--add-modules", buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void syncPatchModuleAndSourcePath(List<String> options) {
        Object sourcePath;
        block31: {
            block30: {
                block29: {
                    block28: {
                        sourcePath = null;
                        ArrayList<String> patchModuleArguments = new ArrayList<String>();
                        try {
                            Iterator<String> iter = options.iterator();
                            while (iter.hasNext()) {
                                Object option = iter.next().trim();
                                if ("--patch-module".equals(option)) {
                                    if (!iter.hasNext()) {
                                        return;
                                    }
                                    patchModuleArguments.add(iter.next().trim());
                                    continue;
                                }
                                if (((String)option).startsWith("--patch-module=")) {
                                    patchModuleArguments.add(((String)option).substring(((String)option).indexOf(61) + 1));
                                    continue;
                                }
                                if (!"-sourcepath".equals(option) && !"--source-path".equals(option)) continue;
                                if (!iter.hasNext()) {
                                    if (sourcePath == null) return;
                                    options.add("-sourcepath");
                                    break block28;
                                }
                                iter.remove();
                                option = iter.next().trim();
                                if (sourcePath != null) {
                                    if (!((String)sourcePath).endsWith(File.pathSeparator)) {
                                        sourcePath = (String)sourcePath + File.pathSeparator;
                                    }
                                    sourcePath = (String)sourcePath + (String)option;
                                } else {
                                    sourcePath = option;
                                }
                                iter.remove();
                            }
                            if (patchModuleArguments.isEmpty()) return;
                            if (sourcePath == null) {
                                return;
                            }
                            HashSet<File> patchModulePaths = new HashSet<File>();
                            for (String patchModuleArg : patchModuleArguments) {
                                String[] patchModulePieces;
                                int index = patchModuleArg.indexOf(61);
                                if (index < 0) continue;
                                patchModuleArg = patchModuleArg.substring(index + 1);
                                for (String patchModulePiece : patchModulePieces = patchModuleArg.split(File.pathSeparator)) {
                                    patchModulePaths.add(new File(patchModulePiece));
                                }
                            }
                            if (patchModulePaths.isEmpty()) {
                                if (sourcePath == null) return;
                                break block29;
                            }
                            String[] sourcePathPieces = ((String)sourcePath).split(File.pathSeparator);
                            ArrayList<String> sourcePaths = new ArrayList<String>(sourcePathPieces.length);
                            for (String sourcePathPiece : sourcePathPieces) {
                                if (patchModulePaths.contains(new File(sourcePathPiece))) continue;
                                sourcePaths.add(sourcePathPiece);
                            }
                            if (sourcePaths.isEmpty()) {
                                sourcePath = null;
                                if (sourcePath == null) return;
                                break block30;
                            }
                            StringBuilder buf = new StringBuilder();
                            boolean appendSeparator = false;
                            for (String sourcePathPiece : sourcePaths) {
                                if (appendSeparator) {
                                    buf.append(File.separatorChar);
                                } else {
                                    appendSeparator = true;
                                }
                                buf.append(sourcePathPiece);
                            }
                            sourcePath = buf.toString();
                            if (sourcePath == null) return;
                            break block31;
                        }
                        catch (Exception ex) {
                            Assert.check((boolean)false);
                            return;
                        }
                    }
                    options.add((String)sourcePath);
                    return;
                }
                options.add("-sourcepath");
                options.add((String)sourcePath);
                return;
            }
            options.add("-sourcepath");
            options.add((String)sourcePath);
            return;
        }
        options.add("-sourcepath");
        options.add((String)sourcePath);
        return;
        finally {
            if (sourcePath != null) {
                options.add("-sourcepath");
                options.add((String)sourcePath);
            }
        }
    }

    private void addEndorsedDirs(List<String> options, Project jprj, StringBuilder endorsedDirs, boolean stringize, boolean reallyVerboseOutput) {
        String endorsedDirsArgument;
        String endorsedDirsSetting = this.getEndorsedDirsSetting(reallyVerboseOutput, jprj);
        if (endorsedDirsSetting != null) {
            endorsedDirs.append(endorsedDirsSetting);
        }
        if ((endorsedDirsArgument = endorsedDirs.toString().trim()).length() > 0) {
            options.add("-endorseddirs");
            options.add(stringize ? Ojc.stringize(endorsedDirsArgument) : endorsedDirsArgument);
        }
    }

    private void filterOutIncompatibleOptions(boolean projectIsJdk9OrHigher, List<String> options, Translator.Log log, boolean hasProfileOption, boolean hasReleaseOption) {
        if (hasReleaseOption || hasProfileOption || projectIsJdk9OrHigher) {
            Iterator<String> iter = options.iterator();
            while (iter.hasNext()) {
                String option = iter.next();
                int warning = -1;
                int remove = -1;
                switch (option) {
                    case "-source": {
                        if (!hasReleaseOption) break;
                        warning = 168;
                        remove = 2;
                        break;
                    }
                    case "-target": {
                        if (!hasReleaseOption) break;
                        warning = 169;
                        remove = 2;
                        break;
                    }
                    case "-bootclasspath": {
                        if (!projectIsJdk9OrHigher) break;
                        warning = 173;
                        remove = 2;
                        break;
                    }
                    case "-extdirs": {
                        if (!hasReleaseOption) break;
                        warning = 171;
                        remove = 2;
                        break;
                    }
                    default: {
                        if (option.startsWith("-Xbootclasspath:")) {
                            if (projectIsJdk9OrHigher) {
                                warning = 173;
                                remove = 1;
                                break;
                            }
                            if (!hasProfileOption) break;
                            warning = 172;
                            remove = 1;
                            break;
                        }
                        if (option.startsWith("-Xbootclasspath/p:")) {
                            if (!projectIsJdk9OrHigher) break;
                            warning = 173;
                            remove = 1;
                            break;
                        }
                        if (!option.startsWith("-Djava.ext.dirs=") || !projectIsJdk9OrHigher) break;
                        warning = 171;
                        remove = 1;
                    }
                }
                if (warning < 0) continue;
                log.warning(null, 0, 0, 0, CompArb.getString(warning));
                iter.remove();
                if (remove <= 1 || !iter.hasNext()) continue;
                option = iter.next();
                iter.remove();
            }
        }
    }

    private String getEndorsedDirsSetting(boolean reallyVerboseOutput, Project prj) {
        URLPath urlPath = PathsConfiguration.getInstance((Project)prj).getEndorsedStandardsDirectories();
        if (urlPath.size() > 0) {
            return Helpers.urlPathToString(reallyVerboseOutput, this._log, urlPath, File.pathSeparator);
        }
        return null;
    }

    private void getProjectOptions(CompilerOptionManager optionManager, List<String> otherOptions, boolean[] hasProfileOption, boolean[] hasReleaseOption, boolean[] reallyVerboseOutput) {
        String[] projectOptions = optionManager.getCompilerOptionsAsArray("Javac");
        for (int x = 0; x < projectOptions.length; ++x) {
            String projectOption = projectOptions[x];
            if ("-profile".equals(projectOption)) {
                hasProfileOption[0] = true;
            } else if ("--release".equals(projectOption)) {
                hasReleaseOption[0] = true;
            } else if ("-cp".equals(projectOption)) {
                projectOption = "-classpath";
            } else if ("-bootclasspath".equals(projectOption)) {
                if (this.isJdevadfWorkspace && x < projectOptions.length - 1) {
                    try {
                        URL wsURL;
                        URL oracleViewRoot;
                        URL jdk7Root;
                        String value = projectOptions[x + 1];
                        if (value.indexOf("$(JDK7)") >= 0 && URLFileSystem.exists((URL)(jdk7Root = URLFactory.newDirURL((URL)(oracleViewRoot = URLFileSystem.getParent((URL)URLFileSystem.getParent((URL)(wsURL = this.workspace.getURL())))), (String)"jdk7")))) {
                            String jdk7Path = jdk7Root.getPath();
                            if (jdk7Path.endsWith("/") || jdk7Path.endsWith("\\")) {
                                jdk7Path = jdk7Path.substring(0, jdk7Path.length() - 1);
                            }
                            otherOptions.add(projectOption);
                            value = value.replace("$(JDK7)", jdk7Path);
                            value = value.replace("$(SEP)", File.pathSeparator);
                            otherOptions.add(value);
                            ++x;
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        FeedbackManager.reportException((Throwable)ex);
                    }
                }
            } else if ("-p".equals(projectOption)) {
                projectOption = "--module-path";
            } else if ("-verbose".equals(projectOption)) {
                reallyVerboseOutput[0] = true;
            }
            otherOptions.add(projectOption);
        }
    }

    private void getAdditionalOptions(List<String> otherOptions, boolean[] hasProfileOption, boolean[] hasReleaseOption, boolean[] reallyVerboseOutput) {
        if (this.additionalCompilerOptions != null) {
            Set<Map.Entry<String, String>> entrySet = this.additionalCompilerOptions.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String option = entry.getKey();
                if ("-cp".equals(option)) {
                    option = "-classpath";
                } else if ("-profile".equals(option)) {
                    hasProfileOption[0] = true;
                } else if ("--release".equals(option)) {
                    hasReleaseOption[0] = true;
                } else if ("-p".equals(option)) {
                    option = "--module-path";
                } else if ("-verbose".equals(option)) {
                    reallyVerboseOutput[0] = true;
                }
                otherOptions.add(option);
                if (entry.getValue() == null) continue;
                otherOptions.add(entry.getValue());
            }
        }
    }

    private void getOptionsFromSystemProperty(List<String> otherOptions, boolean[] hasProfileOption, boolean[] hasReleaseOption, boolean[] reallyVerboseOutput) {
        List<String> systemPropertyOptions = this.getOptionsFromSystemProperty();
        for (String option : systemPropertyOptions) {
            if ("-profile".equals(option)) {
                hasProfileOption[0] = true;
            } else if ("--release".equals(option)) {
                hasReleaseOption[0] = true;
            } else if ("-cp".equals(option)) {
                option = "-classpath";
            } else if ("-p".equals(option)) {
                option = "--module-path";
            } else if ("-verbose".equals(option)) {
                reallyVerboseOutput[0] = true;
            }
            otherOptions.add(option);
        }
    }

    private Map<String, String> getDefaultOptions(BuildSystemConfiguration buildSysConfig, Project jprj, String outPath, boolean stringize, String sourcePath, boolean hasProfileOption, boolean hasReleaseOption, boolean reallyVerboseOutput) {
        LinkedHashMap<String, String> defaultOptions = new LinkedHashMap<String, String>();
        if (!hasReleaseOption) {
            if (buildSysConfig.isJDK14OrHigher() && !buildSysConfig.getSourceString().equals("Default")) {
                String source = buildSysConfig.getSource();
                defaultOptions.put("-source", source);
            }
            if (!buildSysConfig.getTargetString().equals("Default")) {
                String target = buildSysConfig.getTarget();
                defaultOptions.put("-target", target);
            }
        }
        if (UnifiedBuildSystem.showCompileProgress) {
            defaultOptions.put("-verbose", null);
        }
        defaultOptions.put("-encoding", buildSysConfig.getCurrentEncoding());
        if (!(buildSysConfig.isJDK9OrHigher() || hasProfileOption || hasReleaseOption)) {
            URLPath bootPath = null;
            JDK jdk = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK();
            if (jdk != null) {
                bootPath = jdk.getClassPath();
            }
            if (bootPath != null) {
                String bootPathString = Helpers.urlPathToString(reallyVerboseOutput, this._log, bootPath, File.pathSeparator);
                if (stringize) {
                    bootPathString = Ojc.stringize(bootPathString);
                }
                if (bootPathString.length() > 0) {
                    defaultOptions.put("-bootclasspath", bootPathString);
                }
            }
        }
        if (!sourcePath.isEmpty()) {
            if (stringize) {
                sourcePath = Ojc.stringize(sourcePath);
            }
            defaultOptions.put("-sourcepath", sourcePath);
        }
        defaultOptions.put("-d", stringize ? Ojc.stringize(outPath) : outPath);
        return defaultOptions;
    }

    private List<String> getOptionsFromSystemProperty() {
        ArrayList<String> extraOptions = new ArrayList<String>();
        String javacOptions = System.getProperty("oracle.jdevbuild.extra.javac.options");
        if (javacOptions == null) {
            return extraOptions;
        }
        CompileArguments helper = new CompileArguments(new Context());
        helper.addJavaCompilerOptions(javacOptions);
        Map translatedOptions = helper.getJavaCompilerOptions();
        for (String entry : translatedOptions.keySet()) {
            extraOptions.add(entry);
            assert (translatedOptions.get(entry) == null) : "Options are only in keys, not in values";
        }
        return extraOptions;
    }

    private void showJavacInProcessCmdLine(Project jprj, List<String> options, List<Storage> sources) {
        URL javacURL;
        StringBuilder cmdBuf = new StringBuilder();
        String javacExe = null;
        JDK jdk = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK();
        URL uRL = javacURL = jdk != null ? jdk.getSDKBinDir() : null;
        if (javacURL != null) {
            javacURL = URLFactory.newURL((URL)javacURL, (String)"javac");
            javacExe = URLFileSystem.getPlatformPathName((URL)javacURL);
        }
        if (javacExe == null) {
            javacExe = "<path to java executable>";
        }
        cmdBuf.append(javacExe);
        cmdBuf.append(' ');
        boolean skipOption = false;
        for (String option : options) {
            if (skipOption) {
                skipOption = false;
                continue;
            }
            if (option.equals("-version") || option.equals("-et") || option.equals("-rebuild")) continue;
            if (option.indexOf(47) >= 0 || option.indexOf(92) >= 0) {
                cmdBuf.append(Ojc.stringize(option));
            } else {
                cmdBuf.append(option);
            }
            cmdBuf.append(' ');
        }
        for (Storage storage : sources) {
            cmdBuf.append(Ojc.stringize(storage.getPath()));
            cmdBuf.append(' ');
        }
        String cmdLine = cmdBuf.toString();
        if (System.getProperty("COMPILER.COMPILE.PRETTIFY_CMDLINE") != null) {
            cmdLine = this.prettifyCommandLine(cmdLine);
        }
        JCompiler.getInstance().getOutputLog().log((Object)(cmdLine + this.eolSeparator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int runJavacOutOfProcess(Project jprj, CompilerOptionManager optionManager, List<Storage> sources, final List<Storage> results, final Translator.Log log, String sourcePath) {
        String forwardStorPath;
        URLPath moduleURLPath;
        String string;
        URLPath classPath;
        final OjcRedefineMap rm = new OjcRedefineMap();
        final LinkedHashMap<String, Storage> sourcesBeingCompiled = new LinkedHashMap<String, Storage>();
        final HashSet sourcesParsed = new HashSet();
        boolean printMoreExtensiveOutput = false;
        String javacString = null;
        try {
            JDK jdk = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK();
            URL javaExec = jdk != null ? jdk.getJavaExecutable() : null;
            String string2 = javacString = javaExec != null ? javaExec.getPath() : "";
            if (javacString.endsWith("jre/bin/java.exe")) {
                javacString = javacString.substring(0, javacString.length() - 16) + (File.separatorChar == '/' ? "bin/javac" : "bin/javac.exe");
            } else if (javacString.endsWith("java.exe")) {
                javacString = javacString.substring(0, javacString.length() - 4) + (File.separatorChar == '/' ? "c" : "c.exe");
            } else if (javacString.endsWith("jre/bin/java")) {
                javacString = javacString.substring(0, javacString.length() - 12) + (File.separatorChar == '/' ? "bin/javac" : "bin/javac.exe");
            } else if (javacString.endsWith("java")) {
                javacString = javacString + (File.separatorChar == '/' ? "c" : "c.exe");
            } else {
                throw new Throwable();
            }
            File javacFile = new File(javacString);
            if (!javacFile.exists()) {
                throw new Throwable();
            }
            javacString = Ojc.stringize(javacFile.getPath());
        }
        catch (Throwable t) {
            log.error(null, 0, 0, 0, CompArb.getString(130));
            return 1;
        }
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        boolean projectIsJdk9OrHigher = buildSysConfig.isJDK9OrHigher();
        ArrayList<String> javacVmCommands = new ArrayList<String>();
        StringTokenizer vmArgs = new StringTokenizer(buildSysConfig.getOutOfProcessJavaOptions());
        while (vmArgs.hasMoreTokens()) {
            javacVmCommands.add("-J" + vmArgs.nextToken());
        }
        String outPath = Ojc.getOutputDirectory(jprj);
        boolean[] hasProfileOption = new boolean[]{false};
        boolean[] hasReleaseOption = new boolean[]{false};
        boolean[] reallyVerboseOutput = new boolean[]{false};
        ArrayList<String> otherOptions = new ArrayList<String>();
        this.getProjectOptions(optionManager, otherOptions, hasProfileOption, hasReleaseOption, reallyVerboseOutput);
        this.getAdditionalOptions(otherOptions, hasProfileOption, hasReleaseOption, reallyVerboseOutput);
        this.getOptionsFromSystemProperty(otherOptions, hasProfileOption, hasReleaseOption, reallyVerboseOutput);
        Map<String, String> defaultOptions = this.getDefaultOptions(buildSysConfig, jprj, outPath, true, sourcePath, hasProfileOption[0], hasReleaseOption[0], reallyVerboseOutput[0]);
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)jprj);
        if (hasProfileOption[0]) {
            classPath = new URLPath(pathsConfiguration.getJdkClassPath());
            classPath.add(pathsConfiguration.getRunClassPath());
        } else {
            classPath = pathsConfiguration.getRunClassPath();
        }
        String path = Helpers.urlPathAndDependantPathToString(reallyVerboseOutput[0], this._log, classPath, sources, File.pathSeparator, false);
        if (!path.isEmpty()) {
            defaultOptions.put("-classpath", Ojc.stringize(path));
        }
        if (this.APPS_WRITE_CLASSPATH_TO_DIR != null) {
            this.writeAppsClassPathToDirectory(reallyVerboseOutput, this._log, classPath, sources, jprj);
        }
        if (projectIsJdk9OrHigher && !(string = Helpers.urlPathAndDependantPathToString(reallyVerboseOutput[0], this._log, moduleURLPath = pathsConfiguration.getModulePath(false, false), sources, File.pathSeparator, false)).isEmpty()) {
            defaultOptions.put("--module-path", string);
            this.addAddModulesOption(defaultOptions, moduleURLPath);
        }
        for (String string3 : otherOptions) {
            defaultOptions.remove(string3);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        for (Map.Entry<String, String> entry : defaultOptions.entrySet()) {
            cmd.add(entry.getKey());
            if (entry.getValue() == null) continue;
            cmd.add(entry.getValue());
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object var27_34 = null;
        for (int x = 0; x < otherOptions.size(); ++x) {
            void var27_35;
            String otherOption = (String)otherOptions.get(x);
            if (otherOption.equals("-Xprint") || otherOption.equals("-XprintRounds") || otherOption.equals("-XprintProcessorInf")) {
                printMoreExtensiveOutput = true;
            } else {
                if (otherOption.equals("-endorseddirs")) {
                    if (x + 1 >= otherOptions.size()) continue;
                    stringBuilder.append((String)otherOptions.get(x + 1));
                    stringBuilder.append(File.pathSeparatorChar);
                    ++x;
                    continue;
                }
                if (otherOption.startsWith("-Djava.endorsed.dirs=")) {
                    stringBuilder.append(otherOption.substring(otherOption.indexOf(61) + 1));
                    stringBuilder.append(File.pathSeparatorChar);
                    continue;
                }
                if (otherOption.equals("-clearjarindexcache")) {
                    JarIndex.clearCache();
                    continue;
                }
            }
            if (otherOption.startsWith("-")) {
                cmd.add(otherOption);
            } else if ("-classpath".equals(var27_35)) {
                if (hasProfileOption[0] && !hasReleaseOption[0] && !projectIsJdk9OrHigher) {
                    URLPath uRLPath = pathsConfiguration.getJdkClassPath();
                    String classPathString = Ojc.stringize(Helpers.urlPathAndDependantPathToString(reallyVerboseOutput[0], this._log, uRLPath, null, File.pathSeparator, false));
                    if (classPathString == null) {
                        classPathString = "";
                    }
                    if (classPathString.length() > 0) {
                        classPathString = classPathString + File.pathSeparator;
                    }
                    classPathString = classPathString + Ojc.stringize(otherOption);
                    cmd.add(classPathString);
                } else {
                    cmd.add(Ojc.stringize(otherOption));
                }
            } else {
                cmd.add(Ojc.stringize(otherOption));
            }
            String string4 = otherOption;
        }
        if (stringBuilder.length() > 0) {
            if (!hasReleaseOption[0] && !projectIsJdk9OrHigher) {
                this.addEndorsedDirs(cmd, jprj, stringBuilder, true, reallyVerboseOutput[0]);
            } else if (hasReleaseOption[0]) {
                log.warning(null, 0, 0, 0, CompArb.getString(179));
            } else if (projectIsJdk9OrHigher) {
                log.warning(null, 0, 0, 0, CompArb.getString(170));
            }
        }
        this.filterOutIncompatibleOptions(projectIsJdk9OrHigher, cmd, log, hasProfileOption[0], hasReleaseOption[0]);
        this.syncPatchModuleAndSourcePath(cmd);
        try {
            if (tmpJavacFile == null) {
                tmpJavacFile = File.createTempFile("javac", null, null);
                tmpJavacFile.deleteOnExit();
            }
            try (BufferedWriter bw = null;){
                bw = new BufferedWriter(new FileWriter(tmpJavacFile), 16384);
                for (String string5 : cmd) {
                    bw.write(string5.replace('\\', '/'));
                    bw.write("\n");
                }
                boolean isBuggedJavac = PlatformUtils.isWindows() && buildSysConfig.isJDK15();
                for (Storage stor : sources) {
                    forwardStorPath = stor.getPath().replace('\\', '/');
                    if (sourcesBeingCompiled.put(forwardStorPath, stor) != null) continue;
                    log.clear(stor);
                    String fileName = isBuggedJavac && stor.getName().equals("package-info.java") ? Ojc.stringize(stor.getPath().replace('/', '\\')) : Ojc.stringize(forwardStorPath);
                    cmd.add(fileName.replace('/', File.separatorChar));
                    bw.write(fileName);
                    bw.write("\n");
                }
            }
            if (UnifiedBuildSystem.showCompileProgress) {
                void var30_52;
                StringBuilder commandLineBuf = new StringBuilder();
                commandLineBuf.append(javacString);
                commandLineBuf.append(' ');
                for (String vmCommand : javacVmCommands) {
                    commandLineBuf.append(vmCommand);
                    commandLineBuf.append(' ');
                }
                for (String oneCmd : cmd) {
                    commandLineBuf.append(oneCmd);
                    commandLineBuf.append(' ');
                }
                commandLineBuf.append('\n');
                String string6 = commandLineBuf.toString();
                if (System.getProperty("COMPILER.COMPILE.PRETTIFY_CMDLINE") != null) {
                    String string7 = this.prettifyCommandLine(string6);
                }
                JCompiler.getInstance().getOutputLog().log((Object)var30_52);
            }
            cmd.clear();
            cmd.add(javacString);
            cmd.addAll(javacVmCommands);
            cmd.add(Ojc.stringize("@" + tmpJavacFile.getPath()));
        }
        catch (Throwable t) {
            log.error(null, 0, 0, 0, CompArb.getString(131));
            return 1;
        }
        SimpleProcess javacProcess = new SimpleProcess(cmd.toArray(new String[cmd.size()]));
        javacProcess.setAddToProcessesFolder(false);
        javacProcess.setAddToTerminateMenu(false);
        javacProcess.setLogCommandString(false);
        class JavacLogInfo
        extends AbstractLogPage {
            final StringBuffer sb;
            final String outPath;
            final SimpleProcess javacProcess;
            int logLine;
            boolean reallyVerboseOutput;
            boolean startedParsing;
            boolean errorsAtStartup;
            boolean printMoreExtensiveOutput;

            JavacLogInfo(String outp, SimpleProcess prc, boolean reallyVerboseOutput, boolean printMoreExtensiveOutput) {
                super(new ViewId("BuildSystemJavacBufferPage", "BuildSystemJavacBufferPage"), null, false);
                this.sb = new StringBuffer(1024);
                this.logLine = 0;
                this.outPath = outp;
                this.javacProcess = prc;
                this.reallyVerboseOutput = reallyVerboseOutput;
                this.startedParsing = false;
                this.errorsAtStartup = false;
                this.printMoreExtensiveOutput = printMoreExtensiveOutput;
            }

            private Storage getStorageBeingCompiled(String sourceFile) {
                Storage source = (Storage)sourcesBeingCompiled.get(sourceFile.replace('\\', '/'));
                if (source == null) {
                    source = new FileStorage(new File(sourceFile));
                }
                return source;
            }

            public void log(Object msg) {
                String line;
                this.sb.append(msg.toString());
                while ((line = this.getLine(this.sb)) != null) {
                    String sourceFileName;
                    int lineno;
                    String lowerCaseLine = line.toLowerCase();
                    this.checkForTermination();
                    if (++this.logLine == 1) {
                        if (!Ide.getEnvironOptions().getSaveBeforeCompile()) {
                            log.error(null, 0, 0, 0, CompArb.getString(75));
                        }
                        if (UnifiedBuildSystem.showCompileProgress) {
                            JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(94) + Ojc.this.eolSeparator));
                        }
                    }
                    boolean warningAtPreciseLine = false;
                    Matcher matcher = Ojc.this.javacWarningPatternExactLineJpCn.matcher(line);
                    if (matcher.matches()) {
                        warningAtPreciseLine = true;
                    } else {
                        matcher = Ojc.this.javacWarningPatternExactLine.matcher(line);
                        if (matcher.matches()) {
                            warningAtPreciseLine = true;
                        }
                    }
                    if (warningAtPreciseLine) {
                        this.startedParsing = true;
                        try {
                            lineno = Integer.parseInt(matcher.group(2));
                        }
                        catch (NumberFormatException e) {
                            lineno = 0;
                        }
                        String warnMsg = matcher.group(4);
                        Ojc.this.logMessage(log, this.getStorageBeingCompiled(matcher.group(1)), Ojc.lineColumnToPosition(lineno, 0), 0, warnMsg, false);
                        if (!this.printMoreExtensiveOutput) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    matcher = Ojc.this.javacErrorPattern.matcher(line);
                    if (matcher.matches()) {
                        this.startedParsing = true;
                        try {
                            lineno = Integer.parseInt(matcher.group(2));
                        }
                        catch (NumberFormatException e) {
                            lineno = 0;
                        }
                        String errmsg = matcher.group(3);
                        boolean isError = !errmsg.toLowerCase().startsWith(" warning:");
                        Ojc.this.logMessage(log, this.getStorageBeingCompiled(matcher.group(1)), Ojc.lineColumnToPosition(lineno, 0), 0, isError ? errmsg : errmsg.substring(9), isError);
                        if (!this.printMoreExtensiveOutput) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    boolean warningNoLine = false;
                    matcher = Ojc.this.javacWarningPatternNoLineJpCn.matcher(line);
                    if (matcher.matches()) {
                        warningNoLine = true;
                    } else {
                        matcher = Ojc.this.javacWarningPatternNoLine.matcher(line);
                        if (matcher.matches()) {
                            warningNoLine = true;
                        }
                    }
                    if (warningNoLine) {
                        this.startedParsing = true;
                        log.warning(null, 0, 0, 0, matcher.group(2));
                        if (!this.printMoreExtensiveOutput) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    String classFileName = Ojc.this.getFileNameFromOutput(line, ".class");
                    if (classFileName != null && (classFileName.indexOf(this.outPath + File.separator) >= 0 || classFileName.indexOf(this.outPath + ":") >= 0)) {
                        this.startedParsing = true;
                        if (classFileName.indexOf(this.outPath + ":") >= 0) {
                            classFileName = classFileName.replace(this.outPath + ":", this.outPath + File.separator);
                        }
                        results.add(new FileStorage(new File(classFileName)));
                        rm.redefineClass(classFileName, this.outPath);
                        if (!UnifiedBuildSystem.showCompileProgress) continue;
                        String writeMsg = "  " + CompArb.format(111, classFileName) + Ojc.this.eolSeparator;
                        JCompiler.getInstance().getOutputLog().log((Object)writeMsg);
                        continue;
                    }
                    String string = sourceFileName = classFileName == null ? Ojc.this.getFileNameFromOutput(line, ".java") : null;
                    if (sourceFileName != null) {
                        this.startedParsing = true;
                        String sourceNameForwardSlashes = sourceFileName.replace('\\', '/');
                        Storage source = (Storage)sourcesBeingCompiled.get(sourceNameForwardSlashes);
                        if (source == null) {
                            source = new FileStorage(new File(sourceNameForwardSlashes));
                            sourcesBeingCompiled.put(sourceNameForwardSlashes, source);
                            log.clear(source);
                        }
                        if (!sourcesParsed.add(sourceNameForwardSlashes) || !UnifiedBuildSystem.showCompileProgress) continue;
                        String compileMsg = "  " + CompArb.format(112, sourceFileName) + Ojc.this.eolSeparator;
                        JCompiler.getInstance().getOutputLog().log((Object)compileMsg);
                        continue;
                    }
                    if (lowerCaseLine.startsWith("javac:")) {
                        log.error(null, 0, 0, 0, line);
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    if (lowerCaseLine.startsWith("javac ")) {
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    if (line.startsWith("[")) {
                        if (!this.reallyVerboseOutput) continue;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    if (!this.startedParsing && lowerCaseLine.startsWith("could ") || lowerCaseLine.startsWith("error") || lowerCaseLine.startsWith("unrecognized") || lowerCaseLine.startsWith("invalid")) {
                        if (!this.errorsAtStartup) {
                            log.error(null, 0, 0, 0, line);
                        }
                        this.errorsAtStartup = true;
                        JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                        continue;
                    }
                    if (this.startedParsing && !this.printMoreExtensiveOutput) continue;
                    JCompiler.getInstance().getOutputLog().log((Object)(line + Ojc.this.eolSeparator));
                }
                this.checkForTermination();
            }

            private String getLine(StringBuffer sb) {
                char c;
                int j;
                char c2;
                int i;
                for (i = 0; i < sb.length() && ((c2 = sb.charAt(i)) == '\r' || c2 == '\n'); ++i) {
                }
                for (j = i; j < sb.length() && (c = sb.charAt(j)) != '\r' && c != '\n'; ++j) {
                }
                String result = i == j ? null : sb.substring(i, j);
                sb.delete(0, j);
                return result;
            }

            private void checkForTermination() {
                if (Thread.currentThread().isInterrupted()) {
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            SimpleProcess simpleProcess = javacProcess;
                            synchronized (simpleProcess) {
                                if (javacProcess != null) {
                                    javacProcess.getRunProcess().terminate();
                                }
                            }
                        }
                    }.start();
                }
            }

            public Component getGUI() {
                return null;
            }

            protected void requestShow() {
            }

            public void show() {
            }

            public boolean isVisible() {
                return true;
            }
        }
        JavacLogInfo javacLogInfo = new JavacLogInfo(outPath, javacProcess, reallyVerboseOutput[0], printMoreExtensiveOutput);
        javacProcess.setLogPage((LogPage)javacLogInfo);
        int n = javacProcess.execAndWait();
        SimpleProcess jProcess = javacProcess;
        forwardStorPath = javacProcess;
        synchronized (forwardStorPath) {
            jProcess = null;
        }
        if (n < 0) {
            log.error(null, 0, 0, 0, CompArb.getString(123));
        }
        rm.redefineClassMap(jprj, log);
        this.addSMAPs(sources, outPath);
        UnifiedBuildSystem buildSystem = UnifiedBuildSystem.getInstance();
        for (Storage storage : sourcesBeingCompiled.values()) {
            buildSystem.markTranslated(this, storage);
        }
        sourcesBeingCompiled.clear();
        return n == 0 ? n : (log.nerrors() > 0 ? log.nerrors() : 1);
    }

    private String getFileNameFromOutput(String line, String extension) {
        int endIndex = line.lastIndexOf(extension);
        if (endIndex > 0) {
            char c;
            if ((endIndex += extension.length()) < line.length() && (c = line.charAt(endIndex)) != ']' && !Character.isWhitespace(c)) {
                return null;
            }
            String changedLine = line.replace('\\', '/');
            int startIndex = changedLine.indexOf(47);
            if (startIndex >= 0) {
                char c2;
                while (startIndex >= 0 && (c2 = changedLine.charAt(startIndex)) != '[' && !Character.isWhitespace(c2)) {
                    --startIndex;
                }
                return line.substring(++startIndex, endIndex);
            }
        }
        return null;
    }

    private ArrayList<Storage> checkDependencies(Project jprj, JavaDependencyProvider dp, File depFile, ArrayList<Storage> sources, boolean rebuild, String sourcePath) {
        File file;
        if (depFile.exists()) {
            try {
                dp.load(depFile);
            }
            catch (IOException e) {
                dp.reinit();
            }
        }
        ArrayList fileList = new ArrayList();
        ArrayList<StorageJavaFileObject> javaFileObjects = new ArrayList<StorageJavaFileObject>();
        HashMap<File, Storage> sourceMap = new HashMap<File, Storage>(sources.size());
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        for (Storage s : sources) {
            String p = s.getPath();
            file = new File(p);
            sourceMap.put(file, s);
            fileList.add(file);
            StorageJavaFileObject storageJavaFileObject = new StorageJavaFileObject(null, s, buildSysConfig.getCurrentEncoding());
            this.dependencyJavaFileObjects.put(s, (JavaFileObject)storageJavaFileObject);
            javaFileObjects.add(storageJavaFileObject);
        }
        fileList = dp.updateData(fileList, javaFileObjects, rebuild, sourcePath);
        sources.clear();
        ArrayList c = rebuild ? fileList : dp.getDependants(fileList, true);
        for (Object ofile : c) {
            file = (File)ofile;
            Storage stor = (Storage)sourceMap.get(file);
            if (stor != null) {
                sources.add(stor);
                continue;
            }
            sources.add((Storage)new FileStorage(file));
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int translate(Project prj, boolean rebuild, ArrayList<Storage> sources, ArrayList<Storage> results) {
        try {
            this.OJC_COMPILE_OUT_OF_PROCESS = System.getProperty("OJC_COMPILE_OUT_OF_PROCESS") != null;
            this.APPS_WRITE_CLASSPATH_TO_DIR = System.getProperty("APPS_WRITE_CLASSPATH_TO_DIR");
            int n = this.translateImpl(prj, rebuild, sources, results);
            return n;
        }
        finally {
            this.additionalCompilerOptions = null;
            this.dependencyJavaFileObjects.clear();
            this.OJC_COMPILE_OUT_OF_PROCESS = false;
            this.APPS_WRITE_CLASSPATH_TO_DIR = null;
        }
    }

    public int translateImpl(Project prj, boolean rebuild, ArrayList<Storage> sources, ArrayList<Storage> results) {
        UnifiedBuildSystem.getInstance().beginMarking(this);
        Translator.Log log = this._log;
        Project jprj = prj;
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)jprj);
        JDK jdk = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK();
        BuildSystemConfiguration buildSystemConfiguration = BuildSystemConfiguration.getInstance((PropertyStorage)jprj);
        if (optionManager.getCurrentCompiler().equalsIgnoreCase("javac")) {
            int compileResult;
            VersionNumber projectJdkVersionNumber;
            File depFile = BuildSystemUtilities.getCdiFile(prj);
            String encoding = buildSystemConfiguration.getCurrentEncoding();
            boolean cdiHashCodes = JCompilerUtils.isBuildProjectAndDependentsAfterSave();
            JavaDependencyProvider dp = new JavaDependencyProvider(encoding, cdiHashCodes);
            String source = buildSystemConfiguration.getSource();
            if (!source.equals("Default")) {
                dp.setSourceJdk(source);
            }
            Assert.println((String)("**** rebuild value is " + rebuild));
            String sourcePath = Helpers.urlPathToString(false, log, PathsConfiguration.getInstance((Project)jprj).getProjectSourcePath(), File.pathSeparator);
            sourcePath = sourcePath.trim();
            sources = this.checkDependencies(jprj, dp, depFile, sources, rebuild, sourcePath);
            if (sources.size() <= 0) {
                JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(45) + "\n"));
                return 0;
            }
            int errCnt = log.nerrors();
            boolean useInProcess = !buildSystemConfiguration.getOutOfProcess() && !this.OJC_COMPILE_OUT_OF_PROCESS;
            File toolsJarWithJavac = null;
            VersionNumber versionNumber = projectJdkVersionNumber = jdk != null ? jdk.getJavaVersion() : null;
            if (useInProcess && !this.projectUsesDefaultJdk(jprj)) {
                useInProcess = false;
                if (projectJdkVersionNumber != null) {
                    JdkVersion runningIdeJdkVersion = JavaParser.getJdkOfIde();
                    JdkVersion projectJdkVersion = JdkVersion.getJdkVersion((String)projectJdkVersionNumber.toString());
                    if (projectJdkVersion.isHigherVersion(JdkVersion.JDK_1_5) && projectJdkVersion.isLowerVersion(JdkVersion.JDK_9)) {
                        toolsJarWithJavac = this.getProjectsToolJarWithJavac(jdk);
                        if (toolsJarWithJavac != null) {
                            useInProcess = this.canUseProjectsJavac(projectJdkVersion, runningIdeJdkVersion);
                        } else if (!PlatformUtils.isMac() || projectJdkVersion.isHigherOrEqualVersion(JdkVersion.JDK_1_7)) {
                            log.warning(null, 0, 0, 0, CompArb.getString(110));
                        } else {
                            log.warning(null, 0, 0, 0, CompArb.getString(129));
                        }
                    }
                }
            }
            if ((compileResult = !useInProcess ? this.runJavacOutOfProcess(jprj, optionManager, sources, results, log, sourcePath) : this.runJavacInProcess(jprj, toolsJarWithJavac, optionManager, sources, results, log, sourcePath)) == 0) {
                if (errCnt == log.nerrors()) {
                    try {
                        File dir = depFile.getParentFile();
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        dp.save(depFile);
                    }
                    catch (IOException e) {
                        new Exception("Dependency provider error, " + depFile.getPath() + " may be readonly").printStackTrace();
                    }
                }
                return 0;
            }
            if (compileResult != 0 && log.nerrors() == 0) {
                log.error(null, 0, 0, 0, CompArb.getString(155));
            }
            return 1;
        }
        log.error(null, 0, 0, 0, CompArb.getString(117));
        return log.nerrors();
    }

    private boolean projectUsesDefaultJdk(Project jprj) {
        JDK jdk = JProjectLibraries.getInstance((PropertyStorage)jprj).getJDK();
        if (jdk == JLibraryManager.getDefaultJDK()) {
            return ToolProvider.getSystemJavaCompiler() != null;
        }
        return false;
    }

    private File getProjectsToolJarWithJavac(JDK jdk) {
        URL url;
        if (jdk != null && (url = jdk.getSDKBinDir()) != null) {
            String path = URLFileSystem.getPlatformPathName((URL)url);
            String[] relativePaths = new String[]{"../lib/tools.jar", "../../Classes/classes.jar"};
            for (int x = 0; x < 2; ++x) {
                File jarWithJavac = new File(path, relativePaths[x]);
                try {
                    jarWithJavac = jarWithJavac.getCanonicalFile();
                    if (jarWithJavac.exists()) {
                        return jarWithJavac;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!PlatformUtils.isMac()) break;
            }
        }
        return null;
    }

    private boolean canUseProjectsJavac(JdkVersion projectJdkVersion, JdkVersion runningIdeJdkVersion) {
        if (projectJdkVersion.isLowerOrEqualVersion(runningIdeJdkVersion)) {
            return true;
        }
        JCompiler.getInstance().getOutputLog().log((Object)(CompArb.getString(121) + this.eolSeparator));
        return false;
    }

    private String prettifyCommandLine(String cmdLine) {
        String[] tokens = this.tokenizeCommandLine(cmdLine);
        return JDevJavaCompiler.prettifyCommandLine(Arrays.asList(tokens));
    }

    private String[] tokenizeCommandLine(String cmdLine) {
        StringBuilder buf = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>();
        int len = cmdLine.length();
        boolean inString = false;
        for (int pointer = 0; pointer < len; ++pointer) {
            char c = cmdLine.charAt(pointer);
            if (c == '\"') {
                if (!inString) {
                    if (buf.length() > 0) {
                        tokens.add(buf.toString());
                        buf.setLength(0);
                    }
                    buf.append(c);
                    inString = true;
                    continue;
                }
                buf.append(c);
                tokens.add(buf.toString());
                buf.setLength(0);
                inString = false;
                continue;
            }
            if (inString) {
                if (c == '\\' && pointer < len - 1) {
                    buf.append(c);
                    c = cmdLine.charAt(++pointer);
                }
                buf.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) {
                buf.append(c);
                continue;
            }
            if (buf.length() <= 0) continue;
            tokens.add(buf.toString());
            buf.setLength(0);
        }
        if (buf.length() > 0) {
            tokens.add(buf.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private String replaceEolSeparator(String str, char newChar) {
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        boolean doReplacement = true;
        for (int index = 0; index < len; ++index) {
            char c = str.charAt(index);
            if (c != '\n' && c != '\r') {
                buf.append(c);
                doReplacement = true;
                continue;
            }
            if (!doReplacement) continue;
            buf.append(newChar);
            doReplacement = false;
        }
        return buf.toString();
    }
}

