/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeClipboard;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekableTree;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.GraphicsUtils;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JarStorage;
import oracle.jdevimpl.compiler.JCompilerUtils;
import oracle.jdevimpl.java.util.JavaCodePeek;
import oracle.ojc.interfaces.Storage;

public class CompilerPage
extends DefaultLogPage
implements ActiveViewListener,
Observer {
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
    private DefaultTreeModel model = new DefaultTreeModel(this.root);
    private HashMap urlOffsetMarkTable = new HashMap();
    private HashMap urlTreeNodeTable = new HashMap();
    private boolean createWorkspaceNodes;
    private boolean createProjectNodes = true;
    private static final int MAX_ASYNC_MESSAGES = 100;
    private static final int ASYNC_THREAD_SLEEP = 1000;
    private ArrayList asyncMessages = new ArrayList(100);
    private Thread updateThread = null;
    private CompilerPageController controller;

    public CompilerPage() {
        this("CompilerPageId", CompArb.getString(40), null);
    }

    public CompilerPage(String pageId, String pageName, Icon icon, int menuOptions) {
        super(new ViewId(pageId, pageName), icon, false, menuOptions);
        this.getTree().setCellRenderer(new MessageCellRenderer());
        this.setModel(this.model);
        this.getTree().getSelectionModel().setSelectionMode(2);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
    }

    public CompilerPage(String pageId, String pageName, Icon icon) {
        this(pageId, pageName, icon, HIDE_FIX_SOURCE_MENU);
    }

    public void log(Object msg) {
        if (!(msg instanceof IdeLog.Message)) {
            this.requestShow();
        }
        this.logMsg(msg);
    }

    public Controller getController() {
        if (this.controller == null) {
            this.controller = new CompilerPageController(super.getController());
        }
        return this.controller;
    }

    protected void setCreateWorkspaceNodes(boolean value) {
        this.createWorkspaceNodes = value;
    }

    protected void setCreateProjectNodes(boolean value) {
        this.createProjectNodes = value;
    }

    protected Icon getLeafIcon(IdeLog.Message msg) {
        if (msg != null) {
            if (msg.isWarning()) {
                return OracleIcons.getIcon((String)"warning.png");
            }
            if (msg.isError()) {
                return OracleIcons.getIcon((String)"error.png");
            }
        }
        return null;
    }

    protected String treeNodeToString(Object treeNodeArg) {
        Object object;
        if (treeNodeArg instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)treeNodeArg).isLeaf() && (object = ((DefaultMutableTreeNode)treeNodeArg).getUserObject()) instanceof MsgTreeNode && (object = ((MsgTreeNode)object).getMessage()) instanceof IdeLog.Message) {
            return String.valueOf(((IdeLog.Message)object).msg);
        }
        return super.treeNodeToString(treeNodeArg);
    }

    protected String fixMessages(IdeLog.Message m) {
        String msg = m.msg;
        msg = msg.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        return msg;
    }

    private Editor openPreferredEditor(Context context) {
        EditorManager editorManager = EditorManager.getEditorManager();
        if (context != null && context.getNode() instanceof TextNode) {
            try {
                Editor editor = editorManager.openEditorInFrame(CodeEditor.class, context);
                if (editor != null) {
                    return editor;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return editorManager.openDefaultEditorInFrame(context);
    }

    private Editor openPreferredEditor(URL url, Workspace wsp, Project prj) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            return this.openPreferredEditor(wsp, prj, node);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
            Assert.println((String)("oracle.jdeveloper.compiler.CompilePage.openURLInCodeEditor() - " + e.toString()));
            return null;
        }
    }

    protected Editor getEditorFromTreeNode(DefaultMutableTreeNode treeNode, Workspace wsp, Project prj) {
        if (treeNode == null) {
            return null;
        }
        if (!(treeNode.getUserObject() instanceof MsgTreeNode)) {
            return null;
        }
        MsgTreeNode node = (MsgTreeNode)treeNode.getUserObject();
        Object nodeData = node.getNodeData();
        Editor result = null;
        if (nodeData instanceof Storage) {
            Storage fname = (Storage)nodeData;
            if (fname instanceof IdeStorage) {
                result = this.openPreferredEditor(wsp, prj, ((IdeStorage)fname).node);
            } else if (fname instanceof JarStorage) {
                result = this.openPreferredEditor(((JarStorage)fname).getURL(), wsp, prj);
            } else {
                URL url = this.getFileStorageURL(fname);
                if (url != null) {
                    result = this.openPreferredEditor(url, wsp, prj);
                }
            }
        } else if (node.getURL() != null) {
            result = this.openPreferredEditor(node.getURL(), wsp, prj);
        }
        return result;
    }

    private Editor openPreferredEditor(Workspace workspace, Project project, Node node) {
        if (node == null) {
            return null;
        }
        Context preferredContext = null;
        for (Object e : EditorManager.getEditorManager().getAllEditors()) {
            URL codeEditorWorkspaceURL;
            CodeEditor editor;
            Context context;
            if (!(e instanceof CodeEditor) || (context = (editor = (CodeEditor)e).getContext()) == null || context.getNode() != node) continue;
            URL workspaceURL = workspace != null ? workspace.getURL() : null;
            Workspace codeEditorWorkspace = context.getWorkspace();
            URL uRL = codeEditorWorkspaceURL = codeEditorWorkspace != null ? codeEditorWorkspace.getURL() : null;
            if (workspaceURL != null && codeEditorWorkspaceURL != null && !URLFileSystem.equals((URL)workspaceURL, (URL)codeEditorWorkspaceURL)) continue;
            preferredContext = context;
            break;
        }
        if (preferredContext == null) {
            preferredContext = Context.newIdeContext((Node)node);
            preferredContext.setWorkspace(workspace);
            preferredContext.setProject(project);
        }
        return this.openPreferredEditor(preferredContext);
    }

    protected URL getFileStorageURL(Storage storage) {
        URL url;
        if (storage instanceof IdeStorage && (url = ((IdeStorage)storage).node.getURL()) != null) {
            return url;
        }
        File file = new File(storage.getPath());
        if (file.exists()) {
            return URLFactory.newFileURL((File)file);
        }
        return null;
    }

    protected void fixObject(Object obj) {
        this.activateObject(obj);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
        MsgTreeNode msgNode = (MsgTreeNode)treeNode.getUserObject();
        msgNode.invokeFixEvent();
    }

    protected boolean canFixObject(DefaultMutableTreeNode node) {
        MsgTreeNode msgNode = (MsgTreeNode)node.getUserObject();
        return msgNode.canInvokeFixEvent();
    }

    protected JTree createTree() {
        PeekableTree tree = new PeekableTree(){

            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return CompilerPage.this.treeNodeToString(value);
            }

            public Peek createPeek(TreePath tp) {
                URL url;
                MsgTreeNode msgNode;
                IdeLog.Message msg;
                CodePeek peek = null;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (userObject instanceof MsgTreeNode && (msg = (msgNode = (MsgTreeNode)userObject).getMessage()) != null && msg.fname != null && (url = CompilerPage.this.getFileStorageURL(msg.fname)) != null) {
                    peek = JavaCodePeek.createCodePeek((Project)msg.getProject(), (URL)url, (int)msg.line, (String)URLFileSystem.getFileName((URL)url), (JComponent)((Object)this), (Rectangle)this.getPathBounds(tp).intersection(this.getVisibleRect()), (String)"caret-line-highlight");
                }
                return peek;
            }
        };
        tree.setModel(this.model);
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void activateObject(Object obj) {
        treeNode = (DefaultMutableTreeNode)obj;
        msgNode = (MsgTreeNode)treeNode.getUserObject();
        if (msgNode.invokeActivateEvent()) {
            return;
        }
        msg = msgNode.getMessage();
        if (msg == null) {
            return;
        }
        point = null;
        editor = this.getEditorFromTreeNode((DefaultMutableTreeNode)treeNode.getParent(), msg.workspace, msg.project);
        if (editor instanceof CodeEditor) {
            ceditor = (CodeEditor)editor;
            line = msg.line;
            col = msg.col;
            if (msgNode.offsetMark == null) {
                this.activeViewChanged(null);
            }
            if (msgNode.offsetMark != null && msgNode.getURL() != null) {
                tnode = (TextNode)NodeFactory.find((URL)msgNode.getURL());
                if (tnode == null) {
                    return;
                }
                try {
                    tbuf = tnode.acquireTextBuffer();
                    lmap = tbuf.getLineMap();
                    line = lmap.getLineFromOffset(msgNode.offsetMark.getOffset()) + 1;
                    if (col <= 0) ** GOTO lbl39
                    --col;
                }
                catch (Throwable var11_14) {
                }
                finally {
                    tnode.releaseTextBuffer();
                }
            } else if (line == 0 && col > 0) {
                line = ceditor.getLineFromOffset(col) + 1;
                lineStartOffset = ceditor.getLineStartOffset(line - 1);
                col = lineStartOffset < col ? col - lineStartOffset : 1;
            } else if (col > 0) {
                --col;
            }
lbl39:
            // 7 sources

            ceditor.gotoLine(line, col, false);
            Ide.getStatusBar().setText(msg.msg);
            point = new CodeNavigationPoint();
        } else if (editor != null) {
            point = new DefaultNavigationPoint();
        }
        if (point != null && (mgr = NavigationManager.getNavigationManager()) != null) {
            point.setContext(editor.getContext());
            try {
                mgr.navigateTo((NavigationPoint)point);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_com_logwindow_html");
    }

    private JTree inScopeGetTree() {
        return this.getTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logMsg(Object msg) {
        if (msg instanceof IdeLog.Message) {
            ArrayList arrayList = this.asyncMessages;
            synchronized (arrayList) {
                this.asyncMessages.add(msg);
                if (this.asyncMessages.size() == 100) {
                    this.processAsyncMsgQueue(100);
                }
            }
        } else {
            super.logMsg(msg);
        }
    }

    public void startAsynchronousLogging() {
        this.updateThread = new Thread("Log Page Updater"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (CompilerPage.this.updateThread == this) {
                    try {
                        Thread.sleep(1000L);
                        ArrayList arrayList = CompilerPage.this.asyncMessages;
                        synchronized (arrayList) {
                            if (CompilerPage.this.asyncMessages.size() > 0) {
                                CompilerPage.this.processAsyncMsgQueue(100);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        int priority = this.updateThread.getPriority();
        if (priority > 1) {
            this.updateThread.setPriority(priority - 1);
        }
        this.updateThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAsynchronousLogging() {
        this.updateThread = null;
        ArrayList arrayList = this.asyncMessages;
        synchronized (arrayList) {
            this.asyncMessages.clear();
        }
    }

    public void finishAsynchronousLogging() {
        this.updateThread = null;
        this.processAsyncMsgQueue(-1);
        if (this.root.getChildCount() > 0) {
            this.requestShow();
        }
    }

    public boolean isShowingTree() {
        return this.getCurrentView() == this.getTree();
    }

    private void processAsyncMsgQueue(final int max) {
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList arrayList = CompilerPage.this.asyncMessages;
                synchronized (arrayList) {
                    int size = CompilerPage.this.asyncMessages.size();
                    int num = max > 0 && size > max ? max : size;
                    for (int i = 0; i < num; ++i) {
                        CompilerPage.this.addMsg((IdeLog.Message)CompilerPage.this.asyncMessages.remove(0));
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    private void removeMessages(IdeLog.Message msg) {
        DefaultMutableTreeNode node = this.getProjectNode(this.root, msg.project, false);
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode projectNode = node;
        if (msg.fname != null) {
            DefaultMutableTreeNode parent = node;
            if ((node = this.getFileNode(parent, msg.fname, false)) == null) {
                return;
            }
            if (parent.getChildCount() == 1) {
                node = parent;
            }
        }
        this.recursivelyRemoveNode(node, true);
        if (node == projectNode && msg.project != null) {
            msg.project.detach((Observer)this);
        }
    }

    private void addMsg(IdeLog.Message msg) {
        DefaultMutableTreeNode parent;
        JTree tree = this.inScopeGetTree();
        if (this.getCurrentView() != tree) {
            this.setCurrentView(tree);
        }
        if (msg.isStarting()) {
            for (int i = this.root.getChildCount() - 1; i >= 0; --i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.root.getChildAt(i);
                if (((MsgTreeNode)child.getUserObject()).getMessage() == null) continue;
                this.recursivelyRemoveNode(child, true);
            }
            return;
        }
        if (msg.isCompleted()) {
            if (this.root.getChildCount() == 0) {
                View view = Ide.getMainWindow().getLastActiveView();
                LogManager.getLogManager().removePage((LogPage)this);
                if (view == this) {
                    IdeUtil.tryToRestoreFocus(null);
                }
            }
            return;
        }
        if (msg.isRemove()) {
            this.removeMessages(msg);
            return;
        }
        if (this.root.getChildCount() == 0) {
            final Component childComponent = GraphicsUtils.getFocusedChildComponent((Component)Ide.getMainWindow());
            if (!LogManager.getLogManager().isLogVisible()) {
                LogManager.getLogManager().showLog();
            }
            if (!this.isVisible()) {
                this.requestShow();
            }
            if (childComponent != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeUtil.tryToRestoreFocus((Component)childComponent);
                    }
                });
            }
        }
        if (Ide.getMainWindow().getLastActiveView() == LogManager.getLogManager().getLogWindow()) {
            IdeUtil.tryToRestoreFocus((Component)tree);
        }
        if ((parent = this.getCachedFileNode(msg.fname)) == null) {
            DefaultMutableTreeNode fileNode;
            DefaultMutableTreeNode projectNode;
            parent = this.root;
            if (this.createWorkspaceNodes && msg.workspace != null) {
                parent = this.getWorkspaceNode(parent, msg.workspace.getURL(), true);
            }
            if (this.createProjectNodes && msg.project != null && (projectNode = this.getProjectNode(parent, msg.project, true)) != null) {
                parent = projectNode;
            }
            if (msg.fname != null && (fileNode = this.getFileNode(parent, msg.fname, true)) != null) {
                parent = fileNode;
            }
        }
        if (msg.isNoDetails()) {
            tree.makeVisible(new TreePath(parent.getPath()));
            return;
        }
        String str = this.fixMessages(msg);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new MsgTreeNode(str, msg));
        String nodeString = node.toString();
        for (int i = parent.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (!child.toString().equals(nodeString)) continue;
            return;
        }
        if (msg.isError()) {
            int lastError = this.getLastErrorIndex(parent, false);
            if (lastError == -1) {
                if (msg.fname != null) {
                    DefaultTreeModel model;
                    int newIndex;
                    DefaultMutableTreeNode grandparent = (DefaultMutableTreeNode)parent.getParent();
                    int oldIndex = grandparent.getIndex(parent);
                    int lastErrorFile = this.getLastErrorIndex(grandparent, true);
                    int n = newIndex = lastErrorFile == -1 ? 0 : lastErrorFile + 1;
                    if (newIndex != oldIndex && (model = (DefaultTreeModel)tree.getModel()) != null) {
                        grandparent.remove(parent);
                        model.nodesWereRemoved(grandparent, new int[]{oldIndex}, new Object[]{parent});
                        grandparent.insert(parent, newIndex);
                        model.nodesWereInserted(grandparent, new int[]{newIndex});
                    }
                }
                parent.insert(node, 0);
            } else {
                parent.insert(node, lastError + 1);
            }
        } else {
            parent.add(node);
        }
        DefaultMutableTreeNode p = parent;
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        if (model != null) {
            model.nodesWereInserted(p, new int[]{p.getIndex(node)});
        }
        tree.makeVisible(new TreePath(node.getPath()));
    }

    private int getLastErrorIndex(DefaultMutableTreeNode parent, boolean checkChildren) {
        int index = -1;
        Enumeration<TreeNode> children = parent.children();
        int i = 0;
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child;
            IdeLog.Message msg;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            Object userObject = node.getUserObject();
            if (userObject instanceof MsgTreeNode && ((MsgTreeNode)userObject).getMessage() != null && ((MsgTreeNode)userObject).getMessage().isError()) {
                index = i;
            } else if (checkChildren && node.getChildCount() > 0 && (msg = ((MsgTreeNode)(child = (DefaultMutableTreeNode)node.getChildAt(0)).getUserObject()).getMessage()) != null && msg.isError()) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    private DefaultMutableTreeNode getWorkspaceNode(DefaultMutableTreeNode parent, URL workspaceURL, boolean insert) {
        DefaultMutableTreeNode workspaceNode = null;
        Enumeration<TreeNode> workspaces = parent.children();
        while (workspaces.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)workspaces.nextElement();
            URL url = ((MsgTreeNode)node.getUserObject()).getURL();
            if (!URLFileSystem.equals((URL)url, (URL)workspaceURL)) continue;
            workspaceNode = node;
            break;
        }
        if (workspaceNode == null && insert) {
            String str = CompArb.format(67, URLFileSystem.getPlatformPathName((URL)workspaceURL));
            MsgTreeNode msgNode = new MsgTreeNode(str, null);
            msgNode.setURL(workspaceURL);
            workspaceNode = new DefaultMutableTreeNode(msgNode);
            parent.add(workspaceNode);
            DefaultMutableTreeNode n = workspaceNode;
            DefaultTreeModel model = (DefaultTreeModel)this.inScopeGetTree().getModel();
            if (model != null) {
                model.nodesWereInserted(parent, new int[]{parent.getIndex(n)});
            }
        }
        return workspaceNode;
    }

    private DefaultMutableTreeNode getProjectNode(DefaultMutableTreeNode parent, Project project, boolean insert) {
        DefaultTreeModel model;
        JTree currentTree;
        URL projectURL = project.getURL();
        DefaultMutableTreeNode projectNode = null;
        Enumeration<TreeNode> projects = parent.children();
        while (projects.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)projects.nextElement();
            URL url = ((MsgTreeNode)node.getUserObject()).getURL();
            if (!URLFileSystem.equals((URL)url, (URL)projectURL)) continue;
            projectNode = node;
            break;
        }
        if (projectNode == null && insert && (currentTree = this.inScopeGetTree()) != null && (model = (DefaultTreeModel)currentTree.getModel()) != null) {
            String str = CompArb.format(64, URLFileSystem.getPlatformPathName((URL)projectURL));
            MsgTreeNode msgNode = new MsgTreeNode(str, null);
            msgNode.setURL(projectURL);
            projectNode = new DefaultMutableTreeNode(msgNode);
            parent.add(projectNode);
            DefaultMutableTreeNode n = projectNode;
            model.nodesWereInserted(parent, new int[]{parent.getIndex(n)});
            project.attach((Observer)this);
        }
        return projectNode;
    }

    private DefaultMutableTreeNode getCachedFileNode(Storage storage) {
        URL url;
        if (storage != null && (url = this.getFileStorageURL(storage)) != null) {
            return (DefaultMutableTreeNode)this.urlTreeNodeTable.get(url);
        }
        return null;
    }

    protected DefaultMutableTreeNode getFileNode(DefaultMutableTreeNode parent, Storage storage, boolean insert) {
        URL url = this.getFileStorageURL(storage);
        DefaultMutableTreeNode fileNode = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(url);
        if (fileNode == null && insert) {
            MsgTreeNode msgNode = new MsgTreeNode(storage.toString(), null);
            msgNode.setURL(url);
            fileNode = new DefaultMutableTreeNode(msgNode);
            parent.add(fileNode);
            DefaultMutableTreeNode n = fileNode;
            DefaultTreeModel model = (DefaultTreeModel)this.inScopeGetTree().getModel();
            if (model != null) {
                model.nodesWereInserted(parent, new int[]{parent.getIndex(n)});
            }
            this.urlTreeNodeTable.put(url, fileNode);
        }
        return fileNode;
    }

    protected void updateTreeModel(Collection message) {
        try {
            HelpUtils.setHelpID((JComponent)this.inScopeGetTree(), (String)"f1_com_logwindow_html");
            SwingUtilities.invokeLater(new CreateLogTree(message));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOffsetMarkTable(URL url, DefaultMutableTreeNode treeNode) {
        Node node = NodeFactory.find((URL)url);
        if (node instanceof TextNode) {
            TextNode tnode = (TextNode)node;
            try {
                TextBuffer tbuf = tnode.acquireTextBuffer();
                LineMap lmap = tbuf.getLineMap();
                int tCnt = treeNode.getChildCount();
                OffsetMark[] offsetMarks = new OffsetMark[tCnt];
                for (int i = 0; i < tCnt; ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeNode.getChildAt(i);
                    MsgTreeNode msgNode = (MsgTreeNode)child.getUserObject();
                    IdeLog.Message msg = msgNode.getMessage();
                    int offset = msg.line == 0 && msg.col > 0 ? msg.col : lmap.getLineStartOffset(msg.line - 1);
                    msgNode.setURL(url);
                    offsetMarks[i] = msgNode.offsetMark = tbuf.addOffsetMark(offset);
                }
                tnode.attach((Observer)this);
                this.urlOffsetMarkTable.put(url, offsetMarks);
            }
            catch (Throwable throwable) {
            }
            finally {
                tnode.releaseTextBuffer();
            }
        }
    }

    protected void clearUrlOffsetMarkNode(Node node, OffsetMark[] offsetMarks) {
        if (node instanceof TextNode) {
            TextBuffer tbuf;
            TextNode tnode = (TextNode)node;
            if (tnode != null && tnode.isOpen() && (tbuf = tnode.acquireTextBuffer()) != null) {
                for (int j = 0; j < offsetMarks.length; ++j) {
                    tbuf.removeOffsetMark(offsetMarks[j]);
                }
            }
            tnode.detach((Observer)this);
        }
    }

    protected void clearUrlOffsetMarkTable() {
        Set set = this.urlOffsetMarkTable.entrySet();
        if (set != null && set.size() > 0) {
            Object[] entries = set.toArray();
            for (int i = 0; i < entries.length; ++i) {
                Map.Entry entry = (Map.Entry)entries[i];
                URL url = (URL)entry.getKey();
                Node node = NodeFactory.find((URL)url);
                OffsetMark[] om = (OffsetMark[])entry.getValue();
                if (om == null) continue;
                this.clearUrlOffsetMarkNode(node, om);
            }
        }
        this.urlOffsetMarkTable.clear();
        this.urlTreeNodeTable.clear();
    }

    private void removeNode(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MsgTreeNode) {
            this.urlTreeNodeTable.remove(((MsgTreeNode)userObject).getURL());
        }
        node.setUserObject(null);
        this.model.removeNodeFromParent(node);
    }

    private void recursivelyRemoveNode(DefaultMutableTreeNode node, boolean itself) {
        for (int i = node.getChildCount(); i > 0; --i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i - 1);
            if (!child.isLeaf()) {
                this.recursivelyRemoveNode(child, false);
            }
            this.removeNode(child);
        }
        if (itself) {
            this.removeNode(node);
        }
    }

    private void clearNodes() {
        this.recursivelyRemoveNode(this.root, false);
        this.getTree().setModel(this.model);
        this.clearUrlOffsetMarkTable();
    }

    public void clearAll() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    CompilerPage.this.getTree().scrollRowToVisible(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CompilerPage.super.clearAll();
                CompilerPage.this.clearNodes();
                CompilerPage.this.logText("");
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    public String getToolTip() {
        return CompArb.getString(41);
    }

    public void activeViewChanged(ActiveViewEvent e) {
        View editor;
        View view = editor = e != null ? e.getNewView() : Ide.getMainWindow().getLastActiveView();
        if (editor == null || !(editor instanceof CodeEditor)) {
            return;
        }
        Context ctxt = ((CodeEditor)editor).getContext();
        if (ctxt == null || ctxt.getNode() == null || ctxt.getNode().getURL() == null) {
            return;
        }
        URL url = ctxt.getNode().getURL();
        DefaultMutableTreeNode tn = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(url);
        if (tn != null && this.urlOffsetMarkTable.get(url) == null) {
            this.setOffsetMarkTable(url, tn);
        }
    }

    public void update(final Object subject, UpdateMessage change) {
        int msgID = change.getMessageID();
        if (msgID == UpdateMessage.OBJECT_RELOADED) {
            if (subject instanceof TextNode) {
                DefaultMutableTreeNode tn;
                URL url = ((TextNode)subject).getURL();
                OffsetMark[] om = (OffsetMark[])this.urlOffsetMarkTable.get(url);
                if (om != null) {
                    this.clearUrlOffsetMarkNode((Node)subject, om);
                }
                if ((tn = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(url)) != null) {
                    this.setOffsetMarkTable(url, tn);
                }
            }
            return;
        }
        if (msgID == UpdateMessage.OBJECT_CLOSED) {
            if (subject instanceof Project) {
                ((Project)subject).detach((Observer)this);
                JCompilerUtils.invokeAsap(new Runnable(){

                    @Override
                    public void run() {
                        IdeLog.Message msg = new IdeLog.Message(null, (Project)subject, null, null, 0, 0, 0, 3);
                        CompilerPage.this.addMsg(msg);
                        msg = new IdeLog.Message(null, null, null, null, 0, 0, 0, 4);
                        CompilerPage.this.addMsg(msg);
                    }
                });
                return;
            }
            if (subject instanceof TextNode) {
                DefaultMutableTreeNode tn;
                URL url = ((TextNode)subject).getURL();
                OffsetMark[] om = (OffsetMark[])this.urlOffsetMarkTable.remove(url);
                if (om != null) {
                    this.clearUrlOffsetMarkNode((Node)subject, om);
                }
                if ((tn = (DefaultMutableTreeNode)this.urlTreeNodeTable.get(url)) != null) {
                    int tCnt = tn.getChildCount();
                    for (int i = 0; i < tCnt; ++i) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)tn.getChildAt(i);
                        MsgTreeNode msgNode = (MsgTreeNode)child.getUserObject();
                        msgNode.offsetMark = null;
                    }
                }
                return;
            }
        }
    }

    private class CompilerPageController
    implements Controller {
        private Controller parentController;

        private CompilerPageController(Controller parentController) {
            this.parentController = parentController;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId;
            if (action != null && (cmdId = action.getCommandId()) == 18) {
                Clipboard clipBoard = IdeClipboard.getClipboard();
                CompilerPage.this.getTree().getTransferHandler().exportToClipboard(CompilerPage.this.getTree(), clipBoard, 1);
                return true;
            }
            return this.parentController.handleEvent(action, context);
        }

        public boolean update(IdeAction action, Context context) {
            if (action == null) {
                return true;
            }
            int cmdId = action.getCommandId();
            if (cmdId == 18) {
                TreePath[] paths = CompilerPage.this.getTree().getSelectionPaths();
                boolean enabled = false;
                if (paths != null && paths.length > 0) {
                    for (int x = 0; x < paths.length; ++x) {
                        if (paths[x].getLastPathComponent() == null) continue;
                        enabled = true;
                        break;
                    }
                }
                action.setEnabled(enabled);
                return true;
            }
            if (cmdId == GOTO_SOURCE_CMD_ID && CompilerPage.this.getTree().getSelectionCount() > 1) {
                return false;
            }
            return this.parentController.update(action, context);
        }
    }

    protected static final class MsgTreeNode {
        private Object nodeData;
        private IdeLog.Message msg;
        private URL url;
        private Icon icon;
        OffsetMark offsetMark;

        MsgTreeNode(Object nodeData, IdeLog.Message msg) {
            this.nodeData = nodeData;
            this.msg = msg;
            this.url = null;
            this.offsetMark = null;
        }

        public Object getNodeData() {
            return this.nodeData;
        }

        public IdeLog.Message getMessage() {
            return this.msg;
        }

        public Project getProject() {
            return this.msg != null ? this.msg.project : null;
        }

        public Workspace getWorkspace() {
            return this.msg != null ? this.msg.workspace : null;
        }

        public boolean invokeFixEvent() {
            if (this.msg != null && this.msg.fixEvent != null) {
                this.msg.fixEvent.fix(this.msg);
                return true;
            }
            return false;
        }

        public boolean canInvokeFixEvent() {
            if (this.msg != null && this.msg.fixEvent != null) {
                return this.msg.fixEvent.canFix(this.msg);
            }
            return false;
        }

        public boolean invokeActivateEvent() {
            if (this.msg != null && this.msg.activateEvent != null) {
                this.msg.activateEvent.activate(this.msg);
                return true;
            }
            return false;
        }

        public String toString() {
            return this.nodeData.toString();
        }

        public URL getURL() {
            return this.url;
        }

        public void setURL(URL value) {
            this.url = value;
            Node node = NodeFactory.find((URL)this.url);
            boolean uncache = false;
            if (node == null) {
                try {
                    node = NodeFactory.findOrCreate((URL)value);
                    uncache = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (node != null) {
                this.icon = node.getIcon();
            }
            if (uncache) {
                NodeFactory.uncache((URL)this.url);
            }
        }

        public Icon getIcon() {
            return this.icon;
        }
    }

    final class CreateLogTree
    implements Runnable {
        private final Collection msgs;

        CreateLogTree(Collection msgs) {
            this.msgs = msgs;
        }

        @Override
        public void run() {
            ArrayList<IdeLog.Message> messages = this.msgs;
            if (this.msgs == null) {
                return;
            }
            CompilerPage.this.clearNodes();
            ArrayList<IdeLog.Message> newMessages = new ArrayList<IdeLog.Message>(messages.size());
            for (IdeLog.Message msg : messages) {
                if (!msg.isError()) continue;
                newMessages.add(msg);
            }
            for (IdeLog.Message msg : messages) {
                if (msg.isError()) continue;
                newMessages.add(msg);
            }
            messages = newMessages;
            for (IdeLog.Message m : messages) {
                CompilerPage.this.addMsg(m);
            }
        }
    }

    private final class MessageCellRenderer
    extends DefaultTreeCellRenderer {
        private MessageCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            MsgTreeNode node;
            Icon icon;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            if (leaf && obj instanceof MsgTreeNode) {
                Icon i;
                MsgTreeNode node2 = (MsgTreeNode)obj;
                if (node2 != null && (i = CompilerPage.this.getLeafIcon(node2.getMessage())) != null) {
                    this.setIcon(i);
                }
            } else if (obj instanceof MsgTreeNode && (icon = (node = (MsgTreeNode)obj).getIcon()) != null) {
                this.setIcon(icon);
            }
            this.setToolTipText(CompilerPage.this.treeNodeToString(value));
            return this;
        }
    }
}

