/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import java.util.Set;
import oracle.jdevimpl.compiler.TranslatorDefinition;

class BuildNode {
    int marker = 0;
    ArrayList<BuildNode> parents;
    ArrayList<BuildNode> children;
    String name;
    ArrayList<TranslatorDefinition> preProcessors;
    TranslatorDefinition translator;

    BuildNode(String name, TranslatorDefinition translator) {
        this.name = name;
        this.translator = translator;
        this.preProcessors = null;
        this.parents = new ArrayList(1);
        this.children = new ArrayList(1);
    }

    BuildNode(String name, Set<TranslatorDefinition> translators) {
        this.name = name;
        this.parents = new ArrayList(1);
        this.children = new ArrayList(1);
        int cnt = translators != null ? translators.size() : 0;
        this.preProcessors = cnt > 1 ? new ArrayList(cnt - 1) : null;
        this.translator = null;
        if (translators != null) {
            int i = 0;
            for (TranslatorDefinition t : translators) {
                if (this.translator == null && !t.isPreprocessor()) {
                    this.translator = t;
                } else if (i == cnt - 1 && this.translator == null) {
                    this.translator = t;
                } else {
                    this.preProcessors.add(t);
                }
                ++i;
            }
        }
    }

    boolean containsTranslator(TranslatorDefinition translator) {
        return translator == this.translator || this.preProcessors != null && this.preProcessors.contains((Object)translator);
    }

    void addTranslator(TranslatorDefinition translator) {
        if (this.preProcessors == null) {
            this.preProcessors = new ArrayList(1);
        }
        if (translator.isPreprocessor()) {
            this.preProcessors.add(translator);
        } else {
            assert (this.translator.isPreprocessor());
            this.preProcessors.add(this.translator);
            this.translator = translator;
        }
    }
}

