/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.util.Comparator;
import java.util.UUID;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.XMIBean;
import oracle.mof.xmi.XMIPropertyType;

public class XMIClass {
    public static final IdComparator COMPARATOR = new IdComparator();
    private String m_id;

    @XMIBean(type=XMIPropertyType.ID)
    public String getId() {
        if (this.m_id == null) {
            this.m_id = "id" + UUID.randomUUID().toString();
        }
        return this.m_id;
    }

    @XMIBean(type=XMIPropertyType.ID)
    public void setId(String id) {
        ContractUtils.checkNull(id, "Missing id");
        this.m_id = id;
    }

    public void clearId() {
        this.m_id = null;
    }

    public static class IdComparator
    implements Comparator<XMIClass> {
        @Override
        public int compare(XMIClass o1, XMIClass o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

