/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.em_cm;

import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanInfo;

public class ChangePlansModel
implements ComboBoxModel {
    private ArrayList<ChangePlanInfo> plans = new ArrayList(0);
    private ArrayList<ListDataListener> listenerList = new ArrayList(0);
    int selected = 0;

    public void clearList() {
        this.plans.clear();
        this.fireContentsChanged(this, 0, 0);
    }

    public void removeRow(ChangePlanInfo changePlanInfo) {
        if (this.plans.contains(changePlanInfo)) {
            this.plans.remove(changePlanInfo);
        }
        this.fireContentsChanged(this, 0, this.plans.size());
    }

    public void addRow(ChangePlanInfo changePlanInfo) {
        this.plans.add(changePlanInfo);
        this.fireContentsChanged(this, 0, this.plans.size());
    }

    public void addList(ChangePlanInfo[] changePlanInfoArray) {
        this.plans.clear();
        this.selected = 0;
        for (ChangePlanInfo changePlanInfo : changePlanInfoArray) {
            this.plans.add(changePlanInfo);
        }
        this.fireContentsChanged(this, 0, this.plans.size());
    }

    @Override
    public int getSize() {
        return this.plans.size();
    }

    @Override
    public Object getElementAt(int n) {
        if (n >= 0 && n < this.plans.size()) {
            return this.plans.get(n).getPlanOwner() + "/" + this.plans.get(n).getPlanName();
        }
        return null;
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        if (this.listenerList.contains(listDataListener)) {
            this.listenerList.remove(listDataListener);
        }
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object instanceof ChangePlanInfo) {
            ChangePlanInfo changePlanInfo = (ChangePlanInfo)object;
            for (int i = 0; i < this.plans.size(); ++i) {
                if (!changePlanInfo.getPlanName().equalsIgnoreCase(this.plans.get(i).getPlanName()) || !changePlanInfo.getPlanOwner().equalsIgnoreCase(this.plans.get(i).getPlanOwner())) continue;
                this.selected = i;
            }
        } else if (object instanceof String) {
            for (int i = 0; i < this.plans.size(); ++i) {
                if (!((String)object).equalsIgnoreCase(this.plans.get(i).getPlanOwner() + "/" + this.plans.get(i).getPlanName())) continue;
                this.selected = i;
            }
        } else if (object == null) {
            this.selected = -1;
        }
        this.fireContentsChanged(this, 0, this.selected);
    }

    public ChangePlanInfo getSelectedInfo() {
        if (this.plans.size() > 0 && this.selected != -1) {
            return this.plans.get(this.selected);
        }
        return null;
    }

    @Override
    public Object getSelectedItem() {
        if (this.plans.size() > 0 && this.selected != -1) {
            return this.plans.get(this.selected).getPlanOwner() + "/" + this.plans.get(this.selected).getPlanName();
        }
        return null;
    }

    protected synchronized void fireContentsChanged(Object object, int n, int n2) {
        ListDataEvent listDataEvent = new ListDataEvent(object, 0, n, n2);
        for (ListDataListener listDataListener : this.listenerList) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }
}

