/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.DESKey;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.DHPrivateKey;
import oracle.security.crypto.core.DHPublicKey;
import oracle.security.crypto.core.DSA;
import oracle.security.crypto.core.DSAPublicKey;
import oracle.security.crypto.core.ECPrivateKey;
import oracle.security.crypto.core.ECPublicKey;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.KeyPair;
import oracle.security.crypto.core.PSSAlgorithmIdentifier;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SHA;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class CryptoUtils {
    private static final int a = 0;
    private static final int b = 1;
    private static final int c = 2;

    public static PublicKey inputSPKI(byte[] byArray) throws IOException {
        return CryptoUtils.inputSPKI(new UnsyncByteArrayInputStream(byArray));
    }

    public static PublicKey inputSPKI(InputStream inputStream) throws IOException {
        PublicKey publicKey;
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(0));
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "publicKey");
        if (clazz == null) {
            throw new IOException("Unrecognized algorithm identifier.");
        }
        try {
            publicKey = (PublicKey)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Class does not implement PublicKey.");
        }
        ASN1Object aSN1Object = null;
        aSN1Object = algorithmIdentifier.getOID().equals(AlgID.ecKey.getOID()) ? aSN1Sequence.elementAt(1) : ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(((ASN1BitString)aSN1Sequence.elementAt(1)).getValue()));
        try {
            publicKey.initialize(algorithmIdentifier, aSN1Object);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
        return publicKey;
    }

    public static PublicKey inputSPKI(ASN1Sequence aSN1Sequence) throws IOException {
        return CryptoUtils.inputSPKI(new UnsyncByteArrayInputStream(Utils.toBytes(aSN1Sequence)));
    }

    public static oracle.security.crypto.core.PrivateKey inputPrivateKey(File file) throws IOException {
        return CryptoUtils.inputPrivateKey(new FileInputStream(file));
    }

    /*
     * Exception decompiling
     */
    public static oracle.security.crypto.core.PrivateKey inputPrivateKey(InputStream var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static KeyPair inputKeyPair(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        if (aSN1Sequence.size() == 9) {
            oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey = new oracle.security.crypto.core.RSAPrivateKey();
            try {
                rSAPrivateKey.initialize(AlgID.rsaEncryption, aSN1Sequence);
                ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(4)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(6)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(7)).erase();
                ((ASN1Integer)aSN1Sequence.elementAt(8)).erase();
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IOException(algorithmIdentifierException.toString());
            }
            return new KeyPair(rSAPrivateKey.getPublicKey(), rSAPrivateKey);
        }
        if (aSN1Sequence.size() == 6) {
            if (((ASN1Integer)aSN1Sequence.elementAt(0)).getValue().intValue() != 0) {
                throw new ASN1FormatException("Invalid key pair format");
            }
            oracle.security.crypto.core.DSAParams dSAParams = new oracle.security.crypto.core.DSAParams(((ASN1Integer)aSN1Sequence.elementAt(1)).getValue(), ((ASN1Integer)aSN1Sequence.elementAt(2)).getValue(), ((ASN1Integer)aSN1Sequence.elementAt(3)).getValue());
            DSAPublicKey dSAPublicKey = new DSAPublicKey(((ASN1Integer)aSN1Sequence.elementAt(4)).getValue(), dSAParams);
            oracle.security.crypto.core.DSAPrivateKey dSAPrivateKey = new oracle.security.crypto.core.DSAPrivateKey(((ASN1Integer)aSN1Sequence.elementAt(5)).getValue(), dSAParams);
            ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
            return new KeyPair(dSAPublicKey, dSAPrivateKey);
        }
        throw new ASN1FormatException("Unknown key pair format");
    }

    public static byte[] generateKeyID(PublicKey publicKey) {
        FIPS_140_2.assertReadyState();
        SHA sHA = new SHA();
        sHA.update(Utils.toBytes(publicKey.getContents()));
        sHA.computeCurrent();
        return sHA.getDigestBits();
    }

    public static void setKeyParity(SymmetricKey symmetricKey, int n) {
        DESKey.setParity(symmetricKey, n);
    }

    public static boolean checkKeyParity(SymmetricKey symmetricKey, int n) {
        return DESKey.checkParity(symmetricKey, n);
    }

    public static boolean isDesWeakKey(SymmetricKey symmetricKey) {
        return DESKey.isWeak(symmetricKey);
    }

    public static boolean isDesSemiWeakKey(SymmetricKey symmetricKey) {
        return DESKey.isSemiWeak(symmetricKey);
    }

    public static boolean isDesPossiblyWeakKey(SymmetricKey symmetricKey) {
        return DESKey.isPossiblyWeak(symmetricKey);
    }

    public static ASN1Sequence subjectPublicKeyInfo(PublicKey publicKey) {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(publicKey.getAlgID());
        if (publicKey.getAlgID().getOID().equals(AlgID.ecKey.getOID())) {
            aSN1Sequence.addElement(publicKey.getContents());
        } else {
            aSN1Sequence.addElement(new ASN1BitString(Utils.toBytes(publicKey.getContents())));
        }
        return aSN1Sequence;
    }

    public static ASN1Sequence privateKeyInfo(oracle.security.crypto.core.PrivateKey privateKey) {
        byte[] byArray = privateKey.getEncoded();
        try {
            return new ASN1Sequence(new UnsyncByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new StreamableInputException(iOException.toString());
        }
    }

    public static ASN1Sequence makeAlgID(ASN1ObjectID aSN1ObjectID) {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(aSN1ObjectID);
        if (!aSN1ObjectID.equals(DSA.dsaSigOID)) {
            aSN1Sequence.addElement(new ASN1Null());
        }
        return aSN1Sequence;
    }

    public static oracle.security.crypto.core.Signature makeSignature(oracle.security.crypto.core.PrivateKey privateKey) throws SignatureException {
        oracle.security.crypto.core.Signature signature;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(privateKey.getAlgID().getOID(), "useSignature");
        if (clazz == null) {
            throw new SignatureException("Can not find a signature algorithm for this key.");
        }
        try {
            signature = (oracle.security.crypto.core.Signature)clazz.newInstance();
            signature.setPrivateKey(privateKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SignatureException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new SignatureException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new SignatureException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        return signature;
    }

    public static oracle.security.crypto.core.Signature makeSignature(PublicKey publicKey) throws AuthenticationException {
        oracle.security.crypto.core.Signature signature;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(publicKey.getAlgID().getOID(), "useSignature");
        if (clazz == null) {
            throw new AuthenticationException("Can not find a signature algorithm for this key.");
        }
        try {
            signature = (oracle.security.crypto.core.Signature)clazz.newInstance();
            signature.setPublicKey(publicKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AuthenticationException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AuthenticationException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AuthenticationException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
        return signature;
    }

    public static byte[] sign(byte[] byArray, oracle.security.crypto.core.PrivateKey privateKey) throws SignatureException {
        return CryptoUtils.sign(byArray, privateKey, RandomBitsSource.getDefault());
    }

    public static byte[] sign(byte[] byArray, oracle.security.crypto.core.PrivateKey privateKey, RandomBitsSource randomBitsSource) throws SignatureException {
        FIPS_140_2.assertReadyState();
        oracle.security.crypto.core.Signature signature = oracle.security.crypto.core.Signature.getInstance(privateKey);
        signature.setDocument(byArray);
        signature.setRandomBitsSource(randomBitsSource);
        signature.sign();
        return signature.getSigBytes();
    }

    public static ASN1Sequence signASN1(ASN1Object aSN1Object, oracle.security.crypto.core.PrivateKey privateKey) throws SignatureException {
        return CryptoUtils.signASN1(aSN1Object, privateKey, RandomBitsSource.getDefault());
    }

    public static ASN1Sequence signASN1(ASN1Object aSN1Object, oracle.security.crypto.core.PrivateKey privateKey, RandomBitsSource randomBitsSource) throws SignatureException {
        FIPS_140_2.assertReadyState();
        oracle.security.crypto.core.Signature signature = oracle.security.crypto.core.Signature.getInstance(privateKey);
        signature.setDocument(Utils.toBytes(aSN1Object));
        signature.setRandomBitsSource(randomBitsSource);
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(aSN1Object);
        aSN1Sequence.addElement(signature.getAlgID());
        aSN1Sequence.addElement(new ASN1BitString(signature.sign()));
        return aSN1Sequence;
    }

    public static boolean verifySignature(PublicKey publicKey, byte[] byArray, byte[] byArray2) throws AuthenticationException {
        FIPS_140_2.assertReadyState();
        oracle.security.crypto.core.Signature signature = oracle.security.crypto.core.Signature.getInstance(publicKey);
        signature.setDocument(byArray);
        signature.setSigBytes(byArray2);
        return signature.verify();
    }

    public static boolean verifySignedASN1(ASN1Sequence aSN1Sequence, PublicKey publicKey) {
        FIPS_140_2.assertReadyState();
        try {
            byte[] byArray = Utils.toBytes(aSN1Sequence.elementAt(0));
            byte[] byArray2 = ((ASN1BitString)aSN1Sequence.elementAt(2)).getValue();
            oracle.security.crypto.core.Signature signature = oracle.security.crypto.core.Signature.getInstance(new AlgorithmIdentifier(Utils.toStream(aSN1Sequence.elementAt(1))));
            signature.setPublicKey(publicKey);
            signature.setDocument(byArray);
            signature.setSigBytes(byArray2);
            return signature.verify();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            return false;
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static byte[] getIV(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier instanceof CBCAlgorithmIdentifier) {
            return ((CBCAlgorithmIdentifier)algorithmIdentifier).getIV();
        }
        CBCAlgorithmIdentifier cBCAlgorithmIdentifier = new CBCAlgorithmIdentifier(algorithmIdentifier.getOID(), algorithmIdentifier.getParameters());
        return cBCAlgorithmIdentifier.getIV();
    }

    public static PrivateKey toJCEPrivateKey(oracle.security.crypto.core.PrivateKey privateKey) {
        try {
            if (privateKey instanceof oracle.security.crypto.core.RSAPrivateKey && ((oracle.security.crypto.core.RSAPrivateKey)privateKey).getPrimeP() != null) {
                oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey = (oracle.security.crypto.core.RSAPrivateKey)privateKey;
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getExponent(), rSAPrivateKey.getPrimeP(), rSAPrivateKey.getPrimeQ(), rSAPrivateKey.getPrimeExponentP(), rSAPrivateKey.getPrimeExponentQ(), rSAPrivateKey.getCrtCoefficient());
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
            }
            if (privateKey instanceof oracle.security.crypto.core.RSAPrivateKey) {
                oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey = (oracle.security.crypto.core.RSAPrivateKey)privateKey;
                RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getExponent());
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePrivate(rSAPrivateKeySpec);
            }
            if (privateKey instanceof ECPrivateKey) {
                ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
                return (java.security.interfaces.ECPrivateKey)eCPrivateKey.getKey();
            }
            if (privateKey instanceof oracle.security.crypto.core.DSAPrivateKey) {
                oracle.security.crypto.core.DSAPrivateKey dSAPrivateKey = (oracle.security.crypto.core.DSAPrivateKey)privateKey;
                DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAPrivateKey.getParams().getP(), dSAPrivateKey.getParams().getQ(), dSAPrivateKey.getParams().getG());
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                return keyFactory.generatePrivate(dSAPrivateKeySpec);
            }
            if (privateKey instanceof DHPrivateKey) {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
                DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(dHPrivateKey.getX(), dHPrivateKey.getParams().getP(), dHPrivateKey.getParams().getG());
                KeyFactory keyFactory = KeyFactory.getInstance("DiffieHellman");
                return keyFactory.generatePrivate(dHPrivateKeySpec);
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IllegalArgumentException(invalidKeySpecException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException);
        }
        throw new IllegalArgumentException("PrivateKey must be one of RSAPrivateKey, ECPrivateKey, DSAPrivateKey or DHPrivateKey");
    }

    public static oracle.security.crypto.core.PrivateKey fromJCEPrivateKey(PrivateKey privateKey) {
        if (privateKey instanceof oracle.security.crypto.core.PrivateKey) {
            return (oracle.security.crypto.core.PrivateKey)privateKey;
        }
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
            oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey = new oracle.security.crypto.core.RSAPrivateKey(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            return rSAPrivateKey;
        }
        if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            oracle.security.crypto.core.RSAPrivateKey rSAPrivateKey2 = new oracle.security.crypto.core.RSAPrivateKey(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            return rSAPrivateKey2;
        }
        if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
            java.security.interfaces.ECPrivateKey eCPrivateKey = (java.security.interfaces.ECPrivateKey)privateKey;
            ECPrivateKey eCPrivateKey2 = new ECPrivateKey(eCPrivateKey);
            return eCPrivateKey2;
        }
        if (privateKey instanceof DSAPrivateKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
            oracle.security.crypto.core.DSAPrivateKey dSAPrivateKey2 = new oracle.security.crypto.core.DSAPrivateKey(dSAPrivateKey.getX(), new oracle.security.crypto.core.DSAParams(dSAPrivateKey.getParams().getP(), dSAPrivateKey.getParams().getQ(), dSAPrivateKey.getParams().getG()));
            return dSAPrivateKey2;
        }
        if (privateKey instanceof javax.crypto.interfaces.DHPrivateKey) {
            javax.crypto.interfaces.DHPrivateKey dHPrivateKey = (javax.crypto.interfaces.DHPrivateKey)privateKey;
            DHPrivateKey dHPrivateKey2 = new DHPrivateKey(dHPrivateKey.getX(), new DHParams(dHPrivateKey.getParams().getP(), dHPrivateKey.getParams().getG(), dHPrivateKey.getParams().getP().subtract(new BigInteger("1")).divide(new BigInteger("2"))));
            return dHPrivateKey2;
        }
        throw new IllegalArgumentException("PrivateKey must be one of RSAPrivateKey, ECPrivateKey, DSAPrivateKey or DHPrivateKey");
    }

    public static java.security.PublicKey toJCEPublicKey(PublicKey publicKey) {
        try {
            if (publicKey instanceof oracle.security.crypto.core.RSAPublicKey) {
                oracle.security.crypto.core.RSAPublicKey rSAPublicKey = (oracle.security.crypto.core.RSAPublicKey)publicKey;
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getExponent());
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePublic(rSAPublicKeySpec);
            }
            if (publicKey instanceof ECPublicKey) {
                ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
                return (java.security.interfaces.ECPublicKey)eCPublicKey.getKey();
            }
            if (publicKey instanceof DSAPublicKey) {
                DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
                DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicKey.getY(), dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ(), dSAPublicKey.getParams().getG());
                KeyFactory keyFactory = KeyFactory.getInstance("DSA");
                return keyFactory.generatePublic(dSAPublicKeySpec);
            }
            if (publicKey instanceof DHPublicKey) {
                DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
                DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(dHPublicKey.getY(), dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG());
                KeyFactory keyFactory = KeyFactory.getInstance("DiffieHellman");
                return keyFactory.generatePublic(dHPublicKeySpec);
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IllegalArgumentException(invalidKeySpecException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException);
        }
        throw new IllegalArgumentException("PublicKey must be one of RSAPublicKey, ECPublicKey, DSAPublicKey or DHPublicKey");
    }

    public static PublicKey fromJCEPublicKey(java.security.PublicKey publicKey) {
        if (publicKey instanceof PublicKey) {
            return (PublicKey)publicKey;
        }
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            oracle.security.crypto.core.RSAPublicKey rSAPublicKey2 = new oracle.security.crypto.core.RSAPublicKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            return rSAPublicKey2;
        }
        if (publicKey instanceof java.security.interfaces.ECPublicKey) {
            java.security.interfaces.ECPublicKey eCPublicKey = (java.security.interfaces.ECPublicKey)publicKey;
            ECPublicKey eCPublicKey2 = new ECPublicKey(eCPublicKey);
            return eCPublicKey2;
        }
        if (publicKey instanceof java.security.interfaces.DSAPublicKey) {
            java.security.interfaces.DSAPublicKey dSAPublicKey = (java.security.interfaces.DSAPublicKey)publicKey;
            DSAPublicKey dSAPublicKey2 = new DSAPublicKey(dSAPublicKey.getY(), new oracle.security.crypto.core.DSAParams(dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ(), dSAPublicKey.getParams().getG()));
            return dSAPublicKey2;
        }
        if (publicKey instanceof javax.crypto.interfaces.DHPublicKey) {
            javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)publicKey;
            DHPublicKey dHPublicKey2 = new DHPublicKey(dHPublicKey.getY(), new DHParams(dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG(), dHPublicKey.getParams().getP().subtract(new BigInteger("1")).divide(new BigInteger("2"))));
            return dHPublicKey2;
        }
        throw new IllegalArgumentException("PublicKey must be one of RSAPublicKey, ECPublicKey, DSAPublicKey or DHPublicKey");
    }

    public static Signature getSignatureInstance(String string, Key key) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (key.getClass().getName().contains("Luna")) {
            return Signature.getInstance(string, "LunaJCAProvider");
        }
        return Signature.getInstance(string);
    }

    public static Cipher getCipherInstance(Key key, String string) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        if (key.getClass().getName().contains("Luna")) {
            return Cipher.getInstance(string, "LunaJCEProvider");
        }
        return Cipher.getInstance(string);
    }

    public static AlgorithmParameterSpec getOEPAlgoSpec(String string, String string2, AlgorithmParameterSpec algorithmParameterSpec, PSource pSource, Key key) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InstantiationException, InvocationTargetException {
        if (key.getClass().getName().contains("Luna")) {
            Class<?> clazz = Class.forName("com.chrysalisits.crypto.LunaParameterSpecOAEP");
            Class[] classArray = new Class[]{String.class, Integer.TYPE, Integer.TYPE, byte[].class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            byte[] byArray = ((PSource.PSpecified)pSource).getValue() != null ? ((PSource.PSpecified)pSource).getValue() : new byte[]{};
            Object[] objectArray = new Object[]{"SHA1", clazz.getDeclaredField("mgfType_MGF1").get(null), clazz.getDeclaredField("sourceType_DATA_SPECIFIED").get(null), byArray};
            return (AlgorithmParameterSpec)constructor.newInstance(objectArray);
        }
        return new OAEPParameterSpec(string, string2, algorithmParameterSpec, pSource);
    }

    public static byte[] encodeKey(Key key) {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(unsyncByteArrayOutputStream);
        try {
            byte[] byArray = key.getEncoded();
            if (key instanceof PrivateKey) {
                dataOutputStream.write(0);
            } else if (key instanceof java.security.PublicKey) {
                dataOutputStream.write(1);
            } else {
                dataOutputStream.write(2);
            }
            dataOutputStream.writeUTF(key.getFormat());
            dataOutputStream.writeUTF(key.getAlgorithm());
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
            int n = 8 - unsyncByteArrayOutputStream.size() % 8;
            if (n < 8) {
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.write(0);
                }
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public static Key decodeKey(byte[] byArray) {
        EncodedKeySpec encodedKeySpec;
        String string;
        int n;
        block12: {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(unsyncByteArrayInputStream);
            try {
                n = dataInputStream.read();
                String string2 = dataInputStream.readUTF();
                string = dataInputStream.readUTF();
                byte[] byArray2 = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray2);
                if (string2.equals("PKCS#8") || string2.equals("PKCS8")) {
                    encodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
                    break block12;
                }
                if (string2.equals("X.509") || string2.equals("X509")) {
                    encodedKeySpec = new X509EncodedKeySpec(byArray2);
                    break block12;
                }
                if (string2.equals("RAW")) {
                    return new SecretKeySpec(byArray2, string);
                }
                throw new IOException("Key format " + string2 + " not recognised!");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException);
            }
        }
        try {
            switch (n) {
                case 0: {
                    return KeyFactory.getInstance(string).generatePrivate(encodedKeySpec);
                }
                case 1: {
                    return KeyFactory.getInstance(string).generatePublic(encodedKeySpec);
                }
                case 2: {
                    return SecretKeyFactory.getInstance(string).generateSecret(encodedKeySpec);
                }
            }
            throw new IOException("Key type " + n + " not recognized!");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Exception creating key: " + exception.toString(), exception);
        }
    }

    public static boolean matches(java.security.PublicKey publicKey, PrivateKey privateKey) {
        if (publicKey instanceof RSAPublicKey) {
            if (!(privateKey instanceof RSAPrivateKey)) {
                return false;
            }
            return ((RSAPublicKey)publicKey).getModulus().equals(((RSAPrivateKey)privateKey).getModulus());
        }
        if (publicKey instanceof java.security.interfaces.DSAPublicKey) {
            if (!(privateKey instanceof DSAPrivateKey)) {
                return false;
            }
            return CryptoUtils.equals(((java.security.interfaces.DSAPublicKey)publicKey).getParams(), ((DSAPrivateKey)privateKey).getParams());
        }
        if (publicKey instanceof javax.crypto.interfaces.DHPublicKey) {
            if (!(privateKey instanceof javax.crypto.interfaces.DHPrivateKey)) {
                return false;
            }
            return CryptoUtils.equals(((javax.crypto.interfaces.DHPublicKey)publicKey).getParams(), ((javax.crypto.interfaces.DHPrivateKey)privateKey).getParams());
        }
        return false;
    }

    public static boolean equals(DSAParams dSAParams, DSAParams dSAParams2) {
        return dSAParams.getG().equals(dSAParams2.getG()) && dSAParams.getP().equals(dSAParams2.getP()) && dSAParams.getQ().equals(dSAParams2.getQ());
    }

    public static boolean equals(DHParameterSpec dHParameterSpec, DHParameterSpec dHParameterSpec2) {
        return dHParameterSpec.getG().equals(dHParameterSpec2.getG()) && dHParameterSpec.getP().equals(dHParameterSpec2.getP());
    }

    public static String getHmacAlg(AlgorithmIdentifier algorithmIdentifier) {
        String string = null;
        if (algorithmIdentifier.equals(AlgID.sha1) || algorithmIdentifier.equals(AlgID.sha_1) || algorithmIdentifier.equals(AlgID.sha) || algorithmIdentifier.equals(AlgID.hmacSHA) || algorithmIdentifier.equals(AlgID.hmacWithSHA1)) {
            string = "HmacSHA1";
        } else if (algorithmIdentifier.equals(AlgID.md5) || algorithmIdentifier.equals(AlgID.hmacMD5)) {
            string = "HmacMD5";
        } else if (algorithmIdentifier.equals(AlgID.sha_224) || algorithmIdentifier.equals(AlgID.hmacWithSHA224)) {
            string = "HmacSHA224";
        } else if (algorithmIdentifier.equals(AlgID.sha_256) || algorithmIdentifier.equals(AlgID.hmacWithSHA256)) {
            string = "HmacSHA256";
        } else if (algorithmIdentifier.equals(AlgID.sha_384) || algorithmIdentifier.equals(AlgID.hmacWithSHA384)) {
            string = "HmacSHA384";
        } else if (algorithmIdentifier.equals(AlgID.sha_512) || algorithmIdentifier.equals(AlgID.hmacWithSHA512)) {
            string = "HmacSHA512";
        }
        return string;
    }

    public static String getDigestAlg(AlgorithmIdentifier algorithmIdentifier) {
        String string = null;
        if (algorithmIdentifier.equals(AlgID.sha1) || algorithmIdentifier.equals(AlgID.sha_1) || algorithmIdentifier.equals(AlgID.sha)) {
            string = "SHA-1";
        } else if (algorithmIdentifier.equals(AlgID.md5)) {
            string = "MD5";
        } else if (algorithmIdentifier.equals(AlgID.sha_224)) {
            string = "SHA-224";
        } else if (algorithmIdentifier.equals(AlgID.sha_256)) {
            string = "SHA-256";
        } else if (algorithmIdentifier.equals(AlgID.sha_384)) {
            string = "SHA-384";
        } else if (algorithmIdentifier.equals(AlgID.sha_512)) {
            string = "SHA-512";
        }
        return string;
    }

    public static String getSignatureAlg(AlgorithmIdentifier algorithmIdentifier) {
        String string = null;
        if (algorithmIdentifier.equals(AlgID.md2WithRSAEncryption)) {
            string = "MD2withRSA";
        } else if (algorithmIdentifier.equals(AlgID.md5WithRSAEncryption)) {
            string = "MD5withRSA";
        } else if (algorithmIdentifier.equals(AlgID.sha_1WithRSAEncryption)) {
            string = "SHA1withRSA";
        } else if (algorithmIdentifier.equals(AlgID.sha224WithRSAEncryption)) {
            string = "SHA224withRSA";
        } else if (algorithmIdentifier.equals(AlgID.sha256WithRSAEncryption)) {
            string = "SHA256withRSA";
        } else if (algorithmIdentifier.equals(AlgID.sha384WithRSAEncryption)) {
            string = "SHA384withRSA";
        } else if (algorithmIdentifier.equals(AlgID.sha512WithRSAEncryption)) {
            string = "SHA512withRSA";
        } else if (algorithmIdentifier.equals(AlgID.dsaWithSHA1)) {
            string = "SHA1withDSA";
        } else if (algorithmIdentifier.equals(AlgID.ecdsaWithSHA1)) {
            string = "SHA1withECDSA";
        } else if (algorithmIdentifier.equals(AlgID.ecdsaWithSHA256)) {
            string = "SHA256withECDSA";
        } else if (algorithmIdentifier.equals(AlgID.ecdsaWithSHA384)) {
            string = "SHA384withECDSA";
        } else if (algorithmIdentifier.equals(AlgID.ecdsaWithSHA512)) {
            string = "SHA512withECDSA";
        } else if (algorithmIdentifier.getOID().equals(PSSAlgorithmIdentifier.RSASSA_PSS_OID)) {
            string = "RSASSA-PSS";
        }
        return string;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

