/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.KeyPair;
import oracle.security.crypto.core.KeyPairGenerator;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.a;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.core.math.Prime;
import oracle.security.crypto.fips.FIPS_140_2;

public final class RSAKeyPairGenerator
extends KeyPairGenerator {
    private int a;
    private boolean b = false;

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (!algorithmIdentifier.getOID().equals(AlgID.rsaEncryption.getOID())) {
            throw new AlgorithmIdentifierException("Unknown RSA key algorithm identifier");
        }
    }

    @Override
    public void initialize(int n, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        oracle.security.crypto.core.a.a(n, 16384);
        this.a = n;
        this.setRandomBitsSource(randomBitsSource);
        this.b = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInt bigInt;
        BigInt bigInt2;
        BigInt bigInt3;
        BigInt bigInt4;
        BigInt bigInt5;
        BigInt bigInt6;
        BigInt bigInt7;
        if (!this.b) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        FIPS_140_2.assertReadyState();
        oracle.security.crypto.core.a.a(this.a, 16384);
        BigInt bigInt8 = BigInt.valueOf(65537L);
        while (true) {
            if ((bigInt7 = Prime.generateBigIntPrime(this.a / 2, this.d)).compareTo(bigInt6 = Prime.generateBigIntPrime(this.a - bigInt7.bitLength(), this.d)) == 0) {
                continue;
            }
            bigInt5 = bigInt7.multiply(bigInt6);
            bigInt4 = bigInt7.subtract(BigInt.ONE);
            bigInt3 = bigInt6.subtract(BigInt.ONE);
            bigInt2 = bigInt4.multiply(bigInt3);
            if (bigInt5.bitLength() >= this.a && bigInt5.gcd(bigInt2).compareTo(BigInt.ONE) == 0 && bigInt2.remainder(bigInt8).signum() != 0) break;
        }
        if (bigInt7.compareTo(bigInt6) < 0) {
            bigInt = bigInt7;
            bigInt7 = bigInt6;
            bigInt6 = bigInt;
            bigInt = bigInt4;
            bigInt4 = bigInt3;
            bigInt3 = bigInt;
        }
        bigInt = bigInt8.modInverse(bigInt2);
        BigInt bigInt9 = bigInt.remainder(bigInt4);
        BigInt bigInt10 = bigInt.remainder(bigInt3);
        BigInt bigInt11 = bigInt6.modInverse(bigInt7);
        RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInt5, bigInt8);
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(bigInt5, bigInt, bigInt8, bigInt7, bigInt6, bigInt9, bigInt10, bigInt11);
        FIPS_140_2.testKeyPair(rSAPublicKey, rSAPrivateKey);
        bigInt4.erase();
        bigInt3.erase();
        return new KeyPair(rSAPublicKey, rSAPrivateKey);
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }
}

