/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;

public class PSSAlgorithmIdentifier
extends AlgorithmIdentifier {
    public static final ASN1ObjectID RSASSA_PSS_OID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 10);
    private AlgorithmIdentifier a;
    private AlgorithmIdentifier b;
    private int c;
    private int d;

    public PSSAlgorithmIdentifier() {
        this(AlgID.sha_1, AlgID.mgf1WithSHA1, 20, 1);
    }

    public PSSAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, int n, int n2) {
        super(RSASSA_PSS_OID, PSSAlgorithmIdentifier.a(algorithmIdentifier, algorithmIdentifier2, n, n2));
        this.a = algorithmIdentifier;
        this.b = algorithmIdentifier2;
        this.c = n;
        this.d = n2;
    }

    public PSSAlgorithmIdentifier(ASN1Object aSN1Object) throws AlgorithmIdentifierException {
        super(RSASSA_PSS_OID, aSN1Object);
        this.a();
    }

    public PSSAlgorithmIdentifier(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void a() throws AlgorithmIdentifierException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)this.getParameters();
        ArrayList<ASN1Object> arrayList = aSN1Sequence.elementsAsList();
        if (arrayList.size() > 4) {
            throw new AlgorithmIdentifierException("Parameters not formatted correctly");
        }
        this.a = AlgID.sha1;
        this.b = AlgID.mgf1WithSHA1;
        this.c = 20;
        this.d = 1;
        if (arrayList.size() == 0) {
            return;
        }
        int n = -1;
        Iterator<ASN1Object> iterator = arrayList.iterator();
        try {
            while (iterator.hasNext()) {
                ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)iterator.next();
                int n2 = aSN1GenericConstructed.getTag();
                if (n >= n2) {
                    throw new AlgorithmIdentifierException("Order of tags is improper.");
                }
                ArrayList<ASN1Object> arrayList2 = aSN1GenericConstructed.elementsAsList();
                if (arrayList2.size() != 1) {
                    throw new AlgorithmIdentifierException("Parameters not formatted correctly");
                }
                switch (n2) {
                    case 0: {
                        this.a = this.a(arrayList2);
                        break;
                    }
                    case 1: {
                        this.b = this.a(arrayList2);
                        break;
                    }
                    case 2: {
                        this.c = ((ASN1Integer)arrayList2.get(0)).intValue();
                        break;
                    }
                    case 3: {
                        this.d = ((ASN1Integer)arrayList2.get(0)).intValue();
                        break;
                    }
                    default: {
                        throw new AlgorithmIdentifierException("Invalid tag recieved");
                    }
                }
                n = n2;
            }
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Parameters not formatted correctly");
        }
    }

    private AlgorithmIdentifier a(ArrayList<ASN1Object> arrayList) throws AlgorithmIdentifierException {
        AlgorithmIdentifier algorithmIdentifier;
        if (arrayList.get(0) instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)arrayList.get(0);
            ASN1Object aSN1Object = null;
            if (aSN1Sequence.size() == 2) {
                aSN1Object = aSN1Sequence.elementAt(1);
            }
            algorithmIdentifier = new AlgorithmIdentifier((ASN1ObjectID)aSN1Sequence.elementAt(0), aSN1Object);
        } else if (arrayList.get(0) instanceof AlgorithmIdentifier) {
            algorithmIdentifier = (AlgorithmIdentifier)arrayList.get(0);
        } else {
            throw new AlgorithmIdentifierException("Parameters not formatted correctly");
        }
        return algorithmIdentifier;
    }

    public AlgorithmIdentifier getHashFunc() {
        return (AlgorithmIdentifier)this.a.clone();
    }

    public AlgorithmIdentifier getMaskGenFunc() {
        return (AlgorithmIdentifier)this.b.clone();
    }

    private static String a(AlgorithmIdentifier algorithmIdentifier) throws IOException {
        if (algorithmIdentifier.equals(AlgID.sha1)) {
            return "SHA-1";
        }
        if (algorithmIdentifier.equals(AlgID.sha_256)) {
            return "SHA-256";
        }
        if (algorithmIdentifier.equals(AlgID.sha_384)) {
            return "SHA-384";
        }
        if (algorithmIdentifier.equals(AlgID.sha_512)) {
            return "SHA-512";
        }
        throw new IOException("Unrecognized hash function.");
    }

    private static String b(AlgorithmIdentifier algorithmIdentifier) throws IOException {
        if (algorithmIdentifier.getOID().equals(AlgID.mgf1.getOID())) {
            return "MGF1";
        }
        throw new IOException("Unrecognized MGF function.");
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec() throws IOException {
        PSSParameterSpec pSSParameterSpec = new PSSParameterSpec(PSSAlgorithmIdentifier.a(this.a), PSSAlgorithmIdentifier.b(this.b), new MGF1ParameterSpec(PSSAlgorithmIdentifier.a(this.a)), this.c, this.d);
        return pSSParameterSpec;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        super.input(inputStream);
        try {
            this.a();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException("Problem decoding the parameters: " + algorithmIdentifierException.toString());
        }
    }

    private static ASN1Object a(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, int n, int n2) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (!algorithmIdentifier.equals(AlgID.sha1)) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(algorithmIdentifier, 0));
        }
        if (!algorithmIdentifier2.equals(AlgID.mgf1WithSHA1)) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(algorithmIdentifier2, 1));
        }
        if (n != 20) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(new ASN1Integer(n), 2));
        }
        if (n2 != 1) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(new ASN1Integer(n2), 3));
        }
        return aSN1Sequence;
    }

    @Override
    public Object clone() {
        AlgorithmIdentifier algorithmIdentifier = null;
        AlgorithmIdentifier algorithmIdentifier2 = null;
        if (this.a != null) {
            algorithmIdentifier = (AlgorithmIdentifier)this.a.clone();
        }
        if (this.b != null) {
            algorithmIdentifier2 = (AlgorithmIdentifier)this.b.clone();
        }
        int n = this.c;
        int n2 = this.d;
        return new PSSAlgorithmIdentifier(algorithmIdentifier, algorithmIdentifier2, n, n2);
    }
}

