/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.ECKey;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.fips.KeyExportException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class ECPrivateKey
extends ECKey
implements java.security.interfaces.ECPrivateKey,
PrivateKey {
    private boolean d = true;

    public ECPrivateKey() {
    }

    public ECPrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey) {
        super(eCPrivateKey);
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(new UnsyncByteArrayInputStream(eCPrivateKey.getEncoded()));
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!aSN1Integer.equals(0)) {
                System.out.println("Invalid version: " + aSN1Integer.getValue());
            }
            this.b = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
            this.c = aSN1Sequence.elementAt(2);
        }
        catch (IOException iOException) {
            System.out.println("Unrecoginzed EC Key Information");
        }
    }

    public ECPrivateKey(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public ECPrivateKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    @Override
    public byte[] getEncoded() {
        this.a();
        if (this.a == null) {
            return null;
        }
        return ((java.security.interfaces.ECPrivateKey)this.a).getEncoded();
    }

    @Override
    public boolean getAllowExport() {
        return this.d;
    }

    public void setAllowExport(boolean bl) {
        this.d = bl;
    }

    private void a() {
        if (!this.getAllowExport() || !FIPS_140_2.getAllowKeyExport()) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        if (!AlgID.ecKey.getOID().equals(algorithmIdentifier.getOID())) {
            throw new AlgorithmIdentifierException("Wrong algorithm identifier for EC key.");
        }
        this.b = algorithmIdentifier;
        this.c = aSN1Object;
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(0L));
        aSN1Sequence.addElement(algorithmIdentifier);
        aSN1Sequence.addElement(aSN1Object);
        this.a = this.a(Utils.toBytes(aSN1Sequence));
    }

    @Override
    public Object clone() {
        byte[] byArray = this.getEncoded();
        if (byArray == null) {
            return null;
        }
        try {
            ECPrivateKey eCPrivateKey = new ECPrivateKey(byArray);
            eCPrivateKey.d = this.d;
            return eCPrivateKey;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public BigInteger getS() {
        if (this.a == null) {
            return null;
        }
        return ((java.security.interfaces.ECPrivateKey)this.a).getS();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        try {
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!aSN1Integer.equals(0)) {
                System.out.println("Invalid version: " + aSN1Integer.getValue());
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
            ASN1Object aSN1Object = aSN1Sequence.elementAt(2);
            this.initialize(algorithmIdentifier, aSN1Object);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    @Override
    public int length() {
        byte[] byArray = this.getEncoded();
        if (byArray == null) {
            return 0;
        }
        return byArray.length;
    }

    private java.security.interfaces.ECPrivateKey a(byte[] byArray) throws InvalidInputException {
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return (java.security.interfaces.ECPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidInputException(generalSecurityException);
        }
    }
}

