/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.help.HelpUtils;
import oracle.jdevimpl.help.HelpOptions;

public final class UserQuery {
    private String _queryText;
    private int _searchType;
    private boolean _caseSensitive;
    private boolean _includeLocal;
    private boolean _includeOTN;
    private boolean _includeFusionMiddleware;
    private boolean _includeDatabase;
    private static final String APP_SERVER_LIBARY_MACRO = "${APP_SERVER_LIBRARY}";
    private static final String DB_LIBRARY_MACRO = "${DB_LIBRARY}";

    public UserQuery(String queryText, int searchType, boolean caseSensitive, boolean includeLocal, boolean includeOTN, boolean includeFusionMiddleware, boolean includeDatabase) {
        this._queryText = queryText;
        this._searchType = searchType;
        this._caseSensitive = caseSensitive;
        this._includeLocal = includeLocal;
        this._includeOTN = includeOTN;
        this._includeFusionMiddleware = includeFusionMiddleware;
        this._includeDatabase = includeDatabase;
    }

    public UserQuery(String queryText) {
        this._queryText = queryText;
        HelpOptions helpOptions = HelpOptions.getInstance();
        this._includeLocal = helpOptions.includeLocal();
        this._searchType = helpOptions.getLocalSearchType();
        this._caseSensitive = helpOptions.getLocalCaseSensitiveSearch();
        this._includeOTN = helpOptions.includeOTN();
        this._includeFusionMiddleware = helpOptions.includeFusionMiddleware();
        this._includeDatabase = helpOptions.includeDatabase();
    }

    public String getQueryText() {
        return this._queryText;
    }

    public int getSearchType() {
        return this._searchType;
    }

    public void setIncludeLocal(boolean includeLocal) {
        this._includeLocal = includeLocal;
    }

    public void setIncludeOTN(boolean includeOTN) {
        this._includeOTN = includeOTN;
    }

    public void setIncludeDatabase(boolean includeDatabase) {
        this._includeDatabase = includeDatabase;
    }

    public void setIncludeFusionMiddleware(boolean includeFusionMiddleware) {
        this._includeFusionMiddleware = includeFusionMiddleware;
    }

    public boolean getCaseSensitive() {
        return this._caseSensitive;
    }

    public boolean includeLocal() {
        return this._includeLocal;
    }

    public boolean includeOTN() {
        return this._includeOTN;
    }

    public boolean includeTahiti() {
        return this._includeFusionMiddleware || this._includeDatabase;
    }

    public boolean includeFusionMiddleware() {
        return this._includeFusionMiddleware;
    }

    public boolean includeDatabase() {
        return this._includeDatabase;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        try {
            UserQuery aQuery = (UserQuery)obj;
            if (this._queryText.equals(aQuery._queryText) && this._searchType == aQuery._searchType && this._caseSensitive == aQuery._caseSensitive && this._includeOTN == aQuery._includeOTN && this._includeFusionMiddleware == aQuery._includeFusionMiddleware && this._includeDatabase == aQuery._includeDatabase) {
                isEqual = true;
            }
        }
        catch (Exception e) {
            isEqual = false;
        }
        return isEqual;
    }

    public String toString() {
        return this._queryText;
    }

    public List<String> getTahitiSearchList() {
        ArrayList<String> searchList = new ArrayList<String>(2);
        if (this._includeFusionMiddleware) {
            searchList.add(UserQuery.getMiddlewareLibraryName());
        }
        if (this._includeDatabase) {
            searchList.add(UserQuery.getDBLibraryName());
        }
        return searchList;
    }

    static String getDBLibraryName() {
        String dbName = HelpUtils.substituteMacros((String)DB_LIBRARY_MACRO);
        if (dbName.equals(DB_LIBRARY_MACRO)) {
            dbName = "db111";
        }
        return dbName;
    }

    private static String getMiddlewareLibraryName() {
        String asName = HelpUtils.substituteMacros((String)APP_SERVER_LIBARY_MACRO);
        if (asName.equals(APP_SERVER_LIBARY_MACRO)) {
            asName = "as1111";
        }
        return asName;
    }
}

