/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11.ac;

import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.ac.ACElement;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextException;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextStatement;
import oracle.security.xmlsec.saml.SAMLInitializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PhysicalVerification
extends ACElement {
    public static final String PRIMARY = "primary";
    public static final String SECONDARY = "secondary";

    public PhysicalVerification(Element element, AuthenticationContextStatement acs) {
        super(element, acs);
    }

    public PhysicalVerification(Element element, String systemId, AuthenticationContextStatement acs) {
        super(element, systemId, acs);
    }

    public PhysicalVerification(Document owner, AuthenticationContextStatement acs) {
        super(owner, "http://projectliberty.org/schemas/authctx/2002/05", "PhysicalVerification", acs);
    }

    public PhysicalVerification(Document owner, AuthenticationContextStatement acs, String credentialLevel) throws AuthenticationContextException {
        this(owner, acs);
        this.setCredentialLevel(credentialLevel);
    }

    public void setCredentialLevel(String credentialLevel) throws AuthenticationContextException {
        this.authenticationContextClass.validateAttributeValue(credentialLevel, "credentialLevel", "http://projectliberty.org/schemas/authctx/2002/05", this);
        this.setAttribute("credentialLevel", credentialLevel);
    }

    public String getCredentialLevel() {
        if (this.hasAttribute("credentialLevel")) {
            return this.getAttribute("credentialLevel");
        }
        return null;
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

