/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11.ac;

import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.ac.ACElement;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextException;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextStatement;
import oracle.security.xmlsec.saml.SAMLInitializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyStorage
extends ACElement {
    public static final String MEMORY = "memory";
    public static final String SMARTCARD = "smartcard";
    public static final String TOKEN = "token";
    public static final String MOBILE_AUTH_CARD = "MobileAuthCard";

    public KeyStorage(Element element, AuthenticationContextStatement acs) {
        super(element, acs);
    }

    public KeyStorage(Element element, String systemId, AuthenticationContextStatement acs) {
        super(element, systemId, acs);
    }

    public KeyStorage(Document owner, AuthenticationContextStatement acs) {
        super(owner, "http://projectliberty.org/schemas/authctx/2002/05", "KeyStorage", acs);
    }

    public KeyStorage(Document owner, AuthenticationContextStatement acs, String medium) throws AuthenticationContextException {
        this(owner, acs);
        this.setMedium(medium);
    }

    public void setMedium(String medium) throws AuthenticationContextException {
        this.authenticationContextClass.validateAttributeValue(medium, "medium", "http://projectliberty.org/schemas/authctx/2002/05", this);
        this.setAttribute("medium", medium);
    }

    public String getMedium() {
        if (this.hasAttribute("medium")) {
            return this.getAttribute("medium");
        }
        return null;
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

