/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11;

import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.liberty.v11.LibDSigUtils;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.SAMLMessage;
import oracle.security.xmlsec.samlp.Request;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LibSAMLRequest
extends Request {
    public LibSAMLRequest(Element element) throws DOMException {
        super(element);
    }

    public LibSAMLRequest(Element element, String SystemId) throws DOMException {
        super(element, SystemId);
    }

    public LibSAMLRequest(Document owner) throws DOMException {
        super(owner);
        String name = "type";
        String prefix = XMLElement.getDefaultNSPrefix((String)"http://www.w3.org/2001/XMLSchema-instance");
        if (prefix != null && prefix.length() != 0) {
            name = prefix + ":" + name;
        }
        String value = "SignedSAMLRequestType";
        prefix = XMLElement.getDefaultNSPrefix((String)"http://projectliberty.org/schemas/core/2002/12");
        if (prefix != null && prefix.length() != 0) {
            value = prefix + ":" + value;
        }
        this.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", name, value);
        this.addNSPrefixAttrDefault("http://projectliberty.org/schemas/core/2002/12");
        this.addNSPrefixAttrDefault("http://www.w3.org/2001/XMLSchema-instance");
    }

    public void setId(String id) throws DOMException {
        this.setAttribute("id", id);
    }

    public String getId() {
        if (this.hasAttribute("id")) {
            return this.getAttribute("id");
        }
        return null;
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod) {
        return this.addSignature(signatureMethod, c14nMethod, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) {
        String id = this.getId();
        if (id == null || id.length() == 0) {
            return super.addSignature(signatureMethod, c14nMethod, digestMethod);
        }
        this.clearSignature();
        return LibDSigUtils.addSignature((SAMLMessage)this, id, signatureMethod, c14nMethod, digestMethod, this.getNSURIsPrecedeDSig(), this.getLocalNamesPrecedeDSig());
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

