/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11;

import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.dsig.XSReference;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.dsig.XSSignedInfo;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.SAMLMessage;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Document;

class LibDSigUtils {
    LibDSigUtils() {
    }

    static XSSignature addSignature(SAMLMessage msg, String referenceTargetID, String signatureMethod, String c14nMethod, String digestMethod, String[] nsURIs, String[] localNames) {
        XSSignature sig = XSSignature.newInstance((Document)msg.getOwnerDocument(), null);
        XMLUtils.insertChild((XMLElement)msg, (XMLElement)sig, (String[])nsURIs, (String[])localNames, (int)(localNames.length - 1));
        XSSignedInfo si = sig.createSignedInfo(c14nMethod, signatureMethod, null);
        sig.setSignedInfo(si);
        XSReference ref = sig.createReference();
        ref.setDigestMethod(digestMethod);
        ref.setURI("#" + referenceTargetID);
        si.addReference(ref);
        XSAlgorithmIdentifier est = sig.createTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        ref.addTransform(est);
        if (!"http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(c14nMethod)) {
            XSAlgorithmIdentifier canon = sig.createTransform(c14nMethod);
            ref.addTransform(canon);
        }
        return sig;
    }

    static String signURL(String msg, PrivateKey key, String sigAlgURI) throws SigningException {
        try {
            String jceAlg = URIManager.getURIManager().getJCEAlgorithm(sigAlgURI);
            if (jceAlg == null) {
                throw new NoSuchAlgorithmException("Unknown signature algorithm " + sigAlgURI);
            }
            Signature sig = Signature.getInstance(jceAlg);
            sig.initSign(key);
            sig.update(msg.getBytes("UTF8"));
            return URLEncoder.encode(Base64.toBase64((byte[])sig.sign(), (boolean)false));
        }
        catch (Exception ex) {
            throw new SigningException(ex.toString());
        }
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

