/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.liberty.v11.LibAuthenticationStatement;
import oracle.security.xmlsec.liberty.v11.LibDSigUtils;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.saml.Assertion;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.SAMLMessage;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LibAssertion
extends Assertion {
    public LibAssertion(Element element) throws DOMException {
        this(element, null);
    }

    public LibAssertion(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public LibAssertion(Document owner) throws DOMException {
        super(owner);
        this.addNSPrefixAttrDefault("http://projectliberty.org/schemas/core/2002/12");
        this.addNSPrefixAttrDefault("http://www.w3.org/2001/XMLSchema-instance");
        String name = "type";
        String prefix = XMLElement.getDefaultNSPrefix((String)"http://www.w3.org/2001/XMLSchema-instance");
        if (prefix != null && prefix.length() != 0) {
            name = prefix + ":" + name;
        }
        String value = "AssertionType";
        prefix = XMLElement.getDefaultNSPrefix((String)"http://projectliberty.org/schemas/core/2002/12");
        if (prefix != null && prefix.length() != 0) {
            value = prefix + ":" + value;
        }
        this.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", name, value);
    }

    public LibAssertion(Document owner, String assertionId, String issuer, Date issueInstant, String inResponseTo) throws DOMException {
        this(owner);
        this.setAssertionID(assertionId);
        this.setIssuer(issuer);
        this.setIssueInstant(issueInstant);
        this.setInResponseTo(inResponseTo);
    }

    public List getLibAuthenticationStatements() {
        NodeList list = this.getChildElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement");
        Vector<LibAuthenticationStatement> vec = new Vector<LibAuthenticationStatement>();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            vec.addElement(new LibAuthenticationStatement((Element)list.item(i), this.systemId));
        }
        return vec;
    }

    public void setInResponseTo(String value) {
        this.setAttribute("InResponseTo", value);
    }

    public String getInResponseTo() {
        if (this.hasAttribute("InResponseTo")) {
            return this.getAttribute("InResponseTo");
        }
        return null;
    }

    public void setId(String id) throws DOMException {
        this.setAttribute("id", id);
    }

    public String getId() {
        if (this.hasAttribute("id")) {
            return this.getAttribute("id");
        }
        return null;
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod) {
        return this.addSignature(signatureMethod, c14nMethod, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) {
        String id = this.getId();
        if (id == null || id.length() == 0) {
            return super.addSignature(signatureMethod, c14nMethod, digestMethod);
        }
        this.clearSignature();
        return LibDSigUtils.addSignature((SAMLMessage)this, id, signatureMethod, c14nMethod, digestMethod, this.getNSURIsPrecedeDSig(), this.getLocalNamesPrecedeDSig());
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

