/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.CustomFilter;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;

public abstract class HistoryFilterComponent
extends JComboBox {
    protected final HistoryComponent _component;
    protected final URL _url;
    private final Collection _providers;
    private final HistoryFilter _initialFilter;
    private final Observer _customFilterObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            HistoryFilterComponent.this.initializeModel();
        }
    };

    public HistoryFilterComponent(HistoryComponent history, URL url, HistoryFilter initialFilter, Collection providers) {
        this._component = history;
        this._url = url;
        this._providers = providers;
        this._initialFilter = initialFilter;
        this.initializeModel(false);
        BasicComboBoxRenderer comboRenderer = new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ComboItem) {
                    this.setText(value.toString());
                }
                return c;
            }
        };
        this.setRenderer(comboRenderer);
        HistoryManager.getHistoryManager().getCustomFilterManager().getFilterObservable().addObserver(this._customFilterObserver);
    }

    @Override
    public void processKeyEvent(KeyEvent ke) {
        if (ke.getKeyCode() != 37 && ke.getKeyCode() != 39) {
            super.processKeyEvent(ke);
        }
    }

    public HistoryComponent getHistoryComponent() {
        return this._component;
    }

    private void initializeModel() {
        this.initializeModel(true);
    }

    private void initializeModel(boolean doFilter) {
        MyModel model = new MyModel(this.getFilters());
        this.setModel(model);
        if (this._initialFilter != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                ComboItem item = (ComboItem)model.getElementAt(i);
                if (!(item instanceof FilterComboItem) || !((FilterComboItem)item).filter.equals(this._initialFilter)) continue;
                this.setSelectedIndex(i);
                break;
            }
            if (doFilter) {
                this.filter(this._initialFilter);
            }
        }
    }

    public void detachCustomFilterObserver() {
        HistoryManager.getHistoryManager().getCustomFilterManager().getFilterObservable().deleteObserver(this._customFilterObserver);
    }

    protected List getFilters() {
        ArrayList<FilterComboItem> filters = new ArrayList<FilterComboItem>();
        int lastCount = 0;
        filters.add(new FilterComboItem(HistoryManager.getHistoryManager().getAllFilter()));
        lastCount = filters.size();
        for (HistoryProvider provider : this._providers) {
            filters.add(new FilterComboItem(provider.getTypeFilter()));
        }
        for (HistoryProvider provider : this._providers) {
            HistoryFilter[] predefinedFilters = provider.getPredefinedFilters();
            if (predefinedFilters == null || predefinedFilters.length <= 0) continue;
            for (int j = 0; j < predefinedFilters.length; ++j) {
                filters.add(new FilterComboItem(predefinedFilters[j]));
            }
        }
        CustomFilter[] customFilters = HistoryManager.getHistoryManager().getCustomFilterManager().getFilters();
        if (customFilters == null) {
            return filters;
        }
        for (int i = 0; i < customFilters.length; ++i) {
            filters.add(new FilterComboItem(customFilters[i]));
        }
        return filters;
    }

    public HistoryFilter getSelectedFilter() {
        if (this.getSelectedItem() instanceof FilterComboItem) {
            return ((FilterComboItem)this.getSelectedItem()).filter;
        }
        return null;
    }

    public void setSelectedFilter(HistoryFilter filter) {
        this.setSelectedItem(new FilterComboItem(filter));
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void refilter() {
        this.filter(this.getSelectedFilter());
    }

    private void filter(HistoryFilter historyFilter) {
        HistoryModel model = this.createHistoryModel(historyFilter, this._component);
        if (model == null) {
            return;
        }
        HistoryEntry selectedEntry = this._component.getSingleSelection();
        Date selectedDate = null;
        RevisionIdentifier selectedRevision = null;
        if (selectedEntry != null) {
            selectedDate = (Date)selectedEntry.getValue(SharedProperties.getDateProperty());
            selectedRevision = (RevisionIdentifier)selectedEntry.getValue(SharedProperties.getRevisionProperty());
        }
        int sortColumn = this._component.getTable().getSortColumn();
        boolean sortAscending = this._component.getTable().isSortAscending();
        this._component.setModel(model);
        this._component.getTable().setSortColumn(sortColumn, sortAscending);
        selectedEntry = null;
        if (selectedRevision != null && selectedDate != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                HistoryEntry thisEntry = model.getEntry(i);
                RevisionIdentifier thisRevision = (RevisionIdentifier)thisEntry.getValue(SharedProperties.getRevisionProperty());
                Date thisDate = (Date)thisEntry.getValue(SharedProperties.getDateProperty());
                if (thisRevision == null || !thisRevision.equals(selectedRevision) || thisDate == null || !thisDate.equals(selectedDate)) continue;
                selectedEntry = thisEntry;
                break;
            }
        }
        if (selectedEntry == null) {
            return;
        }
        final HistoryEntry selectedEntry0 = selectedEntry;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoryFilterComponent.this._component.setSingleSelection(selectedEntry0);
            }
        });
    }

    protected abstract HistoryModel createHistoryModel(HistoryFilter var1, HistoryComponent var2);

    private class MyModel
    extends DefaultComboBoxModel {
        private final List _filters;

        private MyModel(List filters) {
            this._filters = filters;
        }

        @Override
        public int getSize() {
            return this._filters.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this._filters.get(index);
        }
    }

    protected class FilterComboItem
    extends ComboItem {
        private final HistoryFilter filter;

        FilterComboItem(HistoryFilter filter) {
            this.filter = filter;
        }

        public String toString() {
            return this.filter.getShortLabel();
        }

        public boolean equals(Object o) {
            return o instanceof FilterComboItem && this.filter.equals(((FilterComboItem)o).filter);
        }
    }

    protected abstract class ComboItem {
        protected ComboItem() {
        }
    }
}

